---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 55
  claims_with_evidence: 55
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：batched_git_ref_updates単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：55 / 55、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/batched_git_ref_updates/deletion.rb` - Deletionモデルの実装
- E-02: `app/services/batched_git_ref_updates/cleanup_scheduler_service.rb` - CleanupSchedulerServiceの実装
- E-03: `app/services/batched_git_ref_updates/project_cleanup_service.rb` - ProjectCleanupServiceの実装
- E-04: `app/workers/batched_git_ref_updates/cleanup_scheduler_worker.rb` - CleanupSchedulerWorkerの実装
- E-05: `app/workers/batched_git_ref_updates/project_cleanup_worker.rb` - ProjectCleanupWorkerの実装
- E-06: `spec/models/batched_git_ref_updates/deletion_spec.rb` - Deletionモデルの既存テスト
- E-07: `spec/services/batched_git_ref_updates/cleanup_scheduler_service_spec.rb` - CleanupSchedulerServiceの既存テスト
- E-08: `spec/services/batched_git_ref_updates/project_cleanup_service_spec.rb` - ProjectCleanupServiceの既存テスト
- E-09: `spec/workers/batched_git_ref_updates/cleanup_scheduler_worker_spec.rb` - CleanupSchedulerWorkerの既存テスト
- E-10: `spec/workers/batched_git_ref_updates/project_cleanup_worker_spec.rb` - ProjectCleanupWorkerの既存テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### Deletionモデル（UT-BGR-001〜019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-BGR-001: belongs_to :projectのリレーション確認 | E-01 (L19) | ○ |
| C-02 | UT-BGR-002: scope :for_partitionの動作確認 | E-01 (L21) | ○ |
| C-03 | UT-BGR-003: scope :for_projectの動作確認 | E-01 (L22) | ○ |
| C-04 | UT-BGR-004: scope :select_ref_and_identityの動作確認 | E-01 (L23) | ○ |
| C-05 | UT-BGR-005: enum :status pendingの設定 | E-01 (L44) | ○ |
| C-06 | UT-BGR-006: enum :status processedの設定 | E-01 (L44) | ○ |
| C-07 | UT-BGR-007: status_pending scopeの動作確認 | E-01 (L44), E-06 (L14-15) | ○ |
| C-08 | UT-BGR-008: status_processed scopeの動作確認 | E-01 (L44), E-06 (L14-15) | ○ |
| C-09 | UT-BGR-009: mark_records_processedの正常動作 | E-01 (L46-50), E-06 (L6-27) | ○ |
| C-10 | UT-BGR-010: 複数パーティション更新 | E-01 (L54-62) | ○ |
| C-11 | UT-BGR-011: 空配列のエッジケース | E-01 (L54-62) | ○ |
| C-12 | UT-BGR-012: next_partition_if空パーティション | E-01 (L26-36), E-06 (L37-39) | ○ |
| C-13 | UT-BGR-013: next_partition_if新しいレコード | E-01 (L26-36), E-06 (L41-48) | ○ |
| C-14 | UT-BGR-014: next_partition_if古いレコード | E-01 (L26-36), E-06 (L50-61) | ○ |
| C-15 | UT-BGR-015: detach_partition_if未処理あり | E-01 (L37-42), E-06 (L69-76) | ○ |
| C-16 | UT-BGR-016: detach_partition_if全処理済み | E-01 (L37-42), E-06 (L78-85) | ○ |
| C-17 | UT-BGR-017: PARTITION_DURATION定数 | E-01 (L5) | ○ |
| C-18 | UT-BGR-018: BulkInsertSafe mixin | E-01 (L7) | ○ |
| C-19 | UT-BGR-019: ignore_column :partition_id | E-01 (L17) | ○ |

### CleanupSchedulerService（UT-BGR-020〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | UT-BGR-020: Workerスケジュール | E-02 (L15-21), E-07 (L16-26) | ○ |
| C-21 | UT-BGR-021: processed除外 | E-02 (L15), E-07 (L10-14) | ○ |
| C-22 | UT-BGR-022: プロジェクト数返却 | E-02 (L27), E-07 (L28-34) | ○ |
| C-23 | UT-BGR-023: 排他ロック取得 | E-02 (L14), E-07 (L36-42) | ○ |
| C-24 | UT-BGR-024: ロック失敗時スキップ | E-02 (L14), E-07 (L36-42) | ○ |
| C-25 | UT-BGR-025: MAX_PROJECTS制限 | E-02 (L7, L23), E-07 (L44-53) | ○ |
| C-26 | UT-BGR-026: 0件の場合 | E-02 (L12, L27) | ○ |
| C-27 | UT-BGR-027: LOCK_TIMEOUT定数 | E-02 (L9) | ○ |
| C-28 | UT-BGR-028: MAX_PROJECTS定数 | E-02 (L7) | ○ |
| C-29 | UT-BGR-029: BATCH_SIZE定数 | E-02 (L8) | ○ |

### ProjectCleanupService（UT-BGR-030〜045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | UT-BGR-030: initialize | E-03 (L12-14) | ○ |
| C-31 | UT-BGR-031: ref削除 | E-03 (L28-32), E-08 (L35-54) | ○ |
| C-32 | UT-BGR-032: 他プロジェクト影響なし | E-03 (L25), E-08 (L35-54) | ○ |
| C-33 | UT-BGR-033: processed除外 | E-03 (L24), E-08 (L65-73) | ○ |
| C-34 | UT-BGR-034: processedへ更新 | E-03 (L35), E-08 (L65-73) | ○ |
| C-35 | UT-BGR-035: 削除件数返却 | E-03 (L41), E-08 (L75-79) | ○ |
| C-36 | UT-BGR-036: 重複ref処理 | E-03 (L31), E-08 (L56-63) | ○ |
| C-37 | UT-BGR-037: 排他ロック取得 | E-03 (L19), E-08 (L81-86) | ○ |
| C-38 | UT-BGR-038: ロック失敗時スキップ | E-03 (L19), E-08 (L81-86) | ○ |
| C-39 | UT-BGR-039: 存在しないproject_id | E-03 (L20-21), E-08 (L88-92) | ○ |
| C-40 | UT-BGR-040: MAX_DELETES制限 | E-03 (L10, L37), E-08 (L94-101) | ○ |
| C-41 | UT-BGR-041: 0件の場合 | E-03 (L17, L41) | ○ |
| C-42 | UT-BGR-042: LOCK_TIMEOUT定数 | E-03 (L7) | ○ |
| C-43 | UT-BGR-043: GITALY_BATCH_SIZE定数 | E-03 (L8) | ○ |
| C-44 | UT-BGR-044: QUERY_BATCH_SIZE定数 | E-03 (L9) | ○ |
| C-45 | UT-BGR-045: MAX_DELETES定数 | E-03 (L10) | ○ |

### CleanupSchedulerWorker（UT-BGR-046〜050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | UT-BGR-046: Service実行委譲 | E-04 (L14-15), E-09 (L15-19) | ○ |
| C-47 | UT-BGR-047: 統計ログ記録 | E-04 (L17), E-09 (L21-27) | ○ |
| C-48 | UT-BGR-048: idempotent!宣言 | E-04 (L9), E-09 (L30) | ○ |
| C-49 | UT-BGR-049: data_consistency :sticky | E-04 (L10) | ○ |
| C-50 | UT-BGR-050: feature_category :gitaly | E-04 (L12) | ○ |

### ProjectCleanupWorker（UT-BGR-051〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | UT-BGR-051: Service実行委譲 | E-05 (L12-13), E-10 (L15-19) | ○ |
| C-52 | UT-BGR-052: 統計ログ記録 | E-05 (L15), E-10 (L21-27) | ○ |
| C-53 | UT-BGR-053: idempotent!宣言 | E-05 (L7), E-10 (L30-32) | ○ |
| C-54 | UT-BGR-054: data_consistency :delayed | E-05 (L8) | ○ |
| C-55 | UT-BGR-055: feature_category :gitaly | E-05 (L10) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードおよび既存テストスペックに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに直接対応しており、既存のテストスペックとも整合性があります。

## 6) レビュアーチェックリスト（最小）
- [ ] パーティション管理のテストケース（UT-BGR-012〜016）がスライディングリストパーティショニングの仕様と整合しているか確認
- [ ] 排他ロック関連のテストケース（UT-BGR-023〜024、037〜038）がExclusiveLeaseMixin の動作と整合しているか確認
- [ ] バッチサイズ・上限値のテストケース（UT-BGR-025、040）がリソース制限要件と整合しているか確認
- [ ] Worker設定のテストケース（UT-BGR-048〜055）がSidekiq/GitLab Workerの仕様と整合しているか確認
