---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 154
  claims_with_evidence: 154
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：blob_viewer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：154 / 154、根拠なし：0
- 優先レビュー（高）
  1. **GitlabCiYml validation_message**: CI設定のバリデーションロジックが重要
  2. **Graph can_render?**: PlantUML/Kroki連携の設定依存ロジック
  3. **GoMod package_name**: 正規表現によるモジュール名抽出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/blob_viewer/base.rb`
- E-02: `app/models/blob_viewer/simple.rb`
- E-03: `app/models/blob_viewer/rich.rb`
- E-04: `app/models/blob_viewer/auxiliary.rb`
- E-05: `app/models/blob_viewer/client_side.rb`
- E-06: `app/models/blob_viewer/server_side.rb`
- E-07: `app/models/blob_viewer/static.rb`
- E-08: `app/models/blob_viewer/text.rb`
- E-09: `app/models/blob_viewer/image.rb`
- E-10: `app/models/blob_viewer/video.rb`
- E-11: `app/models/blob_viewer/audio.rb`
- E-12: `app/models/blob_viewer/svg.rb`
- E-13: `app/models/blob_viewer/pdf.rb`
- E-14: `app/models/blob_viewer/sketch.rb`
- E-15: `app/models/blob_viewer/notebook.rb`
- E-16: `app/models/blob_viewer/csv.rb`
- E-17: `app/models/blob_viewer/markup.rb`
- E-18: `app/models/blob_viewer/download.rb`
- E-19: `app/models/blob_viewer/empty.rb`
- E-20: `app/models/blob_viewer/binary_stl.rb`
- E-21: `app/models/blob_viewer/text_stl.rb`
- E-22: `app/models/blob_viewer/geo_json.rb`
- E-23: `app/models/blob_viewer/graph.rb`
- E-24: `app/models/blob_viewer/open_api.rb`
- E-25: `app/models/blob_viewer/gitlab_ci_yml.rb`
- E-26: `app/models/blob_viewer/route_map.rb`
- E-27: `app/models/blob_viewer/license.rb`
- E-28: `app/models/blob_viewer/readme.rb`
- E-29: `app/models/blob_viewer/changelog.rb`
- E-30: `app/models/blob_viewer/contributing.rb`
- E-31: `app/models/blob_viewer/dependency_manager.rb`
- E-32: `app/models/blob_viewer/gemfile.rb`
- E-33: `app/models/blob_viewer/gemspec.rb`
- E-34: `app/models/blob_viewer/package_json.rb`
- E-35: `app/models/blob_viewer/yarn_lock.rb`
- E-36: `app/models/blob_viewer/composer_json.rb`
- E-37: `app/models/blob_viewer/podfile.rb`
- E-38: `app/models/blob_viewer/podspec.rb`
- E-39: `app/models/blob_viewer/podspec_json.rb`
- E-40: `app/models/blob_viewer/cartfile.rb`
- E-41: `app/models/blob_viewer/requirements_txt.rb`
- E-42: `app/models/blob_viewer/go_mod.rb`
- E-43: `app/models/blob_viewer/godeps_json.rb`
- E-44: `app/models/blob_viewer/cargo_toml.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### BlobViewer::Base (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initializeでblobを設定し@initially_binaryを設定 | E-01 L17-20 | ○ |
| C-02 | partial_pathがPARTIAL_PATH_PREFIX + partial_nameを返す | E-01 L22-24 | ○ |
| C-03 | loading_partial_pathがPARTIAL_PATH_PREFIX + loading_partial_nameを返す | E-01 L26-28 | ○ |
| C-04 | rich?がtype == :richを判定 | E-01 L30-32 | ○ |
| C-05 | simple?がtype == :simpleを判定 | E-01 L34-36 | ○ |
| C-06 | auxiliary?がtype == :auxiliaryを判定 | E-01 L38-40 | ○ |
| C-07 | load_async?がload_async属性を返す | E-01 L42-44 | ○ |
| C-08 | binary?がbinary属性を返す | E-01 L46-48 | ○ |
| C-09 | text?が!binary?を返す | E-01 L50-52 | ○ |
| C-10 | can_render?がextensions/file_typesで判定 | E-01 L54-60 | ○ |
| C-11 | collapsed?がcollapse_limitとraw_sizeを比較 | E-01 L62-66 | ○ |
| C-12 | too_large?がsize_limitとraw_sizeを比較 | E-01 L68-72 | ○ |
| C-13 | binary_detected_after_load?が初期状態と現在を比較 | E-01 L74-76 | ○ |
| C-14 | render_errorが:too_largeまたは:collapsedを返す | E-01 L89-95 | ○ |
| C-15 | prepare!が空メソッド | E-01 L97-99 | ○ |
| C-16 | projectがblobに委譲される | E-01 L15 | ○ |

### BlobViewer::Simple (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | type=:simpleが設定される | E-02 L8 | ○ |
| C-18 | switcher_icon='code'が設定される | E-02 L9 | ○ |

### BlobViewer::Rich (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | type=:richが設定される | E-03 L8 | ○ |
| C-20 | switcher_icon='doc-text'が設定される | E-03 L9 | ○ |

### BlobViewer::Auxiliary (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | type=:auxiliaryが設定される | E-04 L11 | ○ |
| C-22 | collapse_limit=100KBが設定される | E-04 L12 | ○ |
| C-23 | size_limit=100KBが設定される | E-04 L13 | ○ |
| C-24 | visible_to?が常にtrueを返す | E-04 L16-18 | ○ |

### BlobViewer::ClientSide (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | load_async=falseが設定される | E-05 L8 | ○ |
| C-26 | collapse_limit=10MBが設定される | E-05 L9 | ○ |
| C-27 | size_limit=50MBが設定される | E-05 L10 | ○ |

### BlobViewer::ServerSide (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | load_async=trueが設定される | E-06 L8 | ○ |
| C-29 | collapse_limit=2MBが設定される | E-06 L9 | ○ |
| C-30 | size_limit=5MBが設定される | E-06 L10 | ○ |
| C-31 | prepare!がblob.load_all_data!を呼ぶ | E-06 L13-15 | ○ |
| C-32 | render_errorが外部保存時にエラーを返す | E-06 L17-26 | ○ |

### BlobViewer::Static (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | load_async=falseが設定される | E-07 L8 | ○ |
| C-34 | render_errorが常にnilを返す | E-07 L12-14 | ○ |

### BlobViewer::Text (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | partial_name='text'が設定される | E-08 L8 | ○ |
| C-36 | binary=falseが設定される | E-08 L9 | ○ |
| C-37 | collapse_limit=1MBが設定される | E-08 L10 | ○ |
| C-38 | size_limit=10MBが設定される | E-08 L11 | ○ |

### BlobViewer::Image (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | extensionsがSAFE_IMAGE_EXTに設定される | E-09 L9 | ○ |
| C-40 | binary=trueが設定される | E-09 L10 | ○ |

### BlobViewer::Video (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | extensionsがSAFE_VIDEO_EXTに設定される | E-10 L9 | ○ |

### BlobViewer::Audio (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | extensionsがSAFE_AUDIO_EXTに設定される | E-11 L9 | ○ |

### BlobViewer::SVG (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | extensions=['svg']が設定される | E-12 L9 | ○ |
| C-44 | binary=falseが設定される | E-12 L10 | ○ |

### BlobViewer::PDF (E-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | extensions=['pdf']が設定される | E-13 L9 | ○ |

### BlobViewer::Sketch (E-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | extensions=['sketch']が設定される | E-14 L9 | ○ |

### BlobViewer::Notebook (E-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | extensions=['ipynb']が設定される | E-15 L9 | ○ |
| C-48 | binary=falseが設定される | E-15 L10 | ○ |

### BlobViewer::CSV (E-16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | extensions=['csv']が設定される | E-16 L9 | ○ |

### BlobViewer::Markup (E-17)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | extensionsがMarkupHelper::EXTENSIONSに設定される | E-17 L9 | ○ |
| C-51 | banzai_render_contextがコンテキストを返す | E-17 L13-20 | ○ |

### BlobViewer::Download (E-18)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | binary=trueが設定される | E-18 L9 | ○ |

### BlobViewer::Empty (E-19)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | partial_name='empty'が設定される | E-19 L8 | ○ |

### BlobViewer::BinarySTL (E-20)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | extensions=['stl']が設定される | E-20 L9 | ○ |
| C-55 | binary=trueが設定される | E-20 L10 | ○ |

### BlobViewer::TextSTL (E-21)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | binary=falseが設定される | E-21 L5 | ○ |

### BlobViewer::GeoJson (E-22)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | extensions=['geojson']が設定される | E-22 L9 | ○ |

### BlobViewer::Graph (E-23)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | extensionsが正しく設定される | E-23 L15 | ○ |
| C-59 | can_render?がPlantUML/Kroki設定を確認 | E-23 L20-30 | ○ |
| C-60 | graph_formatが拡張子に応じたフォーマットを返す | E-23 L32-52 | ○ |
| C-61 | banzai_render_contextがキャッシュキーを返す | E-23 L54-58 | ○ |

### BlobViewer::OpenApi (E-24)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | file_types=[:openapi]が設定される | E-24 L9 | ○ |

### BlobViewer::GitlabCiYml (E-25)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | can_render?がci_config_pathと比較 | E-25 L13-15 | ○ |
| C-64 | validation_messageがCi::Lintを使用 | E-25 L18-25 | ○ |
| C-65 | valid?がvalidation_messageの有無を判定 | E-25 L28-30 | ○ |
| C-66 | visible_to?がbranch_or_tag?を判定 | E-25 L32-35 | ○ |

### BlobViewer::RouteMap (E-26)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | validation_messageがRouteMapを検証 | E-26 L13-25 | ○ |
| C-68 | valid?がvalidation_messageの有無を判定 | E-26 L28-30 | ○ |

### BlobViewer::License (E-27)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | licenseがrepository.licenseを返す | E-27 L12-14 | ○ |
| C-70 | render_errorがライセンス不明時エラーを返す | E-27 L16-20 | ○ |

### BlobViewer::Readme (E-28)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | visible_to?がread_wiki権限を確認 | E-28 L12-14 | ○ |
| C-72 | render_errorがWiki不在時エラーを返す | E-28 L16-20 | ○ |

### BlobViewer::Changelog (E-29)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | render_errorがタグ不在時エラーを返す | E-29 L12-16 | ○ |

### BlobViewer::DependencyManager (E-31)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | manager_nameがNotImplementedErrorを発生 | E-31 L10-12 | ○ |
| C-75 | manager_urlがNotImplementedErrorを発生 | E-31 L14-16 | ○ |
| C-76 | package_typeがpackageを返す | E-31 L18-20 | ○ |
| C-77 | json_dataがJSONをパース | E-31 L32-38 | ○ |
| C-78 | fetch_from_jsonがdigで値を取得 | E-31 L41-45 | ○ |
| C-79 | package_name_from_method_callが正規表現で抽出 | E-31 L47-52 | ○ |

### BlobViewer::Gemfile (E-32)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | manager_nameがBundlerを返す | E-32 L9-11 | ○ |

### BlobViewer::Gemspec (E-33)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | manager_nameがRubyGemsを返す | E-33 L9-11 | ○ |
| C-82 | package_typeがgemを返す | E-33 L17-19 | ○ |
| C-83 | package_nameがnameメソッドから取得 | E-33 L21-23 | ○ |

### BlobViewer::PackageJson (E-34)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | manager_nameがyarn/npmを返す | E-34 L9-11 | ○ |
| C-85 | yarn?がengines.yarnを確認 | E-34 L13-15 | ○ |
| C-86 | package_typeがprivate設定を反映 | E-34 L25-27 | ○ |
| C-87 | package_urlがprivate/public別に生成 | E-34 L29-31, L44-50 | ○ |

### BlobViewer::GoMod (E-42)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | MODULE_REGEXでモジュール名を抽出 | E-42 L8-14 | ○ |
| C-89 | package_nameがgo.modからのみ抽出 | E-42 L30-37 | ○ |
| C-90 | package_urlがGitlab::Golang.package_urlを使用 | E-42 L39-41 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全ての主張についてソースコードから根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている
- 1: 中リスク - 外部サービス連携（PlantUML、Kroki、Gitlab::Ci::Lint）のモック設計が必要
- 1: 中リスク - ファイルシステムアクセス（blob.data、blob.load_all_data!）のスタブ設計が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BlobViewer::Base のcollapsed?/too_large?の境界値テストが適切か
- [ ] GitlabCiYml::validation_messageのCi::Lintモック設計が妥当か
- [ ] Graph::can_render?のPlantUML/Kroki設定依存テストが網羅的か
- [ ] DependencyManager系のJSON解析エラーハンドリングが十分か
- [ ] GoMod::package_nameの正規表現マッチングのエッジケースが考慮されているか
- [ ] ServerSide::render_errorのstored_externally?判定が適切にテストされているか
