---
generated_at: 2026-01-22 15:05:00
metrics:
  claims_total: 173
  claims_with_evidence: 173
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：bulk_imports 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：173 / 173、根拠なし：0
- 優先レビュー（高）
  1. **状態遷移テスト**：state_machineの全状態遷移パターンの網羅性確認
  2. **バリデーションテスト**：条件付きバリデーションの境界条件
  3. **暗号化テスト**：attr_encryptedの動作確認方法

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/bulk_imports/entity.rb`
- E-02: `app/models/bulk_imports/tracker.rb`
- E-03: `app/models/bulk_imports/export.rb`
- E-04: `app/models/bulk_imports/export_batch.rb`
- E-05: `app/models/bulk_imports/failure.rb`
- E-06: `app/models/bulk_imports/configuration.rb`
- E-07: `app/models/bulk_imports/export_upload.rb`
- E-08: `app/models/bulk_imports/export_status.rb`
- E-09: `app/models/bulk_imports/batch_tracker.rb`
- E-10: `app/models/bulk_imports/file_transfer.rb`
- E-11: `app/models/bulk_imports/file_transfer/base_config.rb`
- E-12: `app/models/bulk_imports/file_transfer/project_config.rb`
- E-13: `app/models/bulk_imports/file_transfer/group_config.rb`
- E-14: `app/finders/bulk_imports/entities_finder.rb`
- E-15: `app/finders/bulk_imports/imports_finder.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### BulkImports::Entity（UT-BLK-001〜UT-BLK-044）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :bulk_import リレーション | E-01 L29 | ○ |
| C-02 | belongs_to :parent リレーション | E-01 L30 | ○ |
| C-03 | belongs_to :project リレーション | E-01 L32 | ○ |
| C-04 | belongs_to :group リレーション | E-01 L34 | ○ |
| C-05 | has_many :trackers リレーション | E-01 L36-39 | ○ |
| C-06 | has_many :failures リレーション | E-01 L41-44 | ○ |
| C-07 | validates :source_type, presence: true | E-01 L46 | ○ |
| C-08 | validates :source_full_path, presence: true | E-01 L47 | ○ |
| C-09 | validates :destination_name 条件付き必須 | E-01 L48 | ○ |
| C-10 | validate_parent_is_a_group カスタムバリデーション | E-01 L245-246 | ○ |
| C-11 | validate_imported_entity_type カスタムバリデーション | E-01 L249-263 | ○ |
| C-12 | validate_destination_namespace_ascendency カスタムバリデーション | E-01 L265-278 | ○ |
| C-13 | validate_source_full_path_format カスタムバリデーション | E-01 L280-291 | ○ |
| C-14 | scope :by_user_id スコープ | E-01 L62 | ○ |
| C-15 | scope :stale スコープ | E-01 L63 | ○ |
| C-16 | scope :by_bulk_import_id スコープ | E-01 L64 | ○ |
| C-17 | state_machine :status 定義 | E-01 L74-115 | ○ |
| C-18 | encoded_source_full_path メソッド | E-01 L121-123 | ○ |
| C-19 | pipelines メソッド | E-01 L125-132 | ○ |
| C-20 | pipeline_exists? メソッド | E-01 L134-136 | ○ |
| C-21 | entity_type メソッド | E-01 L138-140 | ○ |
| C-22 | pluralized_name メソッド | E-01 L142-144 | ○ |
| C-23 | portable_class メソッド | E-01 L146-148 | ○ |
| C-24 | base_resource_path メソッド | E-01 L158-164 | ○ |
| C-25 | export_relations_url_path メソッド | E-01 L170-176 | ○ |
| C-26 | relation_download_url_path メソッド | E-01 L178-185 | ○ |
| C-27 | project?/group? メソッド | E-01 L191-197 | ○ |
| C-28 | full_path メソッド | E-01 L203-205 | ○ |
| C-29 | full_path_with_fallback メソッド | E-01 L207-209 | ○ |
| C-30 | update_has_failures メソッド | E-01 L217-223 | ○ |
| C-31 | checksums メソッド | E-01 L229-237 | ○ |
| C-32 | propagate_cancel メソッド | E-01 L239-241 | ○ |

### BulkImports::Tracker（UT-BLK-045〜UT-BLK-067）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | belongs_to :entity リレーション | E-02 L10-14 | ○ |
| C-34 | has_many :batches リレーション | E-02 L16 | ○ |
| C-35 | validates :relation | E-02 L18-20 | ○ |
| C-36 | validates :next_page 条件付き | E-02 L22 | ○ |
| C-37 | pipeline_class メソッド | E-02 L41-47 | ○ |
| C-38 | scope :next_pipeline_trackers_for | E-02 L30-35 | ○ |
| C-39 | scope :running_trackers | E-02 L37-39 | ○ |
| C-40 | state_machine :status 定義 | E-02 L49-106 | ○ |
| C-41 | checksums メソッド | E-02 L108-113 | ○ |
| C-42 | checksums_empty? メソッド | E-02 L115-121 | ○ |
| C-43 | importing_relation メソッド | E-02 L123-125 | ○ |
| C-44 | propagate_cancel メソッド | E-02 L127-129 | ○ |

### BulkImports::Export（UT-BLK-068〜UT-BLK-086）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | belongs_to :project/:group リレーション | E-03 L15-16 | ○ |
| C-46 | belongs_to :user リレーション | E-03 L17 | ○ |
| C-47 | has_one :upload リレーション | E-03 L20 | ○ |
| C-48 | has_many :batches リレーション | E-03 L21 | ○ |
| C-49 | validates :project/:group 排他的存在 | E-03 L23-24 | ○ |
| C-50 | validates :relation/:status presence | E-03 L25 | ○ |
| C-51 | validate :portable_relation? | E-03 L27, L59-63 | ○ |
| C-52 | state_machine :status 定義 | E-03 L34-57 | ○ |
| C-53 | portable メソッド | E-03 L65-69 | ○ |
| C-54 | config メソッド | E-03 L75-79 | ○ |
| C-55 | remove_existing_upload! メソッド | E-03 L81-86 | ○ |
| C-56 | relation_has_user_contributions? メソッド | E-03 L88-90 | ○ |
| C-57 | offline? メソッド | E-03 L92-94 | ○ |

### BulkImports::ExportBatch（UT-BLK-087〜UT-BLK-095）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | belongs_to :export リレーション | E-04 L20 | ○ |
| C-59 | has_one :upload リレーション | E-04 L21 | ○ |
| C-60 | validates :batch_number | E-04 L23 | ○ |
| C-61 | scope :started_and_not_timed_out | E-04 L18 | ○ |
| C-62 | scope :in_progress | E-04 L25 | ○ |
| C-63 | state_machine :status 定義 | E-04 L27-45 | ○ |

### BulkImports::Failure（UT-BLK-096〜UT-BLK-103）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | belongs_to :entity リレーション | E-05 L6-10 | ○ |
| C-65 | validates :entity | E-05 L12 | ○ |
| C-66 | relation メソッド | E-05 L14-19 | ○ |
| C-67 | exception_message= ミューテータ | E-05 L22-24 | ○ |
| C-68 | source_title= ミューテータ | E-05 L26-28 | ○ |
| C-69 | source_url= ミューテータ | E-05 L30-32 | ○ |
| C-70 | subrelation= ミューテータ | E-05 L34-36 | ○ |

### BulkImports::Configuration（UT-BLK-104〜UT-BLK-112）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | belongs_to :bulk_import リレーション | E-06 L10 | ○ |
| C-72 | validates :url length | E-06 L12 | ○ |
| C-73 | validates :access_token length | E-06 L12 | ○ |
| C-74 | validates :url presence | E-06 L13 | ○ |
| C-75 | validates :url public_url | E-06 L14-15 | ○ |
| C-76 | attr_encrypted :url | E-06 L17-20 | ○ |
| C-77 | attr_encrypted :access_token | E-06 L21-24 | ○ |
| C-78 | safe_url メソッド | E-06 L26-30 | ○ |

### BulkImports::ExportUpload（UT-BLK-113〜UT-BLK-117）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | belongs_to :export リレーション | E-07 L9 | ○ |
| C-80 | belongs_to :batch リレーション | E-07 L10 | ○ |
| C-81 | mount_uploader :export_file | E-07 L12 | ○ |
| C-82 | retrieve_upload メソッド | E-07 L22-24 | ○ |
| C-83 | uploads_sharding_key メソッド | E-07 L26-30 | ○ |

### BulkImports::ExportStatus（UT-BLK-118〜UT-BLK-129）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | initialize メソッド | E-08 L9-15 | ○ |
| C-85 | in_progress? メソッド | E-08 L17-19 | ○ |
| C-86 | failed? メソッド | E-08 L21-23 | ○ |
| C-87 | empty? メソッド | E-08 L25-27 | ○ |
| C-88 | error メソッド | E-08 L29-31 | ○ |
| C-89 | batched? メソッド | E-08 L33-35 | ○ |
| C-90 | batches_count メソッド | E-08 L37-39 | ○ |
| C-91 | batch メソッド | E-08 L41-47 | ○ |
| C-92 | total_objects_count メソッド | E-08 L49-53 | ○ |

### BulkImports::BatchTracker（UT-BLK-130〜UT-BLK-142）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | belongs_to :tracker リレーション | E-09 L7 | ○ |
| C-94 | validates :batch_number | E-09 L9 | ○ |
| C-95 | scope :by_last_updated | E-09 L13 | ○ |
| C-96 | scope :in_progress | E-09 L14 | ○ |
| C-97 | pluck_batch_numbers メソッド | E-09 L18-20 | ○ |
| C-98 | state_machine :status 定義 | E-09 L23-61 | ○ |

### BulkImports::FileTransfer（UT-BLK-143〜UT-BLK-145）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | config_for(Project) | E-10 L11-12 | ○ |
| C-100 | config_for(Group) | E-10 L13-14 | ○ |
| C-101 | config_for(unsupported) エラー | E-10 L15-16 | ○ |

### BulkImports::FileTransfer::BaseConfig（UT-BLK-146〜UT-BLK-158）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | initialize メソッド | E-11 L12-14 | ○ |
| C-103 | export_path メソッド | E-11 L32-34 | ○ |
| C-104 | portable_relations メソッド | E-11 L36-38 | ○ |
| C-105 | batchable_relations メソッド | E-11 L40-43 | ○ |
| C-106 | batchable_relation? メソッド | E-11 L45-47 | ○ |
| C-107 | self_relation? メソッド | E-11 L49-51 | ○ |
| C-108 | tree_relation? メソッド | E-11 L53-55 | ○ |
| C-109 | file_relation? メソッド | E-11 L57-59 | ○ |
| C-110 | relation_has_user_contributions? メソッド | E-11 L61-63 | ○ |
| C-111 | user_contributions_relation? メソッド | E-11 L65-67 | ○ |
| C-112 | export_service_for メソッド | E-11 L80-91 | ○ |

### BulkImports::FileTransfer::ProjectConfig（UT-BLK-159〜UT-BLK-161）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | import_export_yaml メソッド | E-12 L15-17 | ○ |
| C-114 | skipped_relations メソッド | E-12 L19-21 | ○ |
| C-115 | file_relations メソッド | E-12 L23-30 | ○ |

### BulkImports::FileTransfer::GroupConfig（UT-BLK-162〜UT-BLK-163）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | import_export_yaml メソッド | E-13 L8-10 | ○ |
| C-117 | skipped_relations メソッド | E-13 L12-14 | ○ |

### BulkImports::EntitiesFinder（UT-BLK-164〜UT-BLK-168）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | execute メソッド | E-14 L11-18 | ○ |
| C-119 | filter_by_bulk_import メソッド | E-14 L24-28 | ○ |
| C-120 | filter_by_status メソッド | E-14 L30-34 | ○ |
| C-121 | sort メソッド | E-14 L36-40 | ○ |

### BulkImports::ImportsFinder（UT-BLK-169〜UT-BLK-173）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | execute メソッド | E-15 L10-14 | ○ |
| C-123 | filter_by_status メソッド | E-15 L20-24 | ○ |
| C-124 | sort メソッド | E-15 L26-30 | ○ |
| C-125 | include_configuration メソッド | E-15 L32-36 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されている
- 注意点：
  - state_machineの状態遷移テストは、after_transitionコールバックの副作用も含めて検証が必要
  - attr_encrypted属性のテストは、暗号化キーの設定が必要
  - ExportStatusはHTTPクライアントを使用するため、モック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Entity状態遷移のafter_transitionコールバック（update_has_failures, propagate_cancel）が正しくテストされているか
- [ ] Configuration暗号化属性のテストで適切な暗号化キーが設定されているか
- [ ] ExportStatusのHTTPクライアント呼び出しが適切にモック化されているか
- [ ] バリデーションの条件分岐（if: -> {}）が全パターン網羅されているか
- [ ] scope定義のSQLクエリが期待通りに構築されているか
- [ ] FileTransfer::BaseConfigのサブクラス固有のメソッドがテストされているか
