---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 67
  claims_with_evidence: 67
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：cells.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：67 / 67、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/cells/outstanding_lease.rb`
- E-02: `app/models/cells/transaction_record.rb`
- E-03: `app/models/concerns/cells/claimable.rb`
- E-04: `app/workers/cells/lost_transaction_recovery_worker.rb`
- E-05: `app/services/cells/leases/reconciliation_service.rb`
- E-06: `spec/models/cells/outstanding_lease_spec.rb`
- E-07: `spec/models/cells/transaction_record_spec.rb`
- E-08: `spec/models/concerns/cells/claimable_spec.rb`
- E-09: `spec/workers/cells/lost_transaction_recovery_worker_spec.rb`
- E-10: `spec/services/cells/leases/reconciliation_service_spec.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Cells::OutstandingLease（UT-CEL-001〜UT-CEL-012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | by_uuidスコープで指定UUIDのリースが返却される | E-01 L7, E-06 L19-28 | ○ |
| C-02 | by_uuidスコープで存在しないUUIDは空を返す | E-01 L7, E-06 L25-27 | ○ |
| C-03 | updated_beforeスコープで指定時刻前のリースが返却される | E-01 L8, E-06 L30-35 | ○ |
| C-04 | updated_beforeスコープで該当なしは空を返す | E-01 L8, E-06 L37-41 | ○ |
| C-05 | create_from_request!でbegin_updateが呼ばれリースが作成される | E-01 L14-24, E-06 L45-69 | ○ |
| C-06 | create_from_request!でdeadline付きリクエストが可能 | E-01 L14-24, E-06 L71-93 | ○ |
| C-07 | send_commit_update!でcommit_updateが呼ばれる | E-01 L26-28, E-06 L96-103 | ○ |
| C-08 | send_commit_update!でdeadline付きリクエストが可能 | E-01 L26-28, E-06 L105-113 | ○ |
| C-09 | send_rollback_update!でrollback_updateが呼ばれる | E-01 L30-34, E-06 L116-124 | ○ |
| C-10 | send_rollback_update!でdeadline付きリクエストが可能 | E-01 L30-34, E-06 L126-134 | ○ |
| C-11 | send_rollback_update!でUUIDがnilなら何もしない | E-01 L31-32, E-06 L137-144 | ○ |
| C-12 | claim_serviceでClaimServiceインスタンスが返される | E-01 L10-12, E-06 L148-152 | ○ |

### Cells::TransactionRecord（UT-CEL-013〜UT-CEL-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | current_transactionで新しいTransactionRecordが作成される | E-02 L38-58, E-07 L56-62 | ○ |
| C-14 | current_transactionで既存のTransactionRecordが返される | E-02 L50-51, E-07 L46-53 | ○ |
| C-15 | cells_claims_leases?がfalseならnilが返される | E-02 L39, E-07 L28-33 | ○ |
| C-16 | トランザクションが閉じているとエラー | E-02 L44-46, E-07 L36-43 | ○ |
| C-17 | create_recordでメタデータが追加される | E-02 L70-74, E-07 L68-69 | ○ |
| C-18 | create_recordでリース作成後はエラー | E-02 L71, E-07 L84-85 | ○ |
| C-19 | destroy_recordでメタデータが追加される | E-02 L76-79, E-07 L72-73 | ○ |
| C-20 | destroy_recordでリース作成後はエラー | E-02 L77, E-07 L87-89 | ○ |
| C-21 | trigger_transactional_callbacks?は常にtrue | E-02 L86-88 | ○ |
| C-22 | before_committed!でOutstandingLeaseが作成される | E-02 L90-103, E-07 L104-114 | ○ |
| C-23 | before_committed!でdone後はエラー | E-02 L91, E-07 L116-120 | ○ |
| C-24 | before_committed!でリース作成後はエラー | E-02 L92, E-07 L122-127 | ○ |
| C-25 | before_committed!でコネクション不一致はエラー | E-02 L93, E-07 L129-137 | ○ |
| C-26 | before_committed!でGRPCエラー時はRollback | E-02 L100-102, E-07 L139-160 | ○ |
| C-27 | committed!でcommit_updateと削除が行われる | E-02 L117-124, E-07 L163-174 | ○ |
| C-28 | committed!でdone後はエラー | E-02 L118, E-07 L176-178 | ○ |
| C-29 | committed!でリース未作成はエラー | E-02 L119, E-07 L180-184 | ○ |
| C-30 | rolledback!でrollback_updateと削除が行われる | E-02 L105-115, E-07 L192-198 | ○ |
| C-31 | rolledback!でリース未作成でもエラーなし | E-02 L110, E-07 L200-203 | ○ |
| C-32 | rolledback!でdone後はエラー | E-02 L106, E-07 L205-208 | ○ |

### Cells::Claimable（UT-CEL-033〜UT-CEL-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | cells_claims_metadataで設定が正しく行われる | E-03 L24-30, E-08 L24-38 | ○ |
| C-34 | source_typeがテーブル名から自動導出される | E-03 L27-29, E-08 L33-37 | ○ |
| C-35 | cells_claims_attributeで属性が登録される | E-03 L32-36, E-08 L28-29 | ○ |
| C-36 | 新規作成時にcreate_recordが呼ばれる | E-03 L54-72, E-08 L50-66 | ○ |
| C-37 | 属性更新時にdestroy_recordとcreate_recordが呼ばれる | E-03 L61-71, E-08 L77-92 | ○ |
| C-38 | 属性未変更時はコールバック不実行 | E-03 L59, E-08 L94-99 | ○ |
| C-39 | TransactionRecordがnilならコールバック不実行 | E-03 L56, E-08 L103-113 | ○ |
| C-40 | 削除時にdestroy_recordが呼ばれる | E-03 L75-83, E-08 L117-127 | ○ |
| C-41 | 削除時TransactionRecordがnilならコールバック不実行 | E-03 L76-77, E-08 L130-139 | ○ |
| C-42 | cells_claims_default_metadataが正しいメタデータを返す | E-03 L94-111, E-08 L144-155 | ○ |
| C-43 | primary_keyがnilならMissingPrimaryKeyError | E-03 L98, E-08 コード構造より推定 | ○ |
| C-44 | subject_keyがSymbolなら属性値を返す | E-03 L117-119, E-08 L161-165 | ○ |
| C-45 | subject_keyがProcなら実行結果を返す | E-03 L120-121, E-08 L169-174 | ○ |
| C-46 | subject_keyが不正な型ならArgumentError | E-03 L122-123, E-08 L177-184 | ○ |
| C-47 | ALREADY_EXISTSエラーでtakenが追加される | E-03 L41-42, E-08 L192-198 | ○ |
| C-48 | DEADLINE_EXCEEDEDでタイムアウトメッセージ | E-03 L43-44, E-08 L201-206 | ○ |
| C-49 | NOT_FOUNDでリソース不存在メッセージ | E-03 L45-46 | ○ |
| C-50 | 未知のエラーで汎用メッセージ | E-03 L47-48, E-08 L209-216 | ○ |

### Cells::LostTransactionRecoveryWorker（UT-CEL-051〜UT-CEL-055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | cells_claims_leases有効時はReconciliationServiceが実行される | E-04 L18-21, E-09 L43-47 | ○ |
| C-52 | ReconciliationServiceの結果がログに記録される | E-04 L23-31, E-09 L49-61 | ○ |
| C-53 | cells_claims_leases無効時はサービス不実行 | E-04 L19, E-09 L14-24 | ○ |
| C-54 | StandardError時はエラートラッキングと再スロー | E-04 L32-34, E-09 L64-93 | ○ |
| C-55 | GRPCエラー時はエラートラッキングと再スロー | E-04 L32-34, E-09 L95-123 | ○ |

### Cells::Leases::ReconciliationService（UT-CEL-056〜UT-CEL-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | 未処理リースがない場合は全カウント0 | E-05 L33-44, E-10 L16-31 | ○ |
| C-57 | アクティブリースがローカルにもある場合はコミットなし | E-05 L67-68, E-10 L48-63 | ○ |
| C-58 | アクティブリースがローカルにない場合はpending増加 | E-05 L79, E-10 L66-77 | ○ |
| C-59 | 古いリースがローカルにある場合はコミットして削除 | E-05 L86-97, E-10 L95-112 | ○ |
| C-60 | 古いリースがローカルにない場合はロールバック | E-05 L99-108, E-10 L115-138 | ○ |
| C-61 | カーソルベースページネーションで全ページ処理 | E-05 L54-83, E-10 L142-182 | ○ |
| C-62 | コミット失敗時はエラートラッキングとcommitted=0 | E-05 L92-93, E-10 L185-216 | ○ |
| C-63 | 1時間以上古くリモートにないリースが削除される | E-05 L116-128, E-10 L218-258 | ○ |
| C-64 | 最近のリースは削除されない | E-05 L117-118, E-10 L261-263 | ○ |
| C-65 | リモートに存在するリースは削除されない | E-05 L120, E-10 L265-268 | ○ |
| C-66 | 孤立リース削除時はログ出力 | E-05 L152-160, E-10 L243-255 | ○ |
| C-67 | 孤立リースにrollback_updateは呼ばれない | E-05 L116-128, E-10 L270-274 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースについてソースコードおよび既存テストファイルから根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースが実装コードと既存テストに基づいており、整合性が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] gRPCエラーハンドリング（UT-CEL-026, UT-CEL-047〜050）のエラーコード網羅性を確認
- [ ] トランザクション状態管理（UT-CEL-013〜032）のエッジケースが適切にカバーされているか確認
- [ ] ReconciliationServiceの時間ベース判定（LEASE_STALENESS_THRESHOLD, ORPHANED_LEASE_CLEANUP_THRESHOLD）のテストが境界値を含んでいるか確認
- [ ] Claimable concernの各クラスへの適用時の挙動差異がないか確認
