---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 97
  claims_with_evidence: 97
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ci.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（ci.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：97 / 97、根拠なし：0
- 優先レビュー（高）
  1. **全て根拠あり** - 全テストケースがソースコードから直接導出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/pipeline.rb` - Ci::Pipeline モデル定義（1754行）
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/build.rb` - Ci::Build モデル定義（1517行）
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/runner.rb` - Ci::Runner モデル定義（700行）
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/job_artifact.rb` - Ci::JobArtifact モデル定義（334行）
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/stage.rb` - Ci::Stage モデル定義（238行）
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/variable.rb` - Ci::Variable モデル定義（33行）
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/pipeline_schedule.rb` - Ci::PipelineSchedule モデル定義（180行）
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/trigger.rb` - Ci::Trigger モデル定義（106行）
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/bridge.rb` - Ci::Bridge モデル定義（411行）
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/processable.rb` - Ci::Processable モデル定義（364行）
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/secure_file.rb` - Ci::SecureFile モデル定義（93行）
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/ci/resource_group.rb` - Ci::ResourceGroup モデル定義（106行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Ci::Pipeline 関連（UT-CI-001〜UT-CI-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | valid_commit_sha メソッドでブランクSHA時にエラー追加 | E-01 (line 751-752) | ○ |
| C-02 | short_sha メソッドでSHA先頭8文字返却 | E-01 (line 807-808, truncate_sha line 670-672) | ○ |
| C-03 | commit メソッドで遅延ロード | E-01 (line 815-817) | ○ |
| C-04 | commit メソッドで存在しないSHAでもnil以外返却 | E-01 (line 811-817) | ○ |
| C-05 | stuck? メソッドで保留ビルドのスタック判定 | E-01 (line 819-821) | ○ |
| C-06 | retryable? メソッドでリトライ可否判定（正常） | E-01 (line 823-827) | ○ |
| C-07 | retryable? メソッドでアーカイブ時false | E-01 (line 824) | ○ |
| C-08 | cancelable? メソッドでキャンセル可否判定（正常） | E-01 (line 842-844) | ○ |
| C-09 | cancelable? メソッドで外部パイプライン時false | E-01 (line 843 internal_pipeline?) | ○ |
| C-10 | auto_canceled? メソッドで自動キャンセル判定 | E-01 (line 846-848) | ○ |
| C-11 | coverage メソッドでカバレッジ平均計算 | E-01 (line 878-881) | ○ |
| C-12 | coverage メソッドでカバレッジなし時nil | E-01 (line 880) | ○ |
| C-13 | has_yaml_errors? メソッドでYAMLエラー判定 | E-01 (line 955-957) | ○ |
| C-14 | has_warnings? メソッドで警告判定 | E-01 (line 932-934) | ○ |
| C-15 | needs_processing? メソッドで処理必要判定 | E-01 (line 948-953) | ○ |
| C-16 | protected_ref? メソッドで保護ブランチ判定 | E-01 (line 1034-1038) | ○ |
| C-17 | merge_request? メソッドでMRパイプライン判定 | E-01 (line 1445-1447) | ○ |
| C-18 | child? メソッドで子パイプライン判定 | E-01 (line 1221-1224) | ○ |
| C-19 | set_status メソッドで状態遷移（正常） | E-01 (line 1011-1031) | ○ |
| C-20 | set_status メソッドで不明ステータスエラー | E-01 (line 1027-1028) | ○ |
| C-21 | queued_duration メソッドでキュー待ち時間計算 | E-01 (line 1053-1060) | ○ |
| C-22 | update_duration メソッドで実行時間更新 | E-01 (line 1062-1066) | ○ |
| C-23 | ref_exists? メソッドで参照存在確認（正常） | E-01 (line 737-741) | ○ |
| C-24 | ref_exists? メソッドでリポジトリなし時false | E-01 (line 739-740) | ○ |
| C-25 | stages_names メソッドでステージ名取得 | E-01 (line 733-735) | ○ |
| C-26 | default_branch? メソッドでデフォルトブランチ判定 | E-01 (line 1441-1443) | ○ |

### Ci::Build 関連（UT-CI-027〜UT-CI-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | playable? メソッドで再生可否判定（正常） | E-02 (line 626-628) | ○ |
| C-28 | playable? メソッドでアーカイブ時false | E-02 (line 627) | ○ |
| C-29 | cancelable? メソッドでキャンセル可否判定（正常） | E-02 (line 653-655) | ○ |
| C-30 | cancelable? メソッドでキャンセル中時false | E-02 (line 654) | ○ |
| C-31 | retries_count メソッドでリトライ回数カウント | E-02 (line 661-663) | ○ |
| C-32 | stuck? メソッドでスタック判定 | E-02 (line 909-911) | ○ |
| C-33 | artifacts? メソッドでアーティファクト判定（正常） | E-02 (line 846-848) | ○ |
| C-34 | artifacts? メソッドで期限切れ時false | E-02 (line 847) | ○ |
| C-35 | erasable? メソッドで消去可否判定 | E-02 (line 965-967) | ○ |
| C-36 | has_trace? メソッドでトレース存在確認 | E-02 (line 822-824) | ○ |
| C-37 | has_tags? メソッドでタグ存在確認 | E-02 (line 885-887) | ○ |
| C-38 | debug_mode? メソッドでデバッグモード判定 | E-02 (line 1198-1203) | ○ |
| C-39 | auto_retry_allowed? メソッドで自動リトライ判定 | E-02 (line 579-581) | ○ |
| C-40 | auto_retry_expected? メソッドで自動リトライ期待判定 | E-02 (line 583-585) | ○ |
| C-41 | variables メソッドで変数収集 | E-02 (line 685-691) | ○ |
| C-42 | persisted_variables メソッドで永続化変数取得 | E-02 (line 693-713) | ○ |
| C-43 | token メソッドでトークン取得 | E-02 (line 1292-1296) | ○ |
| C-44 | pages_generator? メソッドでページジェネレータ判定 | E-02 (line 597-603) | ○ |
| C-45 | steps メソッドでステップ取得 | E-02 (line 1006-1010) | ○ |

### Ci::Runner 関連（UT-CI-046〜UT-CI-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | display_name メソッドで説明返却 | E-03 (line 404-408) | ○ |
| C-47 | display_name メソッドで説明なし時short_sha返却 | E-03 (line 405) | ○ |
| C-48 | online? メソッドでオンライン判定（正常） | E-03 (Ci::HasRunnerStatus include) | ○ |
| C-49 | online? メソッドでタイムアウト時false | E-03 (line 66-68 ONLINE_CONTACT_TIMEOUT) | ○ |
| C-50 | stale? メソッドで陳腐化判定 | E-03 (line 124-129 scope :stale) | ○ |
| C-51 | match_build_if_online? メソッドでビルドマッチ判定 | E-03 (line 444-446) | ○ |
| C-52 | assign_to メソッドでプロジェクト割り当て（正常） | E-03 (line 381-402) | ○ |
| C-53 | assign_to メソッドでインスタンスランナーエラー | E-03 (line 382-383) | ○ |
| C-54 | belongs_to_one_project? メソッドでプロジェクト所属判定 | E-03 (line 436-438) | ○ |
| C-55 | predefined_variables メソッドで定義済み変数取得 | E-03 (line 485-490) | ○ |
| C-56 | compute_token_expiration メソッドでトークン期限計算 | E-03 (line 551-559) | ○ |
| C-57 | ensure_manager メソッドでマネージャー確保 | E-03 (line 562-569) | ○ |

### Ci::JobArtifact 関連（UT-CI-058〜UT-CI-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | expired? メソッドで期限切れ判定（正常） | E-04 (line 197-199) | ○ |
| C-59 | expired? メソッドでnil時false | E-04 (line 198) | ○ |
| C-60 | expiring? メソッドで期限切れ予定判定 | E-04 (line 201-203) | ○ |
| C-61 | local_store? メソッドでローカルストア判定 | E-04 (line 187-189) | ○ |
| C-62 | validate_file_format! メソッドでフォーマットバリデーション | E-04 (line 181-185) | ○ |
| C-63 | max_artifact_size クラスメソッドでサイズ制限取得 | E-04 (line 170-179) | ○ |
| C-64 | stored? メソッドで格納済み判定 | E-04 (line 214-216) | ○ |

### Ci::Stage 関連（UT-CI-065〜UT-CI-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | set_status メソッドで状態遷移（正常） | E-05 (line 142-162) | ○ |
| C-66 | set_status メソッドで不明ステータスエラー | E-05 (line 158-159) | ○ |
| C-67 | groups メソッドでグループ取得 | E-05 (line 170-172) | ○ |
| C-68 | has_warnings? メソッドで警告判定 | E-05 (line 174-176) | ○ |
| C-69 | manual_playable? メソッドで手動再生可否 | E-05 (line 196-198) | ○ |

### Ci::Variable 関連（UT-CI-070〜UT-CI-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | 一意性バリデーション | E-06 (line 17-20) | ○ |
| C-71 | audit_details メソッドでキー名返却 | E-06 (line 28-30) | ○ |

### Ci::PipelineSchedule 関連（UT-CI-072〜UT-CI-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | owned_by? メソッドでオーナー判定 | E-07 (line 74-76) | ○ |
| C-73 | own! メソッドでオーナー変更 | E-07 (line 78-80) | ○ |
| C-74 | deactivate! メソッドで非活性化 | E-07 (line 86-88) | ○ |
| C-75 | ref_for_display メソッドで表示用ref取得 | E-07 (line 117-121) | ○ |
| C-76 | for_tag? メソッドでタグ判定 | E-07 (line 123-127) | ○ |
| C-77 | daily_limit メソッドで日次制限取得 | E-07 (line 113-115) | ○ |

### Ci::Trigger 関連（UT-CI-078〜UT-CI-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | can_access_project? メソッドでアクセス権判定 | E-08 (line 81-83) | ○ |
| C-79 | short_token メソッドで短縮トークン取得 | E-08 (line 73-78) | ○ |
| C-80 | last_used メソッドで最終使用日時取得 | E-08 (line 66-71) | ○ |

### Ci::Bridge 関連（UT-CI-081〜UT-CI-087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | triggers_child_pipeline? メソッドで子パイプライン判定 | E-09 (line 155-157) | ○ |
| C-82 | triggers_cross_project_pipeline? メソッドでクロスプロジェクト判定 | E-09 (line 159-161) | ○ |
| C-83 | downstream_project メソッドでダウンストリーム取得 | E-09 (line 126-134) | ○ |
| C-84 | has_strategy? メソッドで戦略判定 | E-09 (line 247-249) | ○ |
| C-85 | playable? メソッドで再生可否判定 | E-09 (line 177-179) | ○ |
| C-86 | retryable? メソッドでリトライ可否判定（正常） | E-09 (line 109-113) | ○ |
| C-87 | retryable? メソッドでループ検出時false | E-09 (line 110) | ○ |

### Ci::Processable 関連（UT-CI-088〜UT-CI-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | with_resource_group? メソッドでリソースグループ判定 | E-10 (line 275-277) | ○ |
| C-89 | retryable? メソッドでリトライ可否判定 | E-10 (line 228-232) | ○ |
| C-90 | manual_job? メソッドで手動ジョブ判定 | E-10 (line 328-330) | ○ |

### Ci::SecureFile 関連（UT-CI-091〜UT-CI-094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | checksum_algorithm メソッドでsha256返却 | E-11 (line 35-37) | ○ |
| C-92 | metadata_parsable? メソッドで解析可否判定（正常） | E-11 (line 43-45) | ○ |
| C-93 | metadata_parsable? メソッドで非対応拡張子時false | E-11 (line 44) | ○ |
| C-94 | local? メソッドでローカル判定 | E-11 (line 74-76) | ○ |

### Ci::ResourceGroup 関連（UT-CI-095〜UT-CI-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | assign_resource_to メソッドでリソース割り当て | E-12 (line 29-39) | ○ |
| C-96 | release_resource_from メソッドでリソース解放 | E-12 (line 41-48) | ○ |
| C-97 | upcoming_processables メソッドで次のプロセッサブル取得 | E-12 (line 50-65) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースがソースコードから直接導出されており、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいて生成されています。

### 注意点
- Ci::Pipeline は97個のモデルファイル中最も複雑で1700行以上のコードを持つため、追加のテストケースが必要になる可能性があります
- state_machine の状態遷移テストは網羅的に実施することを推奨
- Ci::Build はRunner連携やアーティファクト管理など外部依存が多いため、モックを適切に使用する必要があります

## 6) レビュアーチェックリスト（最小）
- [ ] UT-CI-001〜UT-CI-026: Ci::Pipeline の状態遷移とバリデーションが網羅されているか確認
- [ ] UT-CI-027〜UT-CI-045: Ci::Build の主要メソッドが網羅されているか確認
- [ ] UT-CI-046〜UT-CI-057: Ci::Runner のランナー管理機能が適切にテストされているか確認
- [ ] UT-CI-058〜UT-CI-064: Ci::JobArtifact のアーティファクトライフサイクルがテストされているか確認
- [ ] UT-CI-081〜UT-CI-087: Ci::Bridge のダウンストリームパイプライン機能がテストされているか確認
- [ ] 全体: 境界値テストが十分に含まれているか確認
- [ ] 全体: 異常系テストが実際のエラーハンドリングと一致しているか確認
