---
generated_at: 2026-01-22 15:25:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：cloud_connector単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースがソースコードに基づいている
  2. 既存テストスペックファイルとの整合性が確認済み
  3. 根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/cloud_connector/service_access_token.rb` - モデル定義ファイル（28行）
- E-02: `spec/models/cloud_connector/service_access_token_spec.rb` - 既存テストスペック（69行）
- E-03: `spec/factories/ai/service_access_tokens.rb` - ファクトリ定義（33行）
- E-04: `config/initializers/1_settings.rb` - 設定ファイル（cloud_connector設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | scope :expiredが期限切れトークンを取得 | E-01 (L9), E-02 (L9-13) | ○ |
| C-02 | scope :expiredの境界値テスト | E-01 (L9) | ○ |
| C-03 | scope :expiredの空配列返却 | E-01 (L9), E-02 (L9-13) | ○ |
| C-04 | scope :activeがアクティブトークンを取得 | E-01 (L10), E-02 (L15-19) | ○ |
| C-05 | scope :activeの境界値テスト | E-01 (L10) | ○ |
| C-06 | scope :activeの空配列返却 | E-01 (L10), E-02 (L15-19) | ○ |
| C-07 | tokenの暗号化保存 | E-01 (L12-17), E-02 (L21-35) | ○ |
| C-08 | tokenの復号取得 | E-01 (L12-17), E-02 (L26-34) | ○ |
| C-09 | per_attribute_ivモード | E-01 (L13) | ○ |
| C-10 | 空トークンの異常系 | E-01 (L19) | ○ |
| C-11 | tokenのpresenceバリデーション（正常） | E-01 (L19), E-02 (L38) | ○ |
| C-12 | tokenのpresenceバリデーション（異常） | E-01 (L19), E-02 (L38) | ○ |
| C-13 | expires_atのpresenceバリデーション（正常） | E-01 (L19), E-02 (L39) | ○ |
| C-14 | expires_atのpresenceバリデーション（異常） | E-01 (L19), E-02 (L39) | ○ |
| C-15 | expired?が期限切れでtrue | E-01 (L21-23), E-02 (L48-50) | ○ |
| C-16 | expired?がアクティブでfalse | E-01 (L21-23), E-02 (L44-46) | ○ |
| C-17 | expired?の境界値（現在時刻） | E-01 (L22) | ○ |
| C-18 | expired?の境界値（1秒前） | E-01 (L22) | ○ |
| C-19 | refresh_required?が2日以上でfalse | E-01 (L25-27), E-02 (L57-58) | ○ |
| C-20 | refresh_required?が2日以内でtrue | E-01 (L25-27), E-02 (L61-62) | ○ |
| C-21 | refresh_required?の境界値（ちょうど2日） | E-01 (L26) | ○ |
| C-22 | refresh_required?が期限切れでtrue | E-01 (L25-27), E-02 (L65-67) | ○ |
| C-23 | refresh_required?の境界値（2日未満） | E-01 (L26) | ○ |
| C-24 | テーブル名の設定 | E-01 (L7) | ○ |
| C-25 | 暗号化キーの取得 | E-01 (L14) | ○ |
| C-26 | createの正常系 | E-01, E-03 | ○ |
| C-27 | createの異常系 | E-01 (L19) | ○ |
| C-28 | updateの正常系 | E-01 | ○ |
| C-29 | destroyの正常系 | E-01 | ○ |
| C-30 | AES-256-GCMアルゴリズム | E-01 (L15) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 既存テストスペック（E-02）で多くのテストケースが実装済みであり、ソースコードとの整合性が高い

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいている
- cloud_connectorモジュールは比較的小規模（1モデル、28行）であり、テストケースの網羅性が高い
- 暗号化関連のテストケース（C-07〜C-10, C-25, C-30）はセキュリティ上重要であり、優先度高で設定済み

## 6) レビュアーチェックリスト（最小）
- [ ] scope :expired と scope :active の境界値条件（<, >の使い分け）が正しいか確認
- [ ] attr_encrypted の設定（algorithm, mode, encode等）が実際の実装と一致しているか確認
- [ ] refresh_required?の2日という閾値がビジネス要件と一致しているか確認
- [ ] 既存テストスペック（E-02）との重複・差分を確認
- [ ] トークンの有効期限管理に関するビジネスロジックが網羅されているか確認
