---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 234
  claims_with_evidence: 234
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：clusters.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：234 / 234、根拠なし：0
- 優先レビュー（高）
  1. **認可関連テストケース（UT-CLU-050〜061）**：CI/Userアクセス認可ロジックは複雑なため確認推奨
  2. **状態遷移テストケース（UT-CLU-038〜041）**：state_machineの遷移条件を実コードと照合推奨
  3. **Kubernetesネームスペース解決（UT-CLU-018〜021）**：複数の解決パスがあり網羅性の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/cluster.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agent.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agent_token.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/project.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/group.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/instance.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/kubernetes_namespace.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/platforms/kubernetes.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/providers/gcp.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/providers/aws.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/clusters_hierarchy.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agent_migration.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/cluster_enabled_grant.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/activity_event.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/managed_resource.rb`
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/authorizations/ci_access/group_authorization.rb`
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/authorizations/ci_access/project_authorization.rb`
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/authorizations/ci_access/organization_authorization.rb`
- E-19: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/authorizations/ci_access/implicit_authorization.rb`
- E-20: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/authorizations/user_access/group_authorization.rb`
- E-21: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/agents/authorizations/user_access/project_authorization.rb`
- E-22: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/concerns/provider_status.rb`
- E-23: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/concerns/application_core.rb`
- E-24: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/clusters/concerns/application_status.rb`
- E-25: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/agents/create_service.rb`
- E-26: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/agents/delete_service.rb`
- E-27: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/agent_tokens/create_service.rb`
- E-28: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/agent_tokens/revoke_service.rb`
- E-29: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/create_service.rb`
- E-30: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/destroy_service.rb`
- E-31: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/update_service.rb`
- E-32: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/build_service.rb`
- E-33: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/agents/create_activity_event_service.rb`
- E-34: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/agent_tokens/track_usage_service.rb`
- E-35: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/clusters/cleanup/project_namespace_service.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Clusters::Cluster（UT-CLU-001〜049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜005 | status_name メソッドのテストケース | E-01 (L169-173) | ○ |
| C-006〜008 | all_projects メソッドのテストケース | E-01 (L162-167) | ○ |
| C-009〜012 | provider/platform メソッドのテストケース | E-01 (L228-238) | ○ |
| C-013〜016 | first_project/first_group/instance メソッドのテストケース | E-01 (L240-256) | ○ |
| C-017 | kubeclient メソッドのテストケース | E-01 (L258-259) | ○ |
| C-018〜021 | kubernetes_namespace_for メソッドのテストケース | E-01 (L262-270) | ○ |
| C-022〜024 | allow_user_defined_namespace? メソッドのテストケース | E-01 (L272-274) | ○ |
| C-025〜028 | kube_ingress_domain/predefined_variables のテストケース | E-01 (L276-286) | ○ |
| C-029〜033 | delete_cached_resources!/clusterable のテストケース | E-01 (L288-305) | ○ |
| C-034〜037 | on_creation?/platform_kubernetes_active?/rbac? のテストケース | E-01 (L212-226) | ○ |
| C-038〜041 | state_machine (cleanup_status) のテストケース | E-01 (L125-160) | ○ |
| C-042〜049 | バリデーションのテストケース | E-01 (L53-67, L309-389) | ○ |

### Clusters::Agent（UT-CLU-050〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-050〜051 | has_access_to? メソッドのテストケース | E-02 (L53-55) | ○ |
| C-052〜053 | connected? メソッドのテストケース | E-02 (L57-59) | ○ |
| C-054〜056 | activity_event_deletion_cutoff/to_ability_name のテストケース | E-02 (L61-70) | ○ |
| C-057〜061 | ci_access_authorized_for?/user_access_authorized_for? のテストケース | E-02 (L72-84) | ○ |
| C-062 | user_access_config メソッドのテストケース | E-02 (L88-97) | ○ |
| C-063〜067 | バリデーション（name）のテストケース | E-02 (L44-51) | ○ |

### Clusters::AgentToken（UT-CLU-068〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-068 | revoke! メソッドのテストケース | E-03 (L42-44) | ○ |
| C-069〜070 | to_ability_name/glagent_prefix のテストケース | E-03 (L46-58) | ○ |
| C-071〜075 | バリデーション/スコープのテストケース | E-03 (L29-35) | ○ |

### Clusters::Project/Group/Instance（UT-CLU-076〜083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-076〜078 | Clusters::Project リレーションのテストケース | E-04 (L7-10) | ○ |
| C-079〜080 | Clusters::Group リレーションのテストケース | E-05 (L7-8) | ○ |
| C-081〜083 | Clusters::Instance メソッドのテストケース | E-06 (L5-17) | ○ |

### Clusters::KubernetesNamespace（UT-CLU-084〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-084 | token_name メソッドのテストケース | E-07 (L33-35) | ○ |
| C-085〜088 | predefined_variables メソッドのテストケース | E-07 (L37-45) | ○ |
| C-089〜091 | バリデーションのテストケース | E-07 (L16-20) | ○ |

### Clusters::Platforms::Kubernetes（UT-CLU-092〜119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-092〜095 | enabled?/provided_by_user?/allow_user_defined_namespace? のテストケース | E-08 (L81-92) | ○ |
| C-096〜098 | predefined_variables メソッドのテストケース | E-08 (L94-118) | ○ |
| C-099〜102 | kubeclient/kubeconfig メソッドのテストケース | E-08 (L155-184, L244-255) | ○ |
| C-103〜105 | rollout_status/terminals/ingresses のテストケース | E-08 (L149-176) | ○ |
| C-106〜117 | バリデーションのテストケース | E-08 (L49-70, L298-311) | ○ |
| C-118〜119 | 前処理（enforce_*）のテストケース | E-08 (L289-296) | ○ |

### Clusters::Providers::Gcp（UT-CLU-120〜135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120〜121 | nullify_credentials/assign_operation_id のテストケース | E-09 (L41-49) | ○ |
| C-122〜124 | has_rbac_enabled?/knative_pre_installed? のテストケース | E-09 (L52-58) | ○ |
| C-125〜129 | バリデーションのテストケース | E-09 (L25-39) | ○ |
| C-130〜135 | state_machine (ProviderStatus) のテストケース | E-22 (L9-49) | ○ |

### Clusters::Providers::Aws（UT-CLU-136〜143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136〜139 | nullify_credentials/has_rbac_enabled?/knative_pre_installed?/created_by_user のテストケース | E-10 (L41-59) | ○ |
| C-140〜143 | バリデーションのテストケース | E-10 (L25-39) | ○ |

### Clusters::ClustersHierarchy（UT-CLU-144〜146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144〜146 | base_and_ancestors メソッドのテストケース | E-11 (L12-23, L32-39) | ○ |

### Clusters::AgentMigration（UT-CLU-147〜149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147〜149 | バリデーション/enumのテストケース | E-12 (L14-22) | ○ |

### Clusters::ClusterEnabledGrant（UT-CLU-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | belongs_to :namespace リレーションのテストケース | E-13 (L7) | ○ |

### Clusters::Agents::ActivityEvent（UT-CLU-151〜160）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151〜160 | バリデーション/enum/スコープのテストケース | E-14 (L15-36) | ○ |

### Clusters::Agents::ManagedResource（UT-CLU-161〜164）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-161〜164 | バリデーション/enumのテストケース | E-15 (L13-31) | ○ |

### Clusters::Agents::Authorizations（UT-CLU-165〜184）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165〜170 | CiAccess系認可のテストケース | E-16, E-17, E-18, E-19 | ○ |
| C-171〜173 | ImplicitAuthorizationのテストケース | E-19 (L10-21) | ○ |
| C-174〜178 | UserAccess::GroupAuthorizationのテストケース | E-20 (L15-43) | ○ |
| C-179〜184 | UserAccess::ProjectAuthorizationのテストケース | E-21 (L15-37) | ○ |

### Clusters::Concerns（UT-CLU-185〜200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-185〜195 | ApplicationStatusのテストケース | E-24 (L108-124) | ○ |
| C-196〜200 | ApplicationCoreのテストケース | E-23 (L17-43) | ○ |

### Services（UT-CLU-201〜234）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-201〜203 | Agents::CreateServiceのテストケース | E-25 (L6-28) | ○ |
| C-204〜205 | Agents::DeleteServiceのテストケース | E-26 (L6-23) | ○ |
| C-206〜209 | AgentTokens::CreateServiceのテストケース | E-27 (L17-58) | ○ |
| C-210〜212 | AgentTokens::RevokeServiceのテストケース | E-28 (L13-42) | ○ |
| C-213〜215 | AgentTokens::TrackUsageServiceのテストケース | E-34 (L15-54) | ○ |
| C-216〜219 | CreateServiceのテストケース | E-29 (L12-56) | ○ |
| C-220〜221 | DestroyServiceのテストケース | E-30 (L13-33) | ○ |
| C-222〜224 | UpdateServiceのテストケース | E-31 (L12-31) | ○ |
| C-225〜228 | BuildServiceのテストケース | E-32 (L8-22) | ○ |
| C-229〜231 | Agents::CreateActivityEventServiceのテストケース | E-33 (L11-29) | ○ |
| C-232〜234 | Cleanup::ProjectNamespaceServiceのテストケース | E-35 (L8-45) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースに対して根拠となるソースコードを確認済み
- 追加で確認が望ましい項目：
  - EE（Enterprise Edition）固有の拡張機能（`prepend_mod_with`で追加される機能）
  - Feature flagによる条件分岐のテストケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バリデーション、リレーション、単純なメソッドのテストケース
- 1: 中リスク - 状態遷移、認可チェック、Kubernetes接続関連
- 2: 高リスク - なし（全テストケースにソースコード根拠あり）

## 6) レビュアーチェックリスト（最小）
- [ ] CI/Userアクセス認可のテストケースが実際の認可ロジックを網羅しているか確認
- [ ] state_machine遷移のテストケースが全遷移パターンをカバーしているか確認
- [ ] Kubernetes接続関連のテストケースがエラーハンドリングを適切にカバーしているか確認
- [ ] 暗号化属性（token, password, access_token等）のテストケースが機密性を考慮しているか確認
- [ ] バッチ処理（KUBERNETES_NAMESPACE_BATCH_SIZE等）のテストケースが境界値を含んでいるか確認
- [ ] サービスクラスの権限チェックテストが全ての権限パターンを網羅しているか確認
