---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 65
  claims_with_evidence: 65
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：commit_signatures 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：65 / 65、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全テストケースがソースコードに基づいて生成

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/commit_signatures/gpg_signature.rb`
- E-02: `app/models/commit_signatures/x509_commit_signature.rb`
- E-03: `app/models/commit_signatures/ssh_signature.rb`
- E-04: `app/models/concerns/commit_signature.rb`
- E-05: `app/models/concerns/signature_type.rb`
- E-06: `app/models/concerns/enums/commit_signature.rb`
- E-07: `app/policies/commit_signatures/gpg_signature_policy.rb`
- E-08: `app/policies/commit_signatures/x509_commit_signature_policy.rb`
- E-09: `app/policies/commit_signatures/ssh_signature_policy.rb`
- E-10: `app/graphql/types/commit_signatures/verification_status_enum.rb`
- E-11: `app/graphql/types/commit_signatures/gpg_signature_type.rb`
- E-12: `app/graphql/types/commit_signatures/ssh_signature_type.rb`
- E-13: `app/graphql/types/commit_signatures/x509_signature_type.rb`
- E-14: `app/graphql/types/commit_signature_interface.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-CMS-001: GpgKeyオブジェクトが設定できること | E-01 (gpg_key= メソッド lines 34-44) | ○ |
| C-02 | UT-CMS-002: GpgKeySubkeyオブジェクトが設定できること | E-01 (gpg_key= メソッド lines 34-44) | ○ |
| C-03 | UT-CMS-003: nilを設定した場合にクリアされること | E-01 (gpg_key= メソッド lines 40-43) | ○ |
| C-04 | UT-CMS-004: gpg_key_idがある場合にGpgKeyが返却 | E-01 (gpg_key メソッド lines 46-52) | ○ |
| C-05 | UT-CMS-005: gpg_key_subkey_idがある場合にSubkey返却 | E-01 (gpg_key メソッド lines 46-52) | ○ |
| C-06 | UT-CMS-006: 両方nilの場合にnil返却 | E-01 (gpg_key メソッド lines 46-52) | ○ |
| C-07 | UT-CMS-007: gpg_key_primary_keyidが大文字変換 | E-01 (gpg_key_primary_keyid メソッド lines 54-56) | ○ |
| C-08 | UT-CMS-008: gpg_key_primary_keyidがnilでnil返却 | E-01 (gpg_key_primary_keyid メソッド line 55) | ○ |
| C-09 | UT-CMS-009: signed_by_userでgpg_key.user返却 | E-01 (signed_by_user メソッド lines 16-18) | ○ |
| C-10 | UT-CMS-010: gpg_keyがnilでnil返却 | E-01 (signed_by_user メソッド line 17) | ○ |
| C-11 | UT-CMS-011: typeで:gpg返却 | E-01 (type メソッド lines 20-22) | ○ |
| C-12 | UT-CMS-012: gpg_commitでGitlab::Gpg::Commit返却 | E-01 (gpg_commit メソッド lines 58-62) | ○ |
| C-13 | UT-CMS-013: commitがnilでgpg_commitがnil返却 | E-01 (gpg_commit メソッド line 59) | ○ |
| C-14 | UT-CMS-014: userメソッドでgpg_key.user返却 | E-01 (user メソッド lines 64-66) | ○ |
| C-15 | UT-CMS-015: with_key_and_subkeysで関連署名取得 | E-01 (with_key_and_subkeys メソッド lines 24-32) | ○ |
| C-16 | UT-CMS-016: サブキーなしでメインキー署名のみ | E-01 (with_key_and_subkeys メソッド lines 24-32) | ○ |
| C-17 | UT-CMS-017: gpg_key_primary_keyidのpresence検証 | E-01 (validates line 14) | ○ |
| C-18 | UT-CMS-018: X509Signatureのtypeで:x509返却 | E-02 (type メソッド lines 12-14) | ○ |
| C-19 | UT-CMS-019: x509_commitでGitlab::X509::Commit返却 | E-02 (x509_commit メソッド lines 16-19) | ○ |
| C-20 | UT-CMS-020: commitがnilでx509_commitがnil返却 | E-02 (x509_commit メソッド line 17) | ○ |
| C-21 | UT-CMS-021: signed_by_userでcommit.committer返却 | E-02 (signed_by_user メソッド lines 22-24) | ○ |
| C-22 | UT-CMS-022: commitがnilでsigned_by_userがnil返却 | E-02 (signed_by_user メソッド line 23) | ○ |
| C-23 | UT-CMS-023: emails_for_verificationで積集合返却 | E-02 (emails_for_verification メソッド lines 28-30) | ○ |
| C-24 | UT-CMS-024: verified_committer_emailsで検証済みメール返却 | E-02 (verified_committer_emails メソッド lines 32-34) | ○ |
| C-25 | UT-CMS-025: signed_by_userがnilで空配列返却 | E-02 (verified_committer_emails メソッド line 33) | ○ |
| C-26 | UT-CMS-026: x509_certificate_idのpresence検証 | E-02 (validates line 10) | ○ |
| C-27 | UT-CMS-027: X509Certificateリレーション | E-02 (belongs_to line 8) | ○ |
| C-28 | UT-CMS-028: SshSignatureのtypeで:ssh返却 | E-03 (type メソッド lines 11-13) | ○ |
| C-29 | UT-CMS-029: userが設定時にuser返却 | E-03 (signed_by_user メソッド lines 15-17) | ○ |
| C-30 | UT-CMS-030: userがnilでkey.user返却 | E-03 (signed_by_user メソッド line 16) | ○ |
| C-31 | UT-CMS-031: 両方nilでnil返却 | E-03 (signed_by_user メソッド line 16) | ○ |
| C-32 | UT-CMS-032: key_fingerprint_sha256で直接値返却 | E-03 (key_fingerprint_sha256 メソッド lines 19-21) | ○ |
| C-33 | UT-CMS-033: 直接値nilでkey経由返却 | E-03 (key_fingerprint_sha256 メソッド line 20) | ○ |
| C-34 | UT-CMS-034: 両方nilでnil返却 | E-03 (key_fingerprint_sha256 メソッド line 20) | ○ |
| C-35 | UT-CMS-035: Keyリレーション | E-03 (belongs_to line 8) | ○ |
| C-36 | UT-CMS-036: Userリレーション | E-03 (belongs_to line 9) | ○ |
| C-37 | UT-CMS-037: safe_create!で新規作成 | E-04 (safe_create! メソッド lines 23-26) | ○ |
| C-38 | UT-CMS-038: safe_create!で既存レコード返却 | E-04 (safe_create! メソッド lines 23-26) | ○ |
| C-39 | UT-CMS-039: unsigned_commit_shasで未署名SHA返却 | E-04 (unsigned_commit_shas メソッド lines 29-34) | ○ |
| C-40 | UT-CMS-040: 空配列入力で空配列返却 | E-04 (unsigned_commit_shas メソッド line 30) | ○ |
| C-41 | UT-CMS-041: 全署名済みで空配列返却 | E-04 (unsigned_commit_shas メソッド lines 29-34) | ○ |
| C-42 | UT-CMS-042: commitメソッドでコミット取得 | E-04 (commit メソッド lines 37-39) | ○ |
| C-43 | UT-CMS-043: verification_statusで永続化値返却 | E-04 (verification_status メソッド lines 46-55) | ○ |
| C-44 | UT-CMS-044: Feature flag有効時のメール検証 | E-04 (verification_status メソッド lines 46-55) | ○ |
| C-45 | UT-CMS-045: メール不一致でunverified_author_email | E-04 (verification_status メソッド line 52) | ○ |
| C-46 | UT-CMS-046: commitがnilで永続化値返却 | E-04 (verification_status メソッド line 50) | ○ |
| C-47 | UT-CMS-047: by_commit_shaスコープ | E-04 (scope line 19) | ○ |
| C-48 | UT-CMS-048: commit_shaのpresence検証 | E-04 (validates line 16) | ○ |
| C-49 | UT-CMS-049: project_idのpresence検証 | E-04 (validates line 17) | ○ |
| C-50 | UT-CMS-050: gpg?でtrue返却 | E-05 (define_method lines 10-12) | ○ |
| C-51 | UT-CMS-051: gpg?でfalse返却 | E-05 (define_method lines 10-12) | ○ |
| C-52 | UT-CMS-052: ssh?でtrue返却 | E-05 (define_method lines 10-12) | ○ |
| C-53 | UT-CMS-053: x509?でtrue返却 | E-05 (define_method lines 10-12) | ○ |
| C-54 | UT-CMS-054: verification_statusesでHash返却 | E-06 (verification_statuses メソッド lines 19-21) | ○ |
| C-55 | UT-CMS-055: GraphQL enum定義 | E-10 (VerificationStatusEnum lines 5-12) | ○ |
| C-56 | UT-CMS-056: GpgSignatureTypeフィールド定義 | E-11 (field定義 lines 13-27) | ○ |
| C-57 | UT-CMS-057: SshSignatureTypeフィールド定義 | E-12 (field定義 lines 13-25) | ○ |
| C-58 | UT-CMS-058: X509SignatureTypeフィールド定義 | E-13 (field定義 lines 13-20) | ○ |
| C-59 | UT-CMS-059: resolve_typeでGpgSignatureType返却 | E-14 (resolve_type メソッド lines 28-38) | ○ |
| C-60 | UT-CMS-060: resolve_typeでX509SignatureType返却 | E-14 (resolve_type メソッド lines 28-38) | ○ |
| C-61 | UT-CMS-061: resolve_typeでSshSignatureType返却 | E-14 (resolve_type メソッド lines 28-38) | ○ |
| C-62 | UT-CMS-062: resolve_typeで例外スロー | E-14 (resolve_type メソッド line 37) | ○ |
| C-63 | UT-CMS-063: GpgSignaturePolicyの権限委譲 | E-07 (delegate line 5) | ○ |
| C-64 | UT-CMS-064: X509CommitSignaturePolicyの権限委譲 | E-08 (delegate line 5) | ○ |
| C-65 | UT-CMS-065: SshSignaturePolicyの権限委譲 | E-09 (delegate line 5) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
  - 全テストケースはソースコード解析に基づいて生成されており、根拠が明確に存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に直接基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] verification_status関連のテストケース（UT-CMS-043〜046）がFeature flagの挙動を正しくカバーしているか確認
- [ ] emails_for_verification関連のテストケース（UT-CMS-023〜025）がX509とGPGの両パターンをカバーしているか確認
- [ ] GraphQL型テスト（UT-CMS-055〜062）がスキーマ変更に追従しているか確認
- [ ] ポリシーテスト（UT-CMS-063〜065）が実際の権限チェックを十分にカバーしているか確認
