---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 115
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：concerns.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：115 / 120、根拠なし：5
- 優先レビュー（高）
  1. **UT-CON-085/086**：AuthenticatesWithTwoFactor prompt_for_two_factorの一部挙動は実行時コンテキストに依存
  2. **UT-CON-091/092**：FromUnion from_unionの内部実装はFromSetOperatorモジュールに委譲されており詳細確認が必要
  3. **UT-CON-120**：Subscribable lazy_subscriptionのBatchLoader動作は実行時テストで確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/concerns/issuable.rb` - Issuable concern実装
- E-02: `app/models/concerns/noteable.rb` - Noteable concern実装
- E-03: `app/models/concerns/routable.rb` - Routable concern実装
- E-04: `app/models/concerns/atomic_internal_id.rb` - AtomicInternalId concern実装
- E-05: `app/models/concerns/subscribable.rb` - Subscribable concern実装
- E-06: `app/models/concerns/each_batch.rb` - EachBatch concern実装
- E-07: `app/models/concerns/redis_cacheable.rb` - RedisCacheable concern実装
- E-08: `app/models/concerns/sortable.rb` - Sortable concern実装
- E-09: `app/models/concerns/strip_attribute.rb` - StripAttribute concern実装
- E-10: `app/models/concerns/avatarable.rb` - Avatarable concern実装
- E-11: `app/models/concerns/milestoneable.rb` - Milestoneable concern実装
- E-12: `app/models/concerns/time_trackable.rb` - TimeTrackable concern実装
- E-13: `app/controllers/concerns/check_rate_limit.rb` - CheckRateLimit concern実装
- E-14: `app/controllers/concerns/authenticates_with_two_factor.rb` - AuthenticatesWithTwoFactor concern実装
- E-15: `app/models/concerns/from_union.rb` - FromUnion concern実装
- E-16: `app/models/concerns/presentable.rb` - Presentable concern実装
- E-17: `app/models/concerns/importable.rb` - Importable concern実装
- E-18: `app/models/concerns/resolvable_note.rb` - ResolvableNote concern実装
- E-19: `app/models/concerns/awardable.rb` - Awardable concern実装
- E-20: `app/models/concerns/case_sensitivity.rb` - CaseSensitivity concern実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Issuable#state メソッドが正しい状態を返却 | E-01 L498-500 | ○ |
| C-02 | Issuable#state= メソッドが正しくstate_idを設定 | E-01 L502-504 | ○ |
| C-03 | Issuable#assignee? がアサインユーザーを判定 | E-01 L514-521 | ○ |
| C-04 | Issuable#assignee? が非アサインユーザーを判定 | E-01 L514-521 | ○ |
| C-05 | Issuable#open? がopened状態でtrue | E-01 L523-525 | ○ |
| C-06 | Issuable#overdue? がdue_date過去でtrue | E-01 L527-531 | ○ |
| C-07 | Issuable#overdue? がdue_date nilでfalse | E-01 L528-530 | ○ |
| C-08 | Issuable#user_notes_count が正しくカウント | E-01 L533-541 | ○ |
| C-09 | Issuable#validate_description_length? の境界値動作 | E-01 L249-257 | ○ |
| C-10 | Issuable#truncate_description_on_import! のインポート時動作 | E-01 L259-261 | ○ |
| C-11 | Issuable#validate_assignee_size_length の上限チェック | E-01 L263-268 | ○ |
| C-12 | Issuable.search のタイトル検索 | E-01 L287-289 | ○ |
| C-13 | Issuable.full_search のタイトル/説明検索 | E-01 L333-343 | ○ |
| C-14 | Issuable.sort_by_attribute のソート機能 | E-01 L349-379 | ○ |
| C-15 | Noteable#system_note_timestamp の現在時刻返却 | E-02 L31-33 | ○ |
| C-16 | Noteable#human_class_name の人間可読形式 | E-02 L47-49 | ○ |
| C-17 | Noteable#supports_resolvable_notes? の解決可能判定 | E-02 L51-53 | ○ |
| C-18 | Noteable#supports_discussions? のディスカッション対応判定 | E-02 L55-57 | ○ |
| C-19 | Noteable#discussions のディスカッション取得 | E-02 L89-93 | ○ |
| C-20 | Noteable#discussions_resolved? の解決状態確認 | E-02 L158-160 | ○ |
| C-21 | Noteable#discussions_to_be_resolved の未解決取得 | E-02 L162-164 | ○ |
| C-22 | Noteable#lockable? のロック可能判定 | E-02 L170-172 | ○ |
| C-23 | Noteable#creatable_note_email_address のメールアドレス生成 | E-02 L196-203 | ○ |
| C-24 | Noteable#commenters のコメント投稿者取得 | E-02 L209-215 | ○ |
| C-25 | Routable.find_by_full_path のフルパス検索 | E-03 L18-45 | ○ |
| C-26 | Routable.find_by_full_path のnil時nil返却 | E-03 L19 | ○ |
| C-27 | Routable.find_by_full_path のリダイレクト対応 | E-03 L37-39 | ○ |
| C-28 | Routable#full_name のフルネーム返却 | E-03 L115-117 | ○ |
| C-29 | Routable#full_path のフルパス返却 | E-03 L119-121 | ○ |
| C-30 | Routable#build_full_path の親存在時パス構築 | E-03 L127-133 | ○ |
| C-31 | Routable#build_full_path の親nil時パス構築 | E-03 L131-132 | ○ |
| C-32 | Routable.where_full_path_in の複数パス検索 | E-03 L90-112 | ○ |
| C-33 | Routable.where_full_path_in の空配列時none返却 | E-03 L91 | ○ |
| C-34 | AtomicInternalId.has_internal_id の内部ID生成 | E-04 L32-54 | ○ |
| C-35 | AtomicInternalId#ensure_{scope}_{column}! のID生成 | E-04 L79-98 | ○ |
| C-36 | AtomicInternalId#track_{scope}_{column}! のID追跡 | E-04 L100-120 | ○ |
| C-37 | AtomicInternalId#reset_{scope}_{column} のリセット | E-04 L130-142 | ○ |
| C-38 | AtomicInternalId#validate_{column}_exists! のバリデーション | E-04 L152-156 | ○ |
| C-39 | AtomicInternalId::Supply#next_value の値生成 | E-04 L265-267 | ○ |
| C-40 | Subscribable#subscribed? の購読状態確認 | E-05 L20-28 | ○ |
| C-41 | Subscribable#subscribed? のnil時false返却 | E-05 L21 | ○ |
| C-42 | Subscribable#subscribe の購読設定 | E-05 L76-81 | ○ |
| C-43 | Subscribable#unsubscribe の購読解除 | E-05 L83-88 | ○ |
| C-44 | Subscribable#toggle_subscription の購読トグル | E-05 L67-74 | ○ |
| C-45 | Subscribable#subscribers の購読者取得 | E-05 L59-65 | ○ |
| C-46 | EachBatch.each_batch のバッチ処理 | E-06 L52-106 | ○ |
| C-47 | EachBatch.each_batch の0件時動作 | E-06 L67 | ○ |
| C-48 | EachBatch.each_batch のカスタムカラム対応 | E-06 L52 | ○ |
| C-49 | EachBatch.distinct_each_batch の重複排除 | E-06 L119-166 | ○ |
| C-50 | EachBatch.each_batch_count のバッチカウント | E-06 L192-243 | ○ |
| C-51 | RedisCacheable#cached_attr_reader のキャッシュ読み込み | E-07 L10-20 | ○ |
| C-52 | RedisCacheable#cached_attr_reader のカラム不存在時エラー | E-07 L13-15 | ○ |
| C-53 | RedisCacheable#cache_attributes のキャッシュ保存 | E-07 L28-34 | ○ |
| C-54 | RedisCacheable#merge_cache_attributes のマージ保存 | E-07 L36-42 | ○ |
| C-55 | RedisCacheable#merge_cache_attributes の変更なし時スキップ | E-07 L39 | ○ |
| C-56 | Sortable.order_by のcreated_ascソート | E-08 L24-26, L30 | ○ |
| C-57 | Sortable.order_by のupdated_descソート | E-08 L24-26, L41 | ○ |
| C-58 | Sortable.order_by の未定義ソート時all返却 | E-08 L25 | ○ |
| C-59 | Sortable.simple_sorts のソート方法定義 | E-08 L28-44 | ○ |
| C-60 | StripAttribute#strip_attributes! の空白除去 | E-09 L32-36 | ○ |
| C-61 | StripAttribute#strip_attributes! のnil時動作 | E-09 L34 | ○ |
| C-62 | StripAttribute.strip_attrs の属性リスト | E-09 L23-25 | ○ |
| C-63 | Avatarable#avatar_type の画像検証成功 | E-10 L53-59 | ○ |
| C-64 | Avatarable#avatar_type の非画像検証失敗 | E-10 L54-58 | ○ |
| C-65 | Avatarable#avatar_path のパス生成 | E-10 L61-70 | ○ |
| C-66 | Avatarable#avatar_path のサイズ指定 | E-10 L78 | ○ |
| C-67 | Avatarable#avatar_url のURL生成 | E-10 L34-39 | ○ |
| C-68 | Milestoneable#milestone_available? のプロジェクトマイルストーン検証 | E-11 L57 | ○ |
| C-69 | Milestoneable#milestone_available? のグループマイルストーン検証 | E-11 L58-59 | ○ |
| C-70 | Milestoneable#milestone_available? のblank時true | E-11 L55 | ○ |
| C-71 | Milestoneable#milestone_available? の無関係マイルストーン検証 | E-11 L54-60 | ○ |
| C-72 | Milestoneable#supports_milestone? のサポート確認 | E-11 L66-68 | ○ |
| C-73 | TimeTrackable#spend_time の時間記録 | E-12 L45-61 | ○ |
| C-74 | TimeTrackable#spend_time のリセット | E-12 L56-57, L112-113 | ○ |
| C-75 | TimeTrackable#spend_time の0時動作 | E-12 L54 | ○ |
| C-76 | TimeTrackable#total_time_spent の合計計算 | E-12 L65-73 | ○ |
| C-77 | TimeTrackable#total_time_spent の最大値クランプ | E-12 L72 | ○ |
| C-78 | TimeTrackable#human_total_time_spent の人間可読形式 | E-12 L76-78 | ○ |
| C-79 | TimeTrackable#time_estimate= の見積もり設定 | E-12 L92-94 | ○ |
| C-80 | TimeTrackable#time_estimate= の最大値制限 | E-12 L93 | ○ |
| C-81 | TimeTrackable#check_negative_time_spent の減算検証 | E-12 L129-135 | ○ |
| C-82 | CheckRateLimit#check_rate_limit! の429返却 | E-13 L10-21 | ○ |
| C-83 | CheckRateLimit#check_rate_limit! の制限内継続 | E-13 L11 | ○ |
| C-84 | CheckRateLimit#check_rate_limit! のリダイレクト | E-13 L17-18 | ○ |
| C-85 | AuthenticatesWithTwoFactor#prompt_for_two_factor の2FAプロンプト | E-14 L19-31 | △ |
| C-86 | AuthenticatesWithTwoFactor#prompt_for_two_factor のロックユーザー | E-14 L22 | △ |
| C-87 | AuthenticatesWithTwoFactor#authenticate_with_two_factor_via_otp の有効OTP | E-14 L106-117 | ○ |
| C-88 | AuthenticatesWithTwoFactor#authenticate_with_two_factor_via_otp の無効OTP | E-14 L115-116 | ○ |
| C-89 | AuthenticatesWithTwoFactor#authenticate_with_two_factor_via_webauthn の有効WebAuthn | E-14 L120-138 | ○ |
| C-90 | AuthenticatesWithTwoFactor#user_password_changed? のパスワード変更検出 | E-14 L272-276 | ○ |
| C-91 | FromUnion.from_union のUNION SELECT生成 | E-15 L40-41 | △ |
| C-92 | FromUnion.from_union のUNION ALL生成 | E-15 L40-41 | △ |
| C-93 | Presentable#present のPresenter生成 | E-16 L12-16 | ○ |
| C-94 | Presentable.present の全レコードPresenter適用 | E-16 L7-9 | ○ |
| C-95 | Importable#importing? のインポート状態確認 | E-17 L7-8 | ○ |
| C-96 | Importable#importing? の未設定時nil | E-17 L7 | ○ |
| C-97 | ResolvableNote#resolve! のノート解決 | E-18 L92-94 | ○ |
| C-98 | ResolvableNote#resolve! の解決不可時false | E-18 L68-69 | ○ |
| C-99 | ResolvableNote#unresolve! の解決取消 | E-18 L97-99 | ○ |
| C-100 | ResolvableNote#resolved? の解決状態確認 | E-18 L56-60 | ○ |
| C-101 | ResolvableNote#to_be_resolved? の解決待ち確認 | E-18 L62-64 | ○ |
| C-102 | Awardable#upvotes のアップボートカウント | E-19 L95-97 | ○ |
| C-103 | Awardable#downvotes のダウンボートカウント | E-19 L91-93 | ○ |
| C-104 | Awardable#awarded_emoji? の絵文字付与確認 | E-19 L113-115 | ○ |
| C-105 | Awardable#user_can_award? の権限確認 | E-19 L103-105 | ○ |
| C-106 | Awardable#grouped_awards の絵文字グループ化 | E-19 L79-89 | ○ |
| C-107 | CaseSensitivity.iwhere の大文字小文字無視検索 | E-20 L11-26 | ○ |
| C-108 | CaseSensitivity.iwhere の配列検索 | E-20 L18-19 | ○ |
| C-109 | CaseSensitivity.iwhere のArel対応 | E-20 L15 | ○ |
| C-110 | Issuable.labels_hash のラベルハッシュ生成 | E-01 L166-175 | ○ |
| C-111 | Issuable#to_ability_name の能力名生成 | E-01 L636-638 | ○ |
| C-112 | Issuable#severity の重大度取得 | E-01 L233-237 | ○ |
| C-113 | Issuable#severity のデフォルト値返却 | E-01 L234 | ○ |
| C-114 | Noteable#capped_notes_count の上限付きカウント | E-02 L133-135 | ○ |
| C-115 | Noteable#discussions_can_be_resolved_by? の解決権限確認 | E-02 L166-168 | ○ |
| C-116 | Routable#owned_by? のオーナー確認 | E-03 L136-138 | ○ |
| C-117 | Routable#full_path_components のパス分解 | E-03 L123-125 | ○ |
| C-118 | AtomicInternalId.scope_attrs のスコープ属性生成 | E-04 L206-208 | ○ |
| C-119 | AtomicInternalId.scope_usage のスコープ使用名 | E-04 L220-222 | ○ |
| C-120 | Subscribable#lazy_subscription の遅延ロード | E-05 L30-51 | △ |

## 4) 不足情報（Unknown / Missing）
- AuthenticatesWithTwoFactor（C-85, C-86）: ビューレンダリングやセッション管理の詳細動作は実行時コンテキストに依存するため、統合テストでの確認が推奨
  - 候補：spec/controllers/sessions_controller_spec.rb / spec/features/two_factor_authentication_spec.rb
- FromUnion（C-91, C-92）: 内部実装がFromSetOperatorモジュールに委譲されており、Gitlab::SQL::Unionの詳細確認が必要
  - 候補：lib/gitlab/sql/union.rb / spec/lib/gitlab/sql/union_spec.rb
- Subscribable#lazy_subscription（C-120）: BatchLoaderの動作は実行時テストでの確認が推奨
  - 候補：spec/models/concerns/subscribable_spec.rb

## 5) リスクフラグ（レビュー観点）
- **リスクレベル0（低リスク）**：表示用メソッド、ヘルパーメソッド（C-15, C-16, C-59, C-62, C-78, C-93, C-94, C-111, C-114, C-117, C-119）
- **リスクレベル1（中リスク）**：検索機能、ソート機能、キャッシュ機能（C-12, C-13, C-14, C-51-C-58, C-107-C-109）
- **リスクレベル2（高リスク）**：
  - 状態管理（C-01, C-02, C-05）：Issuableの状態管理は業務ロジックの根幹
  - 内部ID生成（C-34-C-38）：一意性保証が必要
  - 時間追跡（C-73-C-81）：金額計算に影響する可能性
  - 認証（C-82-C-90）：セキュリティに直接関係
  - マイルストーン検証（C-68-C-71）：データ整合性に関係

## 6) レビュアーチェックリスト（最小）
- [ ] Issuable状態管理（C-01, C-02）が正しくSTATE_ID_MAPと連携しているか確認
- [ ] AtomicInternalId（C-34-C-38）の一意性保証ロジックが正しいか確認
- [ ] TimeTrackable（C-73-C-81）の時間計算・制限ロジックが正しいか確認
- [ ] AuthenticatesWithTwoFactor（C-85-C-90）のセキュリティ観点でのテストケース網羅性確認
- [ ] 境界値テスト（C-07, C-31, C-33, C-47, C-55, C-58, C-61, C-70, C-75）の網羅性確認
- [ ] FromUnion（C-91, C-92）の実装詳細確認（FromSetOperator経由）
- [ ] BatchLoaderを使用するSubscribable#lazy_subscription（C-120）の動作確認
