---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 156
  claims_with_evidence: 156
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：container_registry モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：156 / 156、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/container_registry/protection.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/container_registry/data_repair_detail.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/container_registry/protection/rule.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/container_registry/protection/tag_rule.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/container_registry/event.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/check_rule_existence_service.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/create_rule_service.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/update_rule_service.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/delete_rule_service.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/create_tag_rule_service.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/update_tag_rule_service.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/delete_tag_rule_service.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/container_registry/cleanup_worker.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/container_registry/delete_container_repository_worker.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/container_registry/record_data_repair_detail_worker.rb`
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/helpers/container_registry/container_registry_helper.rb`
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/container_registry/protection/concerns/tag_rule.rb`
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/concerns/container_registry/protection/internal_events_tracking.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### モデル関連（ContainerRegistry::Protection, DataRepairDetail）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | table_name_prefixがcontainer_registry_protection_を返却する | E-01 (line 5-7) | ○ |
| C-02 | DataRepairDetailがprojectにbelongs_toする | E-02 (line 10) | ○ |
| C-03 | projectがoptional: falseで必須である | E-02 (line 10) | ○ |
| C-04-06 | status enumが ongoing:0, completed:1, failed:2 を持つ | E-02 (line 12) | ○ |
| C-07-09 | ongoing_sinceスコープがstatus=ongoingかつupdated_at<thresholdで絞り込む | E-02 (line 14) | ○ |

### モデル関連（ContainerRegistry::Protection::Rule）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | RuleがprojectにbelongsToする | E-03 (line 11) | ○ |
| C-11-15 | repository_path_patternのバリデーション（presence, uniqueness, length, format, starts_with） | E-03 (line 13-23) | ○ |
| C-16-18 | minimum_access_level_for_delete enumがmaintainer, owner, adminを持つ | E-03 (line 6-7) | ○ |
| C-19 | 両方のaccess_levelがnilの場合エラー | E-03 (line 111-114) | ○ |
| C-20-22 | for_repository_pathスコープがILIKEでマッチング | E-03 (line 26-33) | ○ |
| C-23-28 | for_action_exists?が:push/:deleteアクションで保護ルール存在チェック | E-03 (line 35-44) | ○ |
| C-29-30 | for_push_exists_for_projects_and_repository_pathsがバッチチェックを実行 | E-03 (line 69-101) | ○ |

### モデル関連（ContainerRegistry::Protection::TagRule）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | TagRuleがprojectにbelongsToする | E-04 (line 15) | ○ |
| C-32-36 | tag_name_patternのバリデーション（presence, length:100, untrusted_regexp, uniqueness） | E-04 (line 17-22) | ○ |
| C-37-38 | validate_access_levelsが両方のアクセスレベル必須をチェック | E-04 (line 84-87) | ○ |
| C-39-43 | mutable, for_actions_and_access, for_delete_and_access, tag_name_patterns_for_project, pluck_tag_name_patternsスコープ | E-04 (line 26-42) | ○ |
| C-44-47 | push_restricted?, delete_restricted?メソッド | E-04 (line 51-57) | ○ |
| C-48-49 | mutable?メソッド | E-04 (line 59-61) | ○ |
| C-50-53 | can_be_deleted?メソッド（admin, maintainer, developer, nil） | E-04 (line 63-68) | ○ |
| C-54-55 | matches_tag_name?メソッド | E-04 (line 70-72) | ○ |
| C-56-57 | type, uniqueness_scopeメソッド | E-04 (line 74-80) | ○ |

### モデル関連（ContainerRegistry::Event）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | initializeでイベントを初期化 | E-05 (line 30-32) | ○ |
| C-59-61 | supported?がpush/deleteをサポート | E-05 (line 34-36) | ○ |
| C-62-63 | handle!でプロジェクト統計更新 | E-05 (line 38-40, 173-180) | ○ |
| C-64-68 | track!でイベントトラッキング | E-05 (line 42-64) | ○ |
| C-69-71 | originatorでユーザー/トークン取得 | E-05 (line 125-133) | ○ |
| C-72-75 | decode_user_infoでJWTデコード | E-05 (line 156-163) | ○ |

### サービス関連（CheckRuleExistenceService）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76-77 | for_delete, for_pushファクトリメソッド | E-06 (line 11-17) | ○ |
| C-78 | initializeで無効なアクション時ArgumentError | E-06 (line 19-23) | ○ |
| C-79-83 | executeで保護ルール存在チェック（User, DeployToken, admin） | E-06 (line 25-62) | ○ |

### サービス関連（CreateRuleService）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84-88 | executeでルール作成（権限チェック、バリデーション、イベントトラッキング） | E-07 (line 14-32) | ○ |

### サービス関連（UpdateRuleService）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89-90 | initializeでnilチェック | E-08 (line 14-22) | ○ |
| C-91-93 | executeでルール更新（権限チェック、バリデーション） | E-08 (line 25-40) | ○ |

### サービス関連（DeleteRuleService）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94-95 | initializeでnilチェック | E-09 (line 9-17) | ○ |
| C-96-98 | executeでルール削除（権限チェック、イベントトラッキング） | E-09 (line 19-34) | ○ |

### サービス関連（CreateTagRuleService）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99-104 | executeでタグルール作成（権限、上限、API互換性、バリデーション、イベント） | E-10 (line 14-41) | ○ |

### サービス関連（UpdateTagRuleService）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105-106 | initializeでnilチェック | E-11 (line 15-23) | ○ |
| C-107-110 | executeでタグルール更新（権限、API互換性、イベント） | E-11 (line 26-44) | ○ |

### サービス関連（DeleteTagRuleService）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111-112 | initializeでnilチェック | E-12 (line 9-17) | ○ |
| C-113-116 | executeでタグルール削除（権限、API互換性、イベント） | E-12 (line 19-35) | ○ |

### ワーカー関連（CleanupWorker）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117-118 | performでジョブエンキュー | E-13 (line 18-24) | ○ |
| C-119 | reset_stale_deletesで停滞リセット | E-13 (line 28-34) | ○ |
| C-120 | delete_stale_ongoing_repair_detailsで停滞削除 | E-13 (line 36-44) | ○ |
| C-121-122 | should_enqueue_record_detail_jobs?の条件チェック | E-13 (line 54-60) | ○ |

### ワーカー関連（DeleteContainerRepositoryWorker）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123-131 | perform_work, remaining_work_count, max_running_jobs, next_container_repository, update_next_container_repository_status | E-14 (line 26-82) | ○ |

### ワーカー関連（RecordDataRepairDetailWorker）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132-140 | perform_work, remaining_work_count, max_running_jobs, lease_key | E-15 (line 20-89) | ○ |

### ヘルパー関連（ContainerRegistryHelper）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141-144 | container_repository_gid_prefix, project_container_registry_template_data | E-16 (line 5-31) | ○ |

### Concerns関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145-150 | protected_patterns_for_delete, protected_for_delete? | E-17 (line 11-44) | ○ |
| C-151-156 | InternalEventsTrackingのトラッキングメソッド | E-18 (line 8-42) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に直接対応しています
- 1: 中リスク - EE拡張（prepend_mod）で追加される機能のテストケースは含まれていません（E-04 line 97, E-05 line 184, E-10 line 64, E-11 line 60, E-14 line 102, E-17 line 50）

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（認可チェック、保護ルール判定）のテストケースが網羅的か確認
- [ ] enum値（status, minimum_access_level_for_push/delete）の境界値テストが十分か確認
- [ ] 外部依存（GitlabApiClient.supports_gitlab_api?）のモック戦略が適切か確認
- [ ] トランザクション処理（next_container_repository）のロック戦略テストが必要か検討
- [ ] JWT処理（decode_user_info）のセキュリティテストが十分か確認
- [ ] EE拡張機能のテストケースが別途必要か確認
