---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：customer_relations.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/customer_relations/contact.rb` - Contactモデル定義
- E-02: `app/models/customer_relations/organization.rb` - Organizationモデル定義
- E-03: `app/models/customer_relations/issue_contact.rb` - IssueContactモデル定義
- E-04: `app/models/customer_relations/contact_state_counts.rb` - ContactStateCounts定義
- E-05: `app/services/customer_relations/contacts/base_service.rb` - ContactsベースService
- E-06: `app/services/customer_relations/contacts/create_service.rb` - Contact作成Service
- E-07: `app/services/customer_relations/contacts/update_service.rb` - Contact更新Service
- E-08: `app/services/customer_relations/organizations/base_service.rb` - OrganizationsベースService
- E-09: `app/services/customer_relations/organizations/create_service.rb` - Organization作成Service
- E-10: `app/services/customer_relations/organizations/update_service.rb` - Organization更新Service
- E-11: `app/services/customer_relations/group_migration_service.rb` - グループ移行Service
- E-12: `app/graphql/mutations/customer_relations/contacts/base.rb` - GraphQL Contacts Base Mutation
- E-13: `app/graphql/mutations/customer_relations/contacts/create.rb` - GraphQL Contact作成Mutation
- E-14: `app/graphql/mutations/customer_relations/contacts/update.rb` - GraphQL Contact更新Mutation
- E-15: `app/graphql/mutations/customer_relations/organizations/create.rb` - GraphQL Organization作成Mutation
- E-16: `app/graphql/mutations/customer_relations/organizations/update.rb` - GraphQL Organization更新Mutation
- E-17: `app/policies/customer_relations/contact_policy.rb` - Contactポリシー定義
- E-18: `app/policies/customer_relations/organization_policy.rb` - Organizationポリシー定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Contact モデル（UT-CRM-001 〜 UT-CRM-049）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :groupリレーションテスト | E-01 (L10) | ○ |
| C-02 | belongs_to :organizationリレーションテスト | E-01 (L11) | ○ |
| C-03 | organization optional: trueの挙動 | E-01 (L11) | ○ |
| C-04 | has_many :issue_contactsリレーションテスト | E-01 (L12) | ○ |
| C-05 | has_many :issues throughリレーションテスト | E-01 (L13) | ○ |
| C-06 | validates :group presence | E-01 (L22) | ○ |
| C-07-12 | validates :first_name, :last_name | E-01 (L24-25) | ○ |
| C-13-14 | validates :phone length | E-01 (L23) | ○ |
| C-15-18 | validates :email length, uniqueness | E-01 (L26, L28) | ○ |
| C-19-20 | validates :description length | E-01 (L27) | ○ |
| C-21-22 | validate_email_format | E-01 (L133-136) | ○ |
| C-23-24 | validate_crm_group | E-01 (L139-143) | ○ |
| C-25-26 | enum :state | E-01 (L17-20) | ○ |
| C-27 | strip_attributes! | E-01 (L15) | ○ |
| C-28 | hook_attrs | E-01 (L50-52) | ○ |
| C-29-31 | reference_prefix, reference_prefix_quoted, reference_postfix | E-01 (L54-64) | ○ |
| C-32-36 | self.search | E-01 (L73-75) | ○ |
| C-37 | self.search_by_state | E-01 (L77-79) | ○ |
| C-38-41 | self.sort_by_field, self.sort_by_organization | E-01 (L81-95) | ○ |
| C-42 | self.sort_by_name | E-01 (L97-113) | ○ |
| C-43-45 | self.find_ids_by_emails | E-01 (L115-119) | ○ |
| C-46-48 | self.exists_for_group? | E-01 (L121-125) | ○ |
| C-49 | self.counts_by_state | E-01 (L127-129) | ○ |

### Organization モデル（UT-CRM-050 〜 UT-CRM-074）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | belongs_to :groupリレーションテスト | E-02 (L10) | ○ |
| C-51 | has_many :contactsリレーションテスト | E-02 (L11) | ○ |
| C-52-59 | バリデーションテスト（group, name, description） | E-02 (L20-25) | ○ |
| C-60-61 | validate_crm_group | E-02 (L74-78) | ○ |
| C-62-63 | enum :state | E-02 (L15-18) | ○ |
| C-64 | strip_attributes! | E-02 (L13) | ○ |
| C-65-67 | self.search, self.search_by_state | E-02 (L37-43) | ○ |
| C-68-70 | self.sort_by_field, self.sort_by_name | E-02 (L45-55) | ○ |
| C-71-72 | self.find_by_name | E-02 (L57-60) | ○ |
| C-73-74 | self.counts_by_state, default_state_counts | E-02 (L62-72) | ○ |

### IssueContact モデル（UT-CRM-075 〜 UT-CRM-086）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75-78 | belongs_to :issue, :contactリレーションテスト | E-03 (L8-9) | ○ |
| C-79-80 | contact_belongs_to_crm_group | E-03 (L39-44) | ○ |
| C-81-82 | self.find_contact_ids_by_emails | E-03 (L15-21) | ○ |
| C-83-84 | self.delete_for_project | E-03 (L23-28) | ○ |
| C-85-86 | self.delete_for_group | E-03 (L30-35) | ○ |

### ContactStateCounts（UT-CRM-087 〜 UT-CRM-091）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87-91 | initialize, inactive, active, all, counts | E-04 (L13-39) | ○ |

### Contacts Services（UT-CRM-092 〜 UT-CRM-109）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92-98 | BaseService: allowed?, organization_valid? | E-05 (L8-23) | ○ |
| C-99-102 | CreateService: execute | E-06 (L6-14) | ○ |
| C-103-109 | UpdateService: execute, handle_active_param | E-07 (L6-28) | ○ |

### Organizations Services（UT-CRM-110 〜 UT-CRM-119）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110-111 | BaseService: allowed? | E-08 (L8-9) | ○ |
| C-112-114 | CreateService: execute | E-09 (L7-15) | ○ |
| C-115-119 | UpdateService: execute, handle_active_param | E-10 (L6-30) | ○ |

### GroupMigrationService（UT-CRM-120 〜 UT-CRM-128）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120-128 | execute, copy_organizations, copy_contacts, update_issues | E-11 (L5-109) | ○ |

### GraphQL Mutations（UT-CRM-129 〜 UT-CRM-138）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129-130 | Contacts::Base set_organization! | E-12 (L17-21) | ○ |
| C-131-132 | Contacts::Create resolve | E-13 (L39-49) | ○ |
| C-133-134 | Contacts::Update resolve | E-14 (L41-58) | ○ |
| C-135-136 | Organizations::Create resolve | E-15 (L38-47) | ○ |
| C-137-138 | Organizations::Update resolve | E-16 (L41-57) | ○ |

### Policies（UT-CRM-139 〜 UT-CRM-140）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | ContactPolicy delegate | E-17 (L4) | ○ |
| C-140 | OrganizationPolicy delegate | E-18 (L4) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全テストケースについてソースコードから根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、信頼度は高い
- 注意点：
  - MAX_PLUCK定数の値（E-01, E-03で参照）はApplicationRecordまたは別の場所で定義されている可能性があり、実際のテスト実装時に確認が必要
  - CRMグループ判定(crm_group?)メソッドの詳細動作は、Groupモデル側の実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] Contact/Organizationのバリデーション境界値（文字数制限）が正しく設定されているか確認
- [ ] CRMグループ検証テスト（validate_crm_group）の前提条件が実行可能か確認
- [ ] GroupMigrationServiceのSQL実行テストでトランザクション処理が適切にテストされるか確認
- [ ] GraphQL Mutationsの認可テストでDeclarativePolicyの設定が正しく反映されるか確認
- [ ] MAX_PLUCK定数の値を確認し、境界値テストに反映する
