---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 120
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：cycle_analytics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：120 / 120、根拠なし：0
- 優先レビュー（高）
  1. すべてのテストケースはソースコードから直接抽出
  2. 高優先度テストケースを重点的にレビュー推奨
  3. バリデーションロジックと境界値テストの確認を推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/cycle_analytics/project_level_stage_adapter.rb`
- E-02: `app/models/analytics/cycle_analytics/stage.rb`
- E-03: `app/models/analytics/cycle_analytics/value_stream.rb`
- E-04: `app/models/analytics/cycle_analytics/aggregation.rb`
- E-05: `app/models/analytics/cycle_analytics/stage_aggregation.rb`
- E-06: `app/models/analytics/cycle_analytics/stage_event_hash.rb`
- E-07: `app/models/analytics/cycle_analytics/merge_request_stage_event.rb`
- E-08: `app/models/analytics/cycle_analytics/issue_stage_event.rb`
- E-09: `app/models/analytics/cycle_analytics/project_level.rb`
- E-10: `app/models/concerns/analytics/cycle_analytics/parentable.rb`
- E-11: `app/models/concerns/analytics/cycle_analytics/stageable.rb`
- E-12: `app/models/concerns/analytics/cycle_analytics/stage_event_model.rb`
- E-13: `app/services/analytics/cycle_analytics/stages/base_service.rb`
- E-14: `app/services/analytics/cycle_analytics/stages/list_service.rb`
- E-15: `app/services/analytics/cycle_analytics/value_streams/list_service.rb`
- E-16: `app/finders/analytics/cycle_analytics/stage_finder.rb`
- E-17: `app/presenters/analytics/cycle_analytics/stage_presenter.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### CycleAnalytics::ProjectLevelStageAdapter (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | initialize: stageとoptionsが正しく初期化される | E-01 (L9-12) | ○ |
| C-002 | as_json: ProjectLevelStage構造体をシリアライズ | E-01 (L15-25) | ○ |
| C-003 | events: DataCollectorからレコード取得 | E-01 (L28-30) | ○ |
| C-004 | median: 中央値を秒単位で返却 | E-01 (L32-34) | ○ |
| C-005 | median: データなし時の挙動 | E-01 (L32-34) | ○ |

### Analytics::CycleAnalytics::Stage (E-02, E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-006 | belongs_to :value_stream リレーション | E-02 (L17-18) | ○ |
| C-007 | has_one :stage_aggregation リレーション | E-02 (L19) | ○ |
| C-008 | validates :name uniqueness | E-02 (L13) | ○ |
| C-009 | max_stages_count: MAX_STAGES_PER_VALUE_STREAM(15)上限 | E-02 (L6, L55-59) | ○ |
| C-010 | max_stages_count: 上限未満は成功 | E-02 (L55-59) | ○ |
| C-011 | validate_default_stage_name: 有効な名前 | E-02 (L62-71) | ○ |
| C-012 | validate_default_stage_name: 無効な名前 | E-02 (L62-71) | ○ |
| C-013 | validate_default_stage_name: カスタムステージ | E-02 (L64) | ○ |
| C-014 | to_global_id: 永続化済み | E-02 (L29-34) | ○ |
| C-015 | to_global_id: 未永続化 | E-02 (L29-34) | ○ |
| C-016 | distinct_stages_within_hierarchy | E-02 (L36-51) | ○ |
| C-017 | ensure_aggregation_record_presence! | E-02 (L27, L73-75) | ○ |

### Analytics::CycleAnalytics::ValueStream (E-03, E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-018 | has_many :stages リレーション | E-03 (L12-16) | ○ |
| C-019 | validates :name presence | E-03 (L18) | ○ |
| C-020 | validates :name length minimum | E-03 (L19) | ○ |
| C-021 | validates :name length maximum | E-03 (L19) | ○ |
| C-022 | validates :name uniqueness | E-03 (L19) | ○ |
| C-023 | max_value_streams_count: MAX(50)上限 | E-03 (L6, L54-58) | ○ |
| C-024 | custom?: 永続化済み | E-03 (L31-33) | ○ |
| C-025 | custom?: デフォルト名でない | E-03 (L31-33) | ○ |
| C-026 | custom?: デフォルト名 | E-03 (L31-33) | ○ |
| C-027 | build_default_value_stream | E-03 (L35-37) | ○ |
| C-028 | project: ProjectNamespaceの場合 | E-03 (L39-43) | ○ |
| C-029 | project: ProjectNamespaceでない場合 | E-03 (L39-43) | ○ |
| C-030 | to_global_id: 永続化済み | E-03 (L45-50) | ○ |
| C-031 | to_global_id: 未永続化 | E-03 (L45-50) | ○ |
| C-032 | ensure_aggregation_record_presence | E-03 (L29, L61-63) | ○ |

### Analytics::CycleAnalytics::Aggregation (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-033 | cursor_for: カーソル取得 | E-04 (L19-24) | ○ |
| C-034 | cursor_for: 空カーソル | E-04 (L19-24) | ○ |
| C-035 | consistency_check_cursor_for: 取得 | E-04 (L26-33) | ○ |
| C-036 | consistency_check_cursor_for: 空 | E-04 (L26-33) | ○ |
| C-037 | refresh_last_run | E-04 (L35-37) | ○ |
| C-038 | complete | E-04 (L39-44) | ○ |
| C-039 | set_cursor | E-04 (L46-49) | ○ |
| C-040 | set_stats | E-04 (L51-55) | ○ |
| C-041 | set_stats: 上限管理 | E-04 (L51-55) | ○ |
| C-042 | estimated_next_run_at | E-04 (L57-66) | ○ |
| C-043 | estimated_next_run_at: enabled=false | E-04 (L58) | ○ |
| C-044 | estimated_next_run_at: last_run_at=nil | E-04 (L59) | ○ |
| C-045 | safe_create_for_namespace: Group | E-04 (L68-88) | ○ |
| C-046 | safe_create_for_namespace: 既存enabled | E-04 (L80-81) | ○ |
| C-047 | safe_create_for_namespace: 再有効化 | E-04 (L83-85) | ○ |
| C-048 | load_batch | E-04 (L115-131) | ○ |
| C-049 | load_batch: 優先順位 | E-04 (L115-131) | ○ |

### Analytics::CycleAnalytics::StageAggregation (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-050 | belongs_to :stage | E-05 (L10) | ○ |
| C-051 | validates runtimes_in_seconds length | E-05 (L12-13) | ○ |
| C-052 | load_batch | E-05 (L19-21) | ○ |
| C-053 | cursor_for | E-05 (L23-28) | ○ |
| C-054 | set_cursor | E-05 (L30-33) | ○ |
| C-055 | refresh_last_run | E-05 (L35-37) | ○ |
| C-056 | set_stats | E-05 (L39-43) | ○ |
| C-057 | set_stats: 上限管理 | E-05 (L41-42) | ○ |
| C-058 | complete | E-05 (L45-47) | ○ |

### Analytics::CycleAnalytics::StageEventHash (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-059 | validates :hash_sha256 presence | E-06 (L8) | ○ |
| C-060 | record_id_by_hash_sha256: 既存 | E-06 (L11-36) | ○ |
| C-061 | record_id_by_hash_sha256: 新規 | E-06 (L11-36) | ○ |
| C-062 | record_id_by_hash_sha256: 競合制御 | E-06 (L26) | ○ |
| C-063 | cleanup_if_unused: 削除 | E-06 (L38-42) | ○ |
| C-064 | cleanup_if_unused: 使用中保護 | E-06 (L38-42) | ○ |
| C-065 | unused_hashes_for | E-06 (L44-48) | ○ |

### Analytics::CycleAnalytics::MergeRequestStageEvent (E-07, E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-066 | validates presence | E-07 (L9) | ○ |
| C-067 | belongs_to :issuable | E-07 (L14) | ○ |
| C-068 | scope :assigned_to | E-07 (L16-20) | ○ |
| C-069 | project_column | E-07 (L22-24) | ○ |
| C-070 | issuable_id_column | E-07 (L26-28) | ○ |
| C-071 | issuable_model | E-07 (L30-32) | ○ |

### Analytics::CycleAnalytics::IssueStageEvent (E-08, E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-072 | validates presence | E-08 (L9) | ○ |
| C-073 | belongs_to :issuable | E-08 (L13) | ○ |
| C-074 | scope :assigned_to | E-08 (L15-20) | ○ |
| C-075 | project_column | E-08 (L23-25) | ○ |
| C-076 | issuable_id_column | E-08 (L27-29) | ○ |
| C-077 | issuable_model | E-08 (L31-33) | ○ |
| C-078 | select_columns: weight, sprint_id | E-08 (L35-40) | ○ |

### Analytics::CycleAnalytics::ProjectLevel (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-079 | initialize | E-09 (L8-11) | ○ |
| C-080 | summary | E-09 (L13-19) | ○ |
| C-081 | permissions | E-09 (L21-23) | ○ |
| C-082 | stats | E-09 (L25-29) | ○ |
| C-083 | []: アクセサ（正常） | E-09 (L31-33) | ○ |
| C-084 | []: アクセサ（異常） | E-09 (L37-44) | ○ |

### Analytics::CycleAnalytics::Stageable (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-085 | start_event | E-11 (L40-43) | ○ |
| C-086 | end_event | E-11 (L45-48) | ○ |
| C-087 | events_hash_code | E-11 (L50-52) | ○ |
| C-088 | start_event_label_based? | E-11 (L54-56) | ○ |
| C-089 | end_event_label_based? | E-11 (L58-60) | ○ |
| C-090 | default_stage? | E-11 (L80-82) | ○ |
| C-091 | subject_class | E-11 (L84-87) | ○ |
| C-092 | validate_stage_event_pairs | E-11 (L91-97) | ○ |
| C-093 | validate_labels | E-11 (L103-106) | ○ |
| C-094 | ensure_stage_event_hash_id | E-11 (L127-135) | ○ |
| C-095 | cleanup_old_stage_event_hash | E-11 (L137-141) | ○ |

### Analytics::CycleAnalytics::StageEventModel (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-096 | scope :by_stage_event_hash_id | E-12 (L12) | ○ |
| C-097 | scope :by_project_id | E-12 (L13) | ○ |
| C-098 | scope :end_event_timestamp_after | E-12 (L15) | ○ |
| C-099 | scope :order_by_end_event | E-12 (L36-48) | ○ |
| C-100 | scope :order_by_db_duration | E-12 (L66-79) | ○ |
| C-101 | issuable_id | E-12 (L91-93) | ○ |
| C-102 | total_time | E-12 (L95-97) | ○ |
| C-103 | total_time: nil | E-12 (L95-97) | ○ |
| C-104 | upsert_data | E-12 (L100-117) | ○ |
| C-105 | upsert_data: 競合時更新 | E-12 (L111-113) | ○ |

### Services (E-13, E-14, E-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | BaseService#initialize | E-13 (L11-15) | ○ |
| C-107 | BaseService#execute | E-13 (L17-19) | ○ |
| C-108 | BaseService#build_default_stages | E-13 (L33-37) | ○ |
| C-109 | ListService#execute: 権限あり | E-14 (L7-13) | ○ |
| C-110 | ListService#execute: 権限なし | E-14 (L8) | ○ |
| C-111 | ListService#execute: フィルタ | E-14 (L12) | ○ |
| C-112 | ValueStreams::ListService#execute: 権限あり | E-15 (L15-21) | ○ |
| C-113 | ValueStreams::ListService#execute: 権限なし | E-15 (L16) | ○ |

### Finder (E-16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | StageFinder#execute: 正常 | E-16 (L11-13) | ○ |
| C-115 | StageFinder#execute: RecordNotFound | E-16 (L23-30) | ○ |

### Presenter (E-17)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | StagePresenter#title: デフォルト | E-17 (L6-8) | ○ |
| C-117 | StagePresenter#title: カスタム | E-17 (L6-8) | ○ |
| C-118 | StagePresenter#description: デフォルト | E-17 (L10-12) | ○ |
| C-119 | StagePresenter#description: カスタム | E-17 (L10-12) | ○ |
| C-120 | StagePresenter#legend | E-17 (L14-16) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードから直接抽出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - cycle_analyticsモジュールは分析機能であり、データの読み取りが中心
- 1: 中リスク - Aggregation関連のカーソル管理とset_statsは並行処理での整合性確認が推奨
- 1: 中リスク - StageEventHashのrecord_id_by_hash_sha256は競合制御が含まれるため、負荷テストでの検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_STAGES_PER_VALUE_STREAM (15) と MAX_VALUE_STREAMS_PER_NAMESPACE (50) の境界値テストが適切か確認
- [ ] safe_create_for_namespaceのupsert動作が期待通りか確認
- [ ] StageEventHashのrecord_id_by_hash_sha256のアトミック性が保証されているか確認
- [ ] 各スコープ（assigned_to, by_project_id等）のSQLインジェクション対策を確認
- [ ] validate_stage_event_pairsのペアリングルールが網羅されているか確認
- [ ] estimate_next_run_atの計算ロジックが正確か確認
