---
generated_at: 2026-01-22 15:00:00
metrics:
  claims_total: 149
  claims_with_evidence: 149
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：design_management 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：149 / 149、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースがソースコードから直接導出されており、根拠不足の項目はなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/design_management/design.rb` - Designモデル（リレーション、バリデーション、スコープ、メソッド）
- E-02: `app/models/design_management/version.rb` - Versionモデル（リレーション、バリデーション、クラスメソッド）
- E-03: `app/models/design_management/action.rb` - Actionモデル（enum、スコープ）
- E-04: `app/models/design_management/design_collection.rb` - DesignCollectionモデル（状態マシン、メソッド）
- E-05: `app/models/design_management/design_at_version.rb` - DesignAtVersionモデル（バリデーション、ID生成）
- E-06: `app/models/design_management/design_action.rb` - DesignActionモデル（バリデーション、属性変換）
- E-07: `app/models/design_management/repository.rb` - Repositoryモデル（リレーション、パス生成）
- E-08: `app/models/design_management/git_repository.rb` - GitRepositoryモデル（属性オーバーライド）
- E-09: `app/services/design_management/save_designs_service.rb` - SaveDesignsService（保存ロジック）
- E-10: `app/services/design_management/delete_designs_service.rb` - DeleteDesignsService（削除ロジック）
- E-11: `app/services/design_management/move_designs_service.rb` - MoveDesignsService（移動ロジック）
- E-12: `app/services/design_management/design_service.rb` - DesignService（基底クラス）
- E-13: `app/services/design_management/design_user_notes_count_service.rb` - ノートカウントサービス
- E-14: `app/services/design_management/generate_image_versions_service.rb` - 画像生成サービス
- E-15: `app/services/design_management/copy_design_collection/copy_service.rb` - コピーサービス
- E-16: `app/finders/design_management/designs_finder.rb` - DesignsFinder（検索ロジック）
- E-17: `app/finders/design_management/versions_finder.rb` - VersionsFinder（検索ロジック）

## 3) Claims と根拠の対応（レビューの主戦場）

### DesignManagement::Design（UT-DES-001〜037）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :projectリレーションの存在 | E-01 (line 23) | ○ |
| C-02 | belongs_to :issueリレーションの存在 | E-01 (line 24) | ○ |
| C-03 | has_many :actionsリレーションの存在 | E-01 (line 26) | ○ |
| C-04 | has_many :versionsリレーションの存在 | E-01 (line 27) | ○ |
| C-05 | has_many :authorsリレーション（distinct） | E-01 (line 28) | ○ |
| C-06 | has_many :notesリレーション（polymorphic） | E-01 (line 31) | ○ |
| C-07 | validates :project, presenceの存在 | E-01 (line 40) | ○ |
| C-08 | validates :filename, presenceの存在 | E-01 (line 40) | ○ |
| C-09 | validates :filename, length制限（255） | E-01 (line 42) | ○ |
| C-10 | validates :filename, uniqueness（scope: issue_id） | E-01 (line 42) | ○ |
| C-11 | validates :issue, presence（unless importing） | E-01 (line 41) | ○ |
| C-12 | validates :description, length制限 | E-01 (line 43) | ○ |
| C-13 | validate_file_is_imageカスタムバリデーション | E-01 (lines 44, 252-259) | ○ |
| C-14 | SAFE_IMAGE_EXT拡張子許可 | E-01 (lines 248-249) | ○ |
| C-15 | scope :visible_at_versionの存在 | E-01 (lines 87-98) | ○ |
| C-16 | visible_at_version(nil)で最新状態取得 | E-01 (line 115) | ○ |
| C-17 | scope :orderedの存在 | E-01 (lines 100-104) | ○ |
| C-18 | scope :currentの存在 | E-01 (line 115) | ○ |
| C-19 | scope :by_issue_id_and_filenameの存在 | E-01 (lines 71-73) | ○ |
| C-20 | by_issue_id_and_filename空配列処理 | E-01 (line 72, WhereComposite) | ○ |
| C-21 | statusメソッド（:new） | E-01 (lines 125-133) | ○ |
| C-22 | statusメソッド（:deleted） | E-01 (lines 125-133) | ○ |
| C-23 | statusメソッド（:current） | E-01 (lines 125-133) | ○ |
| C-24 | deleted?メソッド（true） | E-01 (lines 135-137) | ○ |
| C-25 | deleted?メソッド（false） | E-01 (lines 135-137) | ○ |
| C-26 | new_design?メソッド（true） | E-01 (lines 196-198) | ○ |
| C-27 | new_design?メソッド（false） | E-01 (lines 196-198) | ○ |
| C-28 | visible_in?メソッド（true） | E-01 (lines 142-150) | ○ |
| C-29 | visible_in?メソッド（false） | E-01 (lines 142-150) | ○ |
| C-30 | to_referenceメソッド（短縮形） | E-01 (lines 164-169) | ○ |
| C-31 | to_referenceメソッド（full） | E-01 (lines 164-169) | ○ |
| C-32 | full_pathメソッド | E-01 (lines 200-202) | ○ |
| C-33 | repositoryメソッド | E-01 (lines 215-217) | ○ |
| C-34 | user_notes_countメソッド | E-01 (lines 219-221) | ○ |
| C-35 | after_note_changedメソッド | E-01 (lines 223-227) | ○ |
| C-36 | clear_version_cacheメソッド | E-01 (lines 208-213) | ○ |
| C-37 | diff_refsメソッド | E-01 (lines 204-206) | ○ |

### DesignManagement::Version（UT-DES-038〜058）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | belongs_to :issueリレーション | E-02 (line 36) | ○ |
| C-39 | belongs_to :authorリレーション | E-02 (line 37) | ○ |
| C-40 | belongs_to :namespaceリレーション | E-02 (line 38) | ○ |
| C-41 | has_many :actionsリレーション | E-02 (line 39) | ○ |
| C-42 | has_many :designsリレーション（through） | E-02 (lines 40-44) | ○ |
| C-43 | validates :sha, presence | E-02 (line 47) | ○ |
| C-44 | validates :sha, uniqueness（scope: issue_id） | E-02 (line 48) | ○ |
| C-45 | validates :author, presence | E-02 (line 49) | ○ |
| C-46 | validates :namespace, presence | E-02 (line 51) | ○ |
| C-47 | validates :designs, presence（unless importing） | E-02 (line 46) | ○ |
| C-48 | create_for_designsクラスメソッド | E-02 (lines 84-103) | ○ |
| C-49 | NotSameIssue例外 | E-02 (lines 12, 86) | ○ |
| C-50 | CouldNotCreateVersion例外 | E-02 (lines 14-34, 102) | ○ |
| C-51 | with_lockクラスメソッド | E-02 (lines 109-116) | ○ |
| C-52 | scope :for_designs | E-02 (lines 57-59) | ○ |
| C-53 | scope :earlier_or_equal_to | E-02 (line 60) | ○ |
| C-54 | scope :ordered | E-02 (line 61) | ○ |
| C-55 | scope :by_sha | E-02 (line 63) | ○ |
| C-56 | designs_by_eventメソッド | E-02 (lines 118-123) | ○ |
| C-57 | authorフォールバック | E-02 (lines 125-127) | ○ |
| C-58 | diff_refsメソッド | E-02 (lines 129-131) | ○ |

### DesignManagement::Action（UT-DES-059〜069）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | belongs_to :designリレーション | E-03 (line 13) | ○ |
| C-60 | belongs_to :versionリレーション | E-03 (line 14) | ○ |
| C-61 | enum :event（creation: 0） | E-03 (line 16) | ○ |
| C-62 | enum :event（modification: 1） | E-03 (line 16) | ○ |
| C-63 | enum :event（deletion: 2） | E-03 (line 16) | ○ |
| C-64 | scope :most_recent | E-03 (lines 25-28) | ○ |
| C-65 | scope :up_to_version | E-03 (lines 32-45) | ○ |
| C-66 | up_to_version(nil)処理 | E-03 (lines 33-35) | ○ |
| C-67 | up_to_version型検証 | E-03 (lines 42-44) | ○ |
| C-68 | scope :by_design | E-03 (line 20) | ○ |
| C-69 | scope :by_event | E-03 (line 21) | ○ |

### DesignManagement::DesignCollection（UT-DES-070〜084）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | initialize処理 | E-04 (lines 30-38) | ○ |
| C-71 | delegate :designs | E-04 (line 7) | ○ |
| C-72 | delegate :project | E-04 (line 7) | ○ |
| C-73 | ==メソッド（true） | E-04 (lines 40-42) | ○ |
| C-74 | ==メソッド（false） | E-04 (lines 40-42) | ○ |
| C-75 | find_or_create_design!（既存） | E-04 (lines 44-47) | ○ |
| C-76 | find_or_create_design!（新規） | E-04 (lines 44-47) | ○ |
| C-77 | versionsメソッド | E-04 (lines 49-51) | ○ |
| C-78 | repositoryメソッド | E-04 (lines 53-55) | ○ |
| C-79 | designs_by_filenameメソッド | E-04 (lines 57-59) | ○ |
| C-80 | state_machine初期状態 | E-04 (line 10) | ○ |
| C-81 | copy_start!遷移 | E-04 (lines 13-15) | ○ |
| C-82 | copy_end!遷移 | E-04 (lines 17-19) | ○ |
| C-83 | copy_error!遷移 | E-04 (lines 21-23) | ○ |
| C-84 | copy_reset!遷移 | E-04 (lines 25-27) | ○ |

### DesignManagement::DesignAtVersion（UT-DES-085〜095）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | initialize処理 | E-05 (lines 20-23) | ○ |
| C-86 | id複合ID生成 | E-05 (lines 30-32) | ○ |
| C-87 | ==メソッド | E-05 (lines 34-38) | ○ |
| C-88 | validates :version, presence | E-05 (line 14) | ○ |
| C-89 | validates :design, presence | E-05 (line 15) | ○ |
| C-90 | design_and_version_belong_to_the_same_issue | E-05 (lines 102-108) | ○ |
| C-91 | lazy_findメソッド | E-05 (lines 42-48) | ○ |
| C-92 | findメソッド | E-05 (lines 50-72) | ○ |
| C-93 | status（not_created_yet） | E-05 (lines 74-82) | ○ |
| C-94 | status（deleted） | E-05 (lines 74-82) | ○ |
| C-95 | status（current） | E-05 (lines 74-82) | ○ |

### DesignManagement::DesignAction（UT-DES-096〜104）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | initialize処理 | E-06 (lines 30-36) | ○ |
| C-97 | validates :design, presence | E-06 (line 20) | ○ |
| C-98 | validates :action, presence | E-06 (line 21) | ○ |
| C-99 | validates :action, inclusion | E-06 (line 21) | ○ |
| C-100 | validates :content, presence（needs_content） | E-06 (lines 25-26) | ○ |
| C-101 | validates :content, absence（forbids_content） | E-06 (lines 23-24) | ○ |
| C-102 | row_attrsメソッド | E-06 (lines 38-40) | ○ |
| C-103 | gitaly_actionメソッド | E-06 (lines 42-44) | ○ |
| C-104 | performedメソッド | E-06 (lines 48-50) | ○ |

### DesignManagement::Repository（UT-DES-105〜111）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | belongs_to :projectリレーション | E-07 (line 8) | ○ |
| C-106 | validates :project, presence | E-07 (line 9) | ○ |
| C-107 | validates :project, uniqueness | E-07 (line 9) | ○ |
| C-108 | repositoryメソッド | E-07 (lines 13-21) | ○ |
| C-109 | full_pathメソッド | E-07 (lines 24-26) | ○ |
| C-110 | disk_pathメソッド | E-07 (lines 28-30) | ○ |
| C-111 | repo_typeメソッド | E-07 (lines 32-34) | ○ |

### DesignManagement::GitRepository（UT-DES-112〜114）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | info_attributesメソッド | E-08 (lines 17-19) | ○ |
| C-113 | attributesメソッド | E-08 (lines 23-25) | ○ |
| C-114 | gitattributeメソッド | E-08 (lines 29-31) | ○ |

### DesignManagement::SaveDesignsService（UT-DES-115〜120）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | execute正常系 | E-09 (lines 17-32) | ○ |
| C-116 | 権限チェック | E-09 (line 18) | ○ |
| C-117 | MAX_FILES制限（10） | E-09 (lines 9, 19) | ○ |
| C-118 | ファイル名重複チェック | E-09 (line 20) | ○ |
| C-119 | コピー中チェック | E-09 (line 21) | ○ |
| C-120 | スキップ処理 | E-09 (lines 24, 74-76) | ○ |

### DesignManagement::DeleteDesignsService（UT-DES-121〜123）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | execute正常系 | E-10 (lines 15-31) | ○ |
| C-122 | 権限チェック | E-10 (line 16) | ○ |
| C-123 | TodosDestroyer呼び出し | E-10 (line 29) | ○ |

### DesignManagement::MoveDesignsService（UT-DES-124〜129）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | execute正常系 | E-11 (lines 14-25) | ○ |
| C-125 | no_focusエラー | E-11 (line 15) | ○ |
| C-126 | cannot_moveエラー | E-11 (line 16) | ○ |
| C-127 | no_neighborsエラー | E-11 (line 17) | ○ |
| C-128 | not_distinctエラー | E-11 (line 18) | ○ |
| C-129 | not_same_issueエラー | E-11 (line 19) | ○ |

### DesignManagement::DesignUserNotesCountService（UT-DES-130〜131）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | countメソッド（relation_for_count経由） | E-13 (lines 16-18) | ○ |
| C-131 | cache_keyメソッド | E-13 (lines 26-28) | ○ |

### DesignManagement::GenerateImageVersionsService（UT-DES-132〜134）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | execute正常系 | E-14 (lines 23-31) | ○ |
| C-133 | MAX_DESIGN_SIZE制限 | E-14 (lines 14-15, 95) | ○ |
| C-134 | MIMEタイプ制限 | E-14 (line 46) | ○ |

### DesignManagement::CopyDesignCollection::CopyService（UT-DES-135〜139）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | execute正常系 | E-15 (lines 30-58) | ○ |
| C-136 | 権限チェック | E-15 (line 31) | ○ |
| C-137 | キュー状態チェック | E-15 (line 32) | ○ |
| C-138 | デザイン空チェック | E-15 (line 33) | ○ |
| C-139 | 既存デザインチェック | E-15 (line 34) | ○ |

### DesignManagement::DesignsFinder（UT-DES-140〜144）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | execute正常系 | E-16 (lines 19-26) | ○ |
| C-141 | 権限チェック | E-16 (line 33) | ○ |
| C-142 | visible_at_versionフィルタ | E-16 (lines 40-42) | ○ |
| C-143 | filenamesフィルタ | E-16 (lines 44-49) | ○ |
| C-144 | filenames空配列処理 | E-16 (line 46) | ○ |

### DesignManagement::VersionsFinder（UT-DES-145〜149）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | execute正常系 | E-17 (lines 26-34) | ○ |
| C-146 | 権限チェック | E-17 (line 27) | ○ |
| C-147 | earlier_or_equal_toフィルタ | E-17 (lines 38-42) | ○ |
| C-148 | shaフィルタ | E-17 (lines 50-54) | ○ |
| C-149 | version_idフィルタ | E-17 (lines 44-48) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードの実装に基づいて生成されている
- 状態マシン（DesignCollection）のテストは実際のRedisモック環境でのテストが推奨される
- create_for_designsメソッドはトランザクション処理を含むため、統合テストでの検証も推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルのリレーションテストが網羅されているか確認
- [ ] バリデーションの正常系/異常系が適切にカバーされているか確認
- [ ] 状態遷移テスト（DesignCollection）が全遷移パターンをカバーしているか確認
- [ ] サービスクラスの権限チェックテストが含まれているか確認
- [ ] 境界値テスト（MAX_FILES、MAX_DESIGN_SIZEなど）が適切に定義されているか確認
- [ ] エラーハンドリング（NotSameIssue、CouldNotCreateVersion等）のテストが含まれているか確認
