---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：dev_ops_report.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：40 / 40、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにコードベースの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/dev_ops_report/metric.rb` - Metricモデル定義
- E-02: `app/models/dev_ops_report/card.rb` - Cardクラス定義
- E-03: `app/models/dev_ops_report/idea_to_production_step.rb` - IdeaToProductionStepクラス定義
- E-04: `app/presenters/dev_ops_report/metric_presenter.rb` - MetricPresenterクラス定義
- E-05: `spec/models/dev_ops_report/metric_spec.rb` - Metricモデルのテストスペック
- E-06: `spec/presenters/dev_ops_report/metric_presenter_spec.rb` - MetricPresenterのテストスペック
- E-07: `spec/factories/dev_ops_report_metrics.rb` - テストファクトリ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Metricモデルの全METRICS属性バリデーション | E-01 (L13-24), E-05 (L8-13) | ○ |
| C-02 | METRICS属性のpresence_ofバリデーション | E-01 (L23), E-05 (L10) | ○ |
| C-03 | METRICS属性のnumericality(>=0)バリデーション | E-01 (L23), E-05 (L11) | ○ |
| C-04 | METRICS属性が0の場合のバリデーション成功 | E-01 (L23) | ○ |
| C-05 | instance_scoreメソッドの動作 | E-01 (L26-28), E-07 | ○ |
| C-06 | instance_scoreの異常系（存在しないfeature） | E-01 (L26-28) | ○ |
| C-07 | leader_scoreメソッドの動作 | E-01 (L30-32), E-07 | ○ |
| C-08 | leader_scoreの異常系（存在しないfeature） | E-01 (L30-32) | ○ |
| C-09 | percentage_scoreメソッドの動作 | E-01 (L34-36), E-05 (L15-18), E-07 | ○ |
| C-10 | percentage_scoreの異常系（存在しないfeature） | E-01 (L34-36) | ○ |
| C-11 | テーブル名設定 | E-01 (L7) | ○ |
| C-12 | Cardクラスのinitialize | E-02 (L7-14) | ○ |
| C-13 | Cardのdocsオプショナル引数 | E-02 (L7) | ○ |
| C-14 | Card.instance_scoreの委譲 | E-02 (L16-18), E-06 (L10-17) | ○ |
| C-15 | Card.leader_scoreの委譲 | E-02 (L20-22), E-06 (L14) | ○ |
| C-16 | Card.percentage_scoreの委譲 | E-02 (L24-26), E-06 (L16) | ○ |
| C-17 | Card.title attr_accessor | E-02 (L5) | ○ |
| C-18 | Card.description attr_accessor | E-02 (L5) | ○ |
| C-19 | Card.feature attr_accessor | E-02 (L5) | ○ |
| C-20 | Card.blog attr_accessor | E-02 (L5) | ○ |
| C-21 | Card.docs attr_accessor | E-02 (L5) | ○ |
| C-22 | IdeaToProductionStepのinitialize | E-03 (L7-10) | ○ |
| C-23 | IdeaToProductionStep単一feature計算 | E-03 (L13-18), E-06 (L20-24) | ○ |
| C-24 | IdeaToProductionStep複数features平均計算 | E-03 (L13-18), E-06 (L26-31) | ○ |
| C-25 | IdeaToProductionStep空配列時の挙動 | E-03 (L17-18) | ○ |
| C-26 | IdeaToProductionStep.title attr_accessor | E-03 (L5) | ○ |
| C-27 | IdeaToProductionStep.features attr_accessor | E-03 (L5) | ○ |
| C-28 | MetricPresenter.cards返却数 | E-04 (L9-81) | ○ |
| C-29 | MetricPresenter.cardsのfeature順序 | E-04 (L9-81) | ○ |
| C-30 | MetricPresenter.cards委譲チェーン | E-04 (L9-17), E-06 (L10-17) | ○ |
| C-31 | MetricPresenter.idea_to_production_steps返却数 | E-04 (L83-136) | ○ |
| C-32 | MetricPresenter.idea_to_production_stepsのtitle順序 | E-04 (L83-136) | ○ |
| C-33 | Ideaステップのpercentage_score | E-04 (L85-89), E-06 (L20-24) | ○ |
| C-34 | Planステップのpercentage_score（複数feature平均） | E-04 (L95-99), E-06 (L26-31) | ○ |
| C-35 | MetricPresenter.average_percentage_score計算 | E-04 (L138-140), E-06 (L34-37) | ○ |
| C-36 | average_percentage_scoreのファクトリ値確認 | E-04 (L138-140), E-06 (L36), E-07 | ○ |
| C-37 | MetricPresenter.created_at委譲 | E-04 (L7) | ○ |
| C-38 | MetricPresenter.presents宣言 | E-04 (L5) | ○ |
| C-39 | METRICS定数の項目数 | E-01 (L13-20) | ○ |
| C-40 | METRICS定数のfrozen状態 | E-01 (L20) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースにソースコードからの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースが既存のコードベースとスペックファイルに基づいて生成されている
- IdeaToProductionStep.percentage_scoreの空配列時の挙動（C-25）については、コード上ではZeroDivisionErrorまたはNaNとなる可能性があるが、実際の使用では空配列が渡されることはないと想定される

## 6) レビュアーチェックリスト（最小）
- [ ] METRICS定数の27項目が全て網羅されているか確認
- [ ] バリデーションテスト（UT-DOR-001〜004）の境界値が適切か確認
- [ ] MetricPresenterの9カード、10ステップの構成がUIと一致するか確認
- [ ] IdeaToProductionStepの空配列処理が実運用上問題ないか確認
- [ ] average_percentage_scoreの期待値（約51.1）がファクトリデータと一致するか確認
