---
generated_at: 2026-01-22 15:00:00
metrics:
  claims_total: 86
  claims_with_evidence: 86
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：diff_viewer.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：86 / 86、根拠なし：0
- 優先レビュー（高）
  1. **UT-DVW-012〜015（can_render?）**：レンダリング可否判定の重要なロジック
  2. **UT-DVW-064〜067（ServerSide render_error）**：外部ストレージ対応のエラー処理
  3. **UT-DVW-040〜043（Image can_render?）**：画像差分ビューアの特殊ケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/base.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/image.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/text.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/simple.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/rich.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/static.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/client_side.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/server_side.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/added.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/deleted.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/renamed.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/mode_changed.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/no_preview.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/not_diffable.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/diff_viewer/collapsed.rb`
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/spec/models/diff_viewer/base_spec.rb`
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/spec/models/diff_viewer/server_side_spec.rb`
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/spec/models/diff_viewer/image_spec.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DiffViewer::Base#initializeがdiff_fileを受け取りインスタンスを初期化 | E-01 (L19-22) | ○ |
| C-02 | initializeで@initially_binaryがbinary_in_repo?に基づき設定される | E-01 (L21) | ○ |
| C-03 | partial_pathがPARTIAL_PATH_PREFIXとpartial_nameを結合 | E-01 (L24-26) | ○ |
| C-04 | rich?がtype == :richを判定 | E-01 (L28-30) | ○ |
| C-05 | simple?がtype == :simpleを判定 | E-01 (L32-34) | ○ |
| C-06 | binary?がbinary属性を返す | E-01 (L36-38) | ○ |
| C-07 | text?が!binary?を返す | E-01 (L40-42) | ○ |
| C-08 | can_render?がold_blobとnew_blobの両方を検証 | E-01 (L44-47) | ○ |
| C-09 | can_render_blob?がnilの場合trueを返す | E-01 (L50) | ○ |
| C-10 | can_render_blob?がバイナリ性を検証 | E-01 (L51) | ○ |
| C-11 | can_render_blob?が拡張子をチェック | E-01 (L52) | ○ |
| C-12 | collapsed?がdiff_file.collapsed?を確認 | E-01 (L61), E-16 (L67-77) | ○ |
| C-13 | collapsed?がcollapse_limitとraw_sizeを比較 | E-01 (L63), E-16 (L79-88) | ○ |
| C-14 | collapsed?がexpanded状態を考慮 | E-01 (L63), E-16 (L79-88) | ○ |
| C-15 | collapsed?が結果をメモ化 | E-01 (L58) | ○ |
| C-16 | too_large?がdiff_file.too_large?を確認 | E-01 (L68), E-16 (L101-117) | ○ |
| C-17 | too_large?がsize_limitとraw_sizeを比較 | E-01 (L70), E-16 (L101-117) | ○ |
| C-18 | too_large?が結果をメモ化 | E-01 (L67) | ○ |
| C-19 | expandable?がtoo_large?とtext?を組み合わせて判定 | E-01 (L73-75), E-16 (L119-149) | ○ |
| C-20 | binary_detected_after_load?が初期状態と現在状態を比較 | E-01 (L77-79) | ○ |
| C-21 | generated?がdiff_file.generated?を委譲 | E-01 (L81-83), E-16 (L151-171) | ○ |
| C-22 | render_errorがtoo_large?の場合:too_largeを返す | E-01 (L88-92), E-16 (L173-189) | ○ |
| C-23 | render_error_messageがエラーメッセージを生成 | E-01 (L94-103), E-16 (L191-210) | ○ |
| C-24 | render_error_optionsがview the blobリンクを含む | E-01 (L111-119), E-16 (L206-208) | ○ |
| C-25 | render_error_reasonが理由テキストを返す | E-01 (L122-126) | ○ |
| C-26 | prepare!が空のフックメソッドとして定義 | E-01 (L105-107) | ○ |
| C-27 | Image.can_render?が両blobがnilの場合falseを返す | E-02 (L17-20), E-18 (L12-16) | ○ |
| C-28 | Image.can_render?がold_blobのみ存在でtrueを返す | E-02 (L17-23), E-18 (L19-24) | ○ |
| C-29 | Image.can_render?がnew_blobのみ存在でtrueを返す | E-02 (L17-23), E-18 (L26-31) | ○ |
| C-30 | Image.can_render?が両blob存在でtrueを返す | E-02 (L17-23), E-18 (L33-38) | ○ |
| C-31 | Image.switcher_titleが'image diff'を返す | E-02 (L13-15) | ○ |
| C-32 | Image.partial_nameが'image' | E-02 (L8) | ○ |
| C-33 | Image.extensionsがUploaderHelper::SAFE_IMAGE_EXT | E-02 (L9) | ○ |
| C-34 | Image.binaryがtrue | E-02 (L10) | ○ |
| C-35 | Text.partial_nameが'text' | E-03 (L8) | ○ |
| C-36 | Text.binaryがfalse | E-03 (L9) | ○ |
| C-37 | Text.collapse_limitがnil | E-03 (L14) | ○ |
| C-38 | Text.size_limitがnil | E-03 (L15) | ○ |
| C-39 | Simple includeでtype=:simpleを設定 | E-04 (L8) | ○ |
| C-40 | Simple includeでswitcher_icon='code'を設定 | E-04 (L9) | ○ |
| C-41 | Simple.switcher_titleが'source diff'を返す | E-04 (L11-13) | ○ |
| C-42 | Rich includeでtype=:richを設定 | E-05 (L8) | ○ |
| C-43 | Rich includeでswitcher_icon='doc-text'を設定 | E-05 (L9) | ○ |
| C-44 | Rich.switcher_titleが'rendered diff'を返す | E-05 (L11-13) | ○ |
| C-45 | Static.render_errorが常にnilを返す | E-06 (L8-10) | ○ |
| C-46 | ClientSide includeでcollapse_limit=1.megabyteを設定 | E-07 (L8) | ○ |
| C-47 | ClientSide includeでsize_limit=10.megabytesを設定 | E-07 (L9) | ○ |
| C-48 | ServerSide includeでcollapse_limit=1.megabyteを設定 | E-08 (L8) | ○ |
| C-49 | ServerSide includeでsize_limit=5.megabytesを設定 | E-08 (L9) | ○ |
| C-50 | ServerSide.render_errorがstored_externally?で:server_side_but_stored_externallyを返す | E-08 (L12-18), E-17 (L19-28) | ○ |
| C-51 | ServerSide.render_error_reasonがLFSの場合'it is stored in LFS'を返す | E-08 (L25-32), E-17 (L31-41) | ○ |
| C-52 | ServerSide.render_error_reasonがその他外部格納で'it is stored externally'を返す | E-08 (L25-32), E-17 (L43-47) | ○ |
| C-53 | Added.partial_nameが'added' | E-09 (L8) | ○ |
| C-54 | AddedがSimpleとStaticをinclude | E-09 (L5-6) | ○ |
| C-55 | Deleted.partial_nameが'deleted' | E-10 (L8) | ○ |
| C-56 | DeletedがSimpleとStaticをinclude | E-10 (L5-6) | ○ |
| C-57 | Renamed.partial_nameが'renamed' | E-11 (L8) | ○ |
| C-58 | RenamedがSimpleとStaticをinclude | E-11 (L5-6) | ○ |
| C-59 | ModeChanged.partial_nameが'mode_changed' | E-12 (L8) | ○ |
| C-60 | ModeChangedがSimpleとStaticをinclude | E-12 (L5-6) | ○ |
| C-61 | NoPreview.partial_nameが'no_preview' | E-13 (L8) | ○ |
| C-62 | NoPreview.binaryがtrue | E-13 (L9) | ○ |
| C-63 | NoPreviewがSimpleとStaticをinclude | E-13 (L5-6) | ○ |
| C-64 | NotDiffable.partial_nameが'not_diffable' | E-14 (L8) | ○ |
| C-65 | NotDiffable.binaryがtrue | E-14 (L9) | ○ |
| C-66 | NotDiffableがSimpleとStaticをinclude | E-14 (L5-6) | ○ |
| C-67 | Collapsed.partial_nameが'collapsed' | E-15 (L8) | ○ |
| C-68 | CollapsedがSimpleとStaticをinclude | E-15 (L5-6) | ○ |
| C-69 | BaseがprojectをdelegateでDiff_fileから委譲 | E-01 (L17) | ○ |
| C-70 | collapsed?がcollapse_limit=nilの場合falseを返す | E-01 (L63) | ○ |
| C-71 | too_large?がsize_limit=nilの場合falseを返す | E-01 (L70) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。すべてのテストケースはソースコードおよび既存テストに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードに基づいており、既存テストとの整合性も確認済み
- 既存テスト（E-16, E-17, E-18）がカバーしている領域については、テストケースの妥当性が高い
- 新規追加のテストケース（属性確認、継承確認など）は低リスクの基本的な検証項目

## 6) レビュアーチェックリスト（最小）
- [ ] DiffViewer::Baseのcan_render?/can_render_blob?のロジックが正しく理解されているか確認
- [ ] ServerSideのrender_errorにおけるLFS/外部ストレージ判定が適切か確認
- [ ] Image.can_render?の両blobがnilの特殊ケースが適切にテストされているか確認
- [ ] 各サブクラス（Added, Deleted, Renamed等）のSimple/Staticモジュール継承が正しいか確認
- [ ] collapsed?とtoo_large?の境界値テストが適切か確認
- [ ] クライアントサイド（10MB）とサーバーサイド（5MB）のsize_limitの違いが適切にテストされているか確認
