---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：doorkeeper.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：42 / 42、根拠なし：0
- 優先レビュー（高）
  1. **TokenFallbackのfind_by_fallback_token**：複数戦略の順次試行ロジックが複雑
  2. **FIPS 140-3判定ロジック**：OpenSSL依存のため環境差異あり
  3. **organizationリレーションのoptional: false制約**：全モデルで一貫性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/doorkeeper/access_grant.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/doorkeeper/access_token.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/doorkeeper/openid_connect/request.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/doorkeeper/device_authorization_grant/device_grant.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/doorkeeper/concerns/token_fallback.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/spec/models/doorkeeper/access_grant_spec.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/spec/models/doorkeeper/access_token_spec.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/spec/models/doorkeeper/openid_connect/request_spec.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/spec/models/doorkeeper/device_authorization_grant/device_grant_spec.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Doorkeeper::AccessGrant
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | organizationリレーション（belongs_to, optional: false） | E-01 L10, E-06 L7 | ○ |
| C-02 | organization_idがnullの場合バリデーションエラー | E-01 L10 | ○ |
| C-03 | 存在しないorganization_idでエラー | E-01 L10 | ○ |
| C-04 | openid_requestリレーション（has_one） | E-01 L11-13, E-06 L8 | ○ |
| C-05 | openid_requestが存在しない場合nil | E-01 L11-13 | ○ |
| C-06 | inverse_ofが正しく機能 | E-01 L13 | ○ |

### Doorkeeper::AccessToken
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | organizationリレーション（belongs_to, optional: false） | E-02 L12, E-07 L7 | ○ |
| C-08 | organization_idがnullの場合バリデーションエラー | E-02 L12 | ○ |
| C-09 | resource_ownerリレーション（belongs_to User） | E-02 L13 | ○ |
| C-10 | resource_ownerがnilの場合に正常動作 | E-02 L13 | ○ |
| C-11 | 存在しないresource_owner_idの挙動 | E-02 L13 | ○ |

### Doorkeeper::OpenidConnect::Request
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | access_grantリレーション（belongs_to） | E-03 L12-14, E-08 L7 | ○ |
| C-13 | inverse_ofが正しく機能 | E-03 L14 | ○ |
| C-14 | organizationリレーション（belongs_to, optional: false） | E-03 L16, E-08 L8 | ○ |
| C-15 | organization_idがnullの場合バリデーションエラー | E-03 L16 | ○ |
| C-16 | access_grant_idのpresenceバリデーション | E-03 L11, E-08 L12 | ○ |
| C-17 | access_grant_idがnilでバリデーションエラー | E-03 L11 | ○ |
| C-18 | nonceのpresenceバリデーション | E-03 L11, E-08 L13 | ○ |
| C-19 | nonceがnilでバリデーションエラー | E-03 L11 | ○ |
| C-20 | nonceが空文字でバリデーションエラー | E-03 L11 | ○ |
| C-21 | テーブル名が動的に設定 | E-03 L6 | ○ |

### Doorkeeper::DeviceAuthorizationGrant::DeviceGrant
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | organizationリレーション（belongs_to, optional: false） | E-04 L11, E-09 L6 | ○ |
| C-23 | organization_idがnullの場合バリデーションエラー | E-04 L11 | ○ |
| C-24 | 存在しないorganization_idでエラー | E-04 L11 | ○ |

### Doorkeeper::Concerns::TokenFallback
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | プレーンテキストトークンで検索可能 | E-05 L31-46 | ○ |
| C-26 | 存在しないトークンでnil返却 | E-05 L45 | ○ |
| C-27 | PBKDF2形式トークンがスキップ | E-05 L32 | ○ |
| C-28 | SHA512形式（128文字16進数）トークンがスキップ | E-05 L33 | ○ |
| C-29 | 127文字トークンが検索対象 | E-05 L33 | ○ |
| C-30 | トークン検出時にupgrade_fallback_value呼び出し | E-05 L41 | ○ |
| C-31 | 非FIPSモードのストラテジー | E-05 L52-53 | ○ |
| C-32 | FIPSモード（非140-3）のストラテジー | E-05 L49, L52-53 | ○ |
| C-33 | FIPS 140-3モードのストラテジー | E-05 L50 | ○ |
| C-34 | FIPS 140-3環境でtrue返却 | E-05 L60-71 | ○ |
| C-35 | 非FIPS 140-3環境でfalse返却 | E-05 L68 | ○ |
| C-36 | strong_memoize_attrによるメモ化 | E-05 L72 | ○ |
| C-37 | 複数フォールバック戦略の順次試行 | E-05 L36-44 | ○ |
| C-38 | 空文字トークンの処理 | E-05 L31-46 | ○ |

### SafelyChangeColumnDefault機能
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | AccessGrant.columns_changing_default | E-01 L8 | ○ |
| C-40 | AccessToken.columns_changing_default | E-02 L10 | ○ |
| C-41 | Request.columns_changing_default | E-03 L9 | ○ |
| C-42 | DeviceGrant.columns_changing_default | E-04 L9 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし
  - すべてのテストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースに明確なソースコード根拠あり
- TokenFallbackのFIPS判定ロジックは環境依存があるため、CI/CD環境での動作確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] AccessGrant/AccessToken/Request/DeviceGrantの4モデルすべてでorganizationリレーションのoptional: false制約が適切にテストされているか
- [ ] OpenidConnect::Requestのvalidatesルール（access_grant_id, nonce）がすべてカバーされているか
- [ ] TokenFallbackのPBKDF2/SHA512形式の判定ロジックが正しく境界値テストされているか
- [ ] FIPS 140-3判定のOpenSSL依存部分がモック可能か確認
- [ ] inverse_ofによる循環参照の解消がテストされているか
- [ ] 既存テストスペック（E-06〜E-09）との重複・補完関係を確認
