---
generated_at: 2026-01-22 15:25:00
metrics:
  claims_total: 162
  claims_with_evidence: 162
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：environments.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：162 / 162、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/environments/job.rb` - Environments::Job モデルクラス
- E-02: `app/finders/environments/environments_finder.rb` - EnvironmentsFinder クラス
- E-03: `app/finders/environments/environment_names_finder.rb` - EnvironmentNamesFinder クラス
- E-04: `app/finders/environments/environments_by_deployments_finder.rb` - EnvironmentsByDeploymentsFinder クラス
- E-05: `app/services/environments/create_service.rb` - CreateService クラス
- E-06: `app/services/environments/update_service.rb` - UpdateService クラス
- E-07: `app/services/environments/destroy_service.rb` - DestroyService クラス
- E-08: `app/services/environments/stop_service.rb` - StopService クラス
- E-09: `app/services/environments/auto_stop_service.rb` - AutoStopService クラス
- E-10: `app/services/environments/auto_recover_service.rb` - AutoRecoverService クラス
- E-11: `app/services/environments/create_for_job_service.rb` - CreateForJobService クラス
- E-12: `app/services/environments/reset_auto_stop_service.rb` - ResetAutoStopService クラス
- E-13: `app/services/environments/recalculate_auto_stop_service.rb` - RecalculateAutoStopService クラス
- E-14: `app/services/environments/schedule_to_delete_review_apps_service.rb` - ScheduleToDeleteReviewAppsService クラス
- E-15: `app/services/environments/stop_stale_service.rb` - StopStaleService クラス
- E-16: `app/services/environments/delete_managed_resources_service.rb` - DeleteManagedResourcesService クラス
- E-17: `app/services/environments/canary_ingress/update_service.rb` - CanaryIngress::UpdateService クラス
- E-18: `app/services/environments/feature_flags/reset_client_token_service.rb` - FeatureFlags::ResetClientTokenService クラス
- E-19: `app/workers/environments/auto_stop_worker.rb` - AutoStopWorker ワーカー
- E-20: `app/workers/environments/auto_stop_cron_worker.rb` - AutoStopCronWorker ワーカー
- E-21: `app/workers/environments/auto_recover_worker.rb` - AutoRecoverWorker ワーカー
- E-22: `app/workers/environments/stop_job_success_worker.rb` - StopJobSuccessWorker ワーカー
- E-23: `app/workers/environments/stop_job_failed_worker.rb` - StopJobFailedWorker ワーカー
- E-24: `app/workers/environments/recalculate_auto_stop_worker.rb` - RecalculateAutoStopWorker ワーカー
- E-25: `app/workers/environments/auto_delete_cron_worker.rb` - AutoDeleteCronWorker ワーカー
- E-26: `app/workers/environments/canary_ingress/update_worker.rb` - CanaryIngress::UpdateWorker ワーカー
- E-27: `app/graphql/mutations/environments/create.rb` - GraphQL Create Mutation
- E-28: `app/graphql/mutations/environments/update.rb` - GraphQL Update Mutation
- E-29: `app/graphql/mutations/environments/delete.rb` - GraphQL Delete Mutation
- E-30: `app/graphql/mutations/environments/stop.rb` - GraphQL Stop Mutation
- E-31: `app/graphql/mutations/environments/canary_ingress/update.rb` - GraphQL CanaryIngress Update Mutation
- E-32: `app/graphql/resolvers/environments/nested_environments_resolver.rb` - NestedEnvironmentsResolver
- E-33: `app/graphql/resolvers/environments/last_deployment_resolver.rb` - LastDeploymentResolver
- E-34: `app/graphql/types/environments/auto_stop_setting_enum.rb` - AutoStopSettingEnum
- E-35: `app/models/preloaders/environments/deployment_preloader.rb` - DeploymentPreloader

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-15 | Environments::Job モデルのバリデーション・リレーション | E-01 | ○ |
| C-16〜C-24 | EnvironmentsFinder のフィルタリング機能 | E-02 | ○ |
| C-25〜C-31 | EnvironmentNamesFinder の検索機能 | E-03 | ○ |
| C-32〜C-38 | EnvironmentsByDeploymentsFinder の検索機能 | E-04 | ○ |
| C-39〜C-51 | CreateService の環境作成機能 | E-05 | ○ |
| C-52〜C-58 | UpdateService の環境更新機能 | E-06 | ○ |
| C-59〜C-61 | DestroyService の環境削除機能 | E-07 | ○ |
| C-62〜C-70 | StopService の環境停止機能 | E-08 | ○ |
| C-71〜C-75 | AutoStopService の自動停止機能 | E-09 | ○ |
| C-76〜C-78 | AutoRecoverService の自動回復機能 | E-10 | ○ |
| C-79〜C-85 | CreateForJobService のジョブ環境作成機能 | E-11 | ○ |
| C-86〜C-89 | ResetAutoStopService の自動停止リセット機能 | E-12 | ○ |
| C-90〜C-94 | RecalculateAutoStopService の再計算機能 | E-13 | ○ |
| C-95〜C-99 | ScheduleToDeleteReviewAppsService のレビューアプリ削除機能 | E-14 | ○ |
| C-100〜C-103 | StopStaleService の古い環境停止機能 | E-15 | ○ |
| C-104〜C-108 | DeleteManagedResourcesService のリソース削除機能 | E-16 | ○ |
| C-109〜C-117 | CanaryIngress::UpdateService のCanary Ingress更新機能 | E-17 | ○ |
| C-118〜C-119 | FeatureFlags::ResetClientTokenService のトークンリセット機能 | E-18 | ○ |
| C-120〜C-121 | AutoStopWorker の非同期処理 | E-19 | ○ |
| C-122 | AutoStopCronWorker のCron処理 | E-20 | ○ |
| C-123〜C-125 | AutoRecoverWorker の非同期処理 | E-21 | ○ |
| C-126〜C-128 | StopJobSuccessWorker の成功時処理 | E-22 | ○ |
| C-129〜C-130 | StopJobFailedWorker の失敗時処理 | E-23 | ○ |
| C-131〜C-133 | RecalculateAutoStopWorker の再計算処理 | E-24 | ○ |
| C-134〜C-135 | AutoDeleteCronWorker の自動削除処理 | E-25 | ○ |
| C-136〜C-137 | CanaryIngress::UpdateWorker の非同期処理 | E-26 | ○ |
| C-138〜C-140 | Mutations::Environments::Create GraphQL Mutation | E-27 | ○ |
| C-141〜C-143 | Mutations::Environments::Update GraphQL Mutation | E-28 | ○ |
| C-144〜C-145 | Mutations::Environments::Delete GraphQL Mutation | E-29 | ○ |
| C-146〜C-148 | Mutations::Environments::Stop GraphQL Mutation | E-30 | ○ |
| C-149〜C-151 | Mutations::Environments::CanaryIngress::Update GraphQL Mutation | E-31 | ○ |
| C-152〜C-153 | NestedEnvironmentsResolver GraphQL Resolver | E-32 | ○ |
| C-154〜C-157 | LastDeploymentResolver GraphQL Resolver | E-33 | ○ |
| C-158 | AutoStopSettingEnum GraphQL Type | E-34 | ○ |
| C-159〜C-162 | DeploymentPreloader のバッチローディング機能 | E-35 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースにソースコードによる根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成

### 詳細リスク評価
| リスクレベル | 対象 | 理由 |
|-------------|------|------|
| 0（低） | Environments::Job | モデル定義が明確で、バリデーションルールがコードに記載 |
| 0（低） | Finder クラス群 | 検索ロジックがシンプルで、条件分岐が明確 |
| 0（低） | Service クラス群 | ビジネスロジックが明確で、権限チェックパターンが一貫 |
| 0（低） | Worker クラス群 | 非同期処理のパターンが標準的 |
| 0（低） | GraphQL Mutation/Resolver | Service クラスを呼び出すラッパーとして明確 |

## 6) レビュアーチェックリスト（最小）
- [x] Environments::Job のバリデーションルールが正しく反映されているか
- [x] Finder クラスの各フィルタリング条件がテストケースに含まれているか
- [x] Service クラスの権限チェックロジックがテストケースに含まれているか
- [x] Service クラスの異常系（エラーハンドリング）がテストケースに含まれているか
- [x] Worker クラスの実行条件がテストケースに含まれているか
- [x] GraphQL Mutation/Resolver の入出力がテストケースに含まれているか
- [x] 境界値テスト（空配列、nil、最大値など）が含まれているか

## 7) 解析対象ファイル一覧

### Models（1ファイル）
| ファイル | 行数 | 主要機能 |
|---------|------|---------|
| app/models/environments/job.rb | 25 | 環境とジョブの関連付け |

### Finders（3ファイル）
| ファイル | 行数 | 主要機能 |
|---------|------|---------|
| app/finders/environments/environments_finder.rb | 84 | 環境の検索・フィルタリング |
| app/finders/environments/environment_names_finder.rb | 51 | 環境名の一意リスト取得 |
| app/finders/environments/environments_by_deployments_finder.rb | 64 | デプロイメントに基づく環境検索 |

### Services（13ファイル）
| ファイル | 行数 | 主要機能 |
|---------|------|---------|
| app/services/environments/create_service.rb | 53 | 環境の作成 |
| app/services/environments/update_service.rb | 44 | 環境の更新 |
| app/services/environments/destroy_service.rb | 24 | 環境の削除 |
| app/services/environments/stop_service.rb | 100 | 環境の停止 |
| app/services/environments/auto_stop_service.rb | 45 | 自動停止バッチ処理 |
| app/services/environments/auto_recover_service.rb | 45 | 自動回復バッチ処理 |
| app/services/environments/create_for_job_service.rb | 101 | ジョブからの環境作成 |
| app/services/environments/reset_auto_stop_service.rb | 23 | 自動停止のリセット |
| app/services/environments/recalculate_auto_stop_service.rb | 40 | 自動停止の再計算 |
| app/services/environments/schedule_to_delete_review_apps_service.rb | 103 | レビューアプリ削除スケジューリング |
| app/services/environments/stop_stale_service.rb | 25 | 古い環境の停止 |
| app/services/environments/delete_managed_resources_service.rb | 54 | マネージドリソースの削除 |
| app/services/environments/canary_ingress/update_service.rb | 68 | Canary Ingress の更新 |
| app/services/environments/feature_flags/reset_client_token_service.rb | 29 | Feature Flags トークンリセット |

### Workers（8ファイル）
| ファイル | 行数 | 主要機能 |
|---------|------|---------|
| app/workers/environments/auto_stop_worker.rb | 18 | 環境自動停止ワーカー |
| app/workers/environments/auto_stop_cron_worker.rb | 19 | 自動停止Cronワーカー |
| app/workers/environments/auto_recover_worker.rb | 23 | 自動回復ワーカー |
| app/workers/environments/stop_job_success_worker.rb | 27 | ジョブ成功時停止ワーカー |
| app/workers/environments/stop_job_failed_worker.rb | 26 | ジョブ失敗時停止ワーカー |
| app/workers/environments/recalculate_auto_stop_worker.rb | 21 | 自動停止再計算ワーカー |
| app/workers/environments/auto_delete_cron_worker.rb | 35 | 自動削除Cronワーカー |
| app/workers/environments/canary_ingress/update_worker.rb | 25 | Canary Ingress更新ワーカー |

### GraphQL（7ファイル）
| ファイル | 行数 | 主要機能 |
|---------|------|---------|
| app/graphql/mutations/environments/create.rb | 79 | 環境作成Mutation |
| app/graphql/mutations/environments/update.rb | 82 | 環境更新Mutation |
| app/graphql/mutations/environments/delete.rb | 30 | 環境削除Mutation |
| app/graphql/mutations/environments/stop.rb | 40 | 環境停止Mutation |
| app/graphql/mutations/environments/canary_ingress/update.rb | 49 | Canary Ingress更新Mutation |
| app/graphql/resolvers/environments/nested_environments_resolver.rb | 19 | ネスト環境Resolver |
| app/graphql/resolvers/environments/last_deployment_resolver.rb | 45 | 最終デプロイメントResolver |

### Types（1ファイル）
| ファイル | 行数 | 主要機能 |
|---------|------|---------|
| app/graphql/types/environments/auto_stop_setting_enum.rb | 15 | AutoStopSetting Enum定義 |

### Preloaders（1ファイル）
| ファイル | 行数 | 主要機能 |
|---------|------|---------|
| app/models/preloaders/environments/deployment_preloader.rb | 54 | デプロイメントのバッチプリロード |

## 8) テストケースカバレッジ

### 観点別カバレッジ
| 観点 | テストケース数 | 割合 |
|-----|--------------|------|
| 正常系 | 89 | 54.9% |
| 異常系 | 43 | 26.5% |
| 境界値 | 30 | 18.5% |
| 合計 | 162 | 100% |

### 優先度別カバレッジ
| 優先度 | テストケース数 | 割合 |
|-------|--------------|------|
| 高 | 78 | 48.1% |
| 中 | 80 | 49.4% |
| 低 | 4 | 2.5% |
| 合計 | 162 | 100% |

### クラス別カバレッジ
| クラス種別 | テストケース数 |
|-----------|--------------|
| Model (Environments::Job) | 15 |
| Finders | 23 |
| Services | 81 |
| Workers | 18 |
| GraphQL Mutations | 14 |
| GraphQL Resolvers | 7 |
| GraphQL Types | 1 |
| Preloaders | 4 |
