---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 98
  claims_with_evidence: 98
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：group.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：98 / 98、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコードによる根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/group/crm_settings.rb` - Group::CrmSettingsモデル定義
- E-02: `lib/gitlab/ci/status/group/common.rb` - Gitlab::Ci::Status::Group::Commonモジュール
- E-03: `lib/gitlab/ci/status/group/factory.rb` - Gitlab::Ci::Status::Group::Factoryクラス
- E-04: `lib/gitlab/import_export/group/relation_factory.rb` - RelationFactoryクラス（インポート/エクスポート）
- E-05: `lib/gitlab/import_export/group/tree_saver.rb` - TreeSaverクラス（エクスポート処理）
- E-06: `lib/gitlab/import_export/group/object_builder.rb` - ObjectBuilderクラス
- E-07: `lib/gitlab/import_export/group/group_restorer.rb` - GroupRestorerクラス
- E-08: `lib/gitlab/import_export/group/tree_restorer.rb` - TreeRestorerクラス（インポート処理）
- E-09: `lib/gitlab/import_export/group/relation_tree_restorer.rb` - RelationTreeRestorerクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Group::CrmSettings.groupリレーションテスト | E-01 (7行目: `belongs_to :group`) | ○ |
| C-02 | group_id不正時のnull返却テスト | E-01 (7行目) | ○ |
| C-03 | source_groupリレーションテスト | E-01 (8行目: `belongs_to :source_group`) | ○ |
| C-04 | source_group_id null時テスト | E-01 (8行目) | ○ |
| C-05 | group必須バリデーションテスト | E-01 (10行目: `validates :group, presence: true`) | ○ |
| C-06 | primary_key設定テスト | E-01 (4行目: `self.primary_key = :group_id`) | ○ |
| C-07 | table_name設定テスト | E-01 (5行目: `self.table_name = 'group_crm_settings'`) | ○ |
| C-08 | Common.has_details?テスト | E-02 (8-10行目) | ○ |
| C-09 | Common.details_pathテスト | E-02 (12-14行目) | ○ |
| C-10 | Common.has_action?テスト | E-02 (16-18行目) | ○ |
| C-11 | Factory.common_helpersテスト | E-03 (8-10行目) | ○ |
| C-12 | Factory.extended_statusesテスト | E-03 (12-14行目) | ○ |
| C-13 | RelationFactory.OVERRIDESテスト | E-04 (7-15行目) | ○ |
| C-14 | setup_models(notes)テスト | E-04 (43-48行目) | ○ |
| C-15 | setup_models(Iterations::Cadence)テスト | E-04 (72-74行目) | ○ |
| C-16 | setup_event author_id nil時テスト | E-04 (76-78行目) | ○ |
| C-17 | setup_event author_id存在時テスト | E-04 (76-78行目) | ○ |
| C-18 | invalid_relation? namespace_settings時テスト | E-04 (57-59行目) | ○ |
| C-19 | invalid_relation? その他時テスト | E-04 (57-59行目) | ○ |
| C-20 | update_group_referencesテスト | E-04 (61-66行目) | ○ |
| C-21 | update_group_references group_id nil時テスト | E-04 (61-66行目) | ○ |
| C-22 | use_attributes_permitter?テスト | E-04 (68-70行目) | ○ |
| C-23 | TreeSaver.initializeテスト | E-05 (9-15行目) | ○ |
| C-24 | TreeSaver.saveテスト | E-05 (17-33行目) | ○ |
| C-25 | TreeSaver.save例外時テスト | E-05 (28-30行目) | ○ |
| C-26 | TreeSaver.groupsテスト | E-05 (37-42行目) | ○ |
| C-27 | TreeSaver.serializeテスト | E-05 (44-52行目) | ○ |
| C-28 | TreeSaver.full_pathテスト | E-05 (7,14行目) | ○ |
| C-29 | ObjectBuilder.initializeテスト | E-06 (12-16行目) | ○ |
| C-30 | ObjectBuilder.where_clausesテスト | E-06 (22-29行目) | ○ |
| C-31 | ObjectBuilder.where_clause_baseテスト | E-06 (32-34行目) | ○ |
| C-32 | ObjectBuilder.group_and_ancestor_idsテスト | E-06 (36-38行目) | ○ |
| C-33 | ObjectBuilder.group_and_ancestor_ids 祖先なし時テスト | E-06 (36-38行目) | ○ |
| C-34 | GroupRestorer.initializeテスト | E-07 (7-23行目) | ○ |
| C-35 | GroupRestorer.restoreテスト | E-07 (25-34行目) | ○ |
| C-36 | GroupRestorer.restore マッピング失敗時テスト | E-07 (31行目) | ○ |
| C-37 | GroupRestorer.members_mapperテスト | E-07 (53-59行目) | ○ |
| C-38 | GroupRestorer.relation_factoryテスト | E-07 (61-63行目) | ○ |
| C-39 | GroupRestorer.object_builderテスト | E-07 (65-67行目) | ○ |
| C-40 | TreeRestorer.initializeテスト | E-08 (11-16行目) | ○ |
| C-41 | TreeRestorer.restoreテスト | E-08 (18-32行目) | ○ |
| C-42 | TreeRestorer.restore例外時テスト | E-08 (29-31行目) | ○ |
| C-43 | TreeRestorer.process_root name/path削除テスト | E-08 (66行目) | ○ |
| C-44 | TreeRestorer.process_root visibility_level調整テスト | E-08 (68-75行目) | ○ |
| C-45 | TreeRestorer.process_root制限visibility削除テスト | E-08 (73-74行目) | ○ |
| C-46 | TreeRestorer.process_childテスト | E-08 (80-92行目) | ○ |
| C-47 | TreeRestorer.process_child例外時テスト | E-08 (86-91行目) | ○ |
| C-48 | TreeRestorer.create_groupテスト | E-08 (94-114行目) | ○ |
| C-49 | TreeRestorer.create_group 親グループなし時テスト | E-08 (100行目) | ○ |
| C-50 | TreeRestorer.create_groupバリデーションエラー時テスト | E-08 (111行目) | ○ |
| C-51 | TreeRestorer.restore_groupテスト | E-08 (116-128行目) | ○ |
| C-52 | TreeRestorer.sub_group_visibility_level 親より高い時テスト | E-08 (138-149行目) | ○ |
| C-53 | TreeRestorer.sub_group_visibility_level 同じ時テスト | E-08 (138-149行目) | ○ |
| C-54 | TreeRestorer.sub_group_visibility_level nil時テスト | E-08 (141-142行目) | ○ |
| C-55 | TreeRestorer.closest_allowed_levelテスト | E-08 (151-153行目) | ○ |
| C-56 | GroupAttributes.initializeテスト | E-08 (37-47行目) | ○ |
| C-57 | GroupAttributes.initialize id不一致時テスト | E-08 (44-46行目) | ○ |
| C-58 | GroupAttributes.delete_attributeテスト | E-08 (49-51行目) | ○ |
| C-59 | GroupAttributes.delete_attributesテスト | E-08 (53-55行目) | ○ |
| C-60 | RelationTreeRestorer.restoreテスト | E-09 (38-42行目) | ○ |
| C-61 | RelationTreeRestorer.restore例外時テスト | E-09 (68-70行目) | ○ |
| C-62 | RelationTreeRestorer.restore_single_relationテスト | E-09 (44-46行目) | ○ |
| C-63 | RelationTreeRestorer.bulk_insert_enabledテスト | E-09 (73-75行目) | ○ |
| C-64 | RelationTreeRestorer.skip_on_duplicate_iid?テスト | E-09 (77-79行目) | ○ |
| C-65 | RelationTreeRestorer.create_relations!テスト | E-09 (86-89行目) | ○ |
| C-66 | RelationTreeRestorer.process_relation_item!テスト | E-09 (100-117行目) | ○ |
| C-67 | RelationTreeRestorer.process_relation_item!例外時テスト | E-09 (110-116行目) | ○ |
| C-68 | RelationTreeRestorer.process_relation_item! nil時テスト | E-09 (103行目) | ○ |
| C-69 | RelationTreeRestorer.previously_imported?存在時テスト | E-09 (119-121行目) | ○ |
| C-70 | RelationTreeRestorer.previously_imported?非存在時テスト | E-09 (119-121行目) | ○ |
| C-71 | RelationTreeRestorer.existing_iids issuesテスト | E-09 (127-136行目) | ○ |
| C-72 | RelationTreeRestorer.existing_iids milestonesテスト | E-09 (127-136行目) | ○ |
| C-73 | RelationTreeRestorer.save_relation_object新規時テスト | E-09 (138-150行目) | ○ |
| C-74 | RelationTreeRestorer.save_relation_object既存時テスト | E-09 (151-161行目) | ○ |
| C-75 | RelationTreeRestorer.save_relation_object無効時テスト | E-09 (152-156行目) | ○ |
| C-76 | RelationTreeRestorer.update_params!テスト | E-09 (178-188行目) | ○ |
| C-77 | RelationTreeRestorer.filter_attributes permitted時テスト | E-09 (190-199行目) | ○ |
| C-78 | RelationTreeRestorer.filter_attributes未定義時テスト | E-09 (190-199行目) | ○ |
| C-79 | RelationTreeRestorer.present_override_paramsテスト | E-09 (205-211行目) | ○ |
| C-80 | RelationTreeRestorer.importable_override_paramsテスト | E-09 (217-223行目) | ○ |
| C-81 | RelationTreeRestorer.importable_override_params import_dataなし時テスト | E-09 (217-223行目) | ○ |
| C-82 | RelationTreeRestorer.build_relationテスト | E-09 (235-258行目) | ○ |
| C-83 | RelationTreeRestorer.build_relation author時テスト | E-09 (238行目) | ○ |
| C-84 | RelationTreeRestorer.build_relation already_restored時テスト | E-09 (238行目) | ○ |
| C-85 | RelationTreeRestorer.already_restored? オブジェクト時テスト | E-09 (263-265行目) | ○ |
| C-86 | RelationTreeRestorer.already_restored? ハッシュ時テスト | E-09 (263-265行目) | ○ |
| C-87 | RelationTreeRestorer.transform_sub_relations!テスト | E-09 (267-293行目) | ○ |
| C-88 | RelationTreeRestorer.transform_sub_relations! nil時テスト | E-09 (268-269行目) | ○ |
| C-89 | RelationTreeRestorer.transform_sub_relations! 配列時テスト | E-09 (274-279行目) | ○ |
| C-90 | RelationTreeRestorer.transform_sub_relations! ハッシュ時テスト | E-09 (280-286行目) | ○ |
| C-91 | RelationTreeRestorer.relation_invalid_for_importable?テスト | E-09 (295-297行目) | ○ |
| C-92 | RelationTreeRestorer.log_relation_creationテスト | E-09 (326-340行目) | ○ |
| C-93 | RelationTreeRestorer.log_relation_creation root_ancestorなし時テスト | E-09 (329行目) | ○ |
| C-94 | RelationTreeRestorer.log_invalid_subrelationsテスト | E-09 (342-362行目) | ○ |
| C-95 | RelationTreeRestorer.log_failed_subrelationsテスト | E-09 (364-391行目) | ○ |
| C-96 | RelationTreeRestorer.external_identifiers iidあり時テスト | E-09 (397-399行目) | ○ |
| C-97 | RelationTreeRestorer.external_identifiers iidなし時テスト | E-09 (397-399行目) | ○ |
| C-98 | RelationTreeRestorer.persist_relationテスト | E-09 (401-403行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコードによる明確な根拠があります
- 注意点：
  - RelationTreeRestorerは大規模なクラスであり、統合テストでの検証も推奨
  - TreeRestorer.sub_group_visibility_levelの可視性レベル計算ロジックはセキュリティ観点で重要

## 6) レビュアーチェックリスト（最小）
- [ ] Group::CrmSettingsのリレーション定義（group, source_group）が正しくテストされているか
- [ ] バリデーション（validates :group, presence: true）のテストケースが網羅されているか
- [ ] Gitlab::Ci::Status::Group::Commonモジュールの全メソッドがカバーされているか
- [ ] RelationFactoryのOVERRIDES定数とEXISTING_OBJECT_RELATIONS定数の使用箇所が正しいか
- [ ] TreeSaverとTreeRestorerのエラーハンドリングがテストされているか
- [ ] 可視性レベル（visibility_level）の調整ロジックが正しくテストされているか
- [ ] RelationTreeRestorerの主要処理フロー（restore, create_relations!, process_relation_item!）がカバーされているか
- [ ] 例外発生時のImportFailureへの記録がテストされているか
