---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：groups.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **EE固有機能のテストケース**：CE版コードのみ解析のため、EE固有機能のテストケースが不足している可能性
  2. **プライベートメソッドのテスト観点**：一部プライベートメソッドの詳細動作が確認困難
  3. **外部サービス連携のモック方法**：Mattermost等の外部サービス連携のテスト詳細が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/group.rb`（Groupモデル本体、1407行）
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/groups/feature_setting.rb`（グループ機能設定モデル）
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/group_group_link.rb`（グループ間リンクモデル）
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/group_import_state.rb`（グループインポート状態モデル）
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/group_deletion_schedule.rb`（グループ削除スケジュールモデル）
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/group_custom_attribute.rb`（グループカスタム属性モデル）
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/group_label.rb`（グループラベルモデル）
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/group_deploy_token.rb`（グループデプロイトークンモデル）
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/create_service.rb`（グループ作成サービス）
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/update_service.rb`（グループ更新サービス）
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/destroy_service.rb`（グループ削除サービス）
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/transfer_service.rb`（グループ転送サービス）
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/group_links/create_service.rb`（グループリンク作成サービス）
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/group_links/destroy_service.rb`（グループリンク削除サービス）
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/group_links/update_service.rb`（グループリンク更新サービス）
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/mark_for_deletion_service.rb`（削除マークサービス）
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/groups/restore_service.rb`（リストアサービス）
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/groups/user_groups_finder.rb`（ユーザーグループFinder）
- E-19: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/groups/base.rb`（FinderベースクラスGroups::Base）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Group.sti_nameがGroupを返す | E-01 L33-35 | ○ |
| C-02 | supported_keyset_orderingsの戻り値 | E-01 L37-39 | ○ |
| C-03 | notification_settingsリレーション動作 | E-01 L608-618 | ○ |
| C-04 | 階層順序指定時のソート動作 | E-01 L612-617 | ○ |
| C-05 | notification_settings_forのフィルタリング | E-01 L620-622 | ○ |
| C-06 | packages_feature_enabled?の動作 | E-01 L624-626 | ○ |
| C-07 | dependency_proxy_feature_available?の動作 | E-01 L628-630 | ○ |
| C-08 | notification_email_forの動作 | E-01 L632-636 | ○ |
| C-09 | dependency_proxy_image_prefixの生成 | E-01 L638-645 | ○ |
| C-10 | human_nameの戻り値 | E-01 L647-649 | ○ |
| C-11 | to_human_referenceの動作 | E-01 L651-655 | ○ |
| C-15-24 | visibility_level関連バリデーション | E-01 L657-682 | ○ |
| C-25-27 | lfs_enabled?の動作 | E-01 L684-689 | ○ |
| C-28-30 | owned_by?の動作 | E-01 L691-695 | ○ |
| C-31-37 | add_member系メソッドの動作 | E-01 L697-739 | ○ |
| C-38-44 | member?, has_owner?, has_maintainer?の動作 | E-01 L741-765 | ○ |
| C-45-47 | last_owner?の動作 | E-01 L770-784 | ○ |
| C-48 | ldap_synced?の動作（CE版） | E-01 L806-808 | ○ |
| C-49-50 | post_create_hook, post_destroy_hookの動作 | E-01 L810-820 | ○ |
| C-51 | refresh_members_authorized_projectsの動作 | E-01 L829-844 | ○ |
| C-52-53 | self_and_ancestors_ids, self_and_descendants_idsの動作 | E-01 L859-869 | ○ |
| C-54-65 | メンバーシップ関連メソッドの動作 | E-01 L878-995 | ○ |
| C-66-71 | runners_token, project_creation_level等の動作 | E-01 L1005-1020 | ○ |
| C-72-88 | その他のパブリックメソッドの動作 | E-01 L1022-1315 | ○ |
| C-89-91 | Groups::FeatureSettingの動作 | E-02 L1-24 | ○ |
| C-92-105 | GroupGroupLinkの動作 | E-03 L1-81 | ○ |
| C-106-123 | GroupImportStateの動作 | E-04 L1-42 | ○ |
| C-124-126 | GroupDeletionScheduleの動作 | E-05 L1-10 | ○ |
| C-127-131 | GroupCustomAttributeの動作 | E-06 L1-8 | ○ |
| C-132-135 | GroupLabelの動作 | E-07 L1-20 | ○ |
| C-136-146 | GroupDeployTokenの動作 | E-08 L1-27 | ○ |
| C-147-153 | Groups::CreateServiceの動作 | E-09 L1-199 | ○ |
| C-154-160 | Groups::UpdateServiceの動作 | E-10 L1-197 | ○ |
| C-161-167 | Groups::DestroyServiceの動作 | E-11 L1-149 | ○ |
| C-168-178 | Groups::TransferServiceの動作 | E-12 L1-347 | ○ |
| C-179-181 | Groups::GroupLinks::CreateServiceの動作 | E-13 L1-46 | ○ |
| C-182-185 | Groups::GroupLinks::DestroyServiceの動作 | E-14 L1-35 | ○ |
| C-186-188 | Groups::GroupLinks::UpdateServiceの動作 | E-15 L1-42 | ○ |
| C-189-191 | Groups::MarkForDeletionServiceの動作 | E-16 L1-79 | ○ |
| C-192-194 | Groups::RestoreServiceの動作 | E-17 L1-57 | ○ |
| C-195-200 | Groups::UserGroupsFinderの動作 | E-18 L1-87 | ○ |
| C-EE-01 | EE固有機能（LDAP同期、SAMLなど） | **根拠なし** | △ |
| C-EE-02 | EE固有のバリデーション（サブスクリプション制限など） | **根拠なし** | △ |
| C-EE-03 | prepend_mod_with で追加される機能 | **根拠なし** | △ |
| C-EXT-01 | Mattermost連携の詳細動作 | **根拠なし** | △ |
| C-EXT-02 | 外部サービス（Harbor等）との連携詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **EE固有機能のコード**：CE版のみ解析したため、EE（Enterprise Edition）固有の機能（LDAP同期、SAML、高度なセキュリティ機能等）のテストケースが不足
  - 候補：`ee/app/models/group.rb` / `ee/app/services/groups/` / `ee/lib/ee/group.rb`
- **prepend_mod_with で追加される機能**：各ファイル末尾の `prepend_mod_with` で追加されるモジュールの詳細動作
  - 候補：`ee/app/models/ee/group.rb` / `ee/app/services/groups/`
- **外部サービス連携の詳細**：Mattermost、Harbor等の外部サービスとの連携テストの詳細が不明確
  - 候補：外部サービスのAPIドキュメント / モックライブラリのドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Groupモデルの基本的なリレーション、バリデーション、アクセサ（C-01〜C-88）
- **0: 低リスク** - 関連モデル（GroupGroupLink, GroupImportState等）の基本動作（C-89〜C-146）
- **1: 中リスク** - サービスクラスの正常系処理（C-147〜C-200）
- **1: 中リスク** - 権限・認可に関するテストケース（C-148, C-149, C-171, C-180, C-183）
- **2: 高リスク** - EE固有機能のテストケース不足（C-EE-01〜C-EE-03）：EE環境でのテスト漏れの可能性
- **1: 中リスク** - 外部サービス連携のテスト（C-EXT-01〜C-EXT-02）：モック方法の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度（優先度「高」）のテストケースがすべてカバーされているか確認
- [ ] 可視性レベル（visibility_level）関連のテストケースが適切に網羅されているか確認
- [ ] 権限・認可（has_owner?, member?, max_member_access_for_user等）のテストケースが適切か確認
- [ ] 状態遷移（GroupImportStateのstate_machine）のテストケースが網羅的か確認
- [ ] サービスクラスの異常系（エラー処理）テストケースが十分か確認
- [ ] EE環境で追加されるテストケースの必要性を検討
- [ ] 外部サービス連携（Mattermost等）のモック方法が適切か確認
- [ ] バリデーションエラーメッセージの国際化（I18n）が考慮されているか確認
