---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 110
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hooks.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：110 / 110、根拠なし：0
- 優先レビュー（高）
  1. なし：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/hooks/web_hook.rb` - WebHook基底クラス定義
- E-02: `app/models/concerns/web_hooks/hook.rb` - WebHooks::Hook concern（execute, async_execute, interpolated_url, バリデーション等）
- E-03: `app/models/concerns/web_hooks/auto_disabling.rb` - AutoDisabling concern（executable?, backoff!, enable!等）
- E-04: `app/models/hooks/project_hook.rb` - ProjectHookクラス定義（リレーション、スコープ）
- E-05: `app/models/hooks/system_hook.rb` - SystemHookクラス定義（組織リレーション、デフォルト属性）
- E-06: `app/models/hooks/service_hook.rb` - ServiceHookクラス定義（インテグレーションリレーション）
- E-07: `app/models/hooks/web_hook_log.rb` - WebHookLogクラス定義（ログ管理、スコープ、メソッド）
- E-08: `app/models/hooks/active_hook_filter.rb` - ActiveHookFilterクラス定義（ブランチフィルタリング）
- E-09: `app/models/concerns/triggerable_hooks.rb` - TriggerableHooks concern（hooks_for, select_active）
- E-10: `app/models/concerns/limitable.rb` - Limitable concern（プラン制限チェック）

## 3) Claims と根拠の対応（レビューの主戦場）

### WebHook基底クラス（UT-HOK-001〜UT-HOK-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-HOK-001: executeメソッドがWebHookServiceを呼び出す | E-02 (hook.rb:84-86) | ○ |
| C-02 | UT-HOK-002: idempotency_keyがWebHookServiceに渡される | E-02 (hook.rb:84-86) | ○ |
| C-03 | UT-HOK-003: forceフラグで強制実行できる | E-02 (hook.rb:84-86) | ○ |
| C-04 | UT-HOK-004: async_executeがexecutable?チェック後に非同期実行 | E-02 (hook.rb:89-91) | ○ |
| C-05 | UT-HOK-005: executable?がfalseの場合async_executeは実行されない | E-02 (hook.rb:90) | ○ |
| C-06 | UT-HOK-006〜007: allow_local_requests?がGitlab設定を参照 | E-02 (hook.rb:94-96) | ○ |
| C-07 | UT-HOK-008〜009: rate_limited?とrate_limitがRateLimiterを使用 | E-02 (hook.rb:103-110) | ○ |
| C-08 | UT-HOK-010〜012: interpolated_urlがURL変数を置換 | E-02 (hook.rb:130-139) | ○ |
| C-09 | UT-HOK-013〜014: masked_tokenがトークンをマスク | E-02 (hook.rb:141-143) | ○ |
| C-10 | UT-HOK-015〜016: masked_url_variablesとmasked_custom_headersがキーのみ返却 | E-02 (hook.rb:145-151) | ○ |
| C-11 | UT-HOK-017: validate_public_url?がデフォルトでtrue | E-02 (hook.rb:153-155) | ○ |
| C-12 | UT-HOK-018〜023: URLとトークンのバリデーション | E-02 (hook.rb:48-76) | ○ |
| C-13 | UT-HOK-024〜026: reset_token, reset_url_variables, set_branch_filter_nil | E-02 (hook.rb:159-230) | ○ |

### ProjectHook（UT-HOK-027〜UT-HOK-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | UT-HOK-027: belongs_to :project | E-04 (project_hook.rb:34) | ○ |
| C-15 | UT-HOK-028: has_many :web_hook_logs | E-04 (project_hook.rb:32) | ○ |
| C-16 | UT-HOK-029: projectのpresenceバリデーション | E-04 (project_hook.rb:35) | ○ |
| C-17 | UT-HOK-030: scope :for_projects | E-04 (project_hook.rb:37) | ○ |
| C-18 | UT-HOK-031: available_hooksがAVAILABLE_HOOKSを返す | E-04 (project_hook.rb:39-41) | ○ |
| C-19 | UT-HOK-032: pluralized_nameが'Webhooks'を返す | E-04 (project_hook.rb:45-47) | ○ |
| C-20 | UT-HOK-033: application_contextがプロジェクト情報を含む | E-04 (project_hook.rb:49-52) | ○ |
| C-21 | UT-HOK-034: parentがprojectを返す | E-04 (project_hook.rb:54-57) | ○ |
| C-22 | UT-HOK-035〜036: Limitableによるプラン制限 | E-04 (project_hook.rb:6), E-10 | ○ |

### SystemHook（UT-HOK-037〜UT-HOK-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | UT-HOK-037: belongs_to :organization | E-05 (system_hook.rb:28) | ○ |
| C-24 | UT-HOK-038: organization_idのpresenceバリデーション | E-05 (system_hook.rb:31) | ○ |
| C-25 | UT-HOK-039: system_hook_url バリデーション | E-05 (system_hook.rb:30) | ○ |
| C-26 | UT-HOK-040: allow_local_requests?がシステムフック設定を参照 | E-05 (system_hook.rb:34-36) | ○ |
| C-27 | UT-HOK-041: pluralized_nameが'System hooks'を返す | E-05 (system_hook.rb:38-40) | ○ |
| C-28 | UT-HOK-042: help_pathがヘルプページパスを返す | E-05 (system_hook.rb:42-44) | ○ |
| C-29 | UT-HOK-043: validate_public_url?がfalseを返す | E-05 (system_hook.rb:46-49) | ○ |
| C-30 | UT-HOK-044〜045: デフォルト属性 | E-05 (system_hook.rb:24-26) | ○ |

### ServiceHook（UT-HOK-046〜UT-HOK-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | UT-HOK-046: belongs_to :integration | E-06 (service_hook.rb:12) | ○ |
| C-32 | UT-HOK-047: integrationのpresenceバリデーション | E-06 (service_hook.rb:13) | ○ |
| C-33 | UT-HOK-048〜049: executeがservice_hookをデフォルトhook_nameとして使用 | E-06 (service_hook.rb:15-17) | ○ |
| C-34 | UT-HOK-050: parentがintegrationに委譲 | E-06 (service_hook.rb:19-20) | ○ |

### WebHookLog（UT-HOK-051〜UT-HOK-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | UT-HOK-051: belongs_to :web_hook | E-07 (web_hook_log.rb:18) | ○ |
| C-36 | UT-HOK-052: web_hookのpresenceバリデーション | E-07 (web_hook_log.rb:24) | ○ |
| C-37 | UT-HOK-053: scope :by_status_code | E-07 (web_hook_log.rb:30) | ○ |
| C-38 | UT-HOK-054〜056: self.recentのロジックと制限 | E-07 (web_hook_log.rb:32-39) | ○ |
| C-39 | UT-HOK-057〜060: self.created_betweenのバリデーション | E-07 (web_hook_log.rb:41-51) | ○ |
| C-40 | UT-HOK-061〜063: self.delete_batch_for | E-07 (web_hook_log.rb:54-58) | ○ |
| C-41 | UT-HOK-064〜065: success?の判定ロジック | E-07 (web_hook_log.rb:64-66) | ○ |
| C-42 | UT-HOK-066: internal_error?の判定 | E-07 (web_hook_log.rb:68-70) | ○ |
| C-43 | UT-HOK-067: oversize?の判定 | E-07 (web_hook_log.rb:72-74) | ○ |
| C-44 | UT-HOK-068〜069: request_headersのトークンマスク | E-07 (web_hook_log.rb:76-80) | ○ |
| C-45 | UT-HOK-070〜071: *_headers_listのリスト変換 | E-07 (web_hook_log.rb:82-88) | ○ |
| C-46 | UT-HOK-072: idempotency_key取得 | E-07 (web_hook_log.rb:90-92) | ○ |
| C-47 | UT-HOK-073〜075: url_current?のハッシュ比較 | E-07 (web_hook_log.rb:94-100) | ○ |
| C-48 | UT-HOK-076〜077: privateメソッドのセキュリティ処理 | E-07 (web_hook_log.rb:104-112) | ○ |

### ActiveHookFilter（UT-HOK-078〜UT-HOK-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | UT-HOK-078: initializeでhookが保持される | E-08 (active_hook_filter.rb:4-6) | ○ |
| C-50 | UT-HOK-079〜081: matches?のスコープ判定 | E-08 (active_hook_filter.rb:8-12) | ○ |
| C-51 | UT-HOK-082〜086: matches_branch?のブランチフィルタロジック | E-08 (active_hook_filter.rb:16-33) | ○ |

### AutoDisabling（UT-HOK-087〜UT-HOK-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | UT-HOK-087〜090: executable?の判定ロジック | E-03 (auto_disabling.rb:79-83) | ○ |
| C-53 | UT-HOK-091〜092: temporarily_disabled?の判定 | E-03 (auto_disabling.rb:85-90) | ○ |
| C-54 | UT-HOK-093〜094: permanently_disabled?の判定と境界値 | E-03 (auto_disabling.rb:92-96) | ○ |
| C-55 | UT-HOK-095〜096: enable!のリセット処理 | E-03 (auto_disabling.rb:98-107) | ○ |
| C-56 | UT-HOK-097〜099: backoff!の失敗カウント増加とdisabled_until設定 | E-03 (auto_disabling.rb:111-125) | ○ |
| C-57 | UT-HOK-100〜102: alert_statusのステータス判定 | E-03 (auto_disabling.rb:127-137) | ○ |
| C-58 | UT-HOK-103: next_failure_countの上限制御 | E-03 (auto_disabling.rb:145-147) | ○ |
| C-59 | UT-HOK-104〜106: next_backoffの指数計算と最大値制限 | E-03 (auto_disabling.rb:149-155) | ○ |

### TriggerableHooks（UT-HOK-107〜UT-HOK-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | UT-HOK-107〜109: hooks_forのトリガーフィルタ | E-09 (triggerable_hooks.rb:9-14) | ○ |
| C-61 | UT-HOK-110: select_activeのActiveHookFilter使用 | E-09 (triggerable_hooks.rb:16-20) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースに対して、対応するソースコードの根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいており、信頼性は高い
- 注意点：
  - WebHookServiceクラスの詳細実装は本解析スコープ外のため、execute/async_executeのモック設計時に要確認
  - Gitlab::WebHooks::RateLimiterの詳細仕様は別モジュールのため、レート制限テストの期待値設計時に要確認
  - PartitionedTableの挙動はWebHookLogのパーティション設計に影響するため、テストデータ設計時に考慮必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-HOK-001〜005, 008, 027, 029, 035-036, 037-039, 046-047, 051-052, 054, 056, 061, 068, 076-077, 080-081, 084-085, 087-090, 091, 093, 095, 097-098, 107, 110）のカバレッジ確認
- [ ] セキュリティ関連テスト（トークンマスク、メール秘匿、Basic認証マスク）の網羅性確認
- [ ] バリデーションテストの境界値（URL長さ8192文字、失敗回数39/40）の正確性確認
- [ ] AutoDisablingのバックオフ計算（指数増加、1日上限）の期待値確認
- [ ] ActiveHookFilterの正規表現・ワイルドカードマッチングのテストデータ妥当性確認
