---
generated_at: 2026-01-22 15:25:00
metrics:
  claims_total: 44
  claims_with_evidence: 44
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：identity.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：44 / 44、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/identity.rb` - メインのIdentityモデルクラス
- E-02: `app/models/identity/uniqueness_scopes.rb` - ユニーク制約スコープ定義
- E-03: `spec/models/identity_spec.rb` - Identityモデルの既存テスト
- E-04: `lib/gitlab/auth/identity.rb` - 関連するGitlab::Auth::Identityクラス
- E-05: `spec/lib/gitlab/sidekiq_middleware/identity/passthrough_spec.rb` - Sidekiqミドルウェアテスト
- E-06: `spec/lib/gitlab/sidekiq_middleware/identity/restore_spec.rb` - Sidekiqミドルウェアテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :user リレーションが存在する | E-01 (line 7), E-03 (line 7) | ○ |
| C-02 | user は optional: false で必須 | E-01 (line 7) | ○ |
| C-03 | provider は presence: true で必須 | E-01 (line 9) | ○ |
| C-04 | provider が nil の場合バリデーションエラー | E-01 (line 9) | ○ |
| C-05 | provider が空文字の場合バリデーションエラー | E-01 (line 9) | ○ |
| C-06 | extern_uid は uniqueness バリデーションあり | E-01 (lines 10-14) | ○ |
| C-07 | extern_uid の重複チェックは scope: UniquenessScopes.scopes | E-01 (line 11), E-02 (line 8) | ○ |
| C-08 | extern_uid の重複チェックは case_sensitive: false | E-01 (line 12) | ○ |
| C-09 | extern_uid は allow_blank: true | E-01 (line 10) | ○ |
| C-10 | extern_uid 重複時のカスタムエラーメッセージ | E-01 (line 13) | ○ |
| C-11 | user の uniqueness バリデーションあり | E-01 (line 16) | ○ |
| C-12 | user の uniqueness は scope: UniquenessScopes.scopes | E-01 (line 16), E-02 (line 8) | ○ |
| C-13 | 同一providerで同一userは重複エラー | E-01 (line 16), E-03 (lines 18-34) | ○ |
| C-14 | scope :for_user が定義されている | E-01 (line 21) | ○ |
| C-15 | scope :for_user_ids が定義されている | E-01 (line 22) | ○ |
| C-16 | scope :with_provider が定義されている | E-01 (line 23) | ○ |
| C-17 | scope :with_extern_uid が定義されている | E-01 (lines 24-26) | ○ |
| C-18 | with_extern_uid は iwhere を使用して大文字小文字を区別しない | E-01 (line 25) | ○ |
| C-19 | with_extern_uid は normalize_uid を呼び出す | E-01 (line 25) | ○ |
| C-20 | scope :with_any_extern_uid が定義されている | E-01 (lines 27-29) | ○ |
| C-21 | with_any_extern_uid は extern_uid が nil でないものを検索 | E-01 (line 28) | ○ |
| C-22 | ldap? メソッドが定義されている | E-01 (lines 31-33), E-03 (lines 45-56) | ○ |
| C-23 | ldap? は Gitlab::Auth::OAuth::Provider.ldap_provider? を呼び出す | E-01 (line 32) | ○ |
| C-24 | self.normalize_uid クラスメソッドが定義されている | E-01 (lines 35-41) | ○ |
| C-25 | normalize_uid は LDAP プロバイダーの場合 DN を正規化 | E-01 (lines 36-37), E-03 (lines 59-78) | ○ |
| C-26 | normalize_uid は非 LDAP プロバイダーの場合 to_s のみ | E-01 (lines 38-39) | ○ |
| C-27 | before_save :ensure_normalized_extern_uid コールバックあり | E-01 (line 18) | ○ |
| C-28 | ensure_normalized_extern_uid は extern_uid_changed? 条件付き | E-01 (line 18), E-03 (lines 111-133) | ○ |
| C-29 | ensure_normalized_extern_uid は extern_uid が nil の場合早期リターン | E-01 (lines 45-48) | ○ |
| C-30 | ensure_normalized_extern_uid は normalize_uid を呼び出す | E-01 (line 48) | ○ |
| C-31 | after_destroy :clear_user_synced_attributes コールバックあり | E-01 (line 19), E-03 (lines 136-167) | ○ |
| C-32 | clear_user_synced_attributes は条件付き | E-01 (line 19) | ○ |
| C-33 | user_synced_attributes_metadata_from_provider? メソッドあり | E-01 (lines 51-53) | ○ |
| C-34 | user_synced_attributes_metadata_from_provider? は provider を比較 | E-01 (line 52) | ○ |
| C-35 | clear_user_synced_attributes は metadata を destroy | E-01 (lines 55-57), E-03 (lines 144-151) | ○ |
| C-36 | 異なるプロバイダーの metadata は削除されない | E-03 (lines 155-165) | ○ |
| C-37 | safe navigation (&.) で nil 安全 | E-01 (lines 52, 56) | ○ |
| C-38 | UniquenessScopes モジュールが定義されている | E-02 (lines 6-10) | ○ |
| C-39 | UniquenessScopes.scopes は [:provider] を返す | E-02 (line 8) | ○ |
| C-40 | UniquenessScopes は prepend_mod で拡張可能 | E-02 (line 13) | ○ |
| C-41 | Identity は Sortable concern を include | E-01 (line 4) | ○ |
| C-42 | Identity は CaseSensitivity concern を include | E-01 (line 5) | ○ |
| C-43 | Identity は prepend_mod_with で拡張可能 | E-01 (line 60) | ○ |
| C-44 | with_extern_uid テストで DN フォーマットの違いを吸収 | E-03 (lines 58-67) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースに対してソースコードまたは既存テストから根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、既存のspecファイルとも整合性がある

## 6) レビュアーチェックリスト（最小）
- [ ] UT-IDT-007: extern_uid重複時のカスタムエラーメッセージが正しく表示されることを確認
- [ ] UT-IDT-020, UT-IDT-029: LDAP DN正規化のテストで使用するDN形式が実運用と一致するか確認
- [ ] UT-IDT-035: after_destroyコールバックでuser_synced_attributes_metadataが正しく削除されることを確認
- [ ] UT-IDT-041, UT-IDT-042: EE拡張時のUniquenessScopes.scopesの挙動を確認（CE環境では[:provider]のみ）
- [ ] 既存テスト（spec/models/identity_spec.rb）との重複がないか確認し、必要に応じてマージ検討
