---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 170
  claims_with_evidence: 170
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：import モジュール 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：170 / 170、根拠なし：0
- 優先レビュー（高）
  1. **状態遷移テスト（UT-IMP-054〜068）**：state_machineの定義に基づく遷移パターンの網羅性確認
  2. **バリデーションテスト（UT-IMP-006〜019）**：validatesの条件分岐の複雑さ
  3. **認証情報検証テスト（UT-IMP-160〜163）**：JSONスキーマ検証の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/import/source_user.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/import/namespace_import_user.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/import/source_user_placeholder_reference.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/import/placeholder_user_detail.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/import/placeholders/membership.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/import/offline/export.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/import/offline/configuration.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/base_service.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/keep_as_placeholder_service.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/cancel_reassignment_service.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/accept_reassignment_service.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/reassign_service.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/reject_reassignment_service.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/undo_keep_as_placeholder_service.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/import/source_users/resend_notification_service.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Import::SourceUser モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-IMP-001: placeholder_user belongs_to リレーション | E-01 (line 19) | ○ |
| C-02 | UT-IMP-002: placeholder_user optional: true | E-01 (line 19) | ○ |
| C-03 | UT-IMP-003: reassign_to_user belongs_to リレーション | E-01 (line 20) | ○ |
| C-04 | UT-IMP-004: reassigned_by_user belongs_to リレーション | E-01 (line 21) | ○ |
| C-05 | UT-IMP-005: namespace belongs_to リレーション | E-01 (line 22) | ○ |
| C-06 | UT-IMP-006〜009: presence validation | E-01 (line 24) | ○ |
| C-07 | UT-IMP-010: uniqueness validation | E-01 (line 25) | ○ |
| C-08 | UT-IMP-011〜012: placeholder_user_id 条件付きvalidation | E-01 (lines 26-32) | ○ |
| C-09 | UT-IMP-013〜014: reassignment_token validation | E-01 (lines 27-28) | ○ |
| C-10 | UT-IMP-015〜016: reassign_to_user_id 条件付きvalidation | E-01 (lines 29-32) | ○ |
| C-11 | UT-IMP-017〜019: validate_source_hostname | E-01 (lines 185-193) | ○ |
| C-12 | UT-IMP-020〜026: スコープ定義 | E-01 (lines 42-48) | ○ |
| C-13 | UT-IMP-027〜029: find_source_user メソッド | E-01 (lines 120-129) | ○ |
| C-14 | UT-IMP-030: find_by_namespace_and_token メソッド | E-01 (lines 131-136) | ○ |
| C-15 | UT-IMP-031〜032: search メソッド | E-01 (lines 138-141) | ○ |
| C-16 | UT-IMP-033〜035: sort_by_attribute メソッド | E-01 (lines 144-148) | ○ |
| C-17 | UT-IMP-036〜037: namespace_placeholder_user_count メソッド | E-01 (lines 150-153) | ○ |
| C-18 | UT-IMP-038〜039: source_users_with_missing_information メソッド | E-01 (lines 155-162) | ○ |
| C-19 | UT-IMP-040〜043: mapped_user/mapped_user_id メソッド | E-01 (lines 165-171) | ○ |
| C-20 | UT-IMP-044〜053: ステータス判定メソッド | E-01 (lines 173-183) | ○ |
| C-21 | UT-IMP-054〜068: state_machine 遷移イベント | E-01 (lines 64-117) | ○ |

### Import::NamespaceImportUser モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | UT-IMP-069: import_user belongs_to リレーション | E-02 (line 7) | ○ |
| C-23 | UT-IMP-070: namespace belongs_to リレーション | E-02 (line 8) | ○ |
| C-24 | UT-IMP-071〜072: presence validation | E-02 (line 10) | ○ |

### Import::SourceUserPlaceholderReference モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | UT-IMP-073: source_user belongs_to リレーション | E-03 (line 10) | ○ |
| C-26 | UT-IMP-074: namespace belongs_to リレーション | E-03 (line 11) | ○ |
| C-27 | UT-IMP-075〜076: presence validation | E-03 (line 13) | ○ |
| C-28 | UT-IMP-077〜078: numeric_key numericality validation | E-03 (line 14) | ○ |
| C-29 | UT-IMP-079〜080: ExactlyOnePresentValidator | E-03 (line 18) | ○ |
| C-30 | UT-IMP-081: validate_model_is_not_member | E-03 (lines 147-152) | ○ |
| C-31 | UT-IMP-082〜083: スコープ定義 | E-03 (lines 23-31) | ○ |
| C-32 | UT-IMP-084〜086: aliased_* メソッド | E-03 (lines 50-62) | ○ |
| C-33 | UT-IMP-087: to_serialized メソッド | E-03 (lines 64-66) | ○ |
| C-34 | UT-IMP-088〜089: from_serialized クラスメソッド | E-03 (lines 76-84) | ○ |
| C-35 | UT-IMP-090〜092: model_record メソッド | E-03 (lines 68-73) | ○ |

### Import::PlaceholderUserDetail モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | UT-IMP-093: placeholder_user belongs_to リレーション | E-04 (line 9) | ○ |
| C-37 | UT-IMP-094: namespace belongs_to リレーション | E-04 (line 10) | ○ |
| C-38 | UT-IMP-095: organization belongs_to リレーション | E-04 (line 11) | ○ |
| C-39 | UT-IMP-096: deletion_attempts numericality validation | E-04 (line 13) | ○ |
| C-40 | UT-IMP-097: placeholder_user presence validation | E-04 (line 14) | ○ |
| C-41 | UT-IMP-098〜102: eligible_for_deletion クラスメソッド | E-04 (lines 16-26) | ○ |
| C-42 | UT-IMP-103〜104: increment_deletion_attempt メソッド | E-04 (lines 28-30) | ○ |

### Import::Placeholders::Membership モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | UT-IMP-105: source_user belongs_to リレーション | E-05 (line 10) | ○ |
| C-44 | UT-IMP-106: namespace belongs_to リレーション | E-05 (line 11) | ○ |
| C-45 | UT-IMP-107: group belongs_to リレーション | E-05 (line 12) | ○ |
| C-46 | UT-IMP-108: project belongs_to リレーション | E-05 (line 13) | ○ |
| C-47 | UT-IMP-109〜111: presence validation | E-05 (line 15) | ○ |
| C-48 | UT-IMP-112〜113: access_level inclusion validation | E-05 (line 16) | ○ |
| C-49 | UT-IMP-114: group_id uniqueness validation | E-05 (line 17) | ○ |
| C-50 | UT-IMP-115: project_id uniqueness validation | E-05 (line 18) | ○ |
| C-51 | UT-IMP-116〜117: ExactlyOnePresentValidator | E-05 (line 19) | ○ |
| C-52 | UT-IMP-118〜122: スコープ定義 | E-05 (lines 21-25) | ○ |

### Import::Offline::Export モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | UT-IMP-123: user belongs_to リレーション | E-06 (line 13) | ○ |
| C-54 | UT-IMP-124: organization belongs_to リレーション | E-06 (line 14) | ○ |
| C-55 | UT-IMP-125: configuration has_one リレーション | E-06 (lines 16-17) | ○ |
| C-56 | UT-IMP-126: bulk_import_exports has_many リレーション | E-06 (line 18) | ○ |
| C-57 | UT-IMP-127〜128: presence validation | E-06 (line 20) | ○ |
| C-58 | UT-IMP-129〜134: validate_source_hostname | E-06 (lines 52-62) | ○ |
| C-59 | UT-IMP-135〜136: order_by_created_at スコープ | E-06 (line 23) | ○ |
| C-60 | UT-IMP-137〜142: state_machine 遷移イベント | E-06 (lines 25-46) | ○ |
| C-61 | UT-IMP-143: all_human_statuses クラスメソッド | E-06 (lines 48-50) | ○ |
| C-62 | UT-IMP-144〜145: schedule_configuration_purge メソッド | E-06 (lines 64-68) | ○ |

### Import::Offline::Configuration モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | UT-IMP-146: organization belongs_to リレーション | E-07 (line 10) | ○ |
| C-64 | UT-IMP-147: offline_export belongs_to リレーション | E-07 (line 11) | ○ |
| C-65 | UT-IMP-148〜151: presence validation | E-07 (line 15) | ○ |
| C-66 | UT-IMP-152: provider inclusion validation | E-07 (line 16) | ○ |
| C-67 | UT-IMP-153〜156: bucket length validation | E-07 (line 17) | ○ |
| C-68 | UT-IMP-157〜159: bucket format validation (S3_BUCKET_REGEXP) | E-07 (lines 8, 17) | ○ |
| C-69 | UT-IMP-160: aws JSON schema validation | E-07 (lines 18-20) | ○ |
| C-70 | UT-IMP-161: s3_compatible JSON schema validation | E-07 (lines 21-23) | ○ |
| C-71 | UT-IMP-162〜163: endpoint validation | E-07 (line 24) | ○ |
| C-72 | UT-IMP-164〜165: enum provider | E-07 (lines 26-29) | ○ |
| C-73 | UT-IMP-166〜167: generate_export_prefix after_initialize | E-07 (lines 31, 35-38) | ○ |
| C-74 | UT-IMP-168: encrypts object_storage_credentials | E-07 (line 13) | ○ |
| C-75 | UT-IMP-169〜170: supported_providers メソッド | E-07 (lines 45-51) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースがソースコードの根拠に基づいて生成されており、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されており、根拠が明確です。

### 注意が必要な項目
1. **状態遷移の網羅性**: Import::SourceUserのstate_machineは7つのステータスと8つのイベントを持ち、遷移パターンが複雑です。全ての有効な遷移と無効な遷移がカバーされているか確認推奨。
2. **バリデーションの条件分岐**: ステータスに依存するバリデーション（placeholder_user_id、reassign_to_user_id、reassignment_token）は条件が複雑なため、境界ケースの追加検討を推奨。
3. **JSONスキーマ検証**: object_storage_credentialsの検証はJSONスキーマファイルに依存しており、スキーマファイルの内容確認が必要です。

## 6) レビュアーチェックリスト（最小）
- [ ] state_machineの全遷移パターンが網羅されているか
- [ ] 条件付きバリデーションの全条件分岐がカバーされているか
- [ ] JSONスキーマ検証テストケースがスキーマ定義と整合しているか
- [ ] KNOWN_IMPORT_HOSTSの全ドメインが禁止ドメインテストでカバーされているか
- [ ] DELETION_RETRY_PERIOD (2.days) の境界値テストが適切か
- [ ] S3_BUCKET_REGEXP の正規表現パターンに対するテストが十分か
- [ ] bypassメソッド（admin_bypass_placeholder_confirmation_allowed?、project_bot_reassignment?）の権限テストが考慮されているか
