---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 136
  claims_with_evidence: 136
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：incident_management 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：136 / 136、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースにソースコードベースの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### モデルファイル
- E-01: `app/models/incident_management/project_incident_management_setting.rb`
- E-02: `app/models/incident_management/timeline_event_tag.rb`
- E-03: `app/models/incident_management/issuable_escalation_status.rb`
- E-04: `app/models/incident_management/timeline_event.rb`
- E-05: `app/models/incident_management/timeline_event_tag_link.rb`
- E-06: `app/models/concerns/incident_management/escalatable.rb`

### サービスファイル
- E-07: `app/services/incident_management/timeline_events/base_service.rb`
- E-08: `app/services/incident_management/timeline_events/create_service.rb`
- E-09: `app/services/incident_management/timeline_events/update_service.rb`
- E-10: `app/services/incident_management/timeline_events/destroy_service.rb`
- E-11: `app/services/incident_management/timeline_event_tags/base_service.rb`
- E-12: `app/services/incident_management/timeline_event_tags/create_service.rb`
- E-13: `app/services/incident_management/issuable_escalation_statuses/create_service.rb`
- E-14: `app/services/incident_management/issuable_escalation_statuses/build_service.rb`
- E-15: `app/services/incident_management/issuable_escalation_statuses/prepare_update_service.rb`
- E-16: `app/services/incident_management/issuable_escalation_statuses/after_update_service.rb`
- E-17: `app/services/incident_management/incidents/create_service.rb`
- E-18: `app/services/incident_management/link_alerts/base_service.rb`
- E-19: `app/services/incident_management/link_alerts/create_service.rb`
- E-20: `app/services/incident_management/link_alerts/destroy_service.rb`
- E-21: `app/services/incident_management/pager_duty/process_webhook_service.rb`
- E-22: `app/services/incident_management/pager_duty/create_incident_issue_service.rb`

### Finderファイル
- E-23: `app/finders/incident_management/timeline_events_finder.rb`
- E-24: `app/finders/incident_management/timeline_event_tags_finder.rb`

### Workerファイル
- E-25: `app/workers/incident_management/add_severity_system_note_worker.rb`
- E-26: `app/workers/incident_management/close_incident_worker.rb`
- E-27: `app/workers/incident_management/process_alert_worker_v2.rb`
- E-28: `app/workers/incident_management/pager_duty/process_incident_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### ProjectIncidentManagementSetting（UT-INC-001〜008）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトとの関連が定義されている | E-01 (belongs_to :project) | ○ |
| C-02 | available_issue_templatesがテンプレート一覧を返す | E-01 (Gitlab::Template::IssueTemplate.all) | ○ |
| C-03 | issue_template_contentがstrong_memoizeを使用 | E-01 (strong_memoize(:issue_template_content)) | ○ |
| C-04 | issue_template_keyが空の場合nilを返す | E-01 (if issue_template_key.present?) | ○ |
| C-05 | issue_template_existsバリデーション | E-01 (validate :issue_template_exists) | ○ |
| C-06 | pagerduty_tokenの自動生成 | E-01 (ensure_pagerduty_token, SecureRandom.hex) | ○ |
| C-07 | pagerduty_activeがfalseの場合生成しない | E-01 (return unless pagerduty_active) | ○ |
| C-08 | attr_encryptedによる暗号化 | E-01 (attr_encrypted :pagerduty_token) | ○ |

### TimelineEventTag（UT-INC-009〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | PREDEFINED_TAGSが6種類定義 | E-02 (PREDEFINED_TAGS = [...].freeze) | ○ |
| C-10 | projectとのbelongs_to関連 | E-02 (belongs_to :project) | ○ |
| C-11 | timeline_event_tag_linksとのhas_many関連 | E-02 (has_many :timeline_event_tag_links) | ○ |
| C-12 | timeline_eventsとのthrough関連 | E-02 (has_many :timeline_events, through:) | ○ |
| C-13 | name presenceバリデーション | E-02 (validates :name, presence: true) | ○ |
| C-14 | name formatバリデーション（カンマ禁止） | E-02 (format: { with: /\A[^,]+\z/ }) | ○ |
| C-15 | name uniquenessバリデーション | E-02 (validates :name, uniqueness: { scope: :project_id }) | ○ |
| C-16 | case_sensitive: false | E-02 (case_sensitive: false) | ○ |
| C-17 | name length最大255文字 | E-02 (validates :name, length: { maximum: 255 }) | ○ |
| C-18 | scope :by_names | E-02 (scope :by_names) | ○ |
| C-19 | by_namesが大文字小文字を無視 | E-02 (tag_names.map(&:downcase)) | ○ |
| C-20 | pluck_names | E-02 (def self.pluck_names) | ○ |

### IssuableEscalationStatus（UT-INC-021〜038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | issueとのbelongs_to関連 | E-03 (belongs_to :issue) | ○ |
| C-22 | projectとのthrough関連 | E-03 (has_one :project, through: :issue) | ○ |
| C-23 | issue presenceバリデーション | E-03 (validates :issue, presence: true) | ○ |
| C-24 | issue uniquenessバリデーション | E-03 (validates :issue, uniqueness: true) | ○ |
| C-25 | delegate :project | E-03 (delegate :project, to: :issue) | ○ |
| C-26 | Escalatableによるstatusバリデーション | E-06 (validates :status, presence: true) | ○ |
| C-27 | triggerイベント | E-06 (event :trigger) | ○ |
| C-28 | acknowledgeイベント | E-06 (event :acknowledge) | ○ |
| C-29 | resolveイベントとresolved_at設定 | E-06 (event :resolve, before_transition) | ○ |
| C-30 | resolve時の時刻指定 | E-06 (resolved_at = transition.args.first) | ○ |
| C-31 | ignoreイベント | E-06 (event :ignore) | ○ |
| C-32 | resolved状態でresolved_at必須 | E-06 (validates :resolved_at, presence: true) | ○ |
| C-33 | triggered等でresolved_at禁止 | E-06 (validates :resolved_at, absence: true) | ○ |
| C-34 | open?メソッド（triggered/acknowledged） | E-06 (def open?, OPEN_STATUSES) | ○ |
| C-35 | open?メソッド（resolved/ignored） | E-06 (def open?, OPEN_STATUSES) | ○ |
| C-36 | status_valueメソッド | E-06 (def status_value) | ○ |
| C-37 | status_nameメソッド | E-06 (def status_name) | ○ |
| C-38 | status_event_forメソッド | E-06 (def status_event_for) | ○ |

### TimelineEvent（UT-INC-039〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | projectとのbelongs_to関連 | E-04 (belongs_to :project) | ○ |
| C-40 | authorとのbelongs_to関連 | E-04 (belongs_to :author) | ○ |
| C-41 | incidentとのbelongs_to関連 | E-04 (belongs_to :incident) | ○ |
| C-42 | updated_by_userとのbelongs_to関連 | E-04 (belongs_to :updated_by_user) | ○ |
| C-43 | promoted_from_noteとのbelongs_to関連 | E-04 (belongs_to :promoted_from_note) | ○ |
| C-44 | timeline_event_tag_linksとのhas_many関連 | E-04 (has_many :timeline_event_tag_links) | ○ |
| C-45 | timeline_event_tagsとのthrough関連 | E-04 (has_many :timeline_event_tags, through:) | ○ |
| C-46 | project presenceバリデーション | E-04 (validates :project, presence: true) | ○ |
| C-47 | incident presenceバリデーション | E-04 (validates :incident, presence: true) | ○ |
| C-48 | occurred_at presenceバリデーション | E-04 (validates :occurred_at, presence: true) | ○ |
| C-49 | action presenceバリデーション | E-04 (validates :action, presence: true) | ○ |
| C-50 | action length最大128文字 | E-04 (length: { maximum: 128 }) | ○ |
| C-51 | note presence（user_inputコンテキスト） | E-04 (validates :note, on: :user_input) | ○ |
| C-52 | note length最大280文字（user_input） | E-04 (length: { maximum: 280 }, on: :user_input) | ○ |
| C-53 | note length最大10000文字 | E-04 (length: { maximum: 10_000 }) | ○ |
| C-54 | note_html length最大10000文字 | E-04 (validates :note_html, length: { maximum: 10_000 }) | ○ |
| C-55 | order_occurred_at_asc_id_ascスコープ | E-04 (scope :order_occurred_at_asc_id_asc) | ○ |
| C-56 | cache_markdown_field :note | E-04 (cache_markdown_field :note) | ○ |

### TimelineEventTagLink（UT-INC-057〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | timeline_event_tagとのbelongs_to関連 | E-05 (belongs_to :timeline_event_tag) | ○ |
| C-58 | timeline_eventとのbelongs_to関連 | E-05 (belongs_to :timeline_event) | ○ |

### TimelineEvents::CreateService（UT-INC-059〜071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | executeで正常作成 | E-08 (def execute, timeline_event.save) | ○ |
| C-60 | 権限チェック | E-07, E-08 (return error_no_permissions unless allowed?) | ○ |
| C-61 | タグ検証 | E-08 (validate_tags, non_existing_tags) | ○ |
| C-62 | auto_created時の権限スキップ | E-08 (return true if auto_created) | ○ |
| C-63 | user_inputコンテキスト | E-08 (validation_context, :user_input) | ○ |
| C-64 | create_incidentクラスメソッド | E-08 (def self.create_incident) | ○ |
| C-65 | reopen_incidentクラスメソッド | E-08 (def self.reopen_incident) | ○ |
| C-66 | resolve_incidentクラスメソッド | E-08 (def self.resolve_incident) | ○ |
| C-67 | change_incident_statusクラスメソッド | E-08 (def self.change_incident_status) | ○ |
| C-68 | change_severityクラスメソッド | E-08 (def self.change_severity) | ○ |
| C-69 | change_labelsクラスメソッド | E-08 (def self.change_labels) | ○ |
| C-70 | change_labelsでラベル変更なしエラー | E-08 (if added_labels.blank? && removed_labels.blank?) | ○ |
| C-71 | auto_create_predefined_tags | E-07 (def auto_create_predefined_tags) | ○ |

### TimelineEvents::UpdateService（UT-INC-072〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | executeで正常更新 | E-09 (def execute, timeline_event.save!) | ○ |
| C-73 | 権限チェック | E-09 (return error_no_permissions unless allowed?) | ○ |
| C-74 | occurred_at_and_note変更検出 | E-09 (def was_changed, :occurred_at_and_note) | ○ |
| C-75 | note変更検出 | E-09 (:note if note_changed) | ○ |
| C-76 | occurred_at変更検出 | E-09 (:occurred_at if occurred_at_changed) | ○ |
| C-77 | タグ更新 | E-09 (timeline_event.timeline_event_tags = new_tags) | ○ |
| C-78 | 存在しないタグエラー | E-09 (non_existing_tags = validate_tags) | ○ |

### TimelineEvents::DestroyService（UT-INC-079〜081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | executeで正常削除 | E-10 (timeline_event.destroy) | ○ |
| C-80 | 権限チェック | E-10 (return error_no_permissions unless allowed?) | ○ |
| C-81 | システムノート作成 | E-10 (SystemNoteService.delete_timeline_event) | ○ |

### TimelineEventTags::CreateService（UT-INC-082〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | executeで正常作成 | E-12 (timeline_event_tag.save) | ○ |
| C-83 | 権限チェック | E-11, E-12 (return error_no_permissions unless allowed?) | ○ |
| C-84 | 重複エラー | E-12 (error_in_save) | ○ |

### IssuableEscalationStatuses Services（UT-INC-085〜097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | CreateService正常作成 | E-13 (escalation_status.save) | ○ |
| C-86 | CreateServiceエラー | E-13 (ServiceResponse.error) | ○ |
| C-87 | BuildService既存取得 | E-14 (issue.escalation_status) | ○ |
| C-88 | BuildService新規ビルド | E-14 (issue.build_incident_management_issuable_escalation_status) | ○ |
| C-89 | PrepareUpdateService正常処理 | E-15 (def execute, filter_status) | ○ |
| C-90 | supports_escalation?チェック | E-15 (issuable.supports_escalation?) | ○ |
| C-91 | 権限チェック | E-15 (user_has_permissions?) | ○ |
| C-92 | 無効ステータスエラー | E-15 (add_param_error(:status)) | ○ |
| C-93 | サポート外パラメータ除外 | E-15 (params.slice!(*supported_params)) | ○ |
| C-94 | 冗長パラメータ除去 | E-15 (filter_redundant_params) | ○ |
| C-95 | AfterUpdateServiceシステムノート | E-16 (SystemNoteService.change_incident_status) | ○ |
| C-96 | AfterUpdateServiceタイムラインイベント | E-16 (TimelineEvents::CreateService.change_incident_status) | ○ |
| C-97 | 変更なし時の処理スキップ | E-16 (return unless escalation_status.status_previously_changed?) | ○ |

### Incidents::CreateService（UT-INC-098〜101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | 正常作成 | E-17 (Issues::CreateService.new) | ○ |
| C-99 | severity設定 | E-17 (severity: severity) | ○ |
| C-100 | alert関連付け | E-17 (alert_management_alerts: [alert].compact) | ○ |
| C-101 | alert無効時エラー | E-17 (return error unless alert.valid?) | ○ |

### LinkAlerts Services（UT-INC-102〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | CreateService正常リンク | E-19 (incident.alert_management_alerts << references) | ○ |
| C-103 | CreateService権限チェック | E-18, E-19 (return error_no_permissions unless allowed?) | ○ |
| C-104 | 空配列処理 | E-19 (if references.present?) | ○ |
| C-105 | DestroyService正常削除 | E-20 (incident.alert_management_alerts.delete(alert)) | ○ |
| C-106 | DestroyService権限チェック | E-20 (return error_no_permissions unless allowed?) | ○ |

### PagerDuty Services（UT-INC-107〜115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | ProcessWebhookService正常処理 | E-21 (def execute, accepted) | ○ |
| C-108 | webhook無効時Forbidden | E-21 (return forbidden unless webhook_setting_active?) | ○ |
| C-109 | トークン不正時Unauthorized | E-21 (return unauthorized unless valid_token?) | ○ |
| C-110 | サイズ超過時BadRequest | E-21 (return bad_request unless valid_payload_size?) | ○ |
| C-111 | Worker連携 | E-21 (ProcessIncidentWorker.perform_async) | ○ |
| C-112 | イベントタイプフィルタ | E-21 (PAGER_DUTY_PROCESSABLE_EVENT_TYPES) | ○ |
| C-113 | CreateIncidentIssueService正常作成 | E-22 (def execute, create_incident) | ○ |
| C-114 | webhook無効時Forbidden | E-22 (return forbidden unless webhook_available?) | ○ |
| C-115 | タイトル設定 | E-22 (incident_payload['title']) | ○ |

### Finders（UT-INC-116〜121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | TimelineEventsFinder正常取得 | E-23 (def execute, collection) | ○ |
| C-117 | TimelineEventsFinder権限チェック | E-23 (return unless allowed?) | ○ |
| C-118 | IDフィルタ | E-23 (def by_id, collection.id_in) | ○ |
| C-119 | ソート | E-23 (collection.order_occurred_at_asc_id_asc) | ○ |
| C-120 | TimelineEventTagsFinder正常取得 | E-24 (timeline_event.timeline_event_tags) | ○ |
| C-121 | TimelineEventTagsFinder権限チェック | E-24 (return unless allowed?) | ○ |

### Workers（UT-INC-122〜136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | AddSeveritySystemNoteWorker処理 | E-25 (incident.transaction, SystemNoteService) | ○ |
| C-123 | incident_id nilチェック | E-25 (return if incident_id.blank?) | ○ |
| C-124 | user_id nilチェック | E-25 (return if user_id.blank?) | ○ |
| C-125 | incident存在チェック | E-25 (return unless incident) | ○ |
| C-126 | CloseIncidentWorker処理 | E-26 (close_incident, add_system_note) | ○ |
| C-127 | incident存在チェック | E-26 (return unless incident) | ○ |
| C-128 | クローズ済みスキップ | E-26 (Issue.with_issue_type(:incident).opened) | ○ |
| C-129 | ProcessAlertWorkerV2処理 | E-27 (create_issue_for(alert)) | ○ |
| C-130 | alert_id nilチェック | E-27 (return unless alert_id) | ○ |
| C-131 | alert存在チェック | E-27 (return unless alert) | ○ |
| C-132 | 失敗時ログ | E-27 (log_warning(alert, result)) | ○ |
| C-133 | ProcessIncidentWorker処理 | E-28 (create_issue(project, incident_payload)) | ○ |
| C-134 | project_id nilチェック | E-28 (return unless project_id) | ○ |
| C-135 | project存在チェック | E-28 (return unless project) | ○ |
| C-136 | 失敗時ログ | E-28 (log_error(result)) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースにソースコードベースの根拠が存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [x] 全テストケースにソースコードの根拠が存在することを確認
- [ ] Escalatable concernの状態遷移テストが網羅的であることを確認
- [ ] PagerDuty連携のセキュリティ関連テスト（トークン検証等）を重点確認
- [ ] バリデーションテストが全ての制約を網羅していることを確認
- [ ] 権限チェックテストが全サービスクラスで定義されていることを確認
- [ ] Worker処理のエッジケース（nil値、存在しないレコード等）が網羅されていることを確認
