---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 152
  claims_with_evidence: 148
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：integrations 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：148 / 152、根拠なし：4
- 優先レビュー（高）
  1. **UT-INT-011**: find_issueの存在しない課題キーの挙動 - API応答の詳細仕様要確認
  2. **UT-INT-056**: Google Play APIエラーハンドリング - 具体的なエラーケース要確認
  3. **UT-INT-060**: Apple App Store APIエラーハンドリング - 具体的なエラーケース要確認
  4. **UT-INT-116**: Matrix API送信の成功条件 - レスポンス形式の詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/integrations/jira.rb` - Jira統合モデル（827行）
- E-02: `app/models/integrations/datadog.rb` - Datadog統合モデル（297行）
- E-03: `app/models/integrations/field.rb` - フィールド定義クラス（82行）
- E-04: `app/models/integrations/gitlab_slack_application.rb` - GitLab Slack Appモデル（187行）
- E-05: `app/models/integrations/buildkite.rb` - Buildkite統合モデル（153行）
- E-06: `app/models/integrations/jenkins.rb` - Jenkins統合モデル（92行）
- E-07: `app/models/integrations/google_play.rb` - Google Play統合モデル（126行）
- E-08: `app/models/integrations/apple_app_store.rb` - Apple App Store統合モデル（140行）
- E-09: `app/models/integrations/campfire.rb` - Campfire統合モデル（144行）
- E-10: `app/models/integrations/beyond_identity.rb` - Beyond Identity統合モデル（72行）
- E-11: `app/models/integrations/drone_ci.rb` - Drone CI統合モデル（139行）
- E-12: `app/models/integrations/chat_message/base_message.rb` - チャットメッセージ基底クラス（111行）
- E-13: `app/models/integrations/chat_message/push_message.rb` - プッシュメッセージクラス（120行）
- E-14: `app/models/integrations/chat_message/pipeline_message.rb` - パイプラインメッセージクラス（276行）
- E-15: `app/models/integrations/chat_message/merge_message.rb` - マージメッセージクラス（83行）
- E-16: `app/models/integrations/chat_message/issue_message.rb` - イシューメッセージクラス（84行）
- E-17: `app/models/integrations/chat_message/note_message.rb` - ノートメッセージクラス（86行）
- E-18: `app/models/integrations/chat_message/deployment_message.rb` - デプロイメントメッセージクラス（93行）
- E-19: `app/models/integrations/chat_message/alert_message.rb` - アラートメッセージクラス（76行）
- E-20: `app/models/integrations/slack_workspace/api_scope.rb` - Slack APIスコープモデル（28行）
- E-21: `app/models/integrations/slack_workspace/integration_api_scope.rb` - Slack統合スコープモデル（65行）
- E-22: `app/models/integrations/issue_tracker_data.rb` - Issue Trackerデータモデル（19行）
- E-23: `app/models/integrations/jira_tracker_data.rb` - Jira Trackerデータモデル（25行）
- E-24: `app/models/integrations/zentao.rb` - ZenTao統合モデル（101行）
- E-25: `app/models/integrations/zentao_tracker_data.rb` - ZenTao Trackerデータモデル（21行）
- E-26: `app/models/integrations/matrix.rb` - Matrix統合モデル（117行）
- E-27: `app/models/integrations/slack_slash_commands.rb` - Slack Slash Commandsモデル（55行）
- E-28: `app/models/integrations/packagist.rb` - Packagist統合モデル（75行）
- E-29: `app/models/integrations/jira_cloud_app.rb` - Jira Cloud Appモデル（161行）
- E-30: `app/models/integrations/squash_tm.rb` - Squash TM統合モデル（77行）
- E-31: `app/models/integrations/slack.rb` - Slack統合モデル（32行）
- E-32: `app/models/integrations/mattermost.rb` - Mattermost統合モデル（41行）
- E-33: `app/models/concerns/integrations/has_web_hook.rb` - HasWebHook concern（58行）
- E-34: `app/models/concerns/integrations/base_data_fields.rb` - BaseDataFields concern（78行）
- E-35: `app/models/concerns/integrations/push_data_validations.rb` - PushDataValidations concern（44行）
- E-36: `app/models/concerns/integrations/loggable.rb` - Loggable concern（37行）
- E-37: `app/models/concerns/integrations/enable_ssl_verification.rb` - EnableSslVerification concern（33行）
- E-38: `app/models/concerns/integrations/slack_mattermost_notifier.rb` - SlackMattermostNotifier concern（41行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Integrations::Jira（UT-INT-001〜UT-INT-020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | reference_patternがJira課題キーの正規表現を返却 | E-01 (195-197行: jira_issue_match_regex呼び出し) | ○ |
| C-02 | valid_jira_cloud_url?がJira CloudのURL判定を行う | E-01 (199-206行: URI解析とホスト名チェック) | ○ |
| C-03 | valid_jira_cloud_url?が無効なURLでfalse | E-01 (204-205行: rescue URI::InvalidURIError) | ○ |
| C-04 | valid_jira_cloud_url?が空のURLでfalse | E-01 (200行: return false unless url.present?) | ○ |
| C-05 | data_fieldsがJiraTrackerDataを返却 | E-01 (208-209行: jira_tracker_data || build_jira_tracker_data) | ○ |
| C-06 | optionsがBasic認証オプションを構築 | E-01 (232-238行: username/password設定) | ○ |
| C-07 | optionsがPAT認証オプションを構築 | E-01 (231-232行: Bearer token header) | ○ |
| C-08 | web_urlがJira WebURLを構築 | E-01 (313-329行: Addressable::URI使用) | ○ |
| C-09 | web_urlが空の場合空文字列を返却 | E-01 (314行: return '' unless url.present?) | ○ |
| C-10 | find_issueがJira課題を取得 | E-01 (356-367行: client.Issue.find) | ○ |
| C-11 | find_issueが存在しない課題でnilを返却 | E-01 (726-731行: jira_request rescue) | △ |
| C-12 | close_issueが課題をクローズ | E-01 (369-387行: transition_issue呼び出し) | ○ |
| C-13 | close_issueがクローズ済み課題をスキップ | E-01 (372行: has_resolution?チェック) | ○ |
| C-14 | create_cross_reference_noteがノートを作成 | E-01 (389-425行: add_comment呼び出し) | ○ |
| C-15 | testが接続テストを実行 | E-01 (435-441行: server_info && client_info) | ○ |
| C-16 | testが無効な設定でfalseを返却 | E-01 (438-440行: success判定) | ○ |
| C-17 | personal_access_token_authorization?がPAT判定 | E-01 (457-459行: jira_auth_type == AUTH_TYPE_PAT) | ○ |
| C-18 | issue_transition_enabled?が遷移有効判定 | E-01 (453-455行: automatic || id.present?) | ○ |
| C-19 | project_keys_as_stringがカンマ区切り文字列 | E-01 (465-467行: project_keys.join(',')) | ○ |
| C-20 | validate_jira_cloud_auth_type_is_basicがバリデーション | E-01 (805-814行: errors.add) | ○ |

### Integrations::Datadog（UT-INT-021〜UT-INT-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | hook_urlがDatadog Webhook URLを構築 | E-02 (209-220行: URL_TEMPLATE使用) | ○ |
| C-22 | hook_urlがカスタムAPI URLを使用 | E-02 (210行: api_url.presence) | ○ |
| C-23 | executeがサポートされたイベントで実行 | E-02 (226-233行: supported_events.include?) | ○ |
| C-24 | executeがサポートされないイベントを無視 | E-02 (227行: return unless supported_events.include?) | ○ |
| C-25 | testが接続テストを実行 | E-02 (235-242行: execute呼び出し) | ○ |
| C-26 | datadog_tags_are_validが有効タグ検証 | E-02 (267-273行: TAG_KEY_VALUE_RE) | ○ |
| C-27 | datadog_tags_are_validが無効タグでエラー | E-02 (271行: errors.add) | ○ |
| C-28 | logs_requires_ci_visがCI Visibility依存チェック | E-02 (291-295行: archive_trace_events && !datadog_ci_visibility) | ○ |
| C-29 | initialize_propertiesがデフォルト値初期化 | E-02 (150-161行: datadog_site ||= DEFAULT_DOMAIN) | ○ |
| C-30 | update_pipeline_eventsがCI Visibility設定で更新 | E-02 (167-173行: job_events/pipeline_events設定) | ○ |

### Integrations::Field（UT-INT-031〜UT-INT-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | initializeがフィールドを初期化 | E-03 (21-38行: コンストラクタ) | ○ |
| C-32 | initializeが無効な属性でエラー | E-03 (32-34行: ArgumentError) | ○ |
| C-33 | initializeが無効なタイプでエラー | E-03 (35-37行: TYPES.exclude?) | ○ |
| C-34 | secret?がパスワードタイプ判定 | E-03 (49-51行: type == :password) | ○ |
| C-35 | api_typeがチェックボックスでBoolean | E-03 (67-68行: ::API::Integrations::Boolean) | ○ |
| C-36 | api_typeが数値でInteger | E-03 (69-70行: Integer) | ○ |

### Integrations::GitlabSlackApplication（UT-INT-037〜UT-INT-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | editable?がアクティブ時のみtrue | E-04 (56-58行: activated?) | ○ |
| C-38 | editable?が非アクティブでfalse | E-04 (56-58行: activated?) | ○ |
| C-39 | upgrade_needed?がアップグレード判定 | E-04 (106-108行: slack_integration.upgrade_needed?) | ○ |
| C-40 | testが通知チャンネルテスト | E-04 (47-51行: test_notification_channels) | ○ |
| C-41 | after_build_from_integrationがslack_integration複製 | E-04 (85-99行: slack_integration.dup) | ○ |

### Integrations::Buildkite（UT-INT-042〜UT-INT-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | commit_statusがキャッシュから取得 | E-05 (76-77行: with_reactive_cache) | ○ |
| C-43 | build_pageがビルドページURL構築 | E-05 (83-85行: project_url + builds) | ○ |
| C-44 | calculate_reactive_cacheがステータス計算 | E-05 (103-114行: response['status']) | ○ |
| C-45 | calculate_reactive_cacheがエラー時error | E-05 (107-111行: :error) | ○ |
| C-46 | hook_urlがWebhook URL構築 | E-05 (61-63行: buildkite_endpoint) | ○ |
| C-47 | enable_ssl_verificationが常にtrue | E-05 (47-49行: return true) | ○ |

### Integrations::Jenkins（UT-INT-048〜UT-INT-052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | hook_urlがJenkins Webhook URL構築 | E-06 (57-63行: URI.parse + project_name) | ○ |
| C-49 | hook_urlが認証情報を含む | E-06 (60-61行: url.user/password) | ○ |
| C-50 | executeがサポートされたイベントで実行 | E-06 (39-43行: supported_events.include?) | ○ |
| C-51 | testがテスト実行成功 | E-06 (45-54行: execute呼び出し) | ○ |
| C-52 | testがエラー時false | E-06 (49-51行: rescue StandardError) | ○ |

### Integrations::GooglePlay（UT-INT-053〜UT-INT-056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | ci_variablesがCI変数を返却 | E-07 (98-106行: SUPPLY_JSON_KEY_DATA等) | ○ |
| C-54 | ci_variablesが保護参照フィルタ | E-07 (100行: google_play_protected_refs && !protected_ref) | ○ |
| C-55 | testがGoogle Play APIテスト | E-07 (91-96行: client.list_reviews) | ○ |
| C-56 | testがAPIエラー時false | E-07 (94-95行: Google::Apis::ClientError) | △ |

### Integrations::AppleAppStore（UT-INT-057〜UT-INT-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | ci_variablesがCI変数を返却 | E-08 (111-123行: 4つのCI変数) | ○ |
| C-58 | ci_variablesがBase64エンコード | E-08 (117行: Base64.encode64) | ○ |
| C-59 | testがApp Store APIテスト | E-08 (102-109行: client.apps) | ○ |
| C-60 | testがエラー時メッセージ | E-08 (104-105行: response[:errors]) | △ |

### Integrations::Campfire（UT-INT-061〜UT-INT-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | executeがpushイベント処理 | E-09 (72-77行: supported_events.include?) | ○ |
| C-62 | create_messageが新ブランチメッセージ | E-09 (133行: pushed new branch) | ○ |
| C-63 | create_messageがブランチ削除メッセージ | E-09 (135行: removed branch) | ○ |
| C-64 | create_messageが通常プッシュメッセージ | E-09 (137行: pushed N commits) | ○ |

### Integrations::BeyondIdentity（UT-INT-065〜UT-INT-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | executeがBeyond Identity API呼び出し | E-10 (68-70行: Client.new.execute) | ○ |
| C-66 | activated_for_instance?がインスタンス判定 | E-10 (60-62行: for_instance.first&.activated?) | ○ |

### Integrations::DroneCi（UT-INT-067〜UT-INT-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | executeがpushイベント処理 | E-11 (36-37行: push_valid?) | ○ |
| C-68 | executeがmerge_requestイベント処理 | E-11 (38-39行: merge_request_valid?) | ○ |
| C-69 | calculate_reactive_cacheがkilledをcanceledに変換 | E-11 (69-70行: :canceled) | ○ |
| C-70 | calculate_reactive_cacheがfailureをfailedに変換 | E-11 (71-73行: :failed) | ○ |
| C-71 | enable_ssl_verificationがSaaS URLでtrue | E-11 (121-124行: url_is_saas?) | ○ |

### Integrations::ChatMessage（UT-INT-072〜UT-INT-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | user_combined_nameが名前結合 | E-12 (24-30行: "#{user_full_name} (#{user_name})") | ○ |
| C-73 | user_combined_nameがフルネームなしでユーザー名のみ | E-12 (28行: else user_name) | ○ |
| C-74 | strip_markupがマークアップ除去 | E-12 (87-89行: SlackMarkdownSanitizer.sanitize) | ○ |
| C-75 | format_relative_linksが相対リンク変換 | E-12 (69-75行: RELATIVE_LINK_REGEX) | ○ |
| C-76 | PushMessage attachmentsが新ブランチで空配列 | E-13 (22行: return [] if new_branch?) | ○ |
| C-77 | PushMessage attachmentsが削除ブランチで空配列 | E-13 (22行: removed_branch?) | ○ |
| C-78 | PushMessage attachmentsが通常プッシュでコミット | E-13 (26行: commit_message_attachments) | ○ |
| C-79 | new_branch?がbefore空でtrue | E-13 (77-79行: Gitlab::Git.blank_ref?) | ○ |
| C-80 | removed_branch?がafter空でtrue | E-13 (81-83行: Gitlab::Git.blank_ref?) | ○ |
| C-81 | PipelineMessage attachment_colorが成功でgood | E-14 (94行: 'good') | ○ |
| C-82 | PipelineMessage attachment_colorが警告付き成功でwarning | E-14 (95行: 'warning') | ○ |
| C-83 | PipelineMessage attachment_colorが失敗でdanger | E-14 (97行: 'danger') | ○ |
| C-84 | humanized_statusが成功でhas passed | E-14 (184行: "has passed") | ○ |
| C-85 | humanized_statusが失敗でhas failed | E-14 (186行: "has failed") | ○ |
| C-86 | actually_failed_jobsがリトライ成功を除外 | E-14 (103-112行: succeeded_job_names.exclude?) | ○ |
| C-87 | MergeMessage state_or_action_textがapproved | E-15 (72行: 'approved') | ○ |
| C-88 | MergeMessage state_or_action_textがapproval変換 | E-15 (74-75行: 'added their approval to') | ○ |
| C-89 | IssueMessage issue_typeがincidentでIncident | E-16 (80-81行: 'Incident') | ○ |
| C-90 | IssueMessage issue_typeがissueでIssue | E-16 (80-81行: 'Issue') | ○ |
| C-91 | opened_issue?がopenでtrue | E-16 (54-56行: action == 'open') | ○ |
| C-92 | NoteMessage create_issue_noteがIssue情報生成 | E-17 (59-61行: issue[:iid], issue[:title]) | ○ |
| C-93 | NoteMessage create_commit_noteがCommit情報生成 | E-17 (63-66行: commit_sha, commit[:message]) | ○ |
| C-94 | DeploymentMessage attachment_colorが成功でgood | E-18 (43行: 'good') | ○ |
| C-95 | DeploymentMessage attachment_colorがキャンセルでwarning | E-18 (45行: 'warning') | ○ |
| C-96 | DeploymentMessage attachment_colorが失敗でdanger | E-18 (47行: 'danger') | ○ |
| C-97 | running?がrunningでtrue | E-18 (84-86行: status == 'running') | ○ |
| C-98 | AlertMessage format_timeが時刻フォーマット | E-19 (70-73行: strftime) | ○ |

### Integrations::SlackWorkspace（UT-INT-099〜UT-INT-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | ApiScope find_or_initialize_by_namesが既存取得 | E-20 (8-18行: where + upsert_all) | ○ |
| C-100 | ApiScope find_or_initialize_by_namesが新規作成 | E-20 (12-14行: missing_names + upsert_all) | ○ |
| C-101 | IntegrationApiScope update_scopesが一括更新 | E-21 (19-50行: transaction + upsert_all) | ○ |
| C-102 | ensure_sharding_keyがシャーディングキー設定 | E-21 (54-62行: project_id/group_id/organization_id) | ○ |

### Integrations::TrackerData（UT-INT-103〜UT-INT-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | IssueTrackerData to_database_hashが正しく生成 | E-34 (41-54行: as_json.except) | ○ |
| C-104 | IssueTrackerData validates project_urlが2048文字許可 | E-22 (15行: length: { maximum: 2048 }) | ○ |
| C-105 | IssueTrackerData validates project_urlが2048超でエラー | E-22 (15行: length: { maximum: 2048 }) | ○ |
| C-106 | JiraTrackerData deployment_type enumが正しく設定 | E-23 (21行: enum :deployment_type) | ○ |
| C-107 | JiraTrackerData deployment_type unknownがデフォルト | E-23 (21行: unknown: 0) | ○ |
| C-108 | ZentaoTrackerData validates urlが2048文字許可 | E-25 (16行: length: { maximum: 2048 }) | ○ |
| C-109 | ZentaoTrackerData validates zentao_product_xidが255文字許可 | E-25 (18行: length: { maximum: 255 }) | ○ |

### Integrations::Zentao（UT-INT-110〜UT-INT-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | data_fieldsがZentaoTrackerData返却 | E-24 (46-48行: zentao_tracker_data || build) | ○ |
| C-111 | client_urlがapi_url優先 | E-24 (77-79行: api_url.presence || url) | ○ |
| C-112 | client_urlがapi_urlなしでurl使用 | E-24 (77-79行: api_url.presence || url) | ○ |
| C-113 | testがZenTao APIテスト | E-24 (85-87行: client.ping) | ○ |

### Integrations::Matrix（UT-INT-114〜UT-INT-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | set_webhookがWebhook URL構築 | E-26 (84-90行: MATRIX_HOSTNAME format) | ○ |
| C-115 | set_webhookがデフォルトホスト名使用 | E-26 (85行: matrix-client.matrix.org) | ○ |
| C-116 | notifyがMatrix APIにメッセージ送信 | E-26 (92-111行: Clients::HTTP.put) | △ |

### その他の統合（UT-INT-117〜UT-INT-152）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | SlackSlashCommands triggerがSlack形式フォーマット | E-27 (30-35行: format(result[:text])) | ○ |
| C-118 | SlackSlashCommands redirect_urlがSlack URL構築 | E-27 (37-39行: SLACK_REDIRECT_URL format) | ○ |
| C-119 | Packagist hook_urlがWebhook URL構築 | E-28 (66-69行: base_url + api/update-package) | ○ |
| C-120 | Packagist hook_urlがカスタムサーバー使用 | E-28 (67行: server.presence) | ○ |
| C-121 | Packagist testがテスト実行成功 | E-28 (54-63行: execute呼び出し) | ○ |
| C-122 | Packagist testが202以外で失敗 | E-28 (57行: http_status != 202) | ○ |
| C-123 | JiraCloudApp validate_service_ids_limitが100超エラー | E-29 (114-125行: SERVICE_IDS_LIMIT) | ○ |
| C-124 | JiraCloudApp validate_deployment_gating_environmentsが無効環境エラー | E-29 (134-148行: AVAILABLE_ENVRIONMENT_NAMES) | ○ |
| C-125 | JiraCloudApp validate_valid_deployment_gating_inputが依存バリデーション | E-29 (150-159行: enable && !environments) | ○ |
| C-126 | JiraCloudApp format_deployment_gating_environmentsが正規化 | E-29 (127-132行: split.map.strip.uniq.join) | ○ |
| C-127 | SquashTm hook_urlがWebhook URL構築 | E-30 (69-71行: url + ?token) | ○ |
| C-128 | SquashTm hook_urlがトークンなしでクエリなし | E-30 (70行: unless token.blank?) | ○ |
| C-129 | SquashTm executeがissueイベント処理 | E-30 (54-57行: supported_events.include?) | ○ |
| C-130 | SquashTm executeがconfidential_issueイベント処理 | E-30 (42-44行: %w[issue confidential_issue]) | ○ |
| C-131 | HasWebHook update_web_hook!がWebhook作成/更新 | E-33 (32-50行: hook.save!) | ○ |
| C-132 | HasWebHook update_web_hook!がシャーディングキー設定 | E-33 (44-46行: project_id/group_id/organization_id) | ○ |
| C-133 | hook_ssl_verificationがenable_ssl_verification使用 | E-33 (23-29行: respond_to?チェック) | ○ |
| C-134 | hook_ssl_verificationがメソッドなしでtrue | E-33 (27行: else true) | ○ |
| C-135 | BaseDataFields activated?が統合アクティブでtrue | E-34 (37-39行: integration&.activated?) | ○ |
| C-136 | BaseDataFields activated?が統合nilでfalse | E-34 (38行: !!integration&.activated?) | ○ |
| C-137 | BaseDataFields to_database_hashがID除外 | E-34 (46-47行: except id) | ○ |
| C-138 | BaseDataFields set_sharding_keyが統合からキー設定 | E-34 (58-64行: integration.project_id等) | ○ |
| C-139 | PushDataValidations push_valid?が有効プッシュでtrue | E-35 (14-18行: 複合条件) | ○ |
| C-140 | PushDataValidations push_valid?がコミットなしでfalse | E-35 (15行: total_commits_count > 0) | ○ |
| C-141 | PushDataValidations push_valid?がブランチ削除でfalse | E-35 (16行: !branch_removed?) | ○ |
| C-142 | PushDataValidations merge_request_valid?がopenedでtrue | E-35 (10-12行: state == 'opened') | ○ |
| C-143 | PushDataValidations tag_push_valid?が有効でtrue | E-35 (21-23行: total_commits_count > 0) | ○ |
| C-144 | Loggable log_infoが情報ログ出力 | E-36 (5-8行: logger.info) | ○ |
| C-145 | Loggable log_errorがエラーログ出力 | E-36 (10-13行: logger.error) | ○ |
| C-146 | Loggable build_messageがログメッセージ構築 | E-36 (23-31行: integration情報含むハッシュ) | ○ |
| C-147 | EnableSslVerification initialize_propertiesが新規でtrue | E-37 (16-19行: enable_ssl_verification = true) | ○ |
| C-148 | EnableSslVerification fieldsがSSL検証フィールド配置 | E-37 (22-31行: insert_index) | ○ |
| C-149 | SlackMattermostNotifier notifyがSlackメッセンジャー通知 | E-38 (7-32行: Slack::Messenger.new.ping) | ○ |
| C-150 | Slack webhook_helpがSlack URLヘルプ | E-31 (21-23行: hooks.slack.com) | ○ |
| C-151 | Mattermost default_channel_placeholderがmy-channel | E-32 (28-30行: 'my-channel') | ○ |
| C-152 | Mattermost configurable_channels?がtrue | E-32 (37-39行: true) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-INT-011 (C-11)**: Jira APIの具体的なエラー応答形式の詳細仕様
  - 候補：Jira REST APIドキュメント / 実際のAPIエラー応答サンプル
- **UT-INT-056 (C-56)**: Google Play APIのClientError以外のエラーケース
  - 候補：Google Play Developer APIドキュメント / エラーコード一覧
- **UT-INT-060 (C-60)**: App Store Connect APIのエラー応答形式の詳細
  - 候補：Apple App Store Connect APIドキュメント
- **UT-INT-116 (C-116)**: Matrix APIの成功応答条件とエラーハンドリングの詳細
  - 候補：Matrix Client-Server APIドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ほとんどのテストケースはソースコードから直接導出可能
- **1: 中リスク** - 外部API連携（Jira, Datadog, Google Play, Apple App Store, Matrix）のエラーハンドリングは外部仕様への依存あり
- **0: 低リスク** - ChatMessage系のフォーマット処理は内部ロジックで完結

## 6) レビュアーチェックリスト（最小）
- [ ] 外部API連携テストケース（UT-INT-010〜016, 055-060, 113, 116）の期待結果が実際のAPI仕様と一致するか確認
- [ ] バリデーションテストケースの境界値（2048文字、255文字、100個）がコード上の定数と一致するか確認
- [ ] 認証関連テストケース（UT-INT-006〜007, 017, 020）がセキュリティ要件を満たしているか確認
- [ ] ステータス変換テストケース（UT-INT-069-070, 081-085, 094-097）の変換ルールが要件と一致するか確認
- [ ] シャーディングキー関連テストケース（UT-INT-102, 132, 138）がマルチテナント要件を満たしているか確認
