---
generated_at: 2026-01-22 15:15:00
metrics:
  claims_total: 37
  claims_with_evidence: 37
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：issue.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：37 / 37、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/issue/email.rb` - Issue::Emailモデル定義
- E-02: `app/models/issue/metrics.rb` - Issue::Metricsモデル定義
- E-03: `spec/models/issue/email_spec.rb` - Issue::Emailの既存テストスペック
- E-04: `spec/models/issue/metrics_spec.rb` - Issue::Metricsの既存テストスペック

## 3) Claims と根拠の対応（レビューの主戦場）

### Issue::Email クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | issueリレーションが正しく取得できること | E-01 (L6: `belongs_to :issue`), E-03 (L7) | ○ |
| C-02 | 関連issueが存在しない場合の挙動 | E-01 (L6: `belongs_to :issue`) | ○ |
| C-03 | 有効なemail_message_idでバリデーション通過 | E-01 (L8: `validates :email_message_id, uniqueness: true, presence: true, length: { maximum: 1000 }`) | ○ |
| C-04 | email_message_idがnilの場合バリデーション失敗 | E-01 (L8: `presence: true`), E-03 (L17) | ○ |
| C-05 | email_message_idが空文字の場合バリデーション失敗 | E-01 (L8: `presence: true`) | ○ |
| C-06 | email_message_idが重複している場合バリデーション失敗 | E-01 (L8: `uniqueness: true`), E-03 (L15) | ○ |
| C-07 | email_message_idが1000文字の場合バリデーション通過 | E-01 (L8: `length: { maximum: 1000 }`), E-03 (L16) | ○ |
| C-08 | email_message_idが1001文字の場合バリデーション失敗 | E-01 (L8: `length: { maximum: 1000 }`) | ○ |
| C-09 | 有効なissueでバリデーション通過 | E-01 (L9: `validates :issue, presence: true, uniqueness: true`), E-03 (L13) | ○ |
| C-10 | issueがnilの場合バリデーション失敗 | E-01 (L9: `presence: true`), E-03 (L13) | ○ |
| C-11 | issueが重複している場合バリデーション失敗 | E-01 (L9: `uniqueness: true`), E-03 (L14) | ○ |
| C-12 | issue_idが存在する場合WorkItemが返却されること | E-01 (L11-15: `#work_item`メソッド), E-03 (L28-35) | ○ |
| C-13 | issue work itemタイプの場合WorkItemが返却されること | E-01 (L11-15), E-03 (L28-35) | ○ |
| C-14 | ticket work itemタイプの場合WorkItemが返却されること | E-01 (L11-15), E-03 (L37-44) | ○ |
| C-15 | issue_idがnilの場合nilが返却されること | E-01 (L12: `return unless issue_id.present?`), E-03 (L24-25) | ○ |
| C-16 | issue_idが存在しないIDの場合例外発生 | E-01 (L14: `::WorkItem.find(issue_id)`) | ○ |

### Issue::Metrics クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | issueリレーションが正しく取得できること | E-02 (L7: `belongs_to :issue`) | ○ |
| C-18 | 関連issueが存在しない場合の挙動 | E-02 (L7: `belongs_to :issue`) | ○ |
| C-19 | 指定したissuesに関連するmetricsが返却されること | E-02 (L9: `scope :for_issues`), E-04 (L10-20) | ○ |
| C-20 | 空の配列を渡した場合空の結果が返却されること | E-02 (L9: `scope :for_issues`) | ○ |
| C-21 | 指定していないissueのmetricsは含まれないこと | E-02 (L9), E-04 (L16-19) | ○ |
| C-22 | first_mentioned_in_commit_atがnilのmetricsが返却されること | E-02 (L10-13: `scope :with_first_mention_not_earlier_than`), E-04 (L28-34) | ○ |
| C-23 | first_mentioned_in_commit_atがtimestamp以降のmetricsが返却されること | E-02 (L12: `gteq(timestamp)`), E-04 (L30) | ○ |
| C-24 | first_mentioned_in_commit_atがtimestamp以前のmetricsは除外されること | E-02 (L10-13), E-04 (L31) | ○ |
| C-25 | first_mentioned_in_commit_atがtimestampと同一の場合返却されること | E-02 (L12: `gteq` - greater than or equal) | ○ |
| C-26 | 新規issueに対してmetricsが作成されること | E-02 (L16-33: `.record!`メソッド), E-04 (L39-57) | ○ |
| C-27 | milestoneが設定されている場合first_associated_with_milestone_atが記録されること | E-02 (L18), E-04 (L39-46) | ○ |
| C-28 | milestoneが未設定の場合first_associated_with_milestone_atがnullであること | E-02 (L18: `issue.milestone_id.present? ? now : 'NULL'`) | ○ |
| C-29 | ボードラベルが設定されている場合first_added_to_board_atが記録されること | E-02 (L19, L37-39), E-04 (L61-69) | ○ |
| C-30 | ボードラベルが未設定の場合first_added_to_board_atがnullであること | E-02 (L19: `issue_assigned_to_list_label?(issue) ? now : 'NULL'`) | ○ |
| C-31 | 既存metricsがある場合ON CONFLICT DOでupdateされること | E-02 (L24-28: `ON CONFLICT (issue_id) DO UPDATE SET`), E-04 (L48-57) | ○ |
| C-32 | 既存のfirst_associated_with_milestone_atより新しい値では更新されないこと | E-02 (L26: `LEAST(...first_associated_with_milestone_at, EXCLUDED...)`), E-04 (L48-57) | ○ |
| C-33 | 既存のfirst_added_to_board_atより新しい値では更新されないこと | E-02 (L27: `LEAST(...first_added_to_board_at, EXCLUDED...)`), E-04 (L71-81) | ○ |
| C-34 | created_atとupdated_atが正しく設定されること | E-02 (L23: `created_at, updated_at`, L28: `updated_at = NOW()`) | ○ |
| C-35 | issueがlistラベルを持つ場合trueが返却されること | E-02 (L37-39: `issue.labels.joins(:lists).exists?`), E-04 (L61-69) | ○ |
| C-36 | issueがlistラベルを持たない場合falseが返却されること | E-02 (L37-39) | ○ |
| C-37 | issueにラベルがない場合falseが返却されること | E-02 (L37-39) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードおよび既存テストスペックに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに明確な根拠があり、既存テストスペックとも整合性が取れています。

**注意点:**
- UT-ISS-016: `WorkItem.find`は存在しないIDの場合`ActiveRecord::RecordNotFound`例外を発生させます。これが意図された動作か確認が必要です。
- Issue::Metricsの`.record!`メソッドは生SQLを使用しているため、SQLインジェクションのリスク評価を別途実施することを推奨します（ただし、現在のコードは`issue.id`と`connection.quote`を使用しており、適切に保護されています）。

## 6) レビュアーチェックリスト（最小）
- [ ] Issue::Emailの`#work_item`メソッドで`find`を使用しているが、存在しないIDの場合の例外処理が適切か確認
- [ ] Issue::Metricsの`.record!`メソッドのSQLが期待通りの動作をするか確認
- [ ] バリデーションの境界値テスト（1000文字/1001文字）が正しく設定されているか確認
- [ ] `with_first_mention_not_earlier_than`スコープの境界条件（gteq）が正しいか確認
