---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 143
  claims_with_evidence: 143
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：issues 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：143 / 143、根拠なし：0
- 優先レビュー（高）
  1. **Issues::ConfidentialityFilter - 機密性フィルタ**：複雑なクエリロジック
  2. **Issues::RelativePositionRebalancingService - リバランス処理**：同時実行制御とリトライロジック
  3. **Issues::SetCrmContactsService - CRM連携**：複数の操作モード（追加/削除/置換）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/issues/csv_import.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/issues/search_data.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/issues/confidentiality_filter.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/issues/issue_types_filter.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/lib/gitlab/issues/rebalancing/state.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/base_service.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/create_service.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/update_service.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/close_service.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/reopen_service.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/destroy_service.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/duplicate_service.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/reorder_service.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/zoom_link_service.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/build_service.rb`
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/export_csv_service.rb`
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/import_csv_service.rb`
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/relative_position_rebalancing_service.rb`
- E-19: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/set_crm_contacts_service.rb`
- E-20: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/after_create_service.rb`
- E-21: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/related_branches_service.rb`
- E-22: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/referenced_merge_requests_service.rb`
- E-23: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/prepare_import_csv_service.rb`
- E-24: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/issues/convert_to_ticket_service.rb`
- E-25: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/issues/close_worker.rb`
- E-26: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/issues/rebalancing_worker.rb`
- E-27: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/issues/placement_worker.rb`
- E-28: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/issues/reschedule_stuck_issue_rebalances_worker.rb`
- E-29: `/Users/tomoka.baba/Work/gitlabhq-master/app/graphql/mutations/issues/base.rb`
- E-30: `/Users/tomoka.baba/Work/gitlabhq-master/app/graphql/resolvers/issues/base_resolver.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Issues::CsvImport - project/userリレーション | E-01 | ○ |
| C-02 | Issues::SearchData - issueリレーション | E-02 | ○ |
| C-03 | ConfidentialityFilter - 機密フィルタ処理 | E-03 | ○ |
| C-04 | ConfidentialityFilter - 権限チェック | E-03 | ○ |
| C-05 | IssueTypesFilter - タイプフィルタ | E-04 | ○ |
| C-06 | Rebalancing::State - 初期化処理 | E-05 | ○ |
| C-07 | Rebalancing::State - Redis操作 | E-05 | ○ |
| C-08 | Rebalancing::State - 同時実行管理 | E-05 | ○ |
| C-09 | BaseService - フック実行 | E-06 | ○ |
| C-10 | BaseService - リバランストリガー | E-06 | ○ |
| C-11 | CreateService - Issue作成 | E-07 | ○ |
| C-12 | CreateService - スパムチェック | E-07 | ○ |
| C-13 | CreateService - ディスカッション解決 | E-07 | ○ |
| C-14 | UpdateService - Issue更新 | E-08 | ○ |
| C-15 | UpdateService - 機密変更処理 | E-08 | ○ |
| C-16 | UpdateService - 移動/クローン | E-08 | ○ |
| C-17 | CloseService - Issueクローズ | E-09 | ○ |
| C-18 | CloseService - アラート/インシデント解決 | E-09 | ○ |
| C-19 | ReopenService - Issue再オープン | E-10 | ○ |
| C-20 | DestroyService - Issue削除 | E-11 | ○ |
| C-21 | DuplicateService - 重複処理 | E-12 | ○ |
| C-22 | ReorderService - 順序変更 | E-13 | ○ |
| C-23 | ZoomLinkService - Zoom連携 | E-14 | ○ |
| C-24 | BuildService - Issueビルド | E-15 | ○ |
| C-25 | ExportCsvService - CSV出力 | E-16 | ○ |
| C-26 | ImportCsvService - CSVインポート | E-17 | ○ |
| C-27 | RelativePositionRebalancingService - リバランス実行 | E-18 | ○ |
| C-28 | SetCrmContactsService - CRM連携 | E-19 | ○ |
| C-29 | AfterCreateService - 作成後処理 | E-20 | ○ |
| C-30 | RelatedBranchesService - 関連ブランチ | E-21 | ○ |
| C-31 | ReferencedMergeRequestsService - MR参照 | E-22 | ○ |
| C-32 | PrepareImportCsvService - インポート準備 | E-23 | ○ |
| C-33 | ConvertToTicketService - チケット変換 | E-24 | ○ |
| C-34 | CloseWorker - 非同期クローズ | E-25 | ○ |
| C-35 | RebalancingWorker - 非同期リバランス | E-26 | ○ |
| C-36 | PlacementWorker - 配置処理 | E-27 | ○ |
| C-37 | RescheduleStuckIssueRebalancesWorker - 再スケジュール | E-28 | ○ |
| C-38 | Mutations::Issues::Base - GraphQL変更 | E-29 | ○ |
| C-39 | Resolvers::Issues::BaseResolver - GraphQLリゾルバ | E-30 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目は存在しません
- 全てのテストケースはソースコード解析に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: モデルリレーション、基本的なCRUD操作
- **1 (中リスク)**: GraphQL関連、CSVエクスポート/インポート
- **2 (高リスク)**:
  - 機密性フィルタ（セキュリティに直結）
  - リバランス処理（同時実行制御、データ整合性）
  - CRM連携（外部データ連携）

## 6) レビュアーチェックリスト（最小）
- [ ] Issues::ConfidentialityFilterの機密性チェックが正しく実装されているか
- [ ] Rebalancing処理の同時実行制限（MAX_NUMBER_OF_CONCURRENT_REBALANCES=5）が適切か
- [ ] SetCrmContactsServiceのMAX_ADDITIONAL_CONTACTS=6の制限が要件を満たしているか
- [ ] CloseWorkerのリトライ設定（retry: 3）が適切か
- [ ] ExternalIssue対応のテストケースが十分か
- [ ] 権限チェック（update_issue, reopen_issue等）のテストケースが網羅されているか
