---
generated_at: 2026-01-22 15:25:00
metrics:
  claims_total: 80
  claims_with_evidence: 80
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jira_connect 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：80 / 80、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/jira_connect/public_key.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/jira_connect/create_asymmetric_jwt_service.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/jira_connect/sync_service.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/send_uninstalled_hook_worker.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/sync_builds_worker.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/jira_cloud_app_deactivation_worker.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/sync_deployments_worker.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/sync_merge_request_worker.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/retry_request_worker.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/sync_feature_flags_worker.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/sync_project_worker.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/forward_event_worker.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/jira_connect/sync_branch_worker.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/workers/integrations/jira_connect/remove_branch_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### JiraConnect::PublicKey（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | create!メソッドで公開鍵が作成・保存される | E-01 L13-14 | ○ |
| C-02 | UUIDがGitlab::UUID.v5で生成される | E-01 L14 | ○ |
| C-03 | findメソッドでRedisから公開鍵を取得 | E-01 L16-25 | ○ |
| C-04 | 存在しないUUIDでRecordNotFoundがスロー | E-01 L21 | ○ |
| C-05 | 文字列形式の鍵がOpenSSL::PKey.readでパース | E-01 L28 | ○ |
| C-06 | RSAオブジェクトがそのまま使用可能 | E-01 L28 | ○ |
| C-07 | 無効な鍵でArgumentErrorがスロー | E-01 L32-33 | ○ |
| C-08 | save!でRedisに5分間のTTLで保存 | E-01 L36-39 | ○ |
| C-09 | save!がselfを返却 | E-01 L41 | ○ |
| C-10 | redis_keyが正しい形式を返却 | E-01 L44-46 | ○ |
| C-11 | REDIS_EXPIRY_TIMEが5分（300秒） | E-01 L9 | ○ |

### JiraConnect::CreateAsymmetricJwtService（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | プロキシインストールのみ初期化可能 | E-02 L8 | ○ |
| C-13 | 非プロキシでArgumentErrorがスロー | E-02 L8 | ○ |
| C-14 | eventデフォルトが:installed | E-02 L7 | ○ |
| C-15 | executeでRS256署名JWT生成 | E-02 L15 | ○ |
| C-16 | JWTにaud/iss/qshクレーム含む | E-02 L20-21 | ○ |
| C-17 | JWTヘッダーにkid含む | E-02 L54-56 | ○ |
| C-18 | audクレームがaudience_url | E-02 L24-26 | ○ |
| C-19 | issクレームがclient_key | E-02 L28-30 | ○ |
| C-20 | installedイベントでinstalled_event_url | E-02 L43 | ○ |
| C-21 | uninstalledイベントでuninstalled_event_url | E-02 L41 | ○ |
| C-22 | 3072ビットRSA鍵生成 | E-02 L47 | ○ |
| C-23 | 公開鍵がPublicKeyとして保存 | E-02 L50-52 | ○ |

### JiraConnect::SyncService（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | プロジェクトで初期化 | E-03 L6-7 | ○ |
| C-25 | Jira APIに情報送信 | E-03 L14-17 | ○ |
| C-26 | 複数インストールに同期 | E-03 L14 | ○ |
| C-27 | reviewersがプリロード | E-03 L12, L49-52 | ○ |
| C-28 | インストールなしで空配列 | E-03 L14 | ○ |
| C-29 | 成功レスポンスをinfoログ | E-03 L42 | ○ |
| C-30 | エラーレスポンスをerrorログ | E-03 L39 | ○ |
| C-31 | errorMessages含むレスポンスをerrorログ | E-03 L36 | ○ |
| C-32 | 関連がプリロード | E-03 L49-52 | ○ |

### JiraConnect::SendUninstalledHookWorker（E-04）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | アンインストールイベント送信 | E-04 L19 | ○ |
| C-34 | インストールなしでも処理 | E-04 L17 | ○ |

### JiraConnect::SyncBuildsWorker（E-05）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | パイプライン情報同期 | E-05 L20-22 | ○ |
| C-36 | パイプラインなしで早期リターン | E-05 L18 | ○ |

### JiraConnect::JiraCloudAppDeactivationWorker（E-06）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | 統合が非アクティブ化 | E-06 L23 | ○ |
| C-38 | 子孫統合も非アクティブ化 | E-06 L24-26 | ○ |
| C-39 | トランザクション内で処理 | E-06 L21 | ○ |
| C-40 | 統合なしで早期リターン | E-06 L19 | ○ |
| C-41 | inherit_from_idがnilに設定 | E-06 L22 | ○ |

### JiraConnect::SyncDeploymentsWorker（E-07）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | デプロイメント情報同期 | E-07 L20-22 | ○ |
| C-43 | デプロイメントなしで早期リターン | E-07 L18 | ○ |
| C-44 | sequence_id自動生成 | E-07 L25-27 | ○ |

### JiraConnect::SyncMergeRequestWorker（E-08）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | MR情報同期 | E-08 L23 | ○ |
| C-46 | オープンMRでブランチ情報付加 | E-08 L21 | ○ |
| C-47 | クローズMRでブランチなし | E-08 L21 | ○ |
| C-48 | MRなしで早期リターン | E-08 L19 | ○ |
| C-49 | プロジェクトnilで早期リターン | E-08 L19 | ○ |

### JiraConnect::RetryRequestWorker（E-09）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | HTTPリクエスト送信 | E-09 L15 | ○ |
| C-51 | Authorizationヘッダー設定 | E-09 L15 | ○ |
| C-52 | 400以上でリトライスケジュール | E-09 L17 | ○ |
| C-53 | HTTPエラーでリトライ | E-09 L18-19 | ○ |
| C-54 | attempts=0でリトライなし | E-09 L17, L19 | ○ |
| C-55 | 成功でリトライなし | E-09 L17 | ○ |

### JiraConnect::SyncFeatureFlagsWorker（E-10）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | フィーチャーフラグ同期 | E-10 L20-22 | ○ |
| C-57 | フィーチャーフラグなしで早期リターン | E-10 L18 | ○ |

### JiraConnect::SyncProjectWorker（E-11）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | プロジェクト情報同期 | E-11 L29 | ○ |
| C-59 | プロジェクトなしで早期リターン | E-11 L21 | ○ |
| C-60 | Jiraイシューキー持つMR取得 | E-11 L36 | ○ |
| C-61 | 最大400件MR取得 | E-11 L16, L38 | ○ |
| C-62 | id降順でMR取得 | E-11 L39 | ○ |
| C-63 | Jiraイシューキー含むブランチ取得 | E-11 L45 | ○ |
| C-64 | 最大400件ブランチ取得 | E-11 L16, L46 | ○ |
| C-65 | 更新日時降順でブランチ取得 | E-11 L44 | ○ |

### JiraConnect::ForwardEventWorker（E-12）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | イベント転送 | E-12 L26 | ○ |
| C-67 | インストール削除 | E-12 L18 | ○ |
| C-68 | QSH正しく生成 | E-12 L23 | ○ |
| C-69 | JWT正しく生成 | E-12 L24 | ○ |
| C-70 | instance_url nilで早期リターン | E-12 L20 | ○ |
| C-71 | インストールなしでも処理 | E-12 L15-18 | ○ |

### JiraConnect::SyncBranchWorker（E-13）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | ブランチとコミット同期 | E-13 L25 | ○ |
| C-73 | プロジェクトなしで早期リターン | E-13 L20 | ○ |
| C-74 | branch_name空でブランチなし同期 | E-13 L22 | ○ |
| C-75 | commit_shas空でコミットなし同期 | E-13 L23 | ○ |
| C-76 | 指定SHAでコミット取得 | E-13 L23 | ○ |

### Integrations::JiraConnect::RemoveBranchWorker（E-14）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | ブランチ削除情報送信 | E-14 L25-27 | ○ |
| C-78 | プロジェクトなしで早期リターン | E-14 L20 | ○ |
| C-79 | paramsがsymbolize_keys! | E-14 L22 | ○ |
| C-80 | branch_nameがparamsから取得 | E-14 L23 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードから直接根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードと整合性あり

## 6) レビュアーチェックリスト（最小）
- [ ] PublicKeyのRedis TTL（5分）がビジネス要件と整合するか確認
- [ ] CreateAsymmetricJwtServiceの3072ビットRSA鍵長がセキュリティポリシーと整合するか確認
- [ ] RetryRequestWorkerの最大リトライ回数（3回）とリトライ間隔（1時間）が運用要件と整合するか確認
- [ ] SyncProjectWorkerのMAX_RECORDS_LIMIT（400件）がパフォーマンス要件と整合するか確認
- [ ] ForwardEventWorkerでのinstallation.destroyのタイミングが意図通りか確認（イベント転送前に削除される）
- [ ] JiraCloudAppDeactivationWorkerのBATCH_SIZE（1000件）がパフォーマンス要件と整合するか確認
