---
generated_at: 2026-01-22 15:15:00
metrics:
  claims_total: 101
  claims_with_evidence: 101
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：loose_foreign_keys.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：101 / 101、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースにソースコードまたは既存テストスペックの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/loose_foreign_keys/deleted_record.rb` - DeletedRecordモデル
- E-02: `app/models/loose_foreign_keys/modification_tracker.rb` - ModificationTrackerモデル
- E-03: `app/models/loose_foreign_keys/turbo_modification_tracker.rb` - TurboModificationTrackerモデル
- E-04: `app/services/loose_foreign_keys/cleaner_service.rb` - CleanerServiceサービス
- E-05: `app/services/loose_foreign_keys/partition_cleaner_service.rb` - PartitionCleanerServiceサービス
- E-06: `app/services/loose_foreign_keys/batch_cleaner_service.rb` - BatchCleanerServiceサービス
- E-07: `app/services/loose_foreign_keys/process_deleted_records_service.rb` - ProcessDeletedRecordsServiceサービス
- E-08: `app/workers/loose_foreign_keys/cleanup_worker.rb` - CleanupWorkerワーカー
- E-09: `app/workers/loose_foreign_keys/merge_request_diff_commit_cleanup_worker.rb` - MergeRequestDiffCommitCleanupWorkerワーカー
- E-10: `app/workers/loose_foreign_keys/ci_pipelines_builds_cleanup_cron_worker.rb` - CiPipelinesBuildsCleanupCronWorkerワーカー
- E-11: `spec/models/loose_foreign_keys/deleted_record_spec.rb` - DeletedRecordテストスペック
- E-12: `spec/models/loose_foreign_keys/modification_tracker_spec.rb` - ModificationTrackerテストスペック
- E-13: `spec/models/loose_foreign_keys/turbo_modification_tracker_spec.rb` - TurboModificationTrackerテストスペック
- E-14: `spec/services/loose_foreign_keys/cleaner_service_spec.rb` - CleanerServiceテストスペック
- E-15: `spec/services/loose_foreign_keys/partition_cleaner_service_spec.rb` - PartitionCleanerServiceテストスペック
- E-16: `spec/services/loose_foreign_keys/batch_cleaner_service_spec.rb` - BatchCleanerServiceテストスペック
- E-17: `spec/services/loose_foreign_keys/process_deleted_records_service_spec.rb` - ProcessDeletedRecordsServiceテストスペック
- E-18: `spec/workers/loose_foreign_keys/cleanup_worker_spec.rb` - CleanupWorkerテストスペック

## 3) Claims と根拠の対応（レビューの主戦場）

### DeletedRecordモデル（UT-LFK-001〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | load_batch_for_tableでバッチ取得できること | E-01, E-11 | ○ |
| C-02 | バッチサイズで取得件数が制限されること | E-01 (L41-60), E-11 (L23-27) | ○ |
| C-03 | パーティション番号が各レコードに含まれること | E-01 (L47), E-11 (L29-33) | ○ |
| C-04 | consume_order順でソートされること | E-01 (L37), E-11 (L19-21) | ○ |
| C-05 | 対象テーブルのレコードが存在しない場合空配列が返却 | E-01 (L41-60) | ○ |
| C-06 | mark_records_processedでステータス更新 | E-01 (L62-66), E-11 (L36-42) | ○ |
| C-07 | 更新件数が返却されること | E-01 (L82-94) | ○ |
| C-08 | rescheduleでconsume_afterとcleanup_attemptsが更新 | E-01 (L68-72), E-11 (L45-58) | ○ |
| C-09 | rescheduleで更新件数が返却されること | E-01 (L68-72), E-11 (L48) | ○ |
| C-10 | increment_attemptsでcleanup_attemptsがインクリメント | E-01 (L74-79), E-11 (L61-68) | ○ |
| C-11 | 複数レコードの各々がインクリメントされること | E-01 (L74-79), E-11 (L61-68) | ○ |
| C-12 | for_tableスコープ動作 | E-01 (L35) | ○ |
| C-13 | for_partitionスコープ動作 | E-01 (L36) | ○ |
| C-14 | status_pendingスコープ動作 | E-01 (L39) | ○ |
| C-15 | status_processedスコープ動作 | E-01 (L39) | ○ |
| C-16 | next_partition_if - パーティション空でfalse | E-01 (L17-27), E-11 (L85-87) | ○ |
| C-17 | next_partition_if - 古いレコードでtrue | E-01 (L17-27), E-11 (L98-109) | ○ |
| C-18 | next_partition_if - 新しいレコードでfalse | E-01 (L17-27), E-11 (L89-96) | ○ |
| C-19 | detach_partition_if - 未処理ありでfalse | E-01 (L28-33), E-11 (L121-128) | ○ |
| C-20 | detach_partition_if - 全処理済みでtrue | E-01 (L28-33), E-11 (L130-138) | ○ |

### ModificationTrackerモデル（UT-LFK-021〜035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | 初期状態で各カウンタが0 | E-02 (L7-19) | ○ |
| C-22 | max_runtimeが30秒 | E-02 (L21-23) | ○ |
| C-23 | max_deletesが100000 | E-02 (L25-27) | ○ |
| C-24 | max_updatesが50000 | E-02 (L29-31) | ○ |
| C-25 | add_deletionsで削除カウント加算 | E-02 (L33-36), E-12 (L55-62) | ○ |
| C-26 | add_deletionsでPrometheusカウンター増加 | E-02 (L35), E-12 (L55-62) | ○ |
| C-27 | add_updatesで更新カウント加算 | E-02 (L38-41), E-12 (L65-72) | ○ |
| C-28 | add_updatesでPrometheusカウンター増加 | E-02 (L40), E-12 (L65-72) | ○ |
| C-29 | over_limit? - max_deletes超過でtrue | E-02 (L43-47), E-12 (L9-13) | ○ |
| C-30 | over_limit? - max_deletes未超過でfalse | E-02 (L43-47), E-12 (L15-19) | ○ |
| C-31 | over_limit? - max_updates超過でtrue | E-02 (L43-47), E-12 (L21-29) | ○ |
| C-32 | over_limit? - max_updates未超過でfalse | E-02 (L43-47), E-12 (L31-35) | ○ |
| C-33 | over_limit? - max_runtime超過でtrue | E-02 (L43-47), E-12 (L37-48) | ○ |
| C-34 | over_limit? - max_runtime未超過でfalse | E-02 (L43-47), E-12 (L50-52) | ○ |
| C-35 | statsで統計情報返却 | E-02 (L49-57), E-12 (L75-93) | ○ |

### TurboModificationTrackerモデル（UT-LFK-036〜039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | max_runtimeが45秒（親クラスより高い） | E-03 (L11-13), E-13 (L18-21) | ○ |
| C-37 | max_deletesが200000（親クラスより高い） | E-03 (L15-17), E-13 (L11-13) | ○ |
| C-38 | max_updatesが150000（親クラスより高い） | E-03 (L19-22), E-13 (L15-17) | ○ |
| C-39 | ModificationTrackerの全メソッドが利用可能 | E-03 (L7) - 継承宣言 | ○ |

### CleanerServiceサービス（UT-LFK-040〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | async_nullify時にNULL更新クエリ実行 | E-04 (L78-84), E-14 (L57-65) | ○ |
| C-41 | async_delete時にDELETEクエリ実行 | E-04 (L71-76), E-14 (L67-76) | ○ |
| C-42 | update_column_to時に指定カラム更新 | E-04 (L86-97), E-14 (L94-115) | ○ |
| C-43 | affected_rowsとtableが返却 | E-04 (L17-21) | ○ |
| C-44 | 無効なon_delete引数でエラーログ | E-04 (L46-48), E-14 (L33-44) | ○ |
| C-45 | 外部キー条件欠落でFATALエラーログ | E-04 (L51-54), E-14 (L161-170) | ○ |
| C-46 | 単一主キーでINクエリ生成 | E-04 (L99-104), E-14 (L47-65) | ○ |
| C-47 | 複合主キーでINクエリ生成 | E-04 (L99-104), E-14 (L118-159) | ○ |
| C-48 | with_skip_locked=trueでSKIP LOCKED句追加 | E-04 (L117), E-14 (L174-188) | ○ |
| C-49 | delete_limitオプションでLIMIT値変更 | E-04 (L75), E-14 (L78-92) | ○ |
| C-50 | conditionsオプションで追加条件付与 | E-04 (L112-114) | ○ |
| C-51 | async_delete?ヘルパーメソッド | E-04 (L23-25) | ○ |
| C-52 | async_nullify?ヘルパーメソッド | E-04 (L27-29) | ○ |
| C-53 | update_column_to?ヘルパーメソッド | E-04 (L31-33) | ○ |

### PartitionCleanerServiceサービス（UT-LFK-054〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | パーティションごとにクエリ実行 | E-05 (L25-38), E-15 (L58-68) | ○ |
| C-55 | 全パーティションの影響行数合計返却 | E-05 (L6-8) | ○ |
| C-56 | パーティション識別子がクエリに含まれる | E-05 (L13-15), E-15 (L61-65) | ○ |
| C-57 | with_skip_locked=trueでSKIP LOCKED句追加 | E-05継承, E-15 (L85-104) | ○ |

### BatchCleanerServiceサービス（UT-LFK-058〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | 子レコード削除（async_delete） | E-06, E-16 (L271-272) | ○ |
| C-59 | 子レコードNULL更新（async_nullify） | E-06, E-16 (L273) | ○ |
| C-60 | 子レコードカラム更新（update_column_to） | E-06, E-16 (L277-279) | ○ |
| C-61 | DeletedRecordがprocessedステータスに更新 | E-06 (L59-61), E-16 (L281-284) | ○ |
| C-62 | 処理件数がPrometheusカウンターに記録 | E-06 (L63), E-16 (L286-289) | ○ |
| C-63 | 関連のないレコードは削除されない | E-16 (L292-296) | ○ |
| C-64 | conditions付きで条件に合致するレコードのみ削除 | E-16 (L274, L295) | ○ |
| C-65 | パーティションテーブルの子レコード削除 | E-06 (L125-134), E-16 (L303-366) | ○ |
| C-66 | over_limit時にcleanup_attemptsがインクリメント | E-06 (L89-107), E-16 (L392-400) | ○ |
| C-67 | cleanup_attempts >= 3でリスケジュール | E-06 (L5-6, L89-107), E-16 (L402-415) | ○ |
| C-68 | リスケジュール時にPrometheusカウンター記録 | E-06 (L103) | ○ |
| C-69 | インクリメント時にPrometheusカウンター記録 | E-06 (L106) | ○ |
| C-70 | SKIP LOCKEDありとなしで2回実行 | E-06 (L38, L45) | ○ |
| C-71 | 無効なon_delete引数でエラーログ | E-16 (L461-479) | ○ |
| C-72 | 辞書エントリからfeature_category取得 | E-06 (L70-76), E-16 (L149-157) | ○ |
| C-73 | 辞書に存在しない場合:database返却 | E-06 (L75), E-16 (L174-180) | ○ |
| C-74 | フラグ有効時にエラーがfeature_category付きでトラッキング | E-06 (L82-87), E-16 (L216-228) | ○ |
| C-75 | フラグ無効時にエラートラッキングが呼ばれない | E-16 (L244-254) | ○ |

### ProcessDeletedRecordsServiceサービス（UT-LFK-076〜085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | 全テーブルのレコードがクリーンアップ | E-07 (L19-46), E-17 (L198-204) | ○ |
| C-77 | delete_countとupdate_count返却 | E-07 (L53), E-17 (L206-211) | ○ |
| C-78 | Apdexがsuccess=trueで記録 | E-07 (L48-51), E-17 (L213-218) | ○ |
| C-79 | エラーレートがerror=falseで記録 | E-07 (L58-61), E-17 (L220-225) | ○ |
| C-80 | 複数バッチで処理 | E-07 (L5), E-17 (L227-240) | ○ |
| C-81 | over_limit時にApdexがsuccess=false | E-17 (L260-265) | ○ |
| C-82 | エラー発生時にerror_rateがerror=true | E-07 (L54-61), E-17 (L275-281) | ○ |
| C-83 | エラー発生時に例外が再スロー | E-07 (L54-56), E-17 (L280) | ○ |
| C-84 | worker_classに対応するテーブルのみ返却 | E-07 (L83-88), E-17 (L149-159) | ○ |
| C-85 | 対応するテーブルがない場合空配列返却 | E-17 (L177-188) | ○ |

### CleanupWorkerワーカー（UT-LFK-086〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | 削除レコードがクリーンアップ | E-08 (L14-34), E-18 (L126-132) | ○ |
| C-87 | 排他ロック取得 | E-08 (L22) | ○ |
| C-88 | 統計情報がメタデータとして記録 | E-08 (L32) | ○ |
| C-89 | 分単位でDB切り替え（Main選択） | E-08 (L42-46), E-18 (L134-176) | ○ |
| C-90 | 分単位でDB切り替え（CI選択） | E-08 (L42-46), E-18 (L134-176) | ○ |
| C-91 | turbo_mode?フラグ有効でtrue | E-08 (L54-57), E-18 (L211-218) | ○ |
| C-92 | turbo_mode?フラグ無効でfalse | E-08 (L54-57), E-18 (L180-208) | ○ |
| C-93 | turboモード有効時にTurboModificationTracker使用 | E-08 (L50), E-18 (L224-229) | ○ |
| C-94 | turboモード無効時にModificationTracker使用 | E-08 (L50), E-18 (L193-199) | ○ |
| C-95 | turbo_modeがstatsに含まれる | E-08 (L30), E-18 (L201-207, L231-237) | ○ |

### MergeRequestDiffCommitCleanupWorkerワーカー（UT-LFK-096〜098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | vacuum実行中の場合早期リターン | E-09 (L15-18) | ○ |
| C-97 | vacuum未実行時に処理実行 | E-09 (L20-33) | ○ |
| C-98 | ApplicationRecord接続使用 | E-09 (L26) | ○ |

### CiPipelinesBuildsCleanupCronWorkerワーカー（UT-LFK-099〜101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | Ci::ApplicationRecord接続使用 | E-10 (L23) | ○ |
| C-100 | turboモード有効時にTurboModificationTracker使用 | E-10 (L37-39) | ○ |
| C-101 | turbo_modeがstatsに含まれる | E-10 (L28) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースに対してソースコードまたは既存テストスペックからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコード解析に基づいており、既存のRSpecテストスペックとの整合性も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] DeletedRecordモデルのパーティション戦略（next_partition_if, detach_partition_if）のテストケースがPARTITION_DURATION（1日）の仕様と整合しているか
- [ ] ModificationTrackerの制限値（max_deletes=100000, max_updates=50000, max_runtime=30秒）がテストケースに正しく反映されているか
- [ ] TurboModificationTrackerの制限値（max_deletes=200000, max_updates=150000, max_runtime=45秒）が親クラスより大きいことが確認されているか
- [ ] CleanerServiceのon_delete種別（async_delete, async_nullify, update_column_to）の全てがテストケースでカバーされているか
- [ ] BatchCleanerServiceのフェアキューイング（CLEANUP_ATTEMPTS_BEFORE_RESCHEDULE=3, CONSUME_AFTER_RESCHEDULE=5分）がテストケースに反映されているか
- [ ] ワーカーのturboモード切り替えロジック（Feature Flag依存）がテストケースでカバーされているか
