---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：members モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-101, C-102（InvitationReminderEmailService）**：リマインダー送信タイミングの詳細仕様について追加確認推奨
  2. **EE拡張モジュール**：prepend_mod_with による拡張機能はCE版のみ分析

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/member.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/members/group_member.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/members/project_member.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/creator_service.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/destroy_service.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/update_service.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/create_service.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/invite_service.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/accept_invite_service.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/request_access_service.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/approve_access_request_service.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/base_service.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/import_project_team_service.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/schedule_deletion_service.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/members/invitation_reminder_email_service.rb`
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/members/members/deletion_schedule.rb`
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/members/last_group_owner_assigner.rb`
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/members/pending_invitations_finder.rb`
- E-19: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/members/invite_users_finder.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Memberモデル（C-01 〜 C-40）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | invite?メソッドでinvite_tokenの存在を判定 | E-01 (L532-534) | ○ |
| C-02 | invite?メソッドでnilの場合false | E-01 (L532-534) | ○ |
| C-03 | request?メソッドでrequested_atの存在を判定 | E-01 (L536-538) | ○ |
| C-04 | request?メソッドでnilの場合false | E-01 (L536-538) | ○ |
| C-05 | pending?がinvite?またはrequest?をチェック | E-01 (L540-542) | ○ |
| C-06 | pending?が通常メンバーでfalse | E-01 (L540-542) | ○ |
| C-07 | accept_invite!で招待承認 | E-01 (L559-574) | ○ |
| C-08 | accept_invite!で招待でない場合false | E-01 (L560) | ○ |
| C-09 | accept_invite!でユーザーnilの場合false | E-01 (L561) | ○ |
| C-10 | decline_invite!で招待辞退 | E-01 (L576-584) | ○ |
| C-11 | decline_invite!で招待でない場合false | E-01 (L577) | ○ |
| C-12 | accept_requestでリクエスト承認 | E-01 (L550-557) | ○ |
| C-13 | accept_requestでリクエストでない場合false | E-01 (L551) | ○ |
| C-14 | generate_invite_tokenでトークン生成 | E-01 (L586-590) | ○ |
| C-15 | find_by_invite_tokenでメンバー取得 | E-01 (L459-462) | ○ |
| C-16 | find_by_invite_tokenで無効トークンはnil | E-01 (L459-462) | ○ |
| C-17 | highest_group_memberで最高アクセスレベル取得 | E-01 (L636-645) | ○ |
| C-18 | highest_group_memberで祖先なしの場合nil | E-01 (L638) | ○ |
| C-19 | valid_email?で有効メール検証 | E-01 (L464-466) | ○ |
| C-20 | valid_email?で無効メール検証 | E-01 (L464-466) | ○ |
| C-21 | searchでユーザー名検索 | E-01 (L390-410) | ○ |
| C-22 | search_invite_emailで招待メール検索 | E-01 (L412-414) | ○ |
| C-23 | filter_by_2faで2FA有効フィルタ | E-01 (L416-425) | ○ |
| C-24 | filter_by_2faで2FA無効フィルタ | E-01 (L416-425) | ○ |
| C-25 | sort_by_attributeでアクセスレベル昇順ソート | E-01 (L433-448) | ○ |
| C-26 | sort_by_attributeでアクセスレベル降順ソート | E-01 (L433-448) | ○ |
| C-27 | user_id重複バリデーション | E-01 (L40-42) | ○ |
| C-28 | invite_email重複バリデーション | E-01 (L44-54) | ○ |
| C-29 | 無効なアクセスレベルバリデーション | E-01 (L61, L690-693) | ○ |
| C-30 | 過去の有効期限バリデーション | E-01 (L37) | ○ |
| C-31 | プレースホルダーメールバリデーション | E-01 (L62, L696-702) | ○ |
| C-32 | activeスコープ | E-01 (L132-143) | ○ |
| C-33 | inviteスコープ | E-01 (L187) | ○ |
| C-34 | requestスコープ | E-01 (L193) | ○ |
| C-35 | ownersスコープ | E-01 (L222) | ○ |
| C-36 | maintainersスコープ | E-01 (L219) | ○ |
| C-37 | developersスコープ | E-01 (L218) | ○ |
| C-38 | non_guestsスコープ | E-01 (L220) | ○ |
| C-39 | hook_prerequisites_met?でユーザー存在チェック | E-01 (L544-548) | ○ |
| C-40 | hook_prerequisites_met?でユーザーなしfalse | E-01 (L544-548) | ○ |

### GroupMemberモデル（C-41 〜 C-49）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | groupメソッドでsource返却 | E-02 (L52-54) | ○ |
| C-42 | real_source_typeで'Group'返却 | E-02 (L57-59) | ○ |
| C-43 | last_owner_of_the_group?で最後のオーナー判定 | E-02 (L61-72) | ○ |
| C-44 | last_owner_of_the_group?で複数オーナーfalse | E-02 (L61-72) | ○ |
| C-45 | last_owner_of_the_group?でオーナーでない場合false | E-02 (L62) | ○ |
| C-46 | of_groupsスコープ | E-02 (L21) | ○ |
| C-47 | of_ldap_typeスコープ | E-02 (L22) | ○ |
| C-48 | source_typeバリデーション | E-02 (L17) | ○ |
| C-49 | access_level_rolesでオーナー含む | E-02 (L33-35) | ○ |

### ProjectMemberモデル（C-50 〜 C-60）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | projectメソッドでsource返却 | E-03 (L54-56) | ○ |
| C-51 | namespace_id委譲 | E-03 (L11) | ○ |
| C-52 | holder_of_the_personal_namespace?判定 | E-03 (L58-60) | ○ |
| C-53 | グループプロジェクトでfalse | E-03 (L58-60) | ○ |
| C-54 | truncate_teamでメンバー削除 | E-03 (L38-40) | ○ |
| C-55 | truncate_teamsで複数削除 | E-03 (L26-36) | ○ |
| C-56 | truncate_teamsで例外時false | E-03 (L34-35) | ○ |
| C-57 | in_projectスコープ | E-03 (L18) | ○ |
| C-58 | in_namespacesスコープ | E-03 (L19-22) | ○ |
| C-59 | source_typeバリデーション | E-03 (L15) | ○ |
| C-60 | access_level_rolesでオーナー含まない | E-03 (L49-51) | ○ |

### CreatorService（C-61 〜 C-67）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | add_memberでメンバー追加 | E-04 (L85-101) | ○ |
| C-62 | add_memberで既存メンバー更新 | E-04 (L85-101) | ○ |
| C-63 | add_membersで一括追加 | E-04 (L41-68) | ○ |
| C-64 | 空招待で空配列返却 | E-04 (L42) | ○ |
| C-65 | オーナー管理権限チェック | E-04 (L53) | ○ |
| C-66 | parsed_access_levelでシンボル変換 | E-04 (L12-14) | ○ |
| C-67 | parsed_access_levelで数値そのまま | E-04 (L13) | ○ |

### DestroyService（C-68 〜 C-73）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | executeでメンバー削除 | E-05 (L7-36) | ○ |
| C-69 | skip_authorizationオプション | E-05 (L16-17) | ○ |
| C-70 | 権限なしでAccessDeniedError | E-05 (L17) | ○ |
| C-71 | 最後のグループオーナー保護 | E-05 (L69-85) | ○ |
| C-72 | サブリソースカスケード削除 | E-05 (L122-128) | ○ |
| C-73 | unassign_issuablesオプション | E-05 (L62, L215-227) | ○ |

### UpdateService（C-74 〜 C-79）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | アクセスレベル更新 | E-06 (L13-31) | ○ |
| C-75 | 有効期限更新 | E-06 (L13-31) | ○ |
| C-76 | 一括更新 | E-06 (L16-17) | ○ |
| C-77 | 権限チェックでAccessDeniedError | E-06 (L49) | ○ |
| C-78 | オーナー昇格制限 | E-06 (L99-101) | ○ |
| C-79 | オーナー降格制限 | E-06 (L103-105) | ○ |

### CreateService（C-80 〜 C-83）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | メンバー作成 | E-07 (L23-43) | ○ |
| C-81 | 空招待でBlankInvitesError | E-07 (L86) | ○ |
| C-82 | 招待数上限でTooManyInvitesError | E-07 (L88-91) | ○ |
| C-83 | limitパラメータでカスタム上限 | E-07 (L173-177) | ○ |

### InviteService（C-84 〜 C-86）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | メールアドレスで招待 | E-08 (L10-11) | ○ |
| C-85 | カンマ区切り複数招待 | E-08 (L26-27) | ○ |
| C-86 | 無効メールでエラー | E-08 (L39-46) | ○ |

### AcceptInviteService（C-87 〜 C-88）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | 招待承認成功 | E-09 (L11-16) | ○ |
| C-88 | メール不一致でエラー | E-09 (L29-31) | ○ |

### RequestAccessService（C-89 〜 C-90）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | アクセスリクエスト作成 | E-10 (L7-14) | ○ |
| C-90 | 権限なしでAccessDeniedError | E-10 (L8) | ○ |

### ApproveAccessRequestService（C-91 〜 C-93）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | リクエスト承認 | E-11 (L7-17) | ○ |
| C-92 | アクセスレベル指定承認 | E-11 (L10) | ○ |
| C-93 | 権限なしでAccessDeniedError | E-11 (L33) | ○ |

### ImportProjectTeamService（C-94 〜 C-97）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | チームインポート | E-13 (L14-25) | ○ |
| C-95 | ターゲットプロジェクト不存在でArgumentError | E-13 (L41-46) | ○ |
| C-96 | ソースプロジェクト不存在でArgumentError | E-13 (L41-46) | ○ |
| C-97 | 権限なしでImportProjectTeamForbiddenError | E-13 (L53-58) | ○ |

### ScheduleDeletionService（C-98 〜 C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | 削除スケジュール作成 | E-14 (L13-17) | ○ |
| C-99 | rootネームスペースチェック | E-14 (L14) | ○ |
| C-100 | 権限チェック | E-14 (L15) | ○ |

### InvitationReminderEmailService（C-101 〜 C-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | リマインダー送信タイミング | E-15 (L16-21) | △ |
| C-102 | 期限切れ招待チェック | E-15 (L31) | △ |

### Finder / Model（C-103 〜 C-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | PendingInvitationsFinderで招待検索 | E-18 (L9-14) | ○ |
| C-104 | 空メールリストで空返却 | E-18 (L10) | ○ |
| C-105 | InviteUsersFinderでユーザー検索 | E-19 (L13-25) | ○ |
| C-106 | DeletionSchedule一意性制約 | E-16 (L11) | ○ |
| C-107 | DeletionSchedule namespace関連 | E-16 (L7) | ○ |
| C-108 | DeletionSchedule user関連 | E-16 (L8) | ○ |
| C-109 | DeletionSchedule scheduled_by関連 | E-16 (L9) | ○ |
| C-110 | LastGroupOwnerAssignerで最後のオーナー設定 | E-17 (L10-13) | ○ |
| C-111 | 複数オーナーでlast_owner=false | E-17 (L11) | ○ |
| C-112 | prevent_role_assignement?で管理者false | E-01 (L667) | ○ |
| C-113 | 有効なダウングレードでfalse | E-01 (L674-677) | ○ |
| C-114 | 権限不足でtrue | E-01 (L679) | ○ |
| C-115 | BaseService action_member_permission update | E-12 (L45-53) | ○ |
| C-116 | BaseService action_member_permission override | E-12 (L45-53) | ○ |
| C-117 | 不明なアクションでエラー | E-12 (L51-52) | ○ |
| C-118 | seat_assignableスコープ | E-01 (L81-87) | ○ |
| C-119 | seat_assignable?判定 | E-01 (L89-91) | ○ |
| C-120 | seat_assignable_highest_access_level | E-01 (L93-95) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-101, C-102**：InvitationReminderEmailServiceのリマインダー送信日計算ロジック（REMINDER_RATIO = [2, 5, 10]）の詳細な仕様確認が必要
  - 候補：製品仕様書 / PRドキュメント / 既存テストケース

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接確認可能
- **1: 中リスク** - EE版の拡張機能（prepend_mod_with）は対象外のため、EE固有機能のテストケースは含まれていない

## 6) レビュアーチェックリスト（最小）
- [ ] C-101, C-102のリマインダー送信タイミングの仕様が正しいか確認
- [ ] EE版固有機能のテストケースが別途必要か確認
- [ ] 権限チェック関連のテストケース（C-65, C-70, C-77, C-78, C-79, C-90, C-93）が実際のポリシーと一致しているか確認
- [ ] 最後のオーナー保護ロジック（C-43, C-44, C-71）の動作確認
- [ ] バリデーションエラーメッセージの内容確認
