---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：merge_request単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-MRQ-114, 115（can_be_reverted?）**：リバート判定ロジックの詳細な動作確認が必要
  2. **UT-MRQ-118, 119（closes_issues）**：Issue連携のテストケース網羅性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request.rb` (L1-2400+)
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request/metrics.rb` (L1-54)
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request/cleanup_schedule.rb` (L1-74)
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request/diff_commit_user.rb` (L1-111)
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request/approval_metrics.rb` (L1-25)
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request/commits_metadata.rb` (L1-174)
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request/approval_removal_settings.rb` (L1-40)
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_diff.rb` (L1-400+)
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_assignee.rb` (L1-18)
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_reviewer.rb` (L1-14)
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_context_commit.rb` (L1-51)
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_diff_commit.rb` (L1-268)
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_diff_file.rb` (L1-113)
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_user_mention.rb` (L1-7)
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_requests_closing_issues.rb` (L1-58)
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/merge_request/metrics_finder.rb` (L1-64)
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/merge_request_context_commit_diff_file.rb` (L1-23)

## 3) Claims と根拠の対応（レビューの主戦場）

### MergeRequest本体（UT-MRQ-001〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | draft?メソッドがDRAFT_REGEXでタイトル判定する | E-01 L861-865 | ○ |
| C-02 | draftless_titleがDRAFT_REGEXを除去する | E-01 L867-868 | ○ |
| C-03 | draft_titleがDraft:プレフィックスを付与する | E-01 L871-872 | ○ |
| C-04 | for_fork?がsource/target_projectを比較する | E-01 L1687-1689 | ○ |
| C-05 | source_branch_exists?がrepository.branch_exists?を呼ぶ | E-01 L1836-1840 | ○ |
| C-06 | mergeable?が複数のチェックを実行する | E-01 L1522-1527 | ○ |
| C-07 | merge_ongoing?がmerge_jidとSidekiqStatusを確認する | E-01 L1343-1348 | ○ |
| C-08 | can_be_merged_by?がUserAccessを使用する | E-01 L1914-1917 | ○ |
| C-09 | broken?がhas_no_commits?とbranch_missing?を確認する | E-01 L1910-1912 | ○ |
| C-10 | commits_countがmerge_request_diffから取得する | E-01 L965-973 | ○ |

### MergeRequest状態遷移（UT-MRQ-105〜111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | state_machine :state_idがopened->closedに遷移 | E-01 L211-214 | ○ |
| C-12 | state_machine :state_idがopened->mergedに遷移 | E-01 L215-217 | ○ |
| C-13 | state_machine :merge_statusがunchecked->checkingに遷移 | E-01 L266-269 | ○ |
| C-14 | public_merge_statusがcannot_be_merged_recheckingをcheckingに変換 | E-01 L333-335 | ○ |

### MergeRequest::Metrics（UT-MRQ-041〜045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | Metricsがmerge_requestに属する | E-02 L4 | ○ |
| C-16 | merged_afterスコープがgteq条件を使用 | E-02 L12 | ○ |
| C-17 | record!がON CONFLICT UPSERTを実行 | E-02 L25-38 | ○ |
| C-18 | total_time_to_mergeがtime_to_merge_expressionを使用 | E-02 L47-50 | ○ |

### MergeRequest::CleanupSchedule（UT-MRQ-046〜052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | state_machineがunstarted->runningに遷移 | E-03 L24-26 | ○ |
| C-20 | completeでcompleted_atがセットされる | E-03 L40-42 | ○ |
| C-21 | retryでfailed_countが増加する | E-03 L44-46 | ○ |
| C-22 | start_nextがFOR UPDATE SKIP LOCKEDを使用 | E-03 L59-67 | ○ |
| C-23 | stuck_retry!がSTUCK_RETRY_LIMITで制限 | E-03 L70-72 | ○ |
| C-24 | scheduled_atにpresenceバリデーション | E-03 L16 | ○ |

### MergeRequest::DiffCommitUser（UT-MRQ-053〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | nameに512文字制限 | E-04 L4 | ○ |
| C-26 | emailに512文字制限 | E-04 L5 | ○ |
| C-27 | name/emailの少なくとも一方が必須 | E-04 L6-7 | ○ |
| C-28 | prepareが512文字で切り詰める | E-04 L18-19 | ○ |
| C-29 | find_or_createがRecordNotUniqueでretry | E-04 L23-27 | ○ |
| C-30 | bulk_find_or_createがmappingを返す | E-04 L58-76 | ○ |

### MergeRequest::ApprovalMetrics（UT-MRQ-061〜062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | refresh_last_approved_atがupsertを実行 | E-05 L9-23 | ○ |
| C-32 | last_approved_atにpresenceバリデーション | E-05 L7 | ○ |

### MergeRequest::CommitsMetadata（UT-MRQ-063〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | find_or_createがRecordNotUniqueでretry | E-06 L39-49 | ○ |
| C-34 | bulk_findがproject_idとshaで検索 | E-06 L53-63 | ○ |
| C-35 | bulk_find_or_createがmappingを返す | E-06 L78-137 | ○ |
| C-36 | oldest_merge_request_id_per_commitがマージ済みMRをフィルタ | E-06 L139-157 | ○ |

### MergeRequest::ApprovalRemovalSettings（UT-MRQ-068〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | mutually_exclusive_settingsが両方trueでエラー | E-07 L34-37 | ○ |

### MergeRequestDiff（UT-MRQ-070〜081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | viewable?がcollected/without_files/overflowでtrue | E-08 L254-256 | ○ |
| C-39 | commitsがstrong_memoizeを使用 | E-08 L380-384 | ○ |
| C-40 | files_countがFILES_COUNT_SENTINELを処理 | E-08 L343-352 | ○ |
| C-41 | set_as_latest_diffがmerge_head?で条件分岐 | E-08 L305-313 | ○ |
| C-42 | get_patch_id_shaが同一SHAでnilを返す | E-08 L295-303 | ○ |

### MergeRequestAssignee/Reviewer（UT-MRQ-082〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | assigneeにuniquenessバリデーション | E-09 L9 | ○ |
| C-44 | cache_keyがモデル名とIDを含む | E-09 L14-16 | ○ |
| C-45 | reviewer cache_keyがstateを含む | E-10 L10-12 | ○ |

### MergeRequestContextCommit（UT-MRQ-085〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | to_commitがCommit.from_hashを使用 | E-11 L41-49 | ○ |
| C-47 | shaにuniquenessバリデーション | E-11 L13 | ○ |
| C-48 | delete_bulkがcommit SHAで削除 | E-11 L24-27 | ○ |

### MergeRequestDiffCommit（UT-MRQ-088〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | author_nameがcommit_author&.nameを返す | E-12 L191-193 | ○ |
| C-50 | to_hashがshaをidキーで含める | E-12 L211-216 | ○ |
| C-51 | create_bulkがlegacy_bulk_insertを使用 | E-12 L51-100 | ○ |

### MergeRequestDiffFile（UT-MRQ-092〜096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | diffが外部保存時にexternal_diff_offsetを使用 | E-13 L33-55 | ○ |
| C-53 | utf8_diffがencode_utf8を呼ぶ | E-13 L21-31 | ○ |
| C-54 | new_pathが空の場合old_pathを返す | E-13 L57-59 | ○ |

### MergeRequestUserMention（UT-MRQ-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | merge_requestに属する | E-14 L4 | ○ |

### MergeRequestsClosingIssues（UT-MRQ-098〜099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | merge_request_idにuniquenessバリデーション | E-15 L9 | ○ |
| C-57 | count_for_issueがclosing_merge_requestsを使用 | E-15 L44-46 | ○ |

### MergeRequest::MetricsFinder（UT-MRQ-100〜102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | executeがuser_not_authorized?をチェック | E-16 L11-18 | ○ |
| C-59 | target_projectがnilでklass.noneを返す | E-16 L12 | ○ |

### MergeRequestContextCommitDiffFile（UT-MRQ-103〜104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | pathがnew_pathを優先 | E-17 L19-21 | ○ |

### 根拠不足項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | can_be_reverted?のリバート済み判定ロジック | E-01 L2325-2340（部分的） | △ |
| C-62 | closes_issuesの外部Issue除外ロジック | E-01 L1760-1770（部分的） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-61（can_be_reverted?）**：`has_been_reverted?`メソッドの実装詳細がCommitクラスにあるため、完全な検証には追加調査が必要
  - 候補：`app/models/commit.rb` / `lib/gitlab/git/commit.rb`
- **C-62（closes_issues）**：ExternalIssueクラスの判定ロジック詳細
  - 候補：`app/models/external_issue.rb` / `lib/gitlab/closing_issue_extractor.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 状態遷移テスト（state_machine）、バリデーションテスト
- **1: 中リスク** - マージ可否判定（mergeable?）、権限チェック（can_be_merged_by?）
  - 理由：複数の条件が組み合わさるため、テストケースの網羅性を確認が必要
- **0: 低リスク** - リレーション、アクセサ、スコープのテスト

## 6) レビュアーチェックリスト（最小）
- [ ] 状態遷移テスト（UT-MRQ-046〜051, 105〜111）がすべての遷移パターンをカバーしているか
- [ ] マージ可否判定テスト（UT-MRQ-011〜017）が実際のmergeable_state_checksと整合しているか
- [ ] バリデーションテスト（UT-MRQ-038〜039, 052〜055, 082, 086, 098）がモデル定義と一致しているか
- [ ] バルク処理テスト（UT-MRQ-060, 065, 091）が並行実行時のエッジケースを考慮しているか
- [ ] 権限チェックテスト（UT-MRQ-016〜017, 101）がAbilityクラスの実装と整合しているか
