---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：merge_requests モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-MRQ-044（キャッシュ書き込みテスト）**：キャッシュの内部動作の詳細確認が必要
  2. **UT-MRQ-097/098（CI実行中/失敗ステータス）**：DetailedMergeStatusServiceの複雑な分岐ロジックの網羅性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/merge_requests/merge_schedule.rb`
- E-02: `app/models/merge_requests/merge_data.rb`
- E-03: `app/models/merge_requests/generated_ref_commit.rb`
- E-04: `app/services/merge_requests/mergeability/run_checks_service.rb`
- E-05: `app/services/merge_requests/mergeability/check_base_service.rb`
- E-06: `app/services/merge_requests/mergeability/check_draft_status_service.rb`
- E-07: `app/services/merge_requests/mergeability/check_open_status_service.rb`
- E-08: `app/services/merge_requests/mergeability/check_ci_status_service.rb`
- E-09: `app/services/merge_requests/mergeability/check_conflict_status_service.rb`
- E-10: `app/services/merge_requests/mergeability/check_discussions_status_service.rb`
- E-11: `app/services/merge_requests/mergeability/check_rebase_status_service.rb`
- E-12: `app/services/merge_requests/mergeability/check_commits_status_service.rb`
- E-13: `app/services/merge_requests/mergeability/check_lfs_file_locks_service.rb`
- E-14: `app/services/merge_requests/mergeability/check_merge_time_service.rb`
- E-15: `app/services/merge_requests/mergeability/check_merge_request_title_regex_service.rb`
- E-16: `app/services/merge_requests/mergeability/detailed_merge_status_service.rb`
- E-17: `app/services/merge_requests/mergeability/logger.rb`
- E-18: `app/finders/merge_requests/oldest_per_commit_finder.rb`
- E-19: `app/finders/merge_requests/by_approvals_finder.rb`
- E-20: `app/finders/merge_requests/author_filter.rb`
- E-21: `app/events/merge_requests/approved_event.rb`
- E-22: `app/events/merge_requests/draft_state_change_event.rb`
- E-23: `app/events/merge_requests/discussions_resolved_event.rb`
- E-24: `app/events/merge_requests/mergeable_event.rb`
- E-25: `app/events/merge_requests/merge_request_prepared_event.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Models

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MergeSchedule.merge_requestリレーション定義 | E-01 (line 9) | ○ |
| C-02 | MergeSchedule.merge_request必須バリデーション | E-01 (line 9: optional: false) | ○ |
| C-03 | MergeSchedule.set_sharding_keyコールバック | E-01 (line 11-15) | ○ |
| C-04 | MergeSchedule.set_sharding_keyのnil安全 | E-01 (line 14: &.演算子使用) | ○ |
| C-05 | MergeData.merge_requestリレーション定義 | E-02 (line 26) | ○ |
| C-06 | MergeData.projectリレーション定義 | E-02 (line 27) | ○ |
| C-07 | MergeData.merge_userリレーション定義 | E-02 (line 28) | ○ |
| C-08 | MergeData.projectバリデーション | E-02 (line 30) | ○ |
| C-09 | MergeData.merge_requestバリデーション | E-02 (line 31) | ○ |
| C-10 | MergeData.merge_statusバリデーション | E-02 (line 32) | ○ |
| C-11 | MergeData状態遷移：unchecked→preparing | E-02 (line 44) | ○ |
| C-12 | MergeData状態遷移：can_be_merged→preparing | E-02 (line 44) | ○ |
| C-13 | MergeData状態遷移：cannot_be_merged→preparing（不可） | E-02 (line 44: 遷移元にcannot_be_mergedなし) | ○ |
| C-14 | MergeData状態遷移：preparing→unchecked | E-02 (line 48) | ○ |
| C-15 | MergeData状態遷移：can_be_merged→unchecked | E-02 (line 48) | ○ |
| C-16 | MergeData状態遷移：checking→unchecked | E-02 (line 48) | ○ |
| C-17 | MergeData状態遷移：cannot_be_merged→cannot_be_merged_recheck | E-02 (line 49) | ○ |
| C-18 | MergeData状態遷移：unchecked→checking | E-02 (line 53) | ○ |
| C-19 | MergeData状態遷移：cannot_be_merged_recheck→cannot_be_merged_rechecking | E-02 (line 54) | ○ |
| C-20 | MergeData状態遷移：→can_be_merged | E-02 (line 58) | ○ |
| C-21 | MergeData状態遷移：checking→can_be_merged | E-02 (line 58) | ○ |
| C-22 | MergeData状態遷移：→cannot_be_merged | E-02 (line 62) | ○ |
| C-23 | MergeData状態遷移：checking→cannot_be_merged | E-02 (line 62) | ○ |
| C-24 | MergeData.public_merge_statusの内部状態隠蔽（rechecking） | E-02 (line 87-88) | ○ |
| C-25 | MergeData.public_merge_statusの内部状態隠蔽（preparing） | E-02 (line 88) | ○ |
| C-26 | MergeData.public_merge_statusの通常返却 | E-02 (line 88) | ○ |
| C-27 | MergeData.check_state?でunchecked判定 | E-02 (line 80-81) | ○ |
| C-28 | MergeData.check_state?でcannot_be_merged_recheck判定 | E-02 (line 81) | ○ |
| C-29 | MergeData.check_state?でcan_be_mergedはfalse | E-02 (line 81: can_be_merged含まれず) | ○ |
| C-30 | GeneratedRefCommit.merge_requestリレーション（複合キー） | E-03 (line 16-19) | ○ |
| C-31 | GeneratedRefCommit.projectリレーション | E-03 (line 21) | ○ |
| C-32 | GeneratedRefCommit.commit_shaバリデーション | E-03 (line 22) | ○ |
| C-33 | GeneratedRefCommit.projectバリデーション | E-03 (line 22) | ○ |
| C-34 | GeneratedRefCommit.merge_requestバリデーション | E-03 (line 22) | ○ |
| C-35 | GeneratedRefCommit.oldest_merge_request_id_per_commitクエリ | E-03 (line 24-38) | ○ |
| C-36 | GeneratedRefCommit.oldest_merge_request_id_per_commit空配列処理 | E-03 (line 30: where条件で空配列対応) | ○ |
| C-37 | GeneratedRefCommit.oldest_merge_request_id_per_commitのmergedフィルタ | E-03 (line 33-35) | ○ |

### Services - Mergeability

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | RunChecksService.execute成功時success返却 | E-04 (line 29) | ○ |
| C-39 | RunChecksService.execute失敗時error返却 | E-04 (line 31-37) | ○ |
| C-40 | RunChecksService.executeスキップ機能 | E-04 (line 16-17) | ○ |
| C-41 | RunChecksService.execute全チェック実行モード | E-04 (line 24) | ○ |
| C-42 | RunChecksService.execute早期終了モード | E-04 (line 24) | ○ |
| C-43 | RunChecksService.run_checkキャッシュ読み取り | E-04 (line 47-48) | ○ |
| C-44 | RunChecksService.run_checkキャッシュ書き込み | E-04 (line 50-51) | △ |
| C-45 | CheckBaseService.skip?抽象メソッド | E-05 (line 22-23) | ○ |
| C-46 | CheckBaseService.cacheable?抽象メソッド | E-05 (line 27-28) | ○ |
| C-47 | CheckBaseService.cache_key抽象メソッド | E-05 (line 31-32) | ○ |
| C-48 | CheckBaseService.success結果生成 | E-05 (line 37-39) | ○ |
| C-49 | CheckBaseService.failure結果生成 | E-05 (line 47-49) | ○ |
| C-50 | CheckBaseService.checking結果生成 | E-05 (line 42-44) | ○ |
| C-51 | CheckBaseService.inactive結果生成 | E-05 (line 52-54) | ○ |
| C-52 | CheckBaseService.warning結果生成 | E-05 (line 57-59) | ○ |
| C-53 | CheckDraftStatusService.executeドラフト時failure | E-06 (line 10-11) | ○ |
| C-54 | CheckDraftStatusService.execute非ドラフト時success | E-06 (line 12-13) | ○ |
| C-55 | CheckDraftStatusService.skip?パラメータあり | E-06 (line 17-18) | ○ |
| C-56 | CheckDraftStatusService.skip?パラメータなし | E-06 (line 18) | ○ |
| C-57 | CheckDraftStatusService.cacheable?はfalse | E-06 (line 21-22) | ○ |
| C-58 | CheckOpenStatusService.executeオープン時success | E-07 (line 10-11) | ○ |
| C-59 | CheckOpenStatusService.execute非オープン時failure | E-07 (line 12-13) | ○ |
| C-60 | CheckOpenStatusService.skip?は常にfalse | E-07 (line 17-18) | ○ |
| C-61 | CheckCiStatusService.execute inactive条件 | E-08 (line 12-13) | ○ |
| C-62 | CheckCiStatusService.execute CI成功時success | E-08 (line 15-16, 34-40) | ○ |
| C-63 | CheckCiStatusService.execute CI pending時checking | E-08 (line 17-18, 43-44) | ○ |
| C-64 | CheckCiStatusService.execute CI失敗時failure | E-08 (line 19-20) | ○ |
| C-65 | CheckCiStatusService.execute skippedパイプライン許可 | E-08 (line 53-55) | ○ |
| C-66 | CheckCiStatusService.skip?パラメータ判定 | E-08 (line 25) | ○ |
| C-67 | CheckConflictStatusService.execute can_be_merged時success | E-09 (line 14-15) | ○ |
| C-68 | CheckConflictStatusService.execute cannot_be_merged時failure | E-09 (line 16-17) | ○ |
| C-69 | CheckConflictStatusService.executeチェック中 | E-09 (line 18-19) | ○ |
| C-70 | CheckConflictStatusService.execute SHA不一致時checking | E-09 (line 11-13) | ○ |
| C-71 | CheckDiscussionsStatusService.execute inactive条件 | E-10 (line 9) | ○ |
| C-72 | CheckDiscussionsStatusService.execute解決済みsuccess | E-10 (line 11-12) | ○ |
| C-73 | CheckDiscussionsStatusService.execute未解決failure | E-10 (line 13-14) | ○ |
| C-74 | CheckRebaseStatusService.execute inactive条件（ff不要） | E-11 (line 10) | ○ |
| C-75 | CheckRebaseStatusService.executeリベース不要success | E-11 (line 15-16) | ○ |
| C-76 | CheckRebaseStatusService.executeリベース必要failure | E-11 (line 13-14) | ○ |
| C-77 | CheckCommitsStatusService.execute正常ブランチsuccess | E-12 (line 12-13) | ○ |
| C-78 | CheckCommitsStatusService.executeコミットなしfailure | E-12 (line 10-11) | ○ |
| C-79 | CheckCommitsStatusService.executeブランチ欠落failure | E-12 (line 10-11) | ○ |
| C-80 | CheckCommitsStatusService.skip?は常にfalse | E-12 (line 16-17) | ○ |
| C-81 | CheckLfsFileLocksService.execute LFS無効時inactive | E-13 (line 16, 65-67) | ○ |
| C-82 | CheckLfsFileLocksService.executeロックなしsuccess | E-13 (line 19) | ○ |
| C-83 | CheckLfsFileLocksService.execute他ユーザーロックfailure | E-13 (line 17, 58-62) | ○ |
| C-84 | CheckLfsFileLocksService.execute作成者ロック許可 | E-13 (line 62: not_for_users(author_id)) | ○ |
| C-85 | CheckLfsFileLocksService.cacheable?はtrue | E-13 (line 26-27) | ○ |
| C-86 | CheckLfsFileLocksService.cache_key生成 | E-13 (line 30-42) | ○ |
| C-87 | CheckMergeTimeService.executeスケジュールなしinactive | E-14 (line 11) | ○ |
| C-88 | CheckMergeTimeService.execute未来スケジュールfailure | E-14 (line 13-14) | ○ |
| C-89 | CheckMergeTimeService.execute過去スケジュールsuccess | E-14 (line 15-16) | ○ |
| C-90 | CheckMergeRequestTitleRegexService.execute regex未設定inactive | E-15 (line 12) | ○ |
| C-91 | CheckMergeRequestTitleRegexService.executeマッチsuccess | E-15 (line 14-15) | ○ |
| C-92 | CheckMergeRequestTitleRegexService.execute不一致failure | E-15 (line 16-17) | ○ |
| C-93 | DetailedMergeStatusService.execute preparing返却 | E-16 (line 13) | ○ |
| C-94 | DetailedMergeStatusService.execute checking返却 | E-16 (line 14) | ○ |
| C-95 | DetailedMergeStatusService.execute unchecked返却 | E-16 (line 15) | ○ |
| C-96 | DetailedMergeStatusService.execute mergeable返却 | E-16 (line 23) | ○ |
| C-97 | DetailedMergeStatusService.execute ci_still_running返却 | E-16 (line 73-74) | △ |
| C-98 | DetailedMergeStatusService.execute ci_must_pass返却 | E-16 (line 76) | ○ |
| C-99 | DetailedMergeStatusService.execute失敗チェックidentifier返却 | E-16 (line 32) | ○ |
| C-100 | Logger.instrumentブロック実行 | E-17 (line 17-27) | ○ |
| C-101 | Logger.instrumentブロックなしArgumentError | E-17 (line 18) | ○ |
| C-102 | Logger.commitログ出力 | E-17 (line 13-14, 43-51) | ○ |

### Finders

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | OldestPerCommitFinder.execute最古MR取得 | E-18 (line 17-51) | ○ |
| C-104 | OldestPerCommitFinder.execute merge_commit_shaマッピング | E-18 (line 41) | ○ |
| C-105 | OldestPerCommitFinder.execute squash_commit_shaマッピング | E-18 (line 40) | ○ |
| C-106 | OldestPerCommitFinder.execute merged_commit_shaマッピング | E-18 (line 42) | ○ |
| C-107 | OldestPerCommitFinder.execute空配列処理 | E-18 (line 47) | ○ |
| C-108 | ByApprovalsFinder.execute Noneフィルタ | E-19 (line 26-27, 44-45, 66-67) | ○ |
| C-109 | ByApprovalsFinder.execute Anyフィルタ | E-19 (line 28-29, 49-52, 70-74) | ○ |
| C-110 | ByApprovalsFinder.executeユーザー名フィルタ | E-19 (line 33, 80-81) | ○ |
| C-111 | ByApprovalsFinder.executeユーザーIDフィルタ | E-19 (line 31, 87-88) | ○ |
| C-112 | ByApprovalsFinder MAX_FILTER_ELEMENTS制限 | E-19 (line 9, 17-18) | ○ |
| C-113 | ByApprovalsFinder.executeフィルタなし | E-19 (line 34-35) | ○ |
| C-114 | AuthorFilter.by_author include_assigned=true | E-20 (line 7-10) | ○ |
| C-115 | AuthorFilter.by_author include_assigned=false | E-20 (line 8) | ○ |

### Events

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | ApprovedEvent.schemaプロパティ定義 | E-21 (line 5-17) | ○ |
| C-117 | DraftStateChangeEvent.schemaプロパティ定義 | E-22 (line 5-15) | ○ |
| C-118 | DiscussionsResolvedEvent.schemaプロパティ定義 | E-23 (line 5-15) | ○ |
| C-119 | MergeableEvent.schemaプロパティ定義 | E-24 (line 5-13) | ○ |
| C-120 | MergeRequestPreparedEvent.schemaプロパティ定義 | E-25 (line 5-15) | ○ |

## 4) 不足情報（Unknown / Missing）

### C-44: キャッシュ書き込みテスト
- **理由**: キャッシュストア（`Gitlab::MergeRequests::Mergeability::ResultsStore`）の内部実装を直接確認していないため、実際のキャッシュ書き込み動作の詳細は推測に基づく
- **候補**: `lib/gitlab/merge_requests/mergeability/results_store.rb` / Redisキャッシュ実装 / キャッシュ有効期限設定

### C-97: CI実行中ステータス判定
- **理由**: `diff_head_pipeline_considered_in_progress?`メソッドの詳細実装を確認していないため、CI実行中判定の正確な条件が不明確
- **候補**: `app/models/merge_request.rb`のdiff_head_pipeline関連メソッド / Pipeline状態定義

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|-------------|------|------|
| 1 | MergeData状態遷移テスト | 状態遷移が複雑であり、実際のテストで全パターン網羅が必要 |
| 1 | CheckCiStatusService | CIパイプラインの状態判定が複雑で、エッジケースが存在する可能性 |
| 0 | Eventスキーマテスト | スキーマ定義は単純なHashで明確 |
| 1 | CheckLfsFileLocksService | キャッシュ機能を含むため、キャッシュ状態によるテスト結果の変動に注意 |
| 0 | Finderテスト | クエリロジックは明確に定義されている |

## 6) レビュアーチェックリスト（最小）

- [ ] MergeData状態遷移の全パターンが網羅されているか確認（state_machine定義との整合性）
- [ ] CheckCiStatusServiceの各分岐条件が正しくテストケース化されているか
- [ ] キャッシュ機能を持つサービス（CheckLfsFileLocksService）のキャッシュ有無両方のテストケースがあるか
- [ ] GeneratedRefCommitの複合キーリレーションのテストが適切か
- [ ] DetailedMergeStatusServiceの全返却値パターンがカバーされているか
- [ ] ByApprovalsFinderのMAX_FILTER_ELEMENTS制限が正しくテストされているか
- [ ] 各Eventクラスのスキーマバリデーションテストが十分か
