---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 88
  claims_with_evidence: 88
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：namespace.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：88 / 88、根拠なし：0
- 優先レビュー（高）
  1. **UT-NSP-036〜042**：PackageSetting.duplicates_allowed?のロジックテスト - 複雑な条件分岐
  2. **UT-NSP-063〜077**：TraversalHierarchy - 階層同期とロック制御の複雑な処理
  3. **UT-NSP-079〜088**：AggregationSchedule - 排他制御と非同期処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespace/admin_note.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespace/detail.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespace/package_setting.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespace/root_storage_statistics.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespace/traversal_hierarchy.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespace/aggregation_schedule.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Namespace::AdminNote (UT-NSP-001〜005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | namespaceリレーション（belongs_to :namespace, inverse_of: :admin_note） | E-01 L4 | ○ |
| C-02 | namespaceのpresenceバリデーション | E-01 L5 | ○ |
| C-03 | noteのlength: { maximum: 1000 }バリデーション | E-01 L6 | ○ |
| C-04 | noteが1001文字で境界値エラー | E-01 L6 | ○ |
| C-05 | noteが空文字で許容 | E-01 L6（presence未指定） | ○ |

### Namespace::Detail (UT-NSP-006〜020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | namespaceリレーション（belongs_to :namespace, inverse_of: :namespace_details） | E-02 L7 | ○ |
| C-07 | creatorリレーション（belongs_to :creator, class_name: "User", optional: true） | E-02 L8 | ○ |
| C-08 | creatorがoptionalでnil許容 | E-02 L8 | ○ |
| C-09 | descriptionのlength: { maximum: 2000 }バリデーション | E-02 L10 | ○ |
| C-10 | descriptionが2001文字で境界値エラー | E-02 L10 | ○ |
| C-11 | state_metadataのjson_schemaバリデーション | E-02 L11-12 | ○ |
| C-12 | state_metadataのsize_limit: 64.kilobytes | E-02 L11 | ○ |
| C-13 | jsonb_accessor :last_updated_at | E-02 L15 | ○ |
| C-14 | jsonb_accessor :last_changed_by_user_id | E-02 L16 | ○ |
| C-15 | jsonb_accessor :last_error | E-02 L17 | ○ |
| C-16 | jsonb_accessor :deletion_scheduled_at | E-02 L18 | ○ |
| C-17 | jsonb_accessor :deletion_scheduled_by_user_id | E-02 L19 | ○ |
| C-18 | add_creatorメソッドの存在と動作 | E-02 L33-35 | ○ |
| C-19 | add_creatorでnilを設定可能 | E-02 L33-35, L8 | ○ |
| C-20 | cache_markdown_field :description | E-02 L21 | ○ |

### Namespace::PackageSetting (UT-NSP-021〜045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | namespaceリレーション | E-03 L17 | ○ |
| C-22 | maven_duplicates_allowedのinclusion検証 | E-03 L20 | ○ |
| C-23 | maven_duplicates_allowed=falseの検証 | E-03 L20 | ○ |
| C-24 | maven_duplicate_exception_regexのuntrusted_regexp検証 | E-03 L21 | ○ |
| C-25 | 無効な正規表現でエラー | E-03 L21 | ○ |
| C-26 | maven_duplicate_exception_regexの255文字制限 | E-03 L21 | ○ |
| C-27 | generic_duplicates_allowedのinclusion検証 | E-03 L22 | ○ |
| C-28 | generic_duplicate_exception_regexの検証 | E-03 L23 | ○ |
| C-29 | nuget_duplicates_allowedのinclusion検証 | E-03 L24 | ○ |
| C-30 | nuget_symbol_server_enabledのinclusion検証 | E-03 L26 | ○ |
| C-31 | terraform_module_duplicates_allowedのinclusion検証 | E-03 L27 | ○ |
| C-32 | scope :namespace_id_in | E-03 L30 | ○ |
| C-33 | scope :namespace_id_inの空配列 | E-03 L30 | ○ |
| C-34 | scope :with_terraform_module_duplicates_allowed_or_exception_regex（true条件） | E-03 L31-34 | ○ |
| C-35 | scope :with_terraform_module_duplicates_allowed_or_exception_regex（regex条件） | E-03 L31-34 | ○ |
| C-36 | duplicates_allowed?でpackage=nilの場合true | E-03 L38 | ○ |
| C-37 | duplicates_allowed?でPACKAGES_WITH_SETTINGS外で例外 | E-03 L39 | ○ |
| C-38 | duplicates_allowed?でallowed=true, regex不一致でtrue | E-03 L41-49 | ○ |
| C-39 | duplicates_allowed?でallowed=true, regex一致でfalse | E-03 L41-49 | ○ |
| C-40 | duplicates_allowed?でallowed=false, regex一致でtrue | E-03 L41-49 | ○ |
| C-41 | duplicates_allowed?でallowed=false, regex不一致でfalse | E-03 L41-49 | ○ |
| C-42 | versionでのregexマッチ | E-03 L47 | ○ |
| C-43 | cascading_attr :maven_package_requests_forwarding | E-03 L9 | ○ |
| C-44 | cascading_attr :npm_package_requests_forwarding | E-03 L10 | ○ |
| C-45 | cascading_attr :pypi_package_requests_forwarding | E-03 L11 | ○ |

### Namespace::RootStorageStatistics (UT-NSP-046〜062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | namespaceリレーション | E-04 L19 | ○ |
| C-47 | routeリレーション（through: :namespace） | E-04 L20 | ○ |
| C-48 | scope :for_namespace_ids | E-04 L22 | ○ |
| C-49 | scope :for_namespace_idsの空配列 | E-04 L22 | ○ |
| C-50 | delegate :all_projects_except_soft_deleted | E-04 L24 | ○ |
| C-51 | enum :notification_level（storage_remaining=100） | E-04 L26-32 | ○ |
| C-52 | enum :notification_level（caution=30） | E-04 L26-32 | ○ |
| C-53 | enum :notification_level（warning=15） | E-04 L26-32 | ○ |
| C-54 | enum :notification_level（danger=5） | E-04 L26-32 | ○ |
| C-55 | enum :notification_level（exceeded=0） | E-04 L26-32 | ○ |
| C-56 | recalculate!メソッド | E-04 L34-36 | ○ |
| C-57 | container_registry_sizeの計算 | E-04 L53-59 | ○ |
| C-58 | forks_storage_sizeの計算 | E-04 L62-84 | ○ |
| C-59 | user_namespaceでpersonal_snippets_size | E-04 L110-117 | ○ |
| C-60 | group_namespaceでdependency_proxy_size | E-04 L136-150 | ○ |
| C-61 | namespace_statistics_attributesメソッド | E-04 L38-40 | ○ |
| C-62 | STATISTICS_ATTRIBUTES定数 | E-04 L5-15 | ○ |

### Namespace::TraversalHierarchy (UT-NSP-063〜077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | initializeでrootノード初期化 | E-05 L22-26 | ○ |
| C-64 | initializeでparent_idありで例外 | E-05 L23 | ○ |
| C-65 | sync_traversal_ids!インスタンスメソッド | E-05 L29-31 | ○ |
| C-66 | incorrect_traversal_idsの検出 | E-05 L34-38 | ○ |
| C-67 | incorrect_traversal_idsが空 | E-05 L34-38 | ○ |
| C-68 | for_namespaceクラスメソッド | E-05 L41-43 | ○ |
| C-69 | sync_traversal_ids!クラスメソッド | E-05 L46-51 | ○ |
| C-70 | トランザクション内実行 | E-05 L47-50 | ○ |
| C-71 | recursive_traversal_idsでルートノード | E-05 L59-81 | ○ |
| C-72 | recursive_traversal_idsで子ノード | E-05 L61-68 | ○ |
| C-73 | 循環参照検出（cycle） | E-05 L75-77 | ○ |
| C-74 | acquire_locksでFOR SHAREロック | E-05 L126 | ○ |
| C-75 | acquire_locksでFOR NO KEY UPDATEロック | E-05 L130 | ○ |
| C-76 | QueryCanceledでメトリクス | E-05 L132-137 | ○ |
| C-77 | Deadlockedでメトリクス | E-05 L138-140 | ○ |

### Namespace::AggregationSchedule (UT-NSP-078〜088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | namespaceリレーション | E-06 L11 | ○ |
| C-79 | after_createコールバック | E-06 L13 | ○ |
| C-80 | perform_in遅延実行 | E-06 L25-26 | ○ |
| C-81 | default_lease_timeout | E-06 L15-17 | ○ |
| C-82 | lease_key | E-06 L39-41 | ○ |
| C-83 | lease_release?がfalse | E-06 L47-49 | ○ |
| C-84 | lease_timeout | E-06 L34-36 | ○ |
| C-85 | try_obtain_lease成功時 | E-06 L21-27 | ○ |
| C-86 | try_obtain_lease失敗時 | E-06 L21（ExclusiveLeaseGuard） | ○ |
| C-87 | run_after_commit_or_now（トランザクション内） | E-06 L20（AfterCommitQueue） | ○ |
| C-88 | run_after_commit_or_now（トランザクション外） | E-06 L20（AfterCommitQueue） | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースがソースコードに基づいて生成されており、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Namespace::AdminNote, Namespace::Detail（シンプルなモデル）
- **1: 中リスク** - Namespace::PackageSetting（複雑なバリデーションとビジネスロジック）
- **1: 中リスク** - Namespace::RootStorageStatistics（統計計算ロジック）
- **2: 高リスク** - Namespace::TraversalHierarchy（データベースロック、トランザクション、再帰処理）
- **1: 中リスク** - Namespace::AggregationSchedule（排他制御、非同期処理）

## 6) レビュアーチェックリスト（最小）
- [ ] Namespace::PackageSetting.duplicates_allowed?の条件分岐ロジックが正しくテストされているか確認
- [ ] Namespace::TraversalHierarchyのロック取得順序とタイムアウト処理が適切にテストされているか確認
- [ ] Namespace::RootStorageStatistics.recalculate!の各統計計算が網羅されているか確認
- [ ] Namespace::AggregationScheduleのExclusiveLeaseGuardとAfterCommitQueueの連携テストが適切か確認
- [ ] 境界値テスト（文字列長、配列空など）が適切に設定されているか確認
- [ ] enum値（notification_level）の全ての値がテストされているか確認
