---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 156
  claims_with_evidence: 156
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：namespaces モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：156 / 156、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### モデル
- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/project_namespace.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/user_namespace.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/verified_namespace.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/randomized_suffix_path.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/namespace_isolation.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/descendants.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/sync_event.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/ldap_setting.rb`

### Traversalモジュール
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/traversal/linear.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/traversal/recursive.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/traversal/cached.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/traversal/traversable.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/traversal/linear_scopes.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/traversal/recursive_scopes.rb`

### Preloaderモジュール
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/preloaders/namespace_root_ancestor_preloader.rb`
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/preloaders/group_root_ancestor_preloader.rb`
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/namespaces/preloaders/project_root_ancestor_preloader.rb`

### サービス
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/statistics_refresher_service.rb`
- E-19: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/update_denormalized_descendants_service.rb`
- E-20: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/groups/archive_service.rb`
- E-21: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/groups/unarchive_service.rb`
- E-22: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/package_settings/update_service.rb`
- E-23: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/restore_base_service.rb`
- E-24: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/mark_for_deletion_base_service.rb`
- E-25: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/unlink_project_forks_service.rb`
- E-26: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/namespaces/groups/adjourned_deletion_service.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Namespaces::ProjectNamespace (UT-NMS-001 〜 UT-NMS-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sti_name が 'Project' を返却 | E-01 (L34-36) | ○ |
| C-02 | polymorphic_name が 'Namespaces::ProjectNamespace' を返却 | E-01 (L38-40) | ○ |
| C-03 | create_from_project! が新規プロジェクトから ProjectNamespace を作成 | E-01 (L42-50) | ○ |
| C-04 | create_from_project! が既存プロジェクトで nil を返却 | E-01 (L43) | ○ |
| C-05 | create_from_project! が namespace nil で nil を返却 | E-01 (L44) | ○ |
| C-06 | owner_entity が project を返却 | E-01 (L52-55) | ○ |
| C-07 | sync_attributes_from_project が属性を同期 | E-01 (L57-80) | ○ |
| C-08 | 新規レコード時に visibility_level がデフォルト設定 | E-01 (L66) | ○ |
| C-09 | namespace_id が空で namespace 存在時に parent 設定 | E-01 (L73-77) | ○ |
| C-10 | all_projects が ActiveRecord::Relation を返却 | E-01 (L83-85) | ○ |
| C-11 | max_member_access_for_user がアクセスレベルを返却 | E-01 (L87-89) | ○ |
| C-12 | has_one :project 関連が存在 | E-01 (L26) | ○ |

### Namespaces::UserNamespace (UT-NMS-013 〜 UT-NMS-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | sti_name が 'User' を返却 | E-02 (L27-29) | ○ |
| C-14 | owner_entity が owner を返却 | E-02 (L31-34) | ○ |
| C-15 | owners が配列を返却 | E-02 (L36-38) | ○ |
| C-16 | member? がメンバーシップを判定 | E-02 (L40-44) | ○ |
| C-17 | member? が user nil で false を返却 | E-02 (L41) | ○ |
| C-18 | member? がアクセスレベル未満で false | E-02 (L43) | ○ |
| C-19 | max_member_access_for_user が所有者に OWNER を返却 | E-02 (L61) | ○ |
| C-20 | max_member_access_for_user が管理者に OWNER を返却 | E-02 (L57-58) | ○ |
| C-21 | max_member_access_for_user が組織管理者に OWNER を返却 | E-02 (L57) | ○ |
| C-22 | max_member_access_for_user が user nil で NO_ACCESS | E-02 (L55) | ○ |
| C-23 | max_member_access_for_user が非所有者に NO_ACCESS | E-02 (L61) | ○ |
| C-24 | only_concrete_membership で管理者も NO_ACCESS | E-02 (L57) | ○ |
| C-25 | crm_group が nil を返却 | E-02 (L64-66) | ○ |

### Namespaces::VerifiedNamespace (UT-NMS-026 〜 UT-NMS-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | belongs_to :namespace 関連が存在 | E-03 (L15) | ○ |
| C-27 | enum :verification_level が機能 | E-03 (L17) | ○ |
| C-28 | validates :namespace_id presence | E-03 (L19) | ○ |
| C-29 | validates :namespace_id uniqueness | E-03 (L19) | ○ |
| C-30 | for_project がプロジェクトから検索 | E-03 (L21-23) | ○ |
| C-31 | for_project が存在しない場合 nil | E-03 (L22) | ○ |
| C-32 | find_or_create_by_namespace! が既存を返却 | E-03 (L25-27) | ○ |
| C-33 | find_or_create_by_namespace! が新規作成 | E-03 (L26) | ○ |

### Namespaces::RandomizedSuffixPath (UT-NMS-034 〜 UT-NMS-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | initialize が path を設定 | E-04 (L8-10) | ○ |
| C-35 | call が suffix 付きパスを返却 | E-04 (L12-15) | ○ |
| C-36 | count=0 で suffix なし | E-04 (L37) | ○ |
| C-37 | count>MAX_TRIES でランダムサフィックス | E-04 (L35) | ○ |
| C-38 | to_s が文字列表現を返却 | E-04 (L17-19) | ○ |

### Namespaces::NamespaceIsolation (UT-NMS-039 〜 UT-NMS-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | belongs_to :namespace 関連が存在 | E-05 (L5) | ○ |
| C-40 | validates :namespace presence | E-05 (L7) | ○ |

### Namespaces::Descendants (UT-NMS-041 〜 UT-NMS-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | belongs_to :namespace 関連が存在 | E-06 (L7) | ○ |
| C-42 | validates :namespace_id uniqueness | E-06 (L9) | ○ |
| C-43 | expire_for が outdated_at を更新 | E-06 (L11-28) | ○ |
| C-44 | expire_for が空配列でもエラーなし | E-06 (L27) | ○ |
| C-45 | expire_recursive_for が再帰的に無効化 | E-06 (L30-36) | ○ |
| C-46 | load_outdated_batch がロック付きで取得 | E-06 (L38-44) | ○ |
| C-47 | load_outdated_batch が対象なしで空配列 | E-06 (L39-40) | ○ |
| C-48 | upsert_with_consistent_data が新規挿入 | E-06 (L46-85) | ○ |
| C-49 | upsert_with_consistent_data が既存更新 | E-06 (L64-72) | ○ |
| C-50 | outdated_at 一致時に null 更新 | E-06 (L93-96) | ○ |
| C-51 | outdated_at 不一致時に保持 | E-06 (L96) | ○ |

### Namespaces::SyncEvent (UT-NMS-052 〜 UT-NMS-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | belongs_to :namespace 関連が存在 | E-07 (L8) | ○ |
| C-53 | unprocessed_events スコープが存在 | E-07 (L10) | ○ |
| C-54 | preload_synced_relation がプリロード | E-07 (L11) | ○ |
| C-55 | order_by_id_asc が昇順ソート | E-07 (L12) | ○ |
| C-56 | mark_records_processed が削除 | E-07 (L14-16) | ○ |
| C-57 | enqueue_worker がワーカー起動 | E-07 (L18-20) | ○ |
| C-58 | upper_bound_count が計算 | E-07 (L22-24) | ○ |
| C-59 | upper_bound_count が空で0 | E-07 (L23) | ○ |

### Namespaces::LdapSetting (UT-NMS-060 〜 UT-NMS-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | belongs_to :namespace 関連が存在 | E-08 (L5) | ○ |
| C-61 | validates :namespace presence | E-08 (L6) | ○ |
| C-62 | primary_key が namespace_id | E-08 (L8) | ○ |

### Namespaces::Traversal::Linear (UT-NMS-063 〜 UT-NMS-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | use_traversal_ids? が traversal_ids 存在で true | E-09 (L90-92) | ○ |
| C-64 | use_traversal_ids? が空配列で false | E-09 (L91) | ○ |
| C-65 | traversal_path がパス生成 | E-09 (L82-88) | ○ |
| C-66 | traversal_path で organization_id 付与 | E-09 (L85) | ○ |
| C-67 | root_ancestor がルート祖先取得 | E-09 (L96-112) | ○ |
| C-68 | root_ancestor が parent_id nil で self | E-09 (L105-107) | ○ |
| C-69 | root_ancestor が parent ロード済みで再帰 | E-09 (L98-99) | ○ |
| C-70 | self_and_descendants が子孫取得 | E-09 (L118-122) | ○ |
| C-71 | self_and_descendant_ids が ID 取得 | E-09 (L124-128) | ○ |
| C-72 | descendants が自身除く子孫 | E-09 (L130-134) | ○ |
| C-73 | self_and_hierarchy が全階層 | E-09 (L136-140) | ○ |
| C-74 | ancestors が祖先取得 | E-09 (L142-148) | ○ |
| C-75 | ancestors が parent_id 空で空 Relation | E-09 (L145) | ○ |
| C-76 | ancestor_ids が配列取得 | E-09 (L150-154) | ○ |
| C-77 | ancestor_ids が desc で降順 | E-09 (L153) | ○ |
| C-78 | ancestors_upto が範囲指定 | E-09 (L162-182) | ○ |
| C-79 | ancestors_upto が top nil で全祖先 | E-09 (L167) | ○ |
| C-80 | self_and_ancestors が自身含む祖先 | E-09 (L184-190) | ○ |
| C-81 | self_and_ancestors が parent_id 空で自身のみ | E-09 (L187) | ○ |
| C-82 | self_and_ancestor_ids が配列 | E-09 (L192-196) | ○ |
| C-83 | self_and_ancestor_ids が desc で降順 | E-09 (L195) | ○ |
| C-84 | parent= で traversal_ids 更新 | E-09 (L198-201) | ○ |
| C-85 | parent_id= で traversal_ids 更新 | E-09 (L203-206) | ○ |
| C-86 | shortest_traversal_ids_prefixes が最短プレフィックス | E-09 (L63-79) | ○ |

### Namespaces::Traversal::LinearScopes (UT-NMS-087 〜 UT-NMS-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | as_ids が ID 抽出 | E-13 (L14-16) | ○ |
| C-88 | roots がルート取得 | E-13 (L18-21) | ○ |
| C-89 | self_and_ancestors がクラスメソッド | E-13 (L23-29) | ○ |
| C-90 | self_and_ancestors で include_self=false | E-13 (L64-68) | ○ |
| C-91 | self_and_descendants がクラスメソッド | E-13 (L35-37) | ○ |
| C-92 | self_and_hierarchy が全階層 | E-13 (L43-45) | ○ |
| C-93 | order_by_depth が深さソート | E-13 (L47-55) | ○ |

### Namespaces::Traversal::Recursive (UT-NMS-094 〜 UT-NMS-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | root_ancestor が再帰版 | E-10 (L9-19) | ○ |
| C-95 | all_project_ids が取得 | E-10 (L22-26) | ○ |
| C-96 | self_and_hierarchy が ObjectHierarchy 使用 | E-10 (L35-39) | ○ |
| C-97 | ancestors が ObjectHierarchy 使用 | E-10 (L42-48) | ○ |
| C-98 | self_and_descendants が ObjectHierarchy 使用 | E-10 (L82-85) | ○ |

### Namespaces::Traversal::Cached (UT-NMS-099 〜 UT-NMS-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | self_and_descendant_ids がキャッシュ利用 | E-11 (L14-29) | ○ |
| C-100 | self_and_descendant_ids がフォールバック | E-11 (L57-81) | ○ |
| C-101 | all_project_ids がキャッシュ利用 | E-11 (L36-42) | ○ |
| C-102 | all_unarchived_project_ids がキャッシュ利用 | E-11 (L44-51) | ○ |
| C-103 | sync_traversal_ids がキャッシュ無効化 | E-11 (L83-93) | ○ |
| C-104 | invalidate_descendants_cache が削除時無効化 | E-11 (L103-107) | ○ |
| C-105 | UserNamespace でキャッシュ無効化スキップ | E-11 (L96, L104) | ○ |

### Namespaces::Traversal::Traversable (UT-NMS-106 〜 UT-NMS-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | within スコープが範囲検索 | E-12 (L9-18) | ○ |
| C-107 | within が不正 ID でエラー | E-12 (L10) | ○ |

### Namespaces::Preloaders (UT-NMS-108 〜 UT-NMS-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | NamespaceRootAncestorPreloader initialize | E-15 (L8-11) | ○ |
| C-109 | NamespaceRootAncestorPreloader execute | E-15 (L13-29) | ○ |
| C-110 | 孤立 namespace で警告ログ | E-15 (L34-43) | ○ |
| C-111 | GroupRootAncestorPreloader execute | E-16 (L5-13) | ○ |
| C-112 | ProjectRootAncestorPreloader initialize | E-17 (L6-10) | ○ |
| C-113 | ProjectRootAncestorPreloader execute | E-17 (L12-27) | ○ |
| C-114 | projects が Relation でない場合スキップ | E-17 (L13) | ○ |

### Namespaces::StatisticsRefresherService (UT-NMS-115 〜 UT-NMS-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | execute が統計再計算 | E-18 (L7-13) | ○ |
| C-116 | 子 namespace でもルートの統計更新 | E-18 (L8) | ○ |
| C-117 | ActiveRecordError で RefresherError | E-18 (L12-13) | ○ |

### Namespaces::UpdateDenormalizedDescendantsService (UT-NMS-118 〜 UT-NMS-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | initialize が namespace_id 設定 | E-19 (L12-14) | ○ |
| C-119 | execute が正常更新 | E-19 (L16-18) | ○ |
| C-120 | descendants nil で早期リターン | E-19 (L23) | ○ |
| C-121 | ロックタイムアウトで専用ステータス | E-19 (L28-29) | ○ |
| C-122 | 楽観的ロック失敗で専用ステータス | E-19 (L34) | ○ |
| C-123 | namespace 削除時に descendants 削除 | E-19 (L36-37) | ○ |

### Namespaces::Groups::ArchiveService (UT-NMS-124 〜 UT-NMS-131)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | execute が正常アーカイブ | E-20 (L24-48) | ○ |
| C-125 | 権限なしで NotAuthorizedError | E-20 (L25-27) | ○ |
| C-126 | アーカイブ済みで AlreadyArchivedError | E-20 (L29) | ○ |
| C-127 | 祖先アーカイブ済みで AncestorAlreadyArchivedError | E-20 (L30) | ○ |
| C-128 | 削除予定で ScheduledDeletionError | E-20 (L31) | ○ |
| C-129 | Feature 有効時に子孫アーカイブ解除 | E-20 (L33-38) | ○ |
| C-130 | アーカイブ後にシステムフック | E-20 (L60) | ○ |
| C-131 | アーカイブ後にフォーク解除ワーカー | E-20 (L65-66) | ○ |

### Namespaces::Groups::UnarchiveService (UT-NMS-132 〜 UT-NMS-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | execute が正常アーカイブ解除 | E-21 (L21-39) | ○ |
| C-133 | 権限なしで NotAuthorizedError | E-21 (L22) | ○ |
| C-134 | 未アーカイブで AlreadyUnarchivedError | E-21 (L24) | ○ |
| C-135 | 祖先アーカイブ済みで AncestorArchivedError | E-21 (L23) | ○ |
| C-136 | Feature 有効時に子孫アーカイブ解除 | E-21 (L26-31) | ○ |

### Namespaces::PackageSettings::UpdateService (UT-NMS-137 〜 UT-NMS-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | execute が正常更新 | E-22 (L24-35) | ○ |
| C-138 | 権限なしで 403 エラー | E-22 (L25) | ○ |
| C-139 | バリデーションエラーで 400 エラー | E-22 (L29-33) | ○ |
| C-140 | ALLOWED_ATTRIBUTES 以外は無視 | E-22 (L49-51) | ○ |

### Namespaces::RestoreBaseService (UT-NMS-141 〜 UT-NMS-146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | execute が正常復元 | E-23 (L21-33) | ○ |
| C-142 | 権限なしで UnauthorizedError | E-23 (L48) | ○ |
| C-143 | 削除予定でない場合エラー | E-23 (L49) | ○ |
| C-144 | 削除進行中でエラー | E-23 (L50) | ○ |
| C-145 | original_value で削除サフィックス除去 | E-23 (L72-74) | ○ |
| C-146 | suffix でランダムサフィックス付与 | E-23 (L76-79) | ○ |

### Namespaces::MarkForDeletionBaseService (UT-NMS-147 〜 UT-NMS-151)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | execute が正常マーク | E-24 (L14-29) | ○ |
| C-148 | 権限なしで UnauthorizedError | E-24 (L48) | ○ |
| C-149 | マーク済みで already_marked_error | E-24 (L49) | ○ |
| C-150 | 祖先マーク済みで ancestor_already_marked_error | E-24 (L50) | ○ |
| C-151 | suffixed_identifier が識別子生成 | E-24 (L68-70) | ○ |

### Namespaces::UnlinkProjectForksService (UT-NMS-152 〜 UT-NMS-154)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-152 | initialize が group, user 設定 | E-25 (L5-8) | ○ |
| C-153 | execute がフォーク解除実行 | E-25 (L10-18) | ○ |
| C-154 | フォーク関係なしでも正常終了 | E-25 (L15-16) | ○ |

### Namespaces::Groups::AdjournedDeletionService (UT-NMS-155 〜 UT-NMS-156)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | 権限ありで削除 | E-26 (L11-16) | ○ |
| C-156 | 権限なしで復元 | E-26 (L14-15) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されています
- テストケースはコードの実装に基づいており、ビジネス要件との整合性は別途確認が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの実装と整合しているか確認
- [ ] 高優先度のテストケース（権限チェック、データ整合性、キャッシュ管理）が網羅されているか確認
- [ ] 異常系・境界値テストケースが十分にカバーされているか確認
- [ ] Traversalモジュールの複雑なロジック（階層検索、キャッシュ）のテストが適切か確認
- [ ] サービスクラスの権限チェック、エラーハンドリングが網羅されているか確認
