---
generated_at: 2026-01-22 15:05:00
metrics:
  claims_total: 137
  claims_with_evidence: 137
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：operations.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：137 / 137、根拠なし：0
- 優先レビュー（高）
  1. **UT-OPR-029〜030**：for_unleash_clientメソッドの複雑なクエリロジック - 実際のデータベースでの動作確認推奨
  2. **UT-OPR-064〜067**：HasEnvironmentScopeのon_environmentスコープ - SQLパターンマッチングの動作確認推奨
  3. **UT-OPR-087〜107**：Strategyのパラメータバリデーション - 多数の境界値テストが含まれるため網羅性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/operations/feature_flag.rb`
- E-02: `app/models/operations/feature_flags_client.rb`
- E-03: `app/models/operations/feature_flags/scope.rb`
- E-04: `app/models/operations/feature_flags/strategy.rb`
- E-05: `app/models/operations/feature_flags/strategy_user_list.rb`
- E-06: `app/models/operations/feature_flags/user_list.rb`
- E-07: `app/models/concerns/has_environment_scope.rb`
- E-08: `app/validators/feature_flag_user_xids_validator.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Operations::FeatureFlag（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :projectリレーション | E-01 L15 | ○ |
| C-02 | has_many :strategiesリレーション | E-01 L23 | ○ |
| C-03 | has_many :feature_flag_issuesリレーション | E-01 L24 | ○ |
| C-04 | has_many :issues throughリレーション | E-01 L25 | ○ |
| C-05〜06 | validates :project, :name presence | E-01 L27-29 | ○ |
| C-07〜10 | validates :name length: 2..63 | E-01 L30 | ○ |
| C-11〜15 | validates :name format regex | E-01 L31-36 | ○ |
| C-16〜17 | validates :name uniqueness | E-01 L37 | ○ |
| C-18〜20 | validates :description length | E-01 L38 | ○ |
| C-21 | attribute :active default: true | E-01 L19 | ○ |
| C-22 | attribute :version default: :new_version_flag | E-01 L20 | ○ |
| C-23〜26 | scope :ordered, :enabled, :disabled, :new_version_only | E-01 L42-47 | ○ |
| C-27〜28 | preload_relations, preload_project | E-01 L54-60 | ○ |
| C-29〜30 | for_unleash_client | E-01 L62-68 | ○ |
| C-31〜34 | reference_prefix, reference_postfix, reference_pattern, link_reference_pattern | E-01 L70-86 | ○ |
| C-35〜36 | to_reference | E-01 L89-94 | ○ |
| C-37〜39 | related_issues | E-01 L96-105 | ○ |
| C-40 | path | E-01 L107-109 | ○ |
| C-41 | hook_attrs | E-01 L111-118 | ○ |
| C-42 | has_internal_id :iid | E-01 L17 | ○ |

### Operations::FeatureFlagsClient（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | belongs_to :project | E-02 L12 | ○ |
| C-44〜45 | validates presence | E-02 L14-15 | ○ |
| C-46 | before_validation :ensure_token! | E-02 L23 | ○ |
| C-47〜50 | find_for_project_and_token | E-02 L25-29 | ○ |
| C-51 | update_last_feature_flag_updated_at! | E-02 L32-34 | ○ |
| C-52 | prefix_for_feature_flags_client_token | E-02 L36-38 | ○ |
| C-53 | unleash_api_version | E-02 L40-42 | ○ |
| C-54〜56 | unleash_api_features | E-02 L44-48 | ○ |
| C-57 | unleash_api_cache_key | E-02 L50-54 | ○ |
| C-58 | instance prefix_for_feature_flags_client_token | E-02 L56-58 | ○ |

### Operations::FeatureFlags::Scope（E-03, E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | belongs_to :strategy | E-03 L10 | ○ |
| C-60〜63 | validates :environment_scope | E-07 L7-12 | ○ |
| C-64〜67 | scope :on_environment | E-07 L25-72 | ○ |
| C-68〜69 | scope :for_environment | E-07 L74-80 | ○ |
| C-70 | environment_scope= mutator | E-07 L83-85 | ○ |

### Operations::FeatureFlags::Strategy（E-04, E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | belongs_to :feature_flag | E-04 L23 | ○ |
| C-72 | has_many :scopes | E-04 L24 | ○ |
| C-73 | has_one :strategy_user_list | E-04 L25 | ○ |
| C-74 | has_one :user_list through | E-04 L26 | ○ |
| C-75〜80 | validates :name inclusion | E-04 L28-32 | ○ |
| C-81〜82 | validates :user_list presence/absence | E-04 L35-36 | ○ |
| C-83 | same_project_validation | E-04 L47-51 | ○ |
| C-84〜86 | validate_parameters_type, validate_parameters_keys | E-04 L53-66 | ○ |
| C-87〜94 | gradual_rollout_user_id_parameters_validation | E-04 L87-98 | ○ |
| C-95〜102 | flexible_rollout_parameters_validation | E-04 L100-117 | ○ |
| C-103〜107 | userWithId parameters validation | E-04 L76, E-08 | ○ |
| C-108〜109 | user_list_id= | E-04 L41-43 | ○ |
| C-110〜111 | accepts_nested_attributes_for :scopes | E-04 L39 | ○ |

### Operations::FeatureFlags::StrategyUserList（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | belongs_to :strategy | E-05 L8 | ○ |
| C-113 | belongs_to :user_list | E-05 L9 | ○ |

### Operations::FeatureFlags::UserList（E-06, E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | belongs_to :project | E-06 L12 | ○ |
| C-115 | has_many :strategy_user_lists | E-06 L13 | ○ |
| C-116 | has_many :strategies through | E-06 L14 | ○ |
| C-117〜123 | validates :project, :name | E-06 L18-22 | ○ |
| C-124〜129 | validates :user_xids | E-06 L23, E-08 | ○ |
| C-130 | has_internal_id :iid | E-06 L16 | ○ |
| C-131〜132 | scope :for_name_like | E-06 L27-29 | ○ |
| C-133〜135 | self.belongs_to? | E-06 L31-34 | ○ |
| C-136〜137 | ensure_no_associated_strategies | E-06 L38-43 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコード解析に基づいて生成されています
- 注意点：
  - `for_unleash_client`メソッド（UT-OPR-029〜030）は複雑なSQLクエリを含むため、実際のDB環境でのテストが重要
  - `HasEnvironmentScope`のパターンマッチング（UT-OPR-064〜070）はSQLのLIKE句を使用しており、エッジケースの確認が推奨される
  - `FeatureFlagUserXidsValidator`（UT-OPR-103〜107, 124〜129）は入力形式が複雑なため、追加のエッジケーステストを検討

## 6) レビュアーチェックリスト（最小）
- [ ] Operations::FeatureFlagのバリデーション（名前の形式、長さ、一意性）が実際のビジネス要件と一致しているか
- [ ] Unleash API連携（for_unleash_client, unleash_api_features）のテストケースが十分にカバーしているか
- [ ] 環境スコープのパターンマッチング（on_environment）の優先度ソートロジックが正しいか
- [ ] Strategyのパラメータバリデーション（percentage, rollout, groupId, stickiness）の境界値が網羅されているか
- [ ] UserListの削除制約（ensure_no_associated_strategies）が正しく機能するか
- [ ] FeatureFlagUserXidsValidatorの入力形式チェック（改行、連続カンマ、空白、重複）が十分か
- [ ] プロジェクト間のデータ整合性チェック（same_project_validation, belongs_to?）が正しいか

---

## 補足：Evidence詳細

### E-01: app/models/operations/feature_flag.rb
- モジュール: Operations::FeatureFlag
- 主な機能: フィーチャーフラグの管理
- リレーション: project, strategies, feature_flag_issues, issues
- バリデーション: name（形式、長さ、一意性）、description（長さ）
- スコープ: ordered, enabled, disabled, new_version_only, for_unleash_client
- インスタンスメソッド: to_reference, related_issues, path, hook_attrs

### E-02: app/models/operations/feature_flags_client.rb
- モジュール: Operations::FeatureFlagsClient
- 主な機能: Unleash APIクライアントの管理
- トークン認証: TokenAuthenticatable mixin使用
- 主要メソッド: find_for_project_and_token, update_last_feature_flag_updated_at!, unleash_api_features, unleash_api_cache_key

### E-03: app/models/operations/feature_flags/scope.rb
- モジュール: Operations::FeatureFlags::Scope
- 主な機能: 環境スコープの管理
- HasEnvironmentScope concernをprepend

### E-04: app/models/operations/feature_flags/strategy.rb
- モジュール: Operations::FeatureFlags::Strategy
- 主な機能: ロールアウト戦略の管理
- 対応戦略: default, gitlabUserList, gradualRolloutUserId, flexibleRollout, userWithId
- 複雑なパラメータバリデーション実装

### E-05: app/models/operations/feature_flags/strategy_user_list.rb
- モジュール: Operations::FeatureFlags::StrategyUserList
- 主な機能: StrategyとUserListの中間テーブル

### E-06: app/models/operations/feature_flags/user_list.rb
- モジュール: Operations::FeatureFlags::UserList
- 主な機能: ユーザーリストの管理
- バリデーション: name（一意性、長さ）、user_xids（カスタムバリデータ）
- 削除制約: ensure_no_associated_strategies

### E-07: app/models/concerns/has_environment_scope.rb
- モジュール: HasEnvironmentScope (concern)
- 主な機能: 環境スコープのバリデーションとスコープ
- 複雑なSQLパターンマッチング実装（on_environment）

### E-08: app/validators/feature_flag_user_xids_validator.rb
- クラス: FeatureFlagUserXidsValidator
- 主な機能: ユーザーID一覧のバリデーション
- 検証項目: 形式（改行、タブ、連続カンマ禁止）、長さ（256文字以内）、一意性
