---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 146
  claims_with_evidence: 146
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：organizations.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：146 / 146、根拠なし：0
- 優先レビュー（高）
  1. **バリデーション関連テスト（UT-ORG-033〜042）**：ビジネスロジック上重要
  2. **オーナー管理テスト（UT-ORG-067〜072）**：権限管理の要
  3. **サービス層テスト（UT-ORG-110〜140）**：ビジネスロジックの中核

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/organizations/organization.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/organizations/organization_user.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/organizations/organization_detail.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/organizations/organization_user_detail.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/organizations/organization_setting.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/organizations/organization_isolation.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/organizations/isolation_record.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/organizations/create_service.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/organizations/update_service.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/organizations/base_service.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/organizations/organization_users/update_service.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/organizations/groups/transfer_service.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/organizations/users/transfer_service.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/organizations/organizations_finder.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/finders/organizations/organization_users_finder.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-ORG-001) | default_organizationでid=1の組織が取得できる | E-01 L76-78 | ○ |
| C-02 (UT-ORG-002) | default_organizationで存在しない場合nilが返る | E-01 L76-78 | ○ |
| C-03 (UT-ORG-003) | .default?でDEFAULT_ORGANIZATION_ID比較 | E-01 L80-82 | ○ |
| C-04 (UT-ORG-004) | .default?で異なるIDの場合false | E-01 L80-82 | ○ |
| C-05 (UT-ORG-005) | #default?でインスタンス判定 | E-01 L93-95 | ○ |
| C-06 (UT-ORG-006) | #default?で非デフォルト組織はfalse | E-01 L93-95 | ○ |
| C-07 (UT-ORG-007) | searchで名前検索が可能 | E-01 L72-74 | ○ |
| C-08 (UT-ORG-008) | searchでパス検索が可能 | E-01 L72-74 | ○ |
| C-09 (UT-ORG-009) | search空文字で全件返却 | E-01 L72-74 | ○ |
| C-10 (UT-ORG-010) | scope:without_defaultでデフォルト除外 | E-01 L19 | ○ |
| C-11 (UT-ORG-011) | scope:with_namespace_pathでパス検索 | E-01 L20-22 | ○ |
| C-12 (UT-ORG-012) | scope:with_userでユーザー検索 | E-01 L23-26 | ○ |
| C-13 (UT-ORG-013) | scope:by_pathでパス完全一致 | E-01 L27 | ○ |
| C-14 (UT-ORG-014) | to_paramでパスを返却 | E-01 L97-99 | ○ |
| C-15 (UT-ORG-015) | visibility_level_fieldで:visibility_level | E-01 L85-87 | ○ |
| C-16 (UT-ORG-016) | organization_detailでリレーション取得 | E-01 L46, L89-91 | ○ |
| C-17 (UT-ORG-017) | organization_detailで自動ビルド | E-01 L89-91 | ○ |
| C-18 (UT-ORG-018) | owner_user_idsでオーナーID取得 | E-01 L101-106 | ○ |
| C-19 (UT-ORG-019) | owner_user_idsで空配列 | E-01 L101-106 | ○ |
| C-20 (UT-ORG-020) | user?でメンバー確認true | E-01 L108-110 | ○ |
| C-21 (UT-ORG-021) | user?でメンバー確認false | E-01 L108-110 | ○ |
| C-22 (UT-ORG-022) | owner?でオーナー確認true | E-01 L112-114 | ○ |
| C-23 (UT-ORG-023) | owner?でオーナー確認false | E-01 L112-114 | ○ |
| C-24 (UT-ORG-024) | add_ownerでオーナー追加 | E-01 L116-118 | ○ |
| C-25 (UT-ORG-025) | web_urlでURL生成 | E-01 L120-122 | ○ |
| C-26 (UT-ORG-026) | scoped_paths?でFeature flag確認 | E-01 L127-129 | ○ |
| C-27 (UT-ORG-027) | scoped_paths?でデフォルト組織false | E-01 L127-129 | ○ |
| C-28 (UT-ORG-028) | root_pathでスコープパス有効時 | E-01 L136-140 | ○ |
| C-29 (UT-ORG-029) | root_pathでスコープパス無効時 | E-01 L136-140 | ○ |
| C-30 (UT-ORG-030) | full_pathで/o/{path}形式 | E-01 L144-148 | ○ |
| C-31 (UT-ORG-031) | full_pathでスコープ無効時空文字 | E-01 L144-148 | ○ |
| C-32 (UT-ORG-032) | inspectでデバッグ文字列 | E-01 L131-133 | ○ |
| C-33 (UT-ORG-033) | name presence検証 | E-01 L54-56 | ○ |
| C-34 (UT-ORG-034) | name長さ255文字以内 | E-01 L54-56 | ○ |
| C-35 (UT-ORG-035) | name長さ256文字以上エラー | E-01 L54-56 | ○ |
| C-36 (UT-ORG-036) | path presence検証 | E-01 L58-62 | ○ |
| C-37 (UT-ORG-037) | path uniqueness検証 | E-01 L58-62 | ○ |
| C-38 (UT-ORG-038) | path長さ2文字未満エラー | E-01 L58-62 | ○ |
| C-39 (UT-ORG-039) | path長さ2-255文字OK | E-01 L58-62 | ○ |
| C-40 (UT-ORG-040) | visibility_level検証 | E-01 L64, L153-159 | ○ |
| C-41 (UT-ORG-041) | check_organization_reserved_name | E-01 L65, L164-173 | ○ |
| C-42 (UT-ORG-042) | before_destroy check_if_default_organization | E-01 L29, L175-179 | ○ |
| C-43 (UT-ORG-043) | has_many namespaces | E-01 L31 | ○ |
| C-44 (UT-ORG-044) | has_many groups | E-01 L32 | ○ |
| C-45 (UT-ORG-045) | has_many root_groups | E-01 L33 | ○ |
| C-46 (UT-ORG-046) | has_many projects | E-01 L35 | ○ |
| C-47 (UT-ORG-047) | has_many organization_users | E-01 L48 | ○ |
| C-48 (UT-ORG-048) | has_many users through | E-01 L52 | ○ |
| C-49 (UT-ORG-049) | has_one settings | E-01 L42 | ○ |
| C-50 (UT-ORG-050) | delegate description | E-01 L67 | ○ |
| C-51 (UT-ORG-051) | OrganizationUser belongs_to organization | E-02 L7 | ○ |
| C-52 (UT-ORG-052) | OrganizationUser belongs_to user | E-02 L8 | ○ |
| C-53 (UT-ORG-053) | OrganizationUser user uniqueness | E-02 L10 | ○ |
| C-54 (UT-ORG-054) | access_level presence | E-02 L11 | ○ |
| C-55 (UT-ORG-055) | enum default access_level | E-02 L17-22 | ○ |
| C-56 (UT-ORG-056) | enum owner access_level | E-02 L17-22 | ○ |
| C-57 (UT-ORG-057) | scope owners | E-02 L24 | ○ |
| C-58 (UT-ORG-058) | scope in_organization | E-02 L25 | ○ |
| C-59 (UT-ORG-059) | scope with_active_users | E-02 L26 | ○ |
| C-60 (UT-ORG-060) | scope by_user | E-02 L27 | ○ |
| C-61 (UT-ORG-061) | update_home_organization_record_for | E-02 L29-36 | ○ |
| C-62 (UT-ORG-062) | update_home_organization_record_for admin | E-02 L29-36, L38-44 | ○ |
| C-63 (UT-ORG-063) | home_organization_access_level default | E-02 L38-44 | ○ |
| C-64 (UT-ORG-064) | home_organization_access_level owner | E-02 L38-44 | ○ |
| C-65 (UT-ORG-065) | create_organization_record_for existing | E-02 L46-65 | ○ |
| C-66 (UT-ORG-066) | create_organization_record_for new | E-02 L46-65 | ○ |
| C-67 (UT-ORG-067) | last_owner? true | E-02 L67-74 | ○ |
| C-68 (UT-ORG-068) | last_owner? false with others | E-02 L67-74 | ○ |
| C-69 (UT-ORG-069) | last_owner? false non-owner | E-02 L67-74 | ○ |
| C-70 (UT-ORG-070) | last_owner? with active users | E-02 L71 | ○ |
| C-71 (UT-ORG-071) | ensure_user_has_an_organization | E-02 L82-88 | ○ |
| C-72 (UT-ORG-072) | last_owner_access_level_change | E-02 L90-93 | ○ |
| C-73 (UT-ORG-073) | OrganizationDetail belongs_to | E-03 L11 | ○ |
| C-74 (UT-ORG-074) | organization presence | E-03 L13 | ○ |
| C-75 (UT-ORG-075) | description 1024 OK | E-03 L14 | ○ |
| C-76 (UT-ORG-076) | description 1025 error | E-03 L14 | ○ |
| C-77 (UT-ORG-077) | uploads_sharding_key | E-03 L16-18 | ○ |
| C-78 (UT-ORG-078) | cache_markdown_field | E-03 L9 | ○ |
| C-79 (UT-ORG-079) | OrganizationUserDetail belongs_to org | E-04 L7 | ○ |
| C-80 (UT-ORG-080) | OrganizationUserDetail belongs_to user | E-04 L8 | ○ |
| C-81 (UT-ORG-081) | username presence | E-04 L10 | ○ |
| C-82 (UT-ORG-082) | username uniqueness | E-04 L10 | ○ |
| C-83 (UT-ORG-083) | display_name presence | E-04 L11 | ○ |
| C-84 (UT-ORG-084) | no_namespace_conflicts | E-04 L44-53 | ○ |
| C-85 (UT-ORG-085) | scope for_references | E-04 L15 | ○ |
| C-86 (UT-ORG-086) | scope in_organization | E-04 L16 | ○ |
| C-87 (UT-ORG-087) | scope with_usernames | E-04 L17-24 | ○ |
| C-88 (UT-ORG-088) | with_usernames case insensitive | E-04 L21-23 | ○ |
| C-89 (UT-ORG-089) | with_usernames empty | E-04 L19 | ○ |
| C-90 (UT-ORG-090) | reference_prefix | E-04 L27-29 | ○ |
| C-91 (UT-ORG-091) | reference_pattern | E-04 L31-38 | ○ |
| C-92 (UT-ORG-092) | to_reference | E-04 L40-42 | ○ |
| C-93 (UT-ORG-093) | OrganizationSetting belongs_to | E-05 L6 | ○ |
| C-94 (UT-ORG-094) | settings json_schema | E-05 L7 | ○ |
| C-95 (UT-ORG-095) | restricted_visibility_levels validation | E-05 L13-18 | ○ |
| C-96 (UT-ORG-096) | default_group_visibility exclusion | E-05 L20-24 | ○ |
| C-97 (UT-ORG-097) | default_group_visibility inclusion | E-05 L20-24 | ○ |
| C-98 (UT-ORG-098) | .for existing | E-05 L26-29 | ○ |
| C-99 (UT-ORG-099) | .for new | E-05 L26-29 | ○ |
| C-100 (UT-ORG-100) | .for nil | E-05 L27 | ○ |
| C-101 (UT-ORG-101) | jsonb_accessor default | E-05 L9-11 | ○ |
| C-102 (UT-ORG-102) | jsonb_accessor visibility | E-05 L9-11 | ○ |
| C-103 (UT-ORG-103) | OrganizationIsolation belongs_to | E-06 L5 | ○ |
| C-104 (UT-ORG-104) | organization presence | E-06 L7 | ○ |
| C-105 (UT-ORG-105) | IsolationRecord isolated nil | E-07 L7 | ○ |
| C-106 (UT-ORG-106) | IsolationRecord isolated true | E-07 L7 | ○ |
| C-107 (UT-ORG-107) | IsolationRecord isolated false | E-07 L7 | ○ |
| C-108 (UT-ORG-108) | not_isolated? false | E-07 L9-11 | ○ |
| C-109 (UT-ORG-109) | not_isolated? true | E-07 L9-11 | ○ |
| C-110 (UT-ORG-110) | CreateService execute success | E-08 L5-22 | ○ |
| C-111 (UT-ORG-111) | CreateService owner added | E-08 L26-28 | ○ |
| C-112 (UT-ORG-112) | CreateService no permission | E-08 L6, L30-32 | ○ |
| C-113 (UT-ORG-113) | CreateService feature flag | E-08 L7, L40-43 | ○ |
| C-114 (UT-ORG-114) | CreateService validation error | E-08 L34-38 | ○ |
| C-115 (UT-ORG-115) | UpdateService execute success | E-09 L17-29 | ○ |
| C-116 (UT-ORG-116) | UpdateService remove avatar | E-09 L20-22 | ○ |
| C-117 (UT-ORG-117) | UpdateService no permission | E-09 L18, L37-39 | ○ |
| C-118 (UT-ORG-118) | UpdateService validation error | E-09 L41-45 | ○ |
| C-119 (UT-ORG-119) | BaseService description attr | E-10 L18-25 | ○ |
| C-120 (UT-ORG-120) | BaseService avatar attr | E-10 L18-25 | ○ |
| C-121 (UT-ORG-121) | OrganizationUsers UpdateService success | E-11 L14-21 | ○ |
| C-122 (UT-ORG-122) | OrganizationUsers UpdateService no permission | E-11 L28-30 | ○ |
| C-123 (UT-ORG-123) | OrganizationUsers UpdateService validation error | E-11 L36-40 | ○ |
| C-124 (UT-ORG-124) | Groups TransferService execute success | E-12 L34-52 | ○ |
| C-125 (UT-ORG-125) | Groups TransferService namespaces projects | E-12 L58-71 | ○ |
| C-126 (UT-ORG-126) | Groups TransferService visibility | E-12 L65-66 | ○ |
| C-127 (UT-ORG-127) | Groups TransferService not root error | E-12 L134-136 | ○ |
| C-128 (UT-ORG-128) | Groups TransferService already transferred | E-12 L138-140 | ○ |
| C-129 (UT-ORG-129) | Groups TransferService no admin_group | E-12 L142-147 | ○ |
| C-130 (UT-ORG-130) | Groups TransferService no admin_organization | E-12 L142-147 | ○ |
| C-131 (UT-ORG-131) | Groups TransferService async_execute | E-12 L18-32 | ○ |
| C-132 (UT-ORG-132) | Users TransferService execute success | E-13 L16-39 | ○ |
| C-133 (UT-ORG-133) | Users TransferService namespaces | E-13 L96-99 | ○ |
| C-134 (UT-ORG-134) | Users TransferService projects | E-13 L101-117 | ○ |
| C-135 (UT-ORG-135) | Users TransferService todos | E-13 L119-125 | ○ |
| C-136 (UT-ORG-136) | Users TransferService different orgs | E-13 L62-67 | ○ |
| C-137 (UT-ORG-137) | Users TransferService org not found | E-13 L54-55 | ○ |
| C-138 (UT-ORG-138) | Users TransferService can_transfer_users? true | E-13 L47-52 | ○ |
| C-139 (UT-ORG-139) | Users TransferService can_transfer_users? false | E-13 L47-52 | ○ |
| C-140 (UT-ORG-140) | Users TransferService prepare_bots | E-13 L42-45 | ○ |
| C-141 (UT-ORG-141) | OrganizationsFinder execute | E-14 L16-17 | ○ |
| C-142 (UT-ORG-142) | OrganizationsFinder search | E-14 L32-36 | ○ |
| C-143 (UT-ORG-143) | OrganizationsFinder empty search | E-14 L32-36 | ○ |
| C-144 (UT-ORG-144) | OrganizationUsersFinder execute success | E-15 L15-19 | ○ |
| C-145 (UT-ORG-145) | OrganizationUsersFinder no permission | E-15 L16 | ○ |
| C-146 (UT-ORG-146) | OrganizationUsersFinder nil organization | E-15 L16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、根拠が明確

**注意すべき点：**
1. `Organizations::Concerns::OrganizationUpdater` モジュールは直接読み込んでいないが、TransferServiceで使用されている
2. Feature flag `organization_switching` の有効/無効によるテスト分岐が必要
3. `Gitlab::Access` の定数値（GUEST, OWNER）は外部定義のため、テスト時は実際の値を確認すること

## 6) レビュアーチェックリスト（最小）
- [ ] Organizations::Organizationのバリデーション（name, path, visibility_level）が正しく定義されているか確認
- [ ] オーナー管理（last_owner?、ensure_user_has_an_organization）の境界条件を確認
- [ ] サービス層の権限チェック（can?メソッド呼び出し）が適切に実装されているか確認
- [ ] TransferServiceのトランザクション処理とバッチ処理の整合性を確認
- [ ] Feature flag依存のテストケースについて、フラグ有効/無効の両方をカバーしているか確認
- [ ] jsonb_accessorで定義されたJSONフィールドのスキーマバリデーションを確認
