---
generated_at: 2026-01-22 15:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：package_metadata単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースにコードレベルの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/package_metadata/application_record.rb` - PackageMetadata::ApplicationRecordクラス定義
- E-02: `app/events/package_metadata/ingested_advisory_event.rb` - PackageMetadata::IngestedAdvisoryEventクラス定義
- E-03: `lib/gitlab/event_store/event.rb` - Gitlab::EventStore::Event基底クラス（スキーマバリデーション、data属性の実装）
- E-04: `app/models/application_record.rb` - ::ApplicationRecord基底クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | table_name_prefixがpm_を返す | E-01 (L7-9: `def self.table_name_prefix; 'pm_'; end`) | ○ |
| C-02 | abstract_classがtrue | E-01 (L5: `self.abstract_class = true`) | ○ |
| C-03 | ::ApplicationRecordを継承 | E-01 (L4: `class ApplicationRecord < ::ApplicationRecord`) | ○ |
| C-04 | サブクラスがpm_プレフィックスを持つ | E-01 (table_name_prefixの仕様による) | ○ |
| C-05 | 有効なデータでイベント初期化 | E-02, E-03 (schemaにadvisory_idがinteger型で定義、initializeでvalidate) | ○ |
| C-06 | advisory_id必須バリデーション | E-02 (L11: `'required' => %w[advisory_id]`), E-03 (validate_data!) | ○ |
| C-07 | advisory_id型バリデーション | E-02 (L9: `'type' => 'integer'`), E-03 (JSONSchemer.schema) | ○ |
| C-08 | dataがHashでない場合エラー | E-03 (L59-61: `unless data.is_a?(Hash)`) | ○ |
| C-09 | dataがnilの場合エラー | E-03 (L59: data.is_a?(Hash)でnilはHash扱いにならない) | ○ |
| C-10 | schemaがobject型を定義 | E-02 (L7: `'type' => 'object'`) | ○ |
| C-11 | schemaにadvisory_idプロパティ含む | E-02 (L8-10: properties定義) | ○ |
| C-12 | advisory_idの型がinteger | E-02 (L9: `'type' => 'integer'`) | ○ |
| C-13 | required配列にadvisory_id含む | E-02 (L11: `'required' => %w[advisory_id]`) | ○ |
| C-14 | dataアクセサでデータ取得可能 | E-03 (L30: `attr_reader :data`, L39: `@data = data.with_indifferent_access`) | ○ |
| C-15 | with_indifferent_accessで返却 | E-03 (L39: `@data = data.with_indifferent_access`) | ○ |
| C-16 | Gitlab::EventStore::Eventを継承 | E-02 (L4: `class IngestedAdvisoryEvent < ::Gitlab::EventStore::Event`) | ○ |
| C-17 | advisory_id=0で正常初期化 | E-02, E-03 (integerスキーマは0を許容) | ○ |
| C-18 | advisory_id=-1で正常初期化 | E-02, E-03 (integerスキーマは負値を許容) | ○ |
| C-19 | 大きな値で正常初期化 | E-02, E-03 (integerスキーマは範囲制限なし) | ○ |
| C-20 | 追加プロパティでも初期化可能 | E-02 (additionalProperties指定なし=許容) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースはコード解析に基づいて生成されており、根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - package_metadataモジュールは2つのシンプルなクラスで構成されており、複雑なビジネスロジックは含まれていない
- 注意点：
  - `PackageMetadata::ApplicationRecord`は抽象クラスのため、直接インスタンス化してのテストは不可
  - `IngestedAdvisoryEvent`のテストには`Gitlab::EventStore`の依存関係が必要

## 6) レビュアーチェックリスト（最小）
- [ ] PackageMetadata::ApplicationRecordを継承した具体的なモデルクラスが存在するか確認（現状コード上では見つからず）
- [ ] IngestedAdvisoryEventの発行元・購読者の確認
- [ ] JSONスキーマバリデーションの挙動確認（additionalPropertiesのデフォルト動作）
- [ ] 負のadvisory_idがビジネス上許容されるか確認
