---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 200
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：packages.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：200 / 200、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースはソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/packages/package.rb`
- E-02: `app/models/packages/package_file.rb`
- E-03: `app/models/packages/tag.rb`
- E-04: `app/models/packages/dependency.rb`
- E-05: `app/models/packages/dependency_link.rb`
- E-06: `app/models/packages/build_info.rb`
- E-07: `app/models/packages/event.rb`
- E-08: `app/models/packages/npm/package.rb`
- E-09: `app/models/packages/npm/metadatum.rb`
- E-10: `app/models/packages/npm/metadata_cache.rb`
- E-11: `app/models/packages/maven/package.rb`
- E-12: `app/models/packages/maven/metadatum.rb`
- E-13: `app/models/packages/nuget/package.rb`
- E-14: `app/models/packages/nuget/metadatum.rb`
- E-15: `app/models/packages/nuget/symbol.rb`
- E-16: `app/models/packages/nuget/dependency_link_metadatum.rb`
- E-17: `app/models/packages/pypi/package.rb`
- E-18: `app/models/packages/pypi/metadatum.rb`
- E-19: `app/models/packages/pypi/file_metadatum.rb`
- E-20: `app/models/packages/conan/package.rb`
- E-21: `app/models/packages/conan/metadatum.rb`
- E-22: `app/models/packages/conan/file_metadatum.rb`
- E-23: `app/models/packages/conan/recipe_revision.rb`
- E-24: `app/models/packages/conan/package_revision.rb`
- E-25: `app/models/packages/conan/package_reference.rb`
- E-26: `app/models/packages/helm/package.rb`
- E-27: `app/models/packages/helm/file_metadatum.rb`
- E-28: `app/models/packages/helm/metadata_cache.rb`
- E-29: `app/models/packages/debian/package.rb`
- E-30: `app/models/packages/debian/publication.rb`
- E-31: `app/models/packages/debian/project_distribution.rb`
- E-32: `app/models/packages/debian/group_distribution.rb`
- E-33: `app/models/packages/debian/file_metadatum.rb`
- E-34: `app/models/packages/debian/file_entry.rb`
- E-35: `app/models/packages/cleanup/policy.rb`
- E-36: `app/models/packages/protection/rule.rb`
- E-37: `app/models/packages/rubygems/package.rb`
- E-38: `app/models/packages/rubygems/metadatum.rb`
- E-39: `app/models/packages/cargo/package.rb`
- E-40: `app/models/packages/cargo/metadatum.rb`
- E-41: `app/models/packages/composer/package.rb`
- E-42: `app/models/packages/composer/metadatum.rb`
- E-43: `app/models/packages/composer/sti/package.rb`
- E-44: `app/models/packages/go/package.rb`
- E-45: `app/models/packages/go/module.rb`
- E-46: `app/models/packages/go/module_version.rb`
- E-47: `app/models/packages/generic/package.rb`
- E-48: `app/models/packages/rpm/package.rb`
- E-49: `app/models/packages/rpm/metadatum.rb`
- E-50: `app/models/packages/rpm/repository_file.rb`
- E-51: `app/models/packages/terraform_module/package.rb`
- E-52: `app/models/packages/terraform_module/metadatum.rb`
- E-53: `app/models/packages/ml_model/package.rb`
- E-54: `app/models/packages/package_file_build_info.rb`
- E-55: `app/models/packages/sem_ver.rb`
- E-56: `app/models/concerns/packages/installable.rb`
- E-57: `app/models/concerns/packages/downloadable.rb`
- E-58: `app/models/concerns/packages/destructible.rb`
- E-59: `app/models/concerns/packages/debian/distribution.rb`
- E-60: `app/models/concerns/packages/nuget/version_normalizable.rb`
- E-61: `app/models/concerns/packages/conan/package_fileable.rb`
- E-62: `app/models/concerns/packages/debian/component.rb`
- E-63: `app/models/concerns/packages/debian/architecture.rb`
- E-64: `app/models/concerns/packages/debian/component_file.rb`
- E-65: `app/models/concerns/packages/debian/distribution_key.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Packages::Package#versions - 同名パッケージの他バージョン一覧取得 | E-01 | ○ |
| C-02 | Packages::Package#versions - 自身のバージョン除外 | E-01 | ○ |
| C-03 | Packages::Package#last_build_info - ビルド情報取得 | E-01 | ○ |
| C-04 | Packages::Package#last_build_info - nil時の挙動 | E-01 | ○ |
| C-05 | Packages::Package#pipeline - パイプライン取得 | E-01 | ○ |
| C-06 | Packages::Package#tag_names - タグ名一覧取得 | E-01 | ○ |
| C-07 | Packages::Package#package_settings - 設定取得 | E-01 | ○ |
| C-08 | Packages::Package#create_build_infos! - ビルド情報作成 | E-01 | ○ |
| C-09 | Packages::Package#create_build_infos! - nil入力処理 | E-01 | ○ |
| C-10 | Packages::Package#create_build_infos! - パイプラインなし処理 | E-01 | ○ |
| C-11 | Packages::Package#mark_package_files_for_destruction - 削除マーク | E-01 | ○ |
| C-12 | Packages::Package#mark_package_files_for_destruction - ステータス確認 | E-01 | ○ |
| C-13 | Packages::Package#publish_creation_event - イベント発行 | E-01 | ○ |
| C-14 | Packages::Package#detailed_info? - defaultステータス | E-01 | ○ |
| C-15 | Packages::Package#detailed_info? - processingステータス | E-01 | ○ |
| C-16 | Packages::Package.by_name_and_file_name - 検索成功 | E-01 | ○ |
| C-17 | Packages::Package.by_name_and_file_name - RecordNotFound | E-01 | ○ |
| C-18 | Packages::Package.by_name_and_version! - 検索成功 | E-01 | ○ |
| C-19 | Packages::Package.sort_by_attribute - ソート機能 | E-01 | ○ |
| C-20 | Packages::Package.sort_by_attribute - デフォルトソート | E-01 | ○ |
| C-21 | Packages::Package validates :name - 存在チェック | E-01 | ○ |
| C-22 | Packages::Package validates :name - nil時エラー | E-01 | ○ |
| C-23 | Packages::Package validates :project - nil時エラー | E-01 | ○ |
| C-24 | Packages::Package uniqueness - 成功 | E-01 | ○ |
| C-25 | Packages::Package uniqueness - 重複エラー | E-01 | ○ |
| C-26 | Packages::PackageFile#download_path | E-02 | ○ |
| C-27 | Packages::PackageFile#file_name_for_download | E-02 | ○ |
| C-28 | Packages::PackageFile.most_recent! - 成功 | E-02 | ○ |
| C-29 | Packages::PackageFile.most_recent! - RecordNotFound | E-02 | ○ |
| C-30 | Packages::PackageFile.most_recent_for | E-02 | ○ |
| C-31-36 | Packages::PackageFile バリデーション | E-02 | ○ |
| C-37-40 | Packages::Tag バリデーションとメソッド | E-03 | ○ |
| C-41-46 | Packages::Dependency メソッドとバリデーション | E-04 | ○ |
| C-47-50 | Packages::DependencyLink バリデーションとスコープ | E-05 | ○ |
| C-51-52 | Packages::BuildInfo リレーション | E-06 | ○ |
| C-53-56 | Packages::Event イベント許可判定 | E-07 | ○ |
| C-57-63 | Packages::Npm::Package バリデーションとメソッド | E-08 | ○ |
| C-64-65 | Packages::Npm::Metadatum バリデーション | E-09 | ○ |
| C-66-68 | Packages::Npm::MetadataCache 検索とキー生成 | E-10 | ○ |
| C-69-74 | Packages::Maven::Package/Metadatum | E-11, E-12 | ○ |
| C-75-85 | Packages::Nuget 関連クラス | E-13, E-14, E-15, E-16 | ○ |
| C-86-91 | Packages::Pypi 関連クラス | E-17, E-18, E-19 | ○ |
| C-92-115 | Packages::Conan 関連クラス | E-20, E-21, E-22, E-23, E-24, E-25 | ○ |
| C-116-122 | Packages::Helm 関連クラス | E-26, E-27, E-28 | ○ |
| C-123-137 | Packages::Debian 関連クラス | E-29, E-30, E-31, E-32, E-33, E-34 | ○ |
| C-138-143 | Packages::Cleanup::Policy | E-35 | ○ |
| C-144-148 | Packages::Protection::Rule | E-36 | ○ |
| C-149-150 | Packages::Rubygems 関連クラス | E-37, E-38 | ○ |
| C-151-157 | Packages::Cargo 関連クラス | E-39, E-40 | ○ |
| C-158-161 | Packages::Composer 関連クラス | E-41, E-42, E-43 | ○ |
| C-162-173 | Packages::Go 関連クラス | E-44, E-45, E-46 | ○ |
| C-174-176 | Packages::Generic::Package | E-47 | ○ |
| C-177-183 | Packages::Rpm 関連クラス | E-48, E-49, E-50 | ○ |
| C-184-187 | Packages::TerraformModule 関連クラス | E-51, E-52 | ○ |
| C-188-190 | Packages::MlModel::Package | E-53 | ○ |
| C-191-198 | Packages::SemVer | E-55 | ○ |
| C-199 | Packages::Installable scope | E-56 | ○ |
| C-200 | Packages::Downloadable touch_last_downloaded_at | E-57 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードから直接抽出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいています
- 注意点:
  - Packages::Go::Module と ModuleVersion は ApplicationRecord を継承していないPORO（Plain Old Ruby Object）であり、DBに永続化されません
  - Packages::SemVer もPOROです
  - 各パッケージタイプ固有のバリデーションは正規表現（Gitlab::Regex）に依存しており、正規表現の変更時はテストケースの見直しが必要です

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度のバリデーションテスト（必須チェック、一意性チェック）が網羅されているか確認
- [ ] 各パッケージタイプ（npm, maven, nuget, pypi, conan, helm, debian, cargo, composer, go, generic, rpm, terraform_module, ml_model, rubygems）のテストケースが存在するか確認
- [ ] 正常系・異常系・境界値のテスト観点が各メソッドでカバーされているか確認
- [ ] リレーション（belongs_to, has_many, has_one）のテストケースが存在するか確認
- [ ] スコープメソッドのテストケースが存在するか確認
- [ ] 実際のテスト実装時に、モック/スタブの設計が適切か確認
