---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：pages モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-PAG-035（has_valid_intermediates?）**：OpenSSL検証ロジックの詳細な動作確認が必要
  2. **UT-PAG-117（ObtainLetsEncryptCertificateService invalid状態）**：ACME API応答の詳細仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/pages_deployment.rb` - PagesDeploymentモデル定義
- E-02: `app/models/pages_domain.rb` - PagesDomainモデル定義
- E-03: `app/models/pages_domain_acme_order.rb` - PagesDomainAcmeOrderモデル定義
- E-04: `app/models/pages/project_settings.rb` - Pages::ProjectSettings定義
- E-05: `app/models/pages/lookup_path.rb` - Pages::LookupPath定義
- E-06: `app/models/pages/virtual_domain.rb` - Pages::VirtualDomain定義
- E-07: `app/services/pages/delete_service.rb` - Pages::DeleteService定義
- E-08: `app/services/pages/update_service.rb` - Pages::UpdateService定義
- E-09: `app/services/pages/destroy_deployments_service.rb` - Pages::DestroyDeploymentsService定義
- E-10: `app/services/pages/domains/create_service.rb` - Pages::Domains::CreateService定義
- E-11: `app/services/pages/domains/update_service.rb` - Pages::Domains::UpdateService定義
- E-12: `app/services/pages/domains/delete_service.rb` - Pages::Domains::DeleteService定義
- E-13: `app/services/pages/domains/create_acme_order_service.rb` - Pages::Domains::CreateAcmeOrderService定義
- E-14: `app/services/pages/domains/retry_acme_order_service.rb` - Pages::Domains::RetryAcmeOrderService定義
- E-15: `app/services/pages/domains/obtain_lets_encrypt_certificate_service.rb` - Pages::Domains::ObtainLetsEncryptCertificateService定義
- E-16: `app/finders/pages/deployments_finder.rb` - Pages::DeploymentsFinder定義
- E-17: `lib/gitlab/pages/url_builder.rb` - Gitlab::Pages::UrlBuilder定義
- E-18: `lib/gitlab/pages/settings.rb` - Gitlab::Pages::Settings定義
- E-19: `lib/gitlab/pages/random_domain.rb` - Gitlab::Pages::RandomDomain定義
- E-20: `lib/gitlab/pages/virtual_host_finder.rb` - Gitlab::Pages::VirtualHostFinder定義
- E-21: `lib/gitlab/pages/deployment_validations.rb` - Gitlab::Pages::DeploymentValidations定義

## 3) Claims と根拠の対応（レビューの主戦場）

### PagesDeployment (UT-PAG-001 - UT-PAG-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | active?メソッドはdeleted_atがnilの場合trueを返す | E-01 (L84-86) | ○ |
| C-02 | active?メソッドはdeleted_atが設定されている場合falseを返す | E-01 (L84-86) | ○ |
| C-03 | urlメソッドはGitlab::Pages::UrlBuilderを使用してURLを生成 | E-01 (L88-92) | ○ |
| C-04 | urlメソッドはpath_prefixをオプションとして渡す | E-01 (L90) | ○ |
| C-05 | deactivateメソッドはdeleted_atを現在時刻に設定 | E-01 (L94-96) | ○ |
| C-06 | restoreメソッドはdeleted_atをnilに設定 | E-01 (L98-101) | ○ |
| C-07 | restoreメソッドは同path_prefixの他デプロイメントを非アクティブ化 | E-01 (L128-130) | ○ |
| C-08 | deactivate_allはプロジェクトの全アクティブデプロイメントを非アクティブ化 | E-01 (L58-63) | ○ |
| C-09 | deactivate_deployments_older_thanは指定より古いものを非アクティブ化 | E-01 (L65-72) | ○ |
| C-10 | latest_pipeline_idは最新のcommit_idを返す | E-01 (L54-56) | ○ |
| C-11 | count_versioned_deployments_forはバージョン付きデプロイメント数を返す | E-01 (L78-82) | ○ |
| C-12 | scope:older_thanは指定IDより小さいレコードを返す | E-01 (L22) | ○ |
| C-13 | scope:activeはupload_ready=trueかつdeleted_at=nilのレコードを返す | E-01 (L31) | ○ |
| C-14 | scope:expiredはexpires_atが過去のレコードを返す | E-01 (L32) | ○ |
| C-15 | scope:versionedはpath_prefixが空でないレコードを返す | E-01 (L34) | ○ |
| C-16 | scope:unversionedはpath_prefixが空またはnilのレコードを返す | E-01 (L35) | ○ |
| C-17 | fileがnilの場合バリデーションエラー | E-01 (L37) | ○ |
| C-18 | sizeが0以下の場合バリデーションエラー | E-01 (L39) | ○ |
| C-19 | file_countが0の場合バリデーション成功 | E-01 (L40) | ○ |
| C-20 | file_countが負の場合バリデーションエラー | E-01 (L40) | ○ |

### PagesDomain (UT-PAG-021 - UT-PAG-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | verified?はverified_atが設定されている場合trueを返す | E-02 (L92-94) | ○ |
| C-22 | verified?はverified_atがnilの場合falseを返す | E-02 (L92-94) | ○ |
| C-23 | unverified?はverified?の逆を返す | E-02 (L96-98) | ○ |
| C-24 | enabled?はドメイン検証無効時trueを返す | E-02 (L100-102) | ○ |
| C-25 | enabled?はenabled_untilが設定されている場合trueを返す | E-02 (L100-102) | ○ |
| C-26 | https?はcertificateが存在する場合trueを返す | E-02 (L104-106) | ○ |
| C-27 | https?はcertificateがnilの場合falseを返す | E-02 (L104-106) | ○ |
| C-28 | urlはHTTPS時https://で始まるURLを返す | E-02 (L112-120) | ○ |
| C-29 | urlはHTTP時http://で始まるURLを返す | E-02 (L112-120) | ○ |
| C-30 | urlはdomainがnilの場合nilを返す | E-02 (L113) | ○ |
| C-31 | to_paramはdomain値を返す | E-02 (L108-110) | ○ |
| C-32 | has_matching_key?は証明書と鍵が一致する場合trueを返す | E-02 (L122-128) | ○ |
| C-33 | has_matching_key?は不一致の場合falseを返す | E-02 (L122-128) | ○ |
| C-34 | has_matching_key?はx509がnilの場合falseを返す | E-02 (L123) | ○ |
| C-35 | has_valid_intermediates?は自己署名証明書でtrueを返す | E-02 (L130-150) | △ |
| C-36 | has_valid_intermediates?は有効な中間証明書でtrueを返す | E-02 (L130-150) | ○ |
| C-37 | expired?は有効期限内でfalseを返す | E-02 (L156-161) | ○ |
| C-38 | expired?は期限切れでtrueを返す | E-02 (L156-161) | ○ |
| C-39 | expired?は未来開始証明書でtrueを返す | E-02 (L160) | ○ |
| C-40 | expirationは証明書のnot_afterを返す | E-02 (L163-165) | ○ |
| C-41 | subjectは証明書のsubjectを返す | E-02 (L167-171) | ○ |
| C-42 | verification_domainは検証用ドメイン名を正しく生成 | E-02 (L179-183) | ○ |
| C-43 | verification_domainはdomainがnilの場合nilを返す | E-02 (L180) | ○ |
| C-44 | keyed_verification_codeは正しいフォーマットで返す | E-02 (L185-189) | ○ |
| C-45 | verification_recordは完全なTXTレコード文字列を返す | E-02 (L191-193) | ○ |
| C-46 | certificate=設定時にvalid_not_before/afterが自動設定 | E-02 (L195-201) | ○ |
| C-47 | user_provided_key=設定時にcertificate_sourceがuser_provided | E-02 (L207-210) | ○ |
| C-48 | gitlab_provided_certificate=設定時にcertificate_sourceがgitlab_provided | E-02 (L221-224) | ○ |
| C-49 | clear_auto_ssl_failureはauto_ssl_failedをfalseに設定 | E-02 (L231-233) | ○ |
| C-50 | pages_deployed?はプロジェクトのデプロイ状態を返す | E-02 (L245-247) | ○ |
| C-51 | domain重複時バリデーションエラー | E-02 (L29) | ○ |
| C-52 | Pages root domainサブドメイン時バリデーションエラー | E-02 (L277-284) | ○ |
| C-53 | 最大ドメイン数超過時バリデーションエラー | E-02 (L235-243) | ○ |
| C-54 | 証明書と鍵不一致時エラー | E-02 (L267-271) | ○ |
| C-55 | 鍵が長すぎる場合バリデーションエラー | E-02 (L251-259) | ○ |
| C-56 | scope:enabledはenabled_untilが現在以降のレコードを返す | E-02 (L57) | ○ |
| C-57 | scope:needs_verificationは検証が必要なレコードを返す | E-02 (L58-64) | ○ |
| C-58 | scope:need_auto_ssl_renewalはSSL更新必要レコードを返す | E-02 (L67-76) | ○ |
| C-59 | scope:for_removalは削除対象レコードを返す | E-02 (L78) | ○ |
| C-60 | find_by_domain_case_insensitiveは大文字小文字無視で検索 | E-02 (L84-86) | ○ |

### PagesDomainAcmeOrder (UT-PAG-061 - UT-PAG-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | scope:expiredは期限切れオーダーを返す | E-03 (L8) | ○ |
| C-62 | pages_domainがnilの場合バリデーションエラー | E-03 (L10) | ○ |
| C-63 | expires_atがnilの場合バリデーションエラー | E-03 (L11) | ○ |
| C-64 | urlがnilの場合バリデーションエラー | E-03 (L12) | ○ |
| C-65 | challenge_tokenがnilの場合バリデーションエラー | E-03 (L13) | ○ |
| C-66 | find_by_domain_and_tokenでドメインとトークンで検索可能 | E-03 (L23-25) | ○ |
| C-67 | find_by_domain_and_tokenは存在しない場合nilを返す | E-03 (L23-25) | ○ |

### Pages::ProjectSettings (UT-PAG-068 - UT-PAG-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | urlはproject.pages_urlを返す | E-04 (L9) | ○ |
| C-69 | deploymentsはアクティブなデプロイメントを返す | E-04 (L11) | ○ |
| C-70 | unique_domain_enabled?はユニークドメイン設定を返す | E-04 (L13) | ○ |
| C-71 | force_https?はHTTPS強制設定を返す | E-04 (L15) | ○ |
| C-72 | pages_primary_domainはプライマリドメイン設定を返す | E-04 (L17) | ○ |

### Pages::LookupPath (UT-PAG-073 - UT-PAG-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | project_idはプロジェクトIDを返す | E-05 (L18-21) | ○ |
| C-74 | https_onlyはプロジェクトとドメイン両方HTTPSでtrueを返す | E-05 (L23-27) | ○ |
| C-75 | https_onlyはどちらかHTTPでfalseを返す | E-05 (L23-27) | ○ |
| C-76 | sourceはデプロイメントファイル情報を返す | E-05 (L29-45) | ○ |
| C-77 | sourceはファイルがない場合nilを返す | E-05 (L30) | ○ |
| C-78 | prefixは先頭と末尾にスラッシュを付与 | E-05 (L85-90) | ○ |
| C-79 | unique_hostはユニークドメイン有効時ホストを返す | E-05 (L52-61) | ○ |
| C-80 | unique_hostはカスタムドメイン使用時nilを返す | E-05 (L57) | ○ |
| C-81 | root_directoryはデプロイメントのroot_directoryを返す | E-05 (L63-68) | ○ |
| C-82 | primary_domainはプライマリドメインを返す | E-05 (L70-73) | ○ |

### Pages::VirtualDomain (UT-PAG-083 - UT-PAG-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | certificateはドメインの証明書を返す | E-06 (L14-16) | ○ |
| C-84 | certificateはドメインがnilの場合nilを返す | E-06 (L15) | ○ |
| C-85 | keyはドメインの鍵を返す | E-06 (L18-20) | ○ |
| C-86 | root_namespace_idはルートネームスペースIDを返す | E-06 (L22-24) | ○ |
| C-87 | lookup_pathsはプロジェクトごとのLookupPathを返す | E-06 (L26-28) | ○ |
| C-88 | lookup_pathsは複数バージョン有効時全デプロイメントを含む | E-06 (L59-71) | ○ |
| C-89 | lookup_pathsは複数バージョン無効時path_prefix空のみ含む | E-06 (L64-69) | ○ |

### Pages::DeleteService (UT-PAG-090 - UT-PAG-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | execute権限ありでデプロイメントが非アクティブ化 | E-07 (L5-20) | ○ |
| C-91 | execute権限なしでエラーを返す | E-07 (L6-9) | ○ |
| C-92 | executeでPagesDomainが削除される | E-07 (L17) | ○ |

### Pages::UpdateService (UT-PAG-093 - UT-PAG-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | execute権限ありで設定が更新される | E-08 (L7-18) | ○ |
| C-94 | execute権限なしでエラーを返す | E-08 (L8-11) | ○ |
| C-95 | pages_https_onlyが更新される | E-08 (L30-34) | ○ |
| C-96 | pages_unique_domain_enabledが更新される | E-08 (L23-28) | ○ |

### Pages::DestroyDeploymentsService (UT-PAG-097 - UT-PAG-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | executeで全デプロイメントが削除される | E-09 (L10-14) | ○ |
| C-98 | last_deployment_id指定時は古いもののみ削除 | E-09 (L12) | ○ |

### Pages::Domains::CreateService (UT-PAG-099 - UT-PAG-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | execute権限ありでドメインが作成される | E-10 (L6-28) | ○ |
| C-100 | execute権限なしでnilを返す | E-10 (L7) | ○ |
| C-101 | 重複ドメインの場合エラーが設定される | E-10 (L9-21) | ○ |
| C-102 | 作成成功時イベントが発行される | E-10 (L25, L40-52) | ○ |

### Pages::Domains::UpdateService (UT-PAG-103 - UT-PAG-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | execute権限ありでドメインが更新される | E-11 (L6-14) | ○ |
| C-104 | execute権限なしでnilを返す | E-11 (L7) | ○ |
| C-105 | 更新成功時イベントが発行される | E-11 (L11, L22-34) | ○ |

### Pages::Domains::DeleteService (UT-PAG-106 - UT-PAG-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | execute権限ありでドメインが削除される | E-12 (L6-12) | ○ |
| C-107 | execute権限なしでnilを返す | E-12 (L7) | ○ |
| C-108 | 削除成功時イベントが発行される | E-12 (L11, L20-32) | ○ |

### Pages::Domains::CreateAcmeOrderService (UT-PAG-109 - UT-PAG-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | executeでACMEオーダーが作成される | E-13 (L12-30) | ○ |
| C-110 | ACMEエラー時エラーレスポンスを返す | E-13 (L31-33) | ○ |

### Pages::Domains::RetryAcmeOrderService (UT-PAG-111 - UT-PAG-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | executeでauto_ssl_failedがリセットされる | E-14 (L12-17) | ○ |
| C-112 | executeでワーカーがエンキューされる | E-14 (L21) | ○ |
| C-113 | auto_ssl_enabled=falseの場合処理されない | E-14 (L14) | ○ |

### Pages::Domains::ObtainLetsEncryptCertificateService (UT-PAG-114 - UT-PAG-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | 既存オーダーがない場合新規作成される | E-15 (L24-33) | ○ |
| C-115 | ready状態の場合証明書リクエストされる | E-15 (L40-42) | ○ |
| C-116 | valid状態の場合証明書が保存される | E-15 (L43-45) | ○ |
| C-117 | invalid状態の場合エラーが保存される | E-15 (L46-47) | △ |

### Pages::DeploymentsFinder (UT-PAG-118 - UT-PAG-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | Project親でプロジェクトのデプロイメントを返す | E-16 (L30-32) | ○ |
| C-119 | Namespace親でネームスペース内全デプロイメントを返す | E-16 (L34-36) | ○ |
| C-120 | 不正な親で例外をスロー | E-16 (L27) | ○ |
| C-121 | active=trueでアクティブのみフィルタ | E-16 (L38-42) | ○ |
| C-122 | active=falseで非アクティブのみフィルタ | E-16 (L41) | ○ |
| C-123 | versioned=trueでバージョン付きのみフィルタ | E-16 (L44-48) | ○ |
| C-124 | sortパラメータでソート順変更 | E-16 (L50-52) | ○ |

### Gitlab::Pages::UrlBuilder (UT-PAG-125 - UT-PAG-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | pages_urlは正しいPages URLを生成 | E-17 (L18-21) | ○ |
| C-126 | unique_hostはユニークドメイン有効時ホストを返す | E-17 (L23-28) | ○ |
| C-127 | unique_hostはユニークドメイン無効時nilを返す | E-17 (L24-25) | ○ |
| C-128 | is_namespace_homepage?はプロジェクトパスがホストと一致でtrue | E-17 (L35-38) | ○ |
| C-129 | artifact_urlは許可拡張子でURLを生成 | E-17 (L41-49) | ○ |
| C-130 | artifact_urlは許可されない拡張子でnilを返す | E-17 (L51-56) | ○ |
| C-131 | hostnameはサブドメイン付きホストを返す | E-17 (L59-65) | ○ |
| C-132 | path_prefixはslugify済みprefixを返す | E-17 (L67-71) | ○ |

### Gitlab::Pages::Settings (UT-PAG-133 - UT-PAG-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | pathはdisk_access許可時パスを返す | E-18 (L8-12) | ○ |
| C-134 | pathはdisk_access拒否時例外をトラック | E-18 (L22-25) | ○ |

### Gitlab::Pages::RandomDomain (UT-PAG-135 - UT-PAG-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | generateはランダムドメインを生成 | E-19 (L22-29) | ○ |
| C-136 | generateは長いパスを56文字に切り詰め | E-19 (L23) | ○ |
| C-137 | generateは結果がslugify形式 | E-19 (L29) | ○ |

### Gitlab::Pages::VirtualHostFinder (UT-PAG-138 - UT-PAG-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | executeはGitLabホストサフィックスでVirtualDomainを返す | E-20 (L10-21) | ○ |
| C-139 | executeはユニークドメインでプロジェクトVirtualDomainを返す | E-20 (L28-34) | ○ |
| C-140 | executeはカスタムドメインでドメインVirtualDomainを返す | E-20 (L48-59) | ○ |
| C-141 | executeは存在しないホストでnilを返す | E-20 (L48-52) | ○ |
| C-142 | executeはhostがnilの場合nilを返す | E-20 (L11) | ○ |

### Gitlab::Pages::DeploymentValidations (UT-PAG-143 - UT-PAG-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | valid?は有効なビルドでtrueを返す | E-21 (L11-18) | ○ |
| C-144 | validate_stateはアーティファクトなしでエラー追加 | E-21 (L43-46) | ○ |
| C-145 | validate_stateはメタデータなしでエラー追加 | E-21 (L45) | ○ |
| C-146 | validate_max_sizeはサイズ超過でエラー追加 | E-21 (L48-52) | ○ |
| C-147 | validate_public_folderはpublicなしでエラー追加 | E-21 (L81-88) | ○ |
| C-148 | validate_max_entriesはエントリ数超過でエラー追加 | E-21 (L71-79) | ○ |
| C-149 | validate_outdated_shaは古いSHAでエラー追加 | E-21 (L91-97) | ○ |
| C-150 | latest_build?は最新SHAでtrueを返す | E-21 (L25-29) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-35 (has_valid_intermediates?)**: OpenSSLのX509::Store検証の詳細な動作仕様の確認が推奨される
  - 候補：OpenSSL Ruby gem ドキュメント / OpenSSL公式ドキュメント / RFCドキュメント
- **C-117 (ObtainLetsEncryptCertificateService invalid状態)**: ACME API (RFC 8555) のinvalid状態時の詳細な応答仕様
  - 候補：RFC 8555 / Let's Encrypt API ドキュメント / Acme::Client gem ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大半のテストケース（140件）- 直接的なコード対応あり
- **1 (中リスク)**: 証明書関連テスト（8件）- 外部ライブラリ依存
- **2 (高リスク)**: ACME/Let's Encrypt関連（2件）- 外部API依存、実行時の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] PagesDeploymentのスコープ定義（active, expired, versioned等）が実際のSQL条件と一致しているか確認
- [ ] PagesDomainの証明書検証ロジック（has_matching_key?, has_valid_intermediates?）の動作を実際の証明書で確認
- [ ] 権限チェック（can?）のポリシー定義との整合性確認
- [ ] ACME/Let's Encryptサービスの外部API依存部分のモック戦略確認
- [ ] Gitlab::Pages::UrlBuilderのURL生成パターン（namespace_in_path, unique_domain等）の組み合わせテスト網羅性確認
- [ ] Pages::VirtualDomainの複数バージョン対応ロジックの境界条件確認
