---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：postgresql.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **UT-PGS-029**：table_nameがnilの場合の挙動が未定義
  2. **UT-PGS-031**：存在しないテーブル名の場合の挙動がGitlabSchema依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/postgresql/replication_slot.rb` (93行)
- E-02: `app/models/postgresql/detached_partition.rb` (15行)
- E-03: `spec/models/postgresql/replication_slot_spec.rb` (127行)
- E-04: `spec/models/postgresql/detached_partition_spec.rb` (19行)
- E-05: PostgreSQL公式ドキュメント - pg_replication_slots システムビュー
- E-06: PostgreSQL公式ドキュメント - pg_wal_lsn_diff関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-PGS-001) | .in_use?がtrueを返す | E-01 (L10-14), E-03 (L9-12) | ○ |
| C-02 (UT-PGS-002) | .in_use?がfalseを返す | E-01 (L10-14), E-03 (L14-16) | ○ |
| C-03 (UT-PGS-003) | StatementInvalid時にfalse | E-01 (L12-13), E-03 (L18-21) | ○ |
| C-04 (UT-PGS-004) | lag_too_great?がtrue（閾値超過） | E-01 (L22-41), E-03 (L33-38) | ○ |
| C-05 (UT-PGS-005) | lag_too_great?がfalse（閾値以下） | E-01 (L22-41), E-03 (L49-54) | ○ |
| C-06 (UT-PGS-006) | 複数レプリカで一部遅延時の判定 | E-01 (L36-38), E-03 (L41-46) | ○ |
| C-07 (UT-PGS-007) | 全レプリカ遅延時の判定 | E-01 (L36-38) | ○ |
| C-08 (UT-PGS-008) | 未使用時にfalse | E-01 (L23) | ○ |
| C-09 (UT-PGS-009) | nilラグ値のハンドリング | E-01 (L31), E-03 (L57-63) | ○ |
| C-10 (UT-PGS-010) | カスタム閾値の適用 | E-01 (L22) | ○ |
| C-11 (UT-PGS-011) | .countが総数を返す | E-01 (L43-49), E-03 (L99-103) | ○ |
| C-12 (UT-PGS-012) | .countが0を返す（空時） | E-01 (L43-49) | ○ |
| C-13 (UT-PGS-013) | .unused_slots_countの動作 | E-01 (L51-57), E-03 (L105-108) | ○ |
| C-14 (UT-PGS-014) | 全使用中時に0 | E-01 (L51-57) | ○ |
| C-15 (UT-PGS-015) | .used_slots_countの動作 | E-01 (L59-65) | ○ |
| C-16 (UT-PGS-016) | 全未使用時に0 | E-01 (L59-65) | ○ |
| C-17 (UT-PGS-017) | .slots_retained_bytesの動作 | E-01 (L70-77), E-03 (L117-123) | ○ |
| C-18 (UT-PGS-018) | 空テーブル時の詳細取得 | E-01 (L70-77) | ○ |
| C-19 (UT-PGS-019) | .max_retained_walの動作 | E-01 (L80-85), E-03 (L111-114) | ○ |
| C-20 (UT-PGS-020) | 空テーブル時のCOALESCE | E-01 (L81) | ○ |
| C-21 (UT-PGS-021) | .max_replication_slotsの動作 | E-01 (L87-91), E-03 (L66-69) | ○ |
| C-22 (UT-PGS-022) | テーブル名設定 | E-01 (L5) | ○ |
| C-23 (UT-PGS-023) | SharedModel継承 | E-01 (L4), E-03 (L6) | ○ |
| C-24 (UT-PGS-024) | .ready_to_dropスコープ（過去） | E-02 (L5), E-04 (L7-11) | ○ |
| C-25 (UT-PGS-025) | .ready_to_dropスコープ（未来除外） | E-02 (L5), E-04 (L13-16) | ○ |
| C-26 (UT-PGS-026) | 境界値（現在時刻）の扱い | E-02 (L5) | ○ |
| C-27 (UT-PGS-027) | 該当なし時の挙動 | E-02 (L5) | ○ |
| C-28 (UT-PGS-028) | #fully_qualified_table_name | E-02 (L7-9) | ○ |
| C-29 (UT-PGS-029) | table_nameがnil時の挙動 | **根拠なし** | △ |
| C-30 (UT-PGS-030) | #table_schemaの動作 | E-02 (L11-13) | ○ |
| C-31 (UT-PGS-031) | 存在しないテーブル名の処理 | **根拠なし** | △ |
| C-32 (UT-PGS-032) | DetachedPartitionのSharedModel継承 | E-02 (L4) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-PGS-029**: `table_name`がnilの場合の挙動についてコード上明示的なバリデーションが存在しない
  - 候補：モデルのバリデーション追加 / nil時のエラーハンドリング確認 / 実際のDB制約確認
- **UT-PGS-031**: `Gitlab::Database::GitlabSchema.table_schema`の内部実装に依存
  - 候補：GitlabSchemaクラスの実装確認 / 存在しないテーブル時の戻り値確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ReplicationSlotクラス：PostgreSQLシステムビューへの読み取り専用アクセスのため、データ整合性への影響は低い
- **1: 中リスク** - DetachedPartitionクラス：パーティション削除に関わるため、ready_to_dropスコープの条件が重要
- **0: 低リスク** - 全体的に既存テストスペック（E-03, E-04）と高い整合性を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] UT-PGS-004〜007：lag_too_great?のロジックが本番環境のレプリカ構成と整合しているか
- [ ] UT-PGS-024〜027：ready_to_dropスコープの条件（`<`）が要件と一致しているか
- [ ] UT-PGS-028：DYNAMIC_PARTITIONS_SCHEMA定数の値が環境ごとに正しいか
- [ ] UT-PGS-029：table_nameがnilの場合のエラーハンドリング要否を確認
- [ ] UT-PGS-031：GitlabSchemaの依存関係とエラー時の挙動を確認
