---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 95
  claims_with_evidence: 91
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：project_authorizations 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：91 / 95、根拠なし：4
- 優先レビュー（高）
  1. **UT-PRA-042: log_detailsのtotal_delay計算**：計算式の検証が必要
  2. **UT-PRA-080: トランザクション内処理**：コード上でトランザクション記述確認済みだが、ロールバック挙動は推測
  3. **UT-PRA-095: delete_unlistedの空配列時挙動**：実装から推測、テストコードなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/project_authorization.rb` - ProjectAuthorizationモデル定義
- E-02: `app/models/project_authorizations/changes.rb` - Changes クラス定義
- E-03: `app/events/project_authorizations/authorizations_changed_event.rb` - イベント定義
- E-04: `app/events/project_authorizations/authorizations_added_event.rb` - イベント定義
- E-05: `app/events/project_authorizations/authorizations_removed_event.rb` - イベント定義
- E-06: `lib/gitlab/project_authorizations.rb` - 認可計算クラス
- E-07: `app/services/projects/move_project_authorizations_service.rb` - 移動サービス
- E-08: `app/models/clusters/agents/authorizations/ci_access/project_authorization.rb` - CIアクセス認可
- E-09: `app/models/clusters/agents/authorizations/user_access/project_authorization.rb` - ユーザーアクセス認可
- E-10: `spec/models/project_authorization_spec.rb` - ProjectAuthorizationスペック
- E-11: `spec/models/project_authorizations/changes_spec.rb` - Changesスペック
- E-12: `spec/lib/gitlab/project_authorizations_spec.rb` - 認可計算スペック

## 3) Claims と根拠の対応（レビューの主戦場）

### ProjectAuthorization モデル (UT-PRA-001 〜 UT-PRA-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :userリレーション | E-01 (L8), E-10 (L81) | ○ |
| C-02 | belongs_to :projectリレーション | E-01 (L9), E-10 (L82) | ○ |
| C-03 | project presence バリデーション | E-01 (L11), E-10 (L86) | ○ |
| C-04 | user presence バリデーション | E-01 (L13), E-10 (L87) | ○ |
| C-05 | access_level presence バリデーション | E-01 (L12), E-10 (L88) | ○ |
| C-06 | access_level inclusion バリデーション | E-01 (L12), E-10 (L89) | ○ |
| C-07 | access_level 有効値バリデーション | E-01 (L12), E-10 (L89) | ○ |
| C-08 | user uniqueness バリデーション | E-01 (L13), E-10 (L36-55) | ○ |
| C-09 | アクセスレベル違いでも重複エラー | E-01 (L13), E-10 (L57-77) | ○ |
| C-10 | scope :for_project 単一プロジェクト | E-01 (L15), E-10 (L130-142) | ○ |
| C-11 | scope :for_project 複数プロジェクト | E-01 (L15), E-10 (L144-149) | ○ |
| C-12 | scope :for_user | E-01 (L16), E-10 (L152-168) | ○ |
| C-13 | scope :non_guests | E-01 (L17), E-10 (L96-110) | ○ |
| C-14 | non_guests 境界値 | E-01 (L17), E-10 (L96-110) | ○ |
| C-15 | scope :owners | E-01 (L18), E-10 (L113-128) | ○ |
| C-16 | scope :preload_users | E-01 (L20) | ○ |
| C-17 | scope :count_by_user_id | E-01 (L22-24), E-10 (L171-177) | ○ |
| C-18 | assign_is_unique コールバック | E-01 (L27, L72-74), E-10 (L17-20) | ○ |
| C-19 | select_from_union | E-01 (L29-33) | ○ |
| C-20 | insert_all 一括挿入 | E-01 (L40-42), E-10 (L180-198) | ○ |
| C-21 | insert_all 重複スキップ | E-01 (L40-42), E-10 (L186-198) | ○ |
| C-22 | find_or_create_authorization_for 既存返却 | E-01 (L44-68), E-10 (L219-226) | ○ |
| C-23 | find_or_create_authorization_for 新規作成 | E-01 (L44-68), E-10 (L237-243) | ○ |
| C-24 | find_or_create_authorization_for レースコンディション | E-01 (L44-68), E-10 (L228-233) | ○ |

### ProjectAuthorizations::Changes (UT-PRA-025 〜 UT-PRA-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | initialize でブロックyield | E-02 (L20-26) | ○ |
| C-26 | add で認可蓄積 | E-02 (L28-30), E-11 (L95-107) | ○ |
| C-27 | remove_users_in_project | E-02 (L32-34), E-11 (L269-273) | ○ |
| C-28 | remove_projects_for_user | E-02 (L36-38), E-11 (L371-375) | ○ |
| C-29 | apply! 追加実行 | E-02 (L40-46), E-11 (L119-123) | ○ |
| C-30 | apply! プロジェクトからユーザー削除 | E-02 (L40-46), E-11 (L287-314) | ○ |
| C-31 | apply! ユーザーからプロジェクト削除 | E-02 (L40-46), E-11 (L389-416) | ○ |
| C-32 | is_unique=true で挿入 | E-02 (L99), E-11 (L140-144) | ○ |
| C-33 | BATCH_SIZE超過時バッチ処理 | E-02 (L94-103), E-11 (L125-137) | ○ |
| C-34 | レプリカDB時遅延挿入 | E-02 (L106-112), E-11 (L130-134) | ○ |
| C-35 | プライマリのみ時遅延なし | E-02 (L106-112), E-11 (L150-157) | ○ |
| C-36 | バッチ削除 | E-02 (L84-92), E-11 (L303-314) | ○ |
| C-37 | 削除時レプリカDB遅延 | E-02 (L84-92), E-11 (L303-314) | ○ |
| C-38 | add_delay_between_batches? バッチサイズ以下 | E-02 (L106-112) | ○ |
| C-39 | add_delay_between_batches? 超過+レプリカ | E-02 (L106-112) | ○ |
| C-40 | add_delay_between_batches? プライマリのみ | E-02 (L106-112) | ○ |
| C-41 | log_details ログ出力 | E-02 (L114-121), E-11 (L17-27) | ○ |
| C-42 | log_details total_delay計算 | E-02 (L117) | △ |
| C-43 | publish_removed_event | E-02 (L148-167), E-11 (L30-46) | ○ |
| C-44 | 削除ユーザーなし時イベント未発行 | E-02 (L149), E-11 (L63-73) | ○ |
| C-45 | ロール変更時削除イベント除外 | E-02 (L153-157), E-11 (L174-184) | ○ |
| C-46 | publish_added_event | E-02 (L169-179), E-11 (L48-61) | ○ |
| C-47 | 追加ユーザーなし時イベント未発行 | E-02 (L170), E-11 (L75-85) | ○ |
| C-48 | EVENTS_BATCH_SIZE超過時バッチイベント | E-02 (L172-175), E-11 (L186-206) | ○ |
| C-49 | user_ids空配列時削除なし | E-02 (L58-59), E-11 (L344-350) | ○ |
| C-50 | user_ids nil時削除なし | E-02 (L58-59), E-11 (L352-358) | ○ |
| C-51 | project_ids空配列時削除なし | E-02 (L54-56), E-11 (L446-451) | ○ |
| C-52 | project_ids nil時削除なし | E-02 (L54-56), E-11 (L454-459) | ○ |

### イベントクラス (UT-PRA-053 〜 UT-PRA-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | AuthorizationsChangedEvent schema | E-03 (L6-12) | ○ |
| C-54 | AuthorizationsChangedEvent integer型 | E-03 (L10) | ○ |
| C-55 | AuthorizationsAddedEvent user_ids必須 | E-04 (L8) | ○ |
| C-56 | AuthorizationsAddedEvent project_ids配列 | E-04 (L10) | ○ |
| C-57 | AuthorizationsAddedEvent user_ids配列 | E-04 (L12) | ○ |
| C-58 | AuthorizationsRemovedEvent 必須フィールド | E-05 (L8) | ○ |
| C-59 | AuthorizationsRemovedEvent user_ids配列 | E-05 (L11) | ○ |

### Gitlab::ProjectAuthorizations (UT-PRA-060 〜 UT-PRA-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | initialize でユーザー設定 | E-06 (L10-12) | ○ |
| C-61 | calculate で全認可計算 | E-06 (L14-23), E-12 (L30-33) | ○ |
| C-62 | 所有プロジェクトOWNERレベル | E-06 (L126), E-12 (L42) | ○ |
| C-63 | 直接メンバーシップアクセスレベル | E-06 (L125), E-12 (L43) | ○ |
| C-64 | グループメンバーシップ継承 | E-06 (L127), E-12 (L44) | ○ |
| C-65 | ネストグループ継承 | E-06 (L51-57), E-12 (L190-197) | ○ |
| C-66 | 最大アクセスレベル使用 | E-06 (L52-53), E-12 (L200-206) | ○ |
| C-67 | 共有プロジェクト認可 | E-06 (L132-144), E-12 (L221-223) | ○ |
| C-68 | 共有プロジェクトで低いレベル | E-06 (L137), E-12 (L222) | ○ |
| C-69 | share_with_group_lock | E-06 (L143), E-12 (L235-242) | ○ |
| C-70 | 共有グループ認可 | E-06 (L41-48), E-12 (L274-280) | ○ |
| C-71 | 共有グループで低いレベル | E-06 (L42-45), E-12 (L283-294) | ○ |
| C-72 | 未承認アクセスリクエスト除外 | E-06 (L70, L93), E-12 (L54-64) | ○ |
| C-73 | 保留メンバーシップ除外 | E-06 (L72, L94), E-12 (L357-367) | ○ |
| C-74 | MINIMAL_ACCESS除外 | E-06 (L73, L95), E-12 (L126-136) | ○ |
| C-75 | 継承MINIMAL_ACCESS除外 | E-06 (L73, L95), E-12 (L138-149) | ○ |

### MoveProjectAuthorizationsService (UT-PRA-076 〜 UT-PRA-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | 認可移動 | E-07 (L23-24) | ○ |
| C-77 | 重複回避 | E-07 (L36-40) | ○ |
| C-78 | 残余削除 | E-07 (L15, L27-31) | ○ |
| C-79 | 残余保持 | E-07 (L15) | ○ |
| C-80 | トランザクション内処理 | E-07 (L12) | △ |

### Clusters::Agents認可 (UT-PRA-081 〜 UT-PRA-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | CiAccess belongs_to :agent | E-08 (L12) | ○ |
| C-82 | CiAccess belongs_to :project | E-08 (L13) | ○ |
| C-83 | CiAccess config バリデーション | E-08 (L15) | ○ |
| C-84 | CiAccess config_project | E-08 (L17-19) | ○ |
| C-85 | UserAccess belongs_to :agent | E-09 (L12) | ○ |
| C-86 | UserAccess belongs_to :project | E-09 (L13) | ○ |
| C-87 | UserAccess for_user スコープ | E-09 (L15-20) | ○ |
| C-88 | UserAccess for_user access_level含む | E-09 (L19) | ○ |
| C-89 | UserAccess for_project スコープ | E-09 (L22) | ○ |
| C-90 | UserAccess config バリデーション | E-09 (L24) | ○ |
| C-91 | UserAccess config_project | E-09 (L26-28) | ○ |
| C-92 | upsert_configs | E-09 (L31-33) | ○ |
| C-93 | upsert_configs 重複更新 | E-09 (L32) | ○ |
| C-94 | delete_unlisted | E-09 (L35-37) | ○ |
| C-95 | delete_unlisted 空配列 | E-09 (L36) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-PRA-042 (log_details total_delay計算)**: 計算式 `(entire_size / batch_size.to_f).ceil * SLEEP_DELAY` は E-02 L117 で確認できるが、具体的な数値例のテストコードは確認できず
  - 候補：E-11で該当テストを追加 / 手動計算で検証
- **UT-PRA-080 (トランザクション内処理)**: `Project.transaction do` は確認できるが、ロールバック時の挙動についてのテストは未確認
  - 候補：spec/services/projects/move_project_authorizations_service_spec.rb を確認
- **UT-PRA-095 (delete_unlisted空配列)**: `where.not(project_id: [])` の挙動は実装から推測。空配列を渡した場合 `WHERE project_id IS NOT NULL` 相当になり全削除される可能性
  - 候補：実際にテスト実行して確認 / PostgreSQLの挙動を確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - リレーション、スコープ、基本バリデーションのテストケース (C-01〜C-17, C-81〜C-91)
- **1: 中リスク** - バッチ処理、イベント発行のテストケース (C-33〜C-52)
- **2: 高リスク** - 認可計算ロジック、トランザクション処理 (C-19, C-61〜C-75, C-76〜C-80)
  - 認可計算は権限管理の核心であり、バグが発生するとセキュリティリスクに直結
  - トランザクション処理の失敗はデータ不整合を引き起こす可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 認可計算（Gitlab::ProjectAuthorizations#calculate）のテストケースが主要なアクセスパターンを網羅しているか
- [ ] バリデーションエラーのテストケースが全ての必須フィールドをカバーしているか
- [ ] バッチ処理のテストケースがBATCH_SIZE境界値を考慮しているか
- [ ] イベント発行のテストケースが発行条件と非発行条件の両方をカバーしているか
- [ ] delete_unlistedの空配列挙動が意図した動作か確認
- [ ] 共有グループ/プロジェクトのアクセスレベル制限テストが十分か
