---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 186
  claims_with_evidence: 186
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：projects モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：186 / 186、根拠なし：0
- 優先レビュー（高）
  1. **状態遷移テストケース**：state_machineの遷移ルールは実装から直接抽出したが、実際のビジネス要件との整合性を確認推奨
  2. **カウンター属性テストケース**：CounterAttribute concernの動作はドキュメント確認推奨
  3. **排他制御テストケース**：ExclusiveLeaseの動作仕様は実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/projects/branch_rule.rb`
- E-02: `app/models/projects/all_branches_rule.rb`
- E-03: `app/models/projects/ci_feature_usage.rb`
- E-04: `app/models/projects/build_artifacts_size_refresh.rb`
- E-05: `app/models/projects/topic.rb`
- E-06: `app/models/projects/triggered_hooks.rb`
- E-07: `app/models/projects/wiki_repository.rb`
- E-08: `app/models/projects/project_topic.rb`
- E-09: `app/models/projects/sync_event.rb`
- E-10: `app/models/projects/data_transfer.rb`
- E-11: `app/models/projects/repository_storage_move.rb`
- E-12: `app/models/projects/import_export/relation_export_upload.rb`
- E-13: `app/models/projects/import_export/relation_import_tracker.rb`
- E-14: `app/models/projects/import_export/relation_export.rb`
- E-15: `app/models/projects/forks/details.rb`
- E-16: `app/models/projects/branch_rules/squash_option.rb`
- E-17: `app/models/projects/branch_rules.rb`
- E-18: `app/models/concerns/projects/custom_branch_rule.rb`
- E-19: `app/models/concerns/projects/squash_option.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Projects::BranchRule (UT-PRJ-001 - UT-PRJ-007)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | self.findメソッドがProtectedBranchを検索してBranchRuleを生成する | E-01 L13-18 | ○ |
| C-02 | 存在しないIDでActiveRecord::RecordNotFoundがスローされる | E-01 L17-18 | ○ |
| C-03 | initializeでproject, protected_branchが設定される | E-01 L21-24 | ○ |
| C-04 | protected?メソッドは常にtrueを返却する | E-01 L26-28 | ○ |
| C-05 | matching_branches_countはマッチするブランチ数を返却する | E-01 L30-34 | ○ |
| C-06 | squash_optionメソッドはnilを返却する | E-01 L36-38 | ○ |

### Projects::AllBranchesRule (UT-PRJ-008 - UT-PRJ-011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | nameメソッドは「All branches」を返却する | E-02 L7-9 | ○ |
| C-08 | matching_branches_countはrepository.branch_countを返却する | E-02 L11-13 | ○ |
| C-09 | squash_optionはproject.project_settingを返却する | E-02 L15-17 | ○ |
| C-10 | protected?はCustomBranchRuleモジュールからfalseを継承する | E-18 L42-44 | ○ |

### Projects::CiFeatureUsage (UT-PRJ-012 - UT-PRJ-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | belongs_to :projectリレーションが定義されている | E-03 L7 | ○ |
| C-12 | project, featureのpresenceバリデーションが定義されている | E-03 L9 | ○ |
| C-13 | featureのenumが{code_coverage: 1, security_report: 2}で定義されている | E-03 L11-14 | ○ |
| C-14 | insert_usageメソッドはunique_byで重複を防止する | E-03 L16-25 | ○ |

### Projects::BuildArtifactsSizeRefresh (UT-PRJ-019 - UT-PRJ-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | belongs_to :projectリレーションが定義されている | E-04 L22 | ○ |
| C-16 | projectのpresenceバリデーションが定義されている | E-04 L24 | ○ |
| C-17 | state_machineのSTATESが{created: 1, running: 2, pending: 3, finalizing: 4}で定義されている | E-04 L33-38 | ○ |
| C-18 | created/pending/runningからrunningへのprocess遷移が定義されている | E-04 L47-49 | ○ |
| C-19 | runningからpendingへのrequeue遷移が定義されている | E-04 L51-53 | ○ |
| C-20 | runningからfinalizingへのschedule_finalize遷移が定義されている | E-04 L55-57 | ○ |
| C-21 | staleスコープはSTALE_WINDOW(2時間)以上古いrunningを取得する | E-04 L78 | ○ |
| C-22 | remainingスコープはcreated, pending, staleを取得する | E-04 L79 | ○ |
| C-23 | enqueue_refreshはbulk_insert!でskip_duplicates: trueを使用する | E-04 L84-92 | ○ |
| C-24 | process_next_refresh!はFOR UPDATE SKIP LOCKEDで排他制御する | E-04 L94-106 | ○ |
| C-25 | reset_project_statistics!はCOUNTER_ATTRIBUTE_NAMEでinitiate_refresh!を呼ぶ | E-04 L108-110 | ○ |
| C-26 | next_batchはid_before, id_after, limitを使用してバッチ取得する | E-04 L112-118 | ○ |
| C-27 | started?はcreated?の否定を返却する | E-04 L120-122 | ○ |
| C-28 | finalize!はfinalize_refreshを呼び、destroy!する | E-04 L124-128 | ○ |

### Projects::Topic (UT-PRJ-037 - UT-PRJ-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | name, descriptionの長さバリデーションが定義されている | E-05 L15-17, L27 | ○ |
| C-30 | nameのuniqueness(scope: organization_id)バリデーションが定義されている | E-05 L17 | ○ |
| C-31 | slugのformat, uniquenessバリデーションが定義されている | E-05 L20-24 | ○ |
| C-32 | belongs_to :organizationリレーションが定義されている | E-05 L29 | ○ |
| C-33 | has_many :project_topics, :projectsリレーションが定義されている | E-05 L31-32 | ○ |
| C-34 | in_organization, without_assigned_projectsスコープが定義されている | E-05 L34-35 | ○ |
| C-35 | title_or_nameはtitleがあればtitle、なければnameを返却する | E-05 L46-48 | ○ |
| C-36 | find_by_name_case_insensitiveは大文字小文字を区別しない検索を行う | E-05 L51-53 | ○ |
| C-37 | searchはname, titleでfuzzy_searchを行う | E-05 L55-57 | ○ |
| C-38 | update_non_private_projects_counterはvisibility変更時にカウンターを更新する | E-05 L59-80 | ○ |
| C-39 | validate_name_formatは改行や非ASCII文字を拒否する | E-05 L89-101 | ○ |

### Projects::TriggeredHooks (UT-PRJ-060 - UT-PRJ-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | initializeでscope, data, relationsを初期化する | E-06 L5-9 | ○ |
| C-41 | add_hooksはrelationsに追加しselfを返却する | E-06 L11-14 | ○ |
| C-42 | executeは各フックのasync_executeを呼び出す | E-06 L16-23 | ○ |

### Projects::WikiRepository (UT-PRJ-065 - UT-PRJ-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | belongs_to :projectリレーションが定義されている | E-07 L7 | ○ |
| C-44 | projectのpresence, uniquenessバリデーションが定義されている | E-07 L9 | ○ |

### Projects::ProjectTopic (UT-PRJ-068 - UT-PRJ-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | belongs_to :project, :topicリレーションが定義されている | E-08 L5-6 | ○ |
| C-46 | topic_idのuniqueness(scope: project_id)バリデーションが定義されている | E-08 L8 | ○ |
| C-47 | counter_cache: :total_projects_countが設定されている | E-08 L6 | ○ |

### Projects::SyncEvent (UT-PRJ-073 - UT-PRJ-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | belongs_to :projectリレーションが定義されている | E-09 L8 | ○ |
| C-49 | unprocessed_events, preload_synced_relation, order_by_id_ascスコープが定義されている | E-09 L10-12 | ○ |
| C-50 | mark_records_processedはid_inでdelete_allを実行する | E-09 L14-16 | ○ |
| C-51 | enqueue_workerはProcessSyncEventsWorker.perform_asyncを呼ぶ | E-09 L18-20 | ○ |
| C-52 | upper_bound_countはMAX(id) - MIN(id) + 1を計算する | E-09 L22-24 | ○ |

### Projects::DataTransfer (UT-PRJ-081 - UT-PRJ-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | belongs_to :project, :namespaceリレーションが定義されている | E-10 L11-12 | ○ |
| C-54 | current_month, with_project_between_dates, with_namespace_between_datesスコープが定義されている | E-10 L14-22 | ○ |
| C-55 | counter_attributeでrepository_egress, artifacts_egress, packages_egress, registry_egressが定義されている | E-10 L24-27 | ○ |
| C-56 | beginning_of_monthはUTCの月初日を返却する | E-10 L29-31 | ○ |

### Projects::RepositoryStorageMove (UT-PRJ-091 - UT-PRJ-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | belongs_to :containerリレーションがProjectに紐付いている | E-11 L13 | ○ |
| C-58 | projectはcontainerのエイリアスである | E-11 L14 | ○ |
| C-59 | with_projectsスコープはcontainer: routeをincludesする | E-11 L17 | ○ |
| C-60 | schedule_repository_storage_update_workerはUpdateRepositoryStorageWorkerを呼ぶ | E-11 L20-22 | ○ |
| C-61 | error_keyは:projectを返却する | E-11 L26-28 | ○ |

### Projects::ImportExport::RelationExportUpload (UT-PRJ-096 - UT-PRJ-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | belongs_to :project, :relation_exportリレーションが定義されている | E-12 L10-15 | ○ |
| C-63 | relation_exportはoptional: falseで必須である | E-12 L15 | ○ |
| C-64 | for_project_export_jobsスコープはjoins(:relation_export)で結合する | E-12 L17-21 | ○ |
| C-65 | uploads_sharding_keyはproject_idを含むハッシュを返却する | E-12 L33-35 | ○ |

### Projects::ImportExport::RelationImportTracker (UT-PRJ-101 - UT-PRJ-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | belongs_to :projectリレーションが定義されている | E-13 L6 | ○ |
| C-67 | project, status, relationのpresenceバリデーションが定義されている | E-13 L8-10 | ○ |
| C-68 | relationのenumが{issues: 0, merge_requests: 1, ci_pipelines: 2, milestones: 3}で定義されている | E-13 L15 | ○ |
| C-69 | state_machineのstatesが{created: 0, started: 1, finished: 2, failed: 3}で定義されている | E-13 L17-22 | ○ |
| C-70 | start, finish, fail_opイベントと遷移が定義されている | E-13 L24-34 | ○ |
| C-71 | stale?はSTALE_TIMEOUT(24時間)以上古いcreated/startedをtrueと判定する | E-13 L37-41 | ○ |
| C-72 | cannot_be_created_for_importing_projectバリデーションが定義されている | E-13 L45-49 | ○ |

### Projects::ImportExport::RelationExport (UT-PRJ-120 - UT-PRJ-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | belongs_to :project_export_job, has_one :uploadリレーションが定義されている | E-14 L22-28 | ○ |
| C-74 | export_error, jid, relation, statusのバリデーションが定義されている | E-14 L29-33 | ○ |
| C-75 | by_relationスコープが定義されている | E-14 L35 | ○ |
| C-76 | STATUSが{queued: 0, started: 1, finished: 2, failed: 3}で定義されている | E-14 L37-42 | ○ |
| C-77 | state_machineのイベントと遷移が定義されている | E-14 L44-65 | ○ |
| C-78 | relation_names_listはproject_tree_relation_namesとEXTRA_RELATION_LISTを結合する | E-14 L67-71 | ○ |
| C-79 | mark_as_failedはUrlSanitizer.sanitizeを使用してエラーを保存する | E-14 L73-79 | ○ |

### Projects::Forks::Details (UT-PRJ-138 - UT-PRJ-148)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | initializeでproject, fork_repo, source_repo, refを設定する | E-15 L13-18 | ○ |
| C-81 | countsはahead, behindのハッシュを返却する | E-15 L20-24 | ○ |
| C-82 | exclusive_leaseはExclusiveLease.newを使用する | E-15 L26-31 | ○ |
| C-83 | syncing?はexclusive_lease.exists?を返却する | E-15 L34-36 | ○ |
| C-84 | has_conflicts?はattrsのhas_conflictsを確認する | E-15 L38-40 | ○ |
| C-85 | update!はRails.cache.writeでEXPIRATION_TIME(8時間)で保存する | E-15 L42-46 | ○ |
| C-86 | calculate_divergence_countsはfork_repoとsource_repoの差分を計算する | E-15 L71-95 | ○ |

### Projects::BranchRules::SquashOption (UT-PRJ-149 - UT-PRJ-158)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | belongs_to :protected_branch, :projectリレーションが定義されている | E-16 L8-9 | ○ |
| C-88 | protected_branchのuniquenessバリデーションが定義されている | E-16 L11 | ○ |
| C-89 | validate_protected_branch_not_wildcardカスタムバリデーションが定義されている | E-16 L22-26 | ○ |
| C-90 | validate_protected_branch_belongs_to_projectカスタムバリデーションが定義されている | E-16 L28-33 | ○ |
| C-91 | branch_ruleメソッドはProjects::BranchRuleを生成する | E-16 L16-18 | ○ |

### Projects::SquashOption concern (UT-PRJ-159 - UT-PRJ-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | squash_optionのenumが{never: 0, always: 1, default_on: 2, default_off: 3}で定義されている | E-19 L8 | ○ |
| C-93 | human_squash_optionは各オプションの表示名を返却する | E-19 L11-18 | ○ |
| C-94 | squash_enabled_by_default?はalways, default_onでtrueを返却する | E-19 L20-22 | ○ |
| C-95 | squash_readonly?はalways, neverでtrueを返却する | E-19 L24-26 | ○ |

### Projects::CustomBranchRule concern (UT-PRJ-175 - UT-PRJ-186)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | self.findはProject.findでプロジェクトを取得しインスタンスを生成する | E-18 L16-23 | ○ |
| C-97 | initializeでprojectを設定する | E-18 L25-27 | ○ |
| C-98 | name, matching_branches_countはNotImplementedErrorをスローする | E-18 L29-36 | ○ |
| C-99 | default_branch?, protected?, branch_protection, group, squash_option, created_at, updated_atはデフォルト値を返却する | E-18 L38-64 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースはソースコードから直接抽出したため、根拠なしの項目はありません。
- ただし、以下の点についてはビジネス要件との照合が推奨されます：
  - state_machineの状態遷移ルールの網羅性
  - CounterAttributeの動作仕様
  - ExclusiveLeaseのタイムアウト設定の妥当性

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全テストケースがソースコードに基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] state_machineの状態遷移テストが全ての遷移パターンをカバーしているか確認
- [ ] バリデーションテストが全てのバリデーションルールを網羅しているか確認
- [ ] リレーションテストがinverse_of等の双方向関連を考慮しているか確認
- [ ] スコープテストがクエリの効率性を考慮しているか確認
- [ ] カウンター属性テストが並行性を考慮しているか確認
