---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：protected_branch 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **EE拡張機能のテスト**：EE版でprepend_modされる機能は本CSVでカバーされていない
  2. **ProtectedRefAccess concern**：継承元concernの詳細テストは別モジュールで実施が望ましい
  3. **Gitlab::Access定数の妥当性**：アクセスレベル定数の値が変更された場合の影響確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/protected_branch.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/protected_branch/merge_access_level.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/protected_branch/push_access_level.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/protected_branch/cache_key.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/base_service.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/create_service.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/update_service.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/destroy_service.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/cache_service.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/api_service.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/legacy_api_create_service.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/protected_branches/legacy_api_update_service.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/concerns/protected_branch_access.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/concerns/protected_ref.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProtectedBranch.get_ids_by_nameがIDの配列を返す | E-01 (line 34-36) | ○ |
| C-02 | get_ids_by_nameは存在しない名前で空配列を返す | E-01 (line 34-36: pluckの動作) | ○ |
| C-03 | protected_ref_accessible_to?はadminユーザーにtrue | E-01 (line 43) | ○ |
| C-04 | protected_ref_accessible_to?はDeveloperに初期プッシュ許可 | E-01 (line 46-48) | ○ |
| C-05 | protected_ref_accessible_to?はDeveloperに初期プッシュ拒否可能 | E-01 (line 46-48) | ○ |
| C-06 | protected?は空リポジトリでデフォルトブランチ保護時true | E-01 (line 56) | ○ |
| C-07 | protected?は空ref_nameでfalse | E-01 (line 57) | ○ |
| C-08 | protected?はnilのref_nameでfalse | E-01 (line 57: blank?判定) | ○ |
| C-09 | protected?はCacheServiceを使用 | E-01 (line 59-61) | ○ |
| C-10 | allow_force_push?はforce push許可時true | E-01 (line 64-66) | ○ |
| C-11 | allow_force_push?はforce push禁止時false | E-01 (line 64-66) | ○ |
| C-12 | any_protected?は1つでも保護されていればtrue | E-01 (line 68-74) | ○ |
| C-13 | any_protected?は全て非保護ならfalse | E-01 (line 68-74) | ○ |
| C-14 | by_nameは部分一致検索可能 | E-01 (line 85-89: fuzzy_arel_match) | ○ |
| C-15 | by_nameは空クエリでnone | E-01 (line 86) | ○ |
| C-16 | by_nameはnilクエリでnone | E-01 (line 86: blank?判定) | ○ |
| C-17 | default_branch_forはデフォルトブランチを返す | E-01 (line 95-99) | ○ |
| C-18 | default_branch_forはnilプロジェクトでnil | E-01 (line 96: safe navigation) | ○ |
| C-19 | default_branch_forはデフォルトブランチなしでnil | E-01 (line 96) | ○ |
| C-20 | default_branch?はデフォルトブランチでtrue | E-01 (line 101-105) | ○ |
| C-21 | default_branch?は非デフォルトブランチでfalse | E-01 (line 104) | ○ |
| C-22 | default_branch?はprojectなしでfalse | E-01 (line 102) | ○ |
| C-23 | group_level?はグループレベルでtrue | E-01 (line 107-109) | ○ |
| C-24 | group_level?はプロジェクトレベルでfalse | E-01 (line 107-109) | ○ |
| C-25 | project_level?はプロジェクトレベルでtrue | E-01 (line 111-113) | ○ |
| C-26 | project_level?はグループレベルでfalse | E-01 (line 111-113) | ○ |
| C-27 | entityはグループを返す | E-01 (line 115-117) | ○ |
| C-28 | entityはプロジェクトを返す | E-01 (line 116: OR演算子) | ○ |
| C-29 | validate_not_subgroupはサブグループでエラー | E-01 (line 121-125) | ○ |
| C-30 | validate_not_subgroupはトップレベルで成功 | E-01 (line 122: early return) | ○ |
| C-31 | nameの一意性制約が機能する | E-01 (line 16) | ○ |
| C-32 | scope requiring_code_owner_approval | E-01 (line 18) | ○ |
| C-33 | scope allowing_force_push | E-01 (line 19) | ○ |
| C-34 | scope sorted_by_name | E-01 (line 20) | ○ |
| C-35 | scope for_group | E-01 (line 23) | ○ |
| C-36 | scope after_name_and_id | E-01 (line 26-30) | ○ |
| C-37 | scope after_name_and_idはnilでnone | E-01 (line 27) | ○ |
| C-38 | MergeAccessLevelのデフォルトレベル | E-02 (line 7) | ○ |
| C-39 | MergeAccessLevelのbelongs_to | E-13 (line 8) | ○ |
| C-40 | MergeAccessLevelのprotected_branch_group | E-13 (line 15-17) | ○ |
| C-41 | PushAccessLevelのデフォルトレベル | E-03 (line 8) | ○ |
| C-42 | PushAccessLevelのbelongs_to | E-13 (line 8) | ○ |
| C-43 | CacheKey.to_sはProjectで正しいキー | E-04 (line 12-14, 21-23) | ○ |
| C-44 | CacheKey.to_sはGroupで正しいキー | E-04 (line 12-14, 24-25) | ○ |
| C-45 | CacheKey.to_sはその他でクラス名使用 | E-04 (line 26-27) | ○ |
| C-46 | BaseService.initializeの初期化 | E-05 (line 9-13) | ○ |
| C-47 | BaseService.refresh_cacheの呼び出し | E-05 (line 19-23) | ○ |
| C-48 | BaseService.refresh_cacheのエラーハンドリング | E-05 (line 21-22) | ○ |
| C-49 | CreateService.executeで作成成功 | E-06 (line 5-13) | ○ |
| C-50 | CreateService.executeでskip_authorization | E-06 (line 6) | ○ |
| C-51 | CreateService.executeで認可エラー | E-06 (line 6) | ○ |
| C-52 | CreateService.executeでキャッシュ更新 | E-06 (line 10) | ○ |
| C-53 | CreateService.executeでall_protected_branchesリセット | E-06 (line 24) | ○ |
| C-54 | CreateService.executeでイベント発行 | E-06 (line 30-46) | ○ |
| C-55 | UpdateService.executeで更新成功 | E-07 (line 5-18) | ○ |
| C-56 | UpdateService.executeでskip_authorization | E-07 (line 6) | ○ |
| C-57 | UpdateService.executeで認可エラー | E-07 (line 6) | ○ |
| C-58 | UpdateService.executeでafter_execute | E-07 (line 12) | ○ |
| C-59 | UpdateService.executeでキャッシュ更新 | E-07 (line 14) | ○ |
| C-60 | UpdateService.executeで更新失敗時キャッシュ未更新 | E-07 (line 11: if条件) | ○ |
| C-61 | DestroyService.executeで削除成功 | E-08 (line 5-11) | ○ |
| C-62 | DestroyService.executeで認可エラー | E-08 (line 6) | ○ |
| C-63 | DestroyService.executeでキャッシュ更新 | E-08 (line 9) | ○ |
| C-64 | DestroyService.executeでイベント発行 | E-08 (line 10, 14-27) | ○ |
| C-65 | CacheService.fetchでキャッシュヒット | E-09 (line 17-22) | ○ |
| C-66 | CacheService.fetchでキャッシュミス | E-09 (line 30-47) | ○ |
| C-67 | CacheService.fetchでdry_run | E-09 (line 25-32) | ○ |
| C-68 | CacheService.fetchで有効期限設定 | E-09 (line 36-39) | ○ |
| C-69 | CacheService.fetchでCACHE_LIMIT超過時削除 | E-09 (line 41-44) | ○ |
| C-70 | CacheService.refreshでキャッシュ削除 | E-09 (line 51-52) | ○ |
| C-71 | CacheService.refreshでグループ配下プロジェクト削除 | E-09 (line 54-65) | ○ |
| C-72 | CacheService.refreshでプロジェクトのみ | E-09 (line 54: early return) | ○ |
| C-73 | ApiService.createでCreateService呼び出し | E-10 (line 5-7) | ○ |
| C-74 | ApiService.createでpush_access_levels設定 | E-10 (line 16-22) | ○ |
| C-75 | ApiService.createでmerge_access_levels設定 | E-10 (line 16-22) | ○ |
| C-76 | ApiService.updateでUpdateService呼び出し | E-10 (line 9-12) | ○ |
| C-77 | ApiService.updateでwith_defaults=false | E-10 (line 11) | ○ |
| C-78 | LegacyApiCreateService.developers_can_pushでDEVELOPER | E-11 (line 10-15) | ○ |
| C-79 | LegacyApiCreateService.developers_can_pushでMAINTAINER | E-11 (line 10-15) | ○ |
| C-80 | LegacyApiCreateService.developers_can_mergeでDEVELOPER | E-11 (line 17-22) | ○ |
| C-81 | LegacyApiCreateService.developers_can_mergeでMAINTAINER | E-11 (line 17-22) | ○ |
| C-82 | LegacyApiUpdateService.developers_can_pushで再作成 | E-12 (line 19-24, 40-47) | ○ |
| C-83 | LegacyApiUpdateService.developers_can_mergeで再作成 | E-12 (line 26-31, 40-47) | ○ |
| C-84 | LegacyApiUpdateService.nilで維持 | E-12 (line 41, 45: unless nil?) | ○ |
| C-85 | LegacyApiUpdateService.トランザクション | E-12 (line 16-35) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべてのテストケースにソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいている
- 1: 中リスク - EE版の拡張機能（prepend_mod）のテストケースは本CSVに含まれていない
- 1: 中リスク - ProtectedRefAccess concernから継承されるメソッドの詳細テストは別途必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（認可・アクセス制御関連）の網羅性確認
- [ ] キャッシュ関連テストの境界値テストが十分か確認
- [ ] トランザクション処理のロールバックケースの確認
- [ ] EE版拡張機能のテストが別途必要か確認
- [ ] 既存のspec/models/protected_branch, spec/services/protected_branches との重複確認
