---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：protected_tag単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **humanize_deploy_keyメソッドのデフォルト値**: deploy_keyがnilの場合の実際の戻り値確認が必要
  2. **継承メンバーシップによるcheck_access**: グループメンバーシップ継承時の詳細な挙動確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/protected_tag/create_access_level.rb`
- E-02: `app/models/concerns/protected_tag_access.rb`
- E-03: `app/models/concerns/protected_ref_deploy_key_access.rb`
- E-04: `app/models/concerns/protected_ref_access.rb`
- E-05: `app/models/protected_tag.rb`
- E-06: `app/models/concerns/protected_ref.rb`
- E-07: `spec/models/protected_tag/create_access_level_spec.rb`
- E-08: `spec/support/shared_examples/models/concerns/protected_tag_access_shared_examples.rb`
- E-09: `spec/support/shared_examples/models/concerns/protected_ref_access_shared_examples.rb`
- E-10: `spec/support/shared_examples/models/concerns/protected_ref_deploy_key_access_shared_examples.rb`
- E-11: `spec/support/shared_examples/models/concerns/protected_ref_access_allowed_access_levels_shared_examples.rb`
- E-12: `spec/models/protected_tag_spec.rb`
- E-13: `spec/factories/protected_tags.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :protected_tag関連付け | E-02 (line 8) | ○ |
| C-02 | protected_tagがnilの場合の挙動 | E-02 (line 10: allow_nil: true), E-08 (line 19-21) | ○ |
| C-03 | protected_ref_project委譲 | E-02 (line 10), E-08 (line 11-17) | ○ |
| C-04 | protected_tagがnilの場合nilが返却 | E-08 (line 19-21) | ○ |
| C-05 | belongs_to :deploy_key関連付け | E-03 (line 7), E-10 (line 7) | ○ |
| C-06 | deploy_key_idユニーク性検証 | E-03 (line 10), E-10 (line 72-88) | ○ |
| C-07 | deploy_key_id重複拒否 | E-10 (line 84-88) | ○ |
| C-08 | deploy_key_id nil許容 | E-03 (line 10: allow_nil: true) | ○ |
| C-09 | deploy_key存在検証 | E-03 (line 11), E-10 (line 61-69) | ○ |
| C-10 | deploy_key存在しない場合エラー | E-10 (line 66-69) | ○ |
| C-11 | deploy_keyオーナーメンバーシップ検証成功 | E-03 (line 38-41), E-10 (line 19-25) | ○ |
| C-12 | deploy_keyオーナー非メンバーエラー | E-03 (line 38-41), E-10 (line 27-32) | ○ |
| C-13 | deploy_key書き込み権限検証成功 | E-03 (line 44-47), E-10 (line 12-25) | ○ |
| C-14 | deploy_key読み取り専用拒否 | E-03 (line 44-47), E-10 (line 35-59) | ○ |
| C-15 | typeがdeploy_key(deploy_key設定時) | E-03 (line 22-26), E-10 (line 207-210) | ○ |
| C-16 | typeがdeploy_key(deploy_key_id設定時) | E-03 (line 23), E-10 (line 212-217) | ○ |
| C-17 | typeがrole(未設定時) | E-04 (line 55-57) | ○ |
| C-18 | access_level存在検証 | E-04 (line 48-52) | ○ |
| C-19 | access_level nil時エラー | E-04 (line 49), E-09 (line 13) | ○ |
| C-20 | access_level許可レベル検証 | E-04 (line 50), E-09 (line 12) | ○ |
| C-21 | access_level不正レベル拒否 | E-04 (line 50), E-09 (line 12) | ○ |
| C-22 | access_levelユニーク性検証 | E-04 (line 51), E-09 (line 15-18) | ○ |
| C-23 | access_level重複拒否 | E-04 (line 51) | ○ |
| C-24 | scope :maintainer | E-04 (line 40), E-09 (line 41) | ○ |
| C-25 | scope :developer | E-04 (line 41), E-09 (line 40) | ○ |
| C-26 | scope :for_role | E-04 (line 45), E-09 (line 37-46) | ○ |
| C-27 | human_access_levels(セルフホスト) | E-04 (line 8-14), E-11 (line 26-33) | ○ |
| C-28 | human_access_levels(Gitlab.com) | E-04 (line 25-27), E-11 (line 16-23) | ○ |
| C-29 | allowed_access_levels(セルフホスト) | E-04 (line 17-28), E-11 (line 26-33) | ○ |
| C-30 | allowed_access_levels(Gitlab.com) | E-04 (line 25-27), E-11 (line 16-23) | ○ |
| C-31 | humanize(roleタイプ) | E-04 (line 63-68, 84-85), E-09 (line 49-61) | ○ |
| C-32 | humanize(deploy_keyタイトル) | E-03 (line 30-31), E-10 (line 223-227) | ○ |
| C-33 | humanize(deploy_key nil時) | E-03 (line 31), E-10 (line 229-234) | ○ |
| C-34 | check_access(user nil) | E-04 (line 72), E-09 (line 80-83) | ○ |
| C-35 | check_access(NO_ACCESS) | E-04 (line 72, 92-94), E-09 (line 86-89) | ○ |
| C-36 | check_access(ADMIN+admin user) | E-04 (line 73, 88-90), E-09 (line 103-109) | ○ |
| C-37 | check_access(ADMIN+非admin) | E-04 (line 73), E-09 (line 95-101) | ○ |
| C-38 | check_access(deploy_key+オーナー+有効) | E-03 (line 53-55), E-10 (line 163-165) | ○ |
| C-39 | check_access(deploy_key+非オーナー) | E-03 (line 57-58), E-10 (line 187-193) | ○ |
| C-40 | check_access(deploy_key+無効状態) | E-03 (line 60-64), E-10 (line 167-177) | ○ |
| C-41 | check_access(role+push権限+適切なレベル) | E-04 (line 96-104), E-09 (line 112-114) | ○ |
| C-42 | check_access(role+レベル不足) | E-04 (line 104), E-09 (line 125-129) | ○ |
| C-43 | check_access(role+push権限なし) | E-04 (line 103), E-09 (line 132-138) | ○ |
| C-44 | non_role_typesにdeploy_key含む | E-03 (line 16-19) | ○ |
| C-45 | role?(type=:role) | E-04 (line 59-61) | ○ |
| C-46 | role?(type=:deploy_key) | E-04 (line 59-61), E-03 (line 22-26) | ○ |
| C-47 | deploy_key?(type=:deploy_key) | E-03 (line 34-36) | ○ |
| C-48 | deploy_key?(type=:role) | E-03 (line 34-36) | ○ |
| C-49 | deploy_key_owned_by?(一致) | E-03 (line 57-58) | ○ |
| C-50 | deploy_key_owned_by?(不一致) | E-03 (line 57-58) | ○ |
| C-51 | valid_deploy_key_status?(全条件満たす) | E-03 (line 60-64), E-10 (line 163-165) | ○ |
| C-52 | valid_deploy_key_status?(read_project権限なし) | E-03 (line 62), E-10 (line 179-185) | ○ |
| C-53 | valid_deploy_key_status?(非メンバー) | E-03 (line 63), E-10 (line 138-149) | ○ |
| C-54 | valid_deploy_key_status?(書き込み権限なし) | E-03 (line 64), E-10 (line 167-177) | ○ |
| C-55 | deploy_key_owner_project_member?(メンバー) | E-03 (line 67-68) | ○ |
| C-56 | deploy_key_owner_project_member?(非メンバー) | E-03 (line 67-68) | ○ |
| C-57 | deploy_key_has_write_access_to_project?(書き込み権限あり) | E-03 (line 71-72) | ○ |
| C-58 | deploy_key_has_write_access_to_project?(書き込み権限なし) | E-03 (line 71-72) | ○ |
| C-59 | humanize_deploy_key(タイトル取得) | E-03 (line 30-31) | ○ |
| C-60 | humanize_deploy_key(nilの場合デフォルト) | E-03 (line 31) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-60 (humanize_deploy_key nilの場合)**: deploy_keyがnilの場合の`deploy_key&.title`の戻り値が`nil`となり、`|| 'Deploy key'`により`'Deploy key'`が返却されることはコードから推測できるが、spec中に明示的なテストケースがない
  - 候補：spec/support/shared_examples/models/concerns/protected_ref_deploy_key_access_shared_examples.rb での追加テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: protected_tagモジュールは1モデル（CreateAccessLevel）のみで構成されており、シンプルな構造
- **0（低リスク）**: 既存のshared_examplesで主要なテストケースがカバーされている
- **1（中リスク）**: ProtectedRefDeployKeyAccessのprivateメソッドは直接テストされていないため、統合テストでの検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ProtectedTagAccessモジュールのbelongs_to関連が正しく動作することを確認
- [ ] ProtectedRefDeployKeyAccessモジュールのバリデーションが期待通りに動作することを確認
- [ ] deploy_keyのオーナーシップとプロジェクトメンバーシップの検証ロジックが正しいことを確認
- [ ] access_levelのユニーク制約がfor_roleスコープと組み合わせて正しく動作することを確認
- [ ] check_accessメソッドのアクセス制御ロジックがセキュリティ要件を満たすことを確認
- [ ] Gitlab.com環境とセルフホスト環境でのallowed_access_levelsの違いが意図通りであることを確認
