---
generated_at: 2026-01-22 15:15:00
metrics:
  claims_total: 119
  claims_with_evidence: 119
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：releases.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：119 / 119、根拠なし：0
- 優先レビュー（高）
  1. **UT-REL-062〜076**: CreateService の複雑なビジネスロジック（カタログ連携、Evidence作成条件など）
  2. **UT-REL-015〜026**: Link バリデーションのREGEX・長さ制限テスト
  3. **UT-REL-003**: Evidence.summary のセキュリティ関連ロジック（issues削除）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/releases/evidence.rb`（Evidence モデル）
- E-02: `app/models/releases/source.rb`（Source モデル）
- E-03: `app/models/releases/link.rb`（Link モデル）
- E-04: `app/services/releases/base_service.rb`（BaseService）
- E-05: `app/services/releases/create_service.rb`（CreateService）
- E-06: `app/services/releases/update_service.rb`（UpdateService）
- E-07: `app/services/releases/destroy_service.rb`（DestroyService）
- E-08: `app/services/releases/create_evidence_service.rb`（CreateEvidenceService）
- E-09: `app/services/releases/links/base_service.rb`（Links::BaseService）
- E-10: `app/services/releases/links/create_service.rb`（Links::CreateService）
- E-11: `app/services/releases/links/update_service.rb`（Links::UpdateService）
- E-12: `app/services/releases/links/destroy_service.rb`（Links::DestroyService）
- E-13: `app/services/releases/links/params.rb`（Links::Params）

## 3) Claims と根拠の対応（レビューの主戦場）

### Releases::Evidence（UT-REL-001〜010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | milestones メソッドがリレーションを取得 | E-01 L16-18 | ○ |
| C-02 | milestones がメモ化される | E-01 L17 `@milestones ||=` | ○ |
| C-03 | summary から issues が削除される | E-01 L25-33 | ○ |
| C-04 | milestones が nil でも動作 | E-01 L28 `&.each` safe navigation | ○ |
| C-05 | milestones が空配列でも動作 | E-01 L28 each は空配列でも動作 | ○ |
| C-06 | belongs_to :release リレーション | E-01 L8 | ○ |
| C-07 | default_scope で created_at 昇順 | E-01 L10 | ○ |
| C-08 | sha_attribute :summary_sha | E-01 L12 | ○ |
| C-09 | alias_attribute :collected_at | E-01 L13 | ○ |
| C-10 | alias_attribute :sha | E-01 L14 | ○ |

### Releases::Source（UT-REL-011〜014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | all メソッドで全形式の Source 生成 | E-02 L10-14 | ○ |
| C-12 | url メソッドで正しい URL 生成 | E-02 L17-21 | ○ |
| C-13 | タグ名のスラッシュがハイフンに変換 | E-02 L33 `tr('/', '-')` | ○ |
| C-14 | hook_attrs で format と url 返却 | E-02 L23-28 | ○ |

### Releases::Link（UT-REL-015〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | URL バリデーション（http/https/ftp） | E-03 L14 `addressable_url: { schemes: %w[http https ftp] }` | ○ |
| C-16 | 無効なスキームでエラー | E-03 L14 | ○ |
| C-17 | 空の URL でエラー | E-03 L14 `presence: true` | ○ |
| C-18 | URL の uniqueness（scope: release） | E-03 L14 `uniqueness: { scope: :release }` | ○ |
| C-19 | name の presence バリデーション | E-03 L15 | ○ |
| C-20 | 空の name でエラー | E-03 L15 | ○ |
| C-21 | name の uniqueness（scope: release） | E-03 L15 | ○ |
| C-22 | 有効な filepath で保存可 | E-03 L16-26 | ○ |
| C-23 | 128文字超でエラー | E-03 L23 `FILEPATH_MAX_LENGTH` | ○ |
| C-24 | 無効フォーマットでエラー | E-03 L25 `FILEPATH_REGEX` | ○ |
| C-25 | filepath が nil で通過 | E-03 L22 `return if filepath.nil?` | ○ |
| C-26 | filepath の uniqueness | E-03 L16 | ○ |
| C-27 | sorted スコープ | E-03 L28 | ○ |
| C-28 | link_type enum other=0 | E-03 L30-35 | ○ |
| C-29 | link_type enum runbook=1 | E-03 L30-35 | ○ |
| C-30 | link_type enum package=2 | E-03 L30-35 | ○ |
| C-31 | link_type enum image=3 | E-03 L30-35 | ○ |
| C-32 | internal? が true を返す条件 | E-03 L37-39 | ○ |
| C-33 | internal? が false を返す条件 | E-03 L37-39 | ○ |
| C-34 | hook_attrs の返却値 | E-03 L41-48 | ○ |

### Releases::BaseService（UT-REL-035〜061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | initialize で変数設定 | E-04 L12-16 | ○ |
| C-36 | tag_name が params[:tag] を返す | E-04 L18-20 | ○ |
| C-37 | tag_message が返される | E-04 L22-24 | ○ |
| C-38 | ref が返される | E-04 L26-28 | ○ |
| C-39 | name が params[:name] を優先 | E-04 L30-32 | ○ |
| C-40 | name が tag_name にフォールバック | E-04 L31 `params[:name] || tag_name` | ○ |
| C-41 | description が返される | E-04 L34-36 | ○ |
| C-42 | released_at が返される | E-04 L38-40 | ○ |
| C-43 | release が検索される | E-04 L42-46 | ○ |
| C-44 | release が nil を返す | E-04 L44 `find_by_tag` | ○ |
| C-45 | release がメモ化される | E-04 L42 `strong_memoize` | ○ |
| C-46 | repository が返される | E-04 L48-52 | ○ |
| C-47 | existing_tag が検索される | E-04 L54-58 | ○ |
| C-48 | existing_tag が nil を返す | E-04 L56 `find_tag` | ○ |
| C-49 | milestones が検索される | E-04 L60-74 | ○ |
| C-50 | milestones が空配列を返す | E-04 L61 | ○ |
| C-51 | inexistent_milestone_titles | E-04 L76-82 | ○ |
| C-52 | inexistent_milestone_titles 空配列 | E-04 L77 | ○ |
| C-53 | inexistent_milestone_ids | E-04 L84-90 | ○ |
| C-54 | inexistent_milestone_ids 空配列 | E-04 L85 | ○ |
| C-55 | param_for_milestone_titles_provided? true | E-04 L92-94 | ○ |
| C-56 | param_for_milestone_titles_provided? false | E-04 L93 | ○ |
| C-57 | param_for_milestone_ids_provided? true | E-04 L96-98 | ○ |
| C-58 | param_for_milestone_ids_provided? false | E-04 L97 | ○ |
| C-59 | param_for_milestones_provided? | E-04 L100-102 | ○ |
| C-60 | param_for_milestones_exists? | E-04 L104-106 | ○ |
| C-61 | execute_hooks 呼び出し | E-04 L108-110 | ○ |

### Releases::CreateService（UT-REL-062〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | リリース作成成功 | E-05 L5-32 | ○ |
| C-63 | 権限なしで 403 | E-05 L6 | ○ |
| C-64 | 保護タグで 403 | E-05 L7 | ○ |
| C-65 | 既存リリースで 409 | E-05 L8 | ○ |
| C-66 | マイルストーンタイトル不在で 400 | E-05 L10-14 | ○ |
| C-67 | マイルストーン ID 不在で 400 | E-05 L16-20 | ○ |
| C-68 | タグ自動作成 | E-05 L36-50 | ○ |
| C-69 | ref 未指定で 422 | E-05 L41 | ○ |
| C-70 | 通知サービス呼び出し | E-05 L71, L84-86 | ○ |
| C-71 | Webhook 実行 | E-05 L73 | ○ |
| C-72 | Evidence ワーカーエンキュー | E-05 L75, L107-111 | ○ |
| C-73 | historical_release で Evidence スキップ | E-05 L108 | ○ |
| C-74 | upcoming_release で Evidence スキップ | E-05 L108 | ○ |
| C-75 | Catalog Resource 公開処理 | E-05 L63-67, L113-117 | ○ |
| C-76 | 例外時 400 エラー | E-05 L80-82 | ○ |
| C-77 | links_attributes パース | E-05 L101-105 | ○ |
| C-78 | links_attributes 空配列 | E-05 L102 `|| []` | ○ |

### Releases::UpdateService（UT-REL-079〜090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | リリース更新成功 | E-06 L5-31 | ○ |
| C-80 | タグ不在で 404 | E-06 L36 | ○ |
| C-81 | リリース不在で 404 | E-06 L37 | ○ |
| C-82 | 権限なしで 403 | E-06 L38 | ○ |
| C-83 | 空 params で 400 | E-06 L39, L58-60 | ○ |
| C-84 | マイルストーンタイトル不在で 400 | E-06 L41-45 | ○ |
| C-85 | マイルストーン ID 不在で 400 | E-06 L47-51 | ○ |
| C-86 | Webhook 実行 | E-06 L21 | ○ |
| C-87 | milestones_updated true | E-06 L23-24, L62-66 | ○ |
| C-88 | milestones_updated false | E-06 L62-66 | ○ |
| C-89 | 更新失敗でエラー | E-06 L26 | ○ |
| C-90 | RecordInvalid 例外 | E-06 L28-29 | ○ |

### Releases::DestroyService（UT-REL-091〜097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | リリース削除成功 | E-07 L5-16 | ○ |
| C-92 | リリース不在で 404 | E-07 L6 | ○ |
| C-93 | 権限なしで 403 | E-07 L7 | ○ |
| C-94 | Webhook 実行 | E-07 L12 | ○ |
| C-95 | Catalog Resource unpublished 更新 | E-07 L24-30 | ○ |
| C-96 | Catalog Resource 状態維持 | E-07 L27 | ○ |
| C-97 | 削除失敗でエラー | E-07 L17-18 | ○ |

### Releases::CreateEvidenceService（UT-REL-098〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | Evidence 作成 | E-08 L10-18 | ○ |
| C-99 | summary シリアライズ | E-08 L13-14 | ○ |
| C-100 | summary_sha 計算 | E-08 L16 | ○ |

### Releases::Links::BaseService（UT-REL-101〜102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | initialize で変数設定 | E-09 L12-16 | ○ |
| C-102 | allowed_params でフィルタ | E-09 L20-22 | ○ |

### Releases::Links::CreateService（UT-REL-103〜105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | リンク作成成功 | E-10 L6-15 | ○ |
| C-104 | 権限なしでエラー | E-10 L7 | ○ |
| C-105 | バリデーションエラー | E-10 L14 | ○ |

### Releases::Links::UpdateService（UT-REL-106〜109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | リンク更新成功 | E-11 L6-14 | ○ |
| C-107 | 権限なしでエラー | E-11 L7 | ○ |
| C-108 | リンク不在でエラー | E-11 L8 | ○ |
| C-109 | バリデーションエラー | E-11 L13 | ○ |

### Releases::Links::DestroyService（UT-REL-110〜113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | リンク削除成功 | E-12 L6-14 | ○ |
| C-111 | 権限なしでエラー | E-12 L7 | ○ |
| C-112 | リンク不在でエラー | E-12 L8 | ○ |
| C-113 | 削除失敗でエラー | E-12 L13 | ○ |

### Releases::Links::Params（UT-REL-114〜119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | with_indifferent_access 変換 | E-13 L7 | ○ |
| C-115 | name, url, link_type 抽出 | E-13 L11 | ○ |
| C-116 | direct_asset_path から filepath 変換 | E-13 L12, L21, L24-25 | ○ |
| C-117 | filepath 直接指定 | E-13 L24-25 | ○ |
| C-118 | filepath 未指定時は含まない | E-13 L12 条件分岐 | ○ |
| C-119 | メモ化 | E-13 L11 `@allowed_params ||=` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースについて、対応するソースコードの根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに根拠あり
- 1: 中リスク - 以下の点について実際のテスト実装時に注意が必要
  - FILEPATH_REGEX のカタストロフィックバックトラッキング対策（E-03 L10-11 コメント参照）
  - Evidence.summary の機密情報削除ロジック（GitLab Issue #121930 参照）
  - Catalog Resource 連携のフィーチャーフラグ依存（E-05 L116）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェック（create_release, update_release, destroy_release）のテストが網羅されているか
- [ ] バリデーション（URL, name, filepath）の境界値テストが適切か
- [ ] Webhook（execute_hooks）の各アクション（create, update, delete）がテストされているか
- [ ] マイルストーン検証（inexistent_milestone_titles/ids）のエラーハンドリングが正しいか
- [ ] Evidence 作成条件（historical_release, upcoming_release）のスキップロジックが正しいか
- [ ] Catalog Resource 連携の状態更新ロジックが正しいか
- [ ] トランザクション処理（UpdateService）のロールバックテストが含まれているか
