---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 71
  claims_with_evidence: 71
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：repositories モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：71 / 71、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/repositories/commit_collection_with_next_cursor.rb` - CommitCollectionWithNextCursorクラス定義
- E-02: `app/models/repositories/tags/gpg_signature.rb` - GpgSignatureモデル定義
- E-03: `app/models/repositories/tags/ssh_signature.rb` - SshSignatureモデル定義
- E-04: `app/models/repositories/tags/x509_signature.rb` - X509Signatureモデル定義
- E-05: `app/models/commit_collection.rb` - 親クラスCommitCollection定義
- E-06: `app/models/concerns/signature_type.rb` - SignatureType concern定義
- E-07: `app/models/concerns/sha_attribute.rb` - ShaAttribute concern定義
- E-08: `app/models/concerns/enums/commit_signature.rb` - verification_status enum定義
- E-09: `spec/models/repositories/commit_collection_with_next_cursor_spec.rb` - 既存テスト仕様
- E-10: `spec/models/repositories/tags/gpg_signature_spec.rb` - 既存テスト仕様
- E-11: `spec/models/repositories/tags/ssh_signature_spec.rb` - 既存テスト仕様
- E-12: `spec/models/repositories/tags/x509_signature_spec.rb` - 既存テスト仕様

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CommitCollectionWithNextCursor#initialize - next_cursorを指定してインスタンス生成 | E-01, E-09 | ○ |
| C-02 | CommitCollectionWithNextCursor#initialize - next_cursor=nil生成 | E-01, E-09 | ○ |
| C-03 | CommitCollectionWithNextCursor#next_cursor - attr_reader | E-01, E-09 | ○ |
| C-04 | CommitCollectionWithNextCursor#next_page - alias_method | E-01 | ○ |
| C-05 | CommitCollectionWithNextCursor#each - Enumerable継承 | E-01, E-05, E-09 | ○ |
| C-06 | CommitCollectionWithNextCursor#committers - ユーザー取得 | E-05, E-09 | ○ |
| C-07 | CommitCollectionWithNextCursor#committers - 空配列返却 | E-05, E-09 | ○ |
| C-08 | CommitCollectionWithNextCursor#committers - with_merge_commits=true | E-05, E-09 | ○ |
| C-09 | CommitCollectionWithNextCursor#committers - with_merge_commits=false | E-05, E-09 | ○ |
| C-10 | CommitCollectionWithNextCursor#committers - include_author_when_signed | E-05, E-09 | ○ |
| C-11 | CommitCollectionWithNextCursor#committers - committer_email=nil | E-05, E-09 | ○ |
| C-12 | CommitCollectionWithNextCursor#committer_user_ids | E-05, E-09 | ○ |
| C-13 | CommitCollectionWithNextCursor#committer_user_ids - 空配列 | E-05, E-09 | ○ |
| C-14 | CommitCollectionWithNextCursor#without_merge_commits | E-05, E-09 | ○ |
| C-15 | CommitCollectionWithNextCursor#with_latest_pipeline | E-05, E-09 | ○ |
| C-16 | CommitCollectionWithNextCursor#with_markdown_cache | E-05, E-09 | ○ |
| C-17 | CommitCollectionWithNextCursor#unenriched | E-05, E-09 | ○ |
| C-18 | CommitCollectionWithNextCursor#fully_enriched? - true | E-05, E-09 | ○ |
| C-19 | CommitCollectionWithNextCursor#fully_enriched? - false | E-05, E-09 | ○ |
| C-20 | CommitCollectionWithNextCursor#fully_enriched? - 空 | E-05, E-09 | ○ |
| C-21 | CommitCollectionWithNextCursor#enrich! - 置換 | E-05, E-09 | ○ |
| C-22 | CommitCollectionWithNextCursor#enrich! - 順序維持 | E-05, E-09 | ○ |
| C-23 | CommitCollectionWithNextCursor#enrich! - スキップ | E-05, E-09 | ○ |
| C-24 | CommitCollectionWithNextCursor#enrich! - フォールバック | E-05, E-09 | ○ |
| C-25 | CommitCollectionWithNextCursor#load_tags | E-05, E-09 | ○ |
| C-26 | CommitCollectionWithNextCursor#respond_to_missing? - true | E-05, E-09 | ○ |
| C-27 | CommitCollectionWithNextCursor#respond_to_missing? - false | E-05, E-09 | ○ |
| C-28 | CommitCollectionWithNextCursor#method_missing | E-05, E-09 | ○ |
| C-29 | GpgSignature - belongs_to :project 正常系 | E-02, E-10 | ○ |
| C-30 | GpgSignature - belongs_to :project 必須 | E-02, E-10 | ○ |
| C-31 | GpgSignature - belongs_to :gpg_key | E-02, E-10 | ○ |
| C-32 | GpgSignature - belongs_to :gpg_key_subkey | E-02, E-10 | ○ |
| C-33 | GpgSignature - validates :object_name presence | E-02, E-10 | ○ |
| C-34 | GpgSignature - validates :object_name uniqueness | E-02, E-10 | ○ |
| C-35 | GpgSignature - validates :gpg_key_primary_keyid | E-02, E-10 | ○ |
| C-36 | GpgSignature - scope :by_project | E-02 | ○ |
| C-37 | GpgSignature - scope :by_object_name | E-02 | ○ |
| C-38 | GpgSignature#type | E-02 | ○ |
| C-39 | GpgSignature#gpg_key getter - gpg_key_id | E-02, E-10 | ○ |
| C-40 | GpgSignature#gpg_key getter - gpg_key_subkey_id | E-02, E-10 | ○ |
| C-41 | GpgSignature#gpg_key= setter - GpgKey | E-02, E-10 | ○ |
| C-42 | GpgSignature#gpg_key= setter - GpgKeySubkey | E-02, E-10 | ○ |
| C-43 | GpgSignature#gpg_key= setter - nil | E-02, E-10 | ○ |
| C-44 | GpgSignature - verification_status enum | E-02, E-08 | ○ |
| C-45 | GpgSignature - verification_status 全値 | E-02, E-08 | ○ |
| C-46 | GpgSignature - sha_attribute :object_name | E-02, E-07 | ○ |
| C-47 | GpgSignature - sha_attribute :gpg_key_primary_keyid | E-02, E-07 | ○ |
| C-48 | GpgSignature#gpg? | E-02, E-06 | ○ |
| C-49 | GpgSignature#ssh? | E-02, E-06 | ○ |
| C-50 | GpgSignature#x509? | E-02, E-06 | ○ |
| C-51 | SshSignature - belongs_to :project 正常系 | E-03, E-11 | ○ |
| C-52 | SshSignature - belongs_to :project 必須 | E-03, E-11 | ○ |
| C-53 | SshSignature - belongs_to :key | E-03, E-11 | ○ |
| C-54 | SshSignature - validates :object_name presence | E-03, E-11 | ○ |
| C-55 | SshSignature - validates :object_name uniqueness | E-03, E-11 | ○ |
| C-56 | SshSignature - scope :by_project | E-03 | ○ |
| C-57 | SshSignature - scope :by_object_name | E-03 | ○ |
| C-58 | SshSignature#type | E-03 | ○ |
| C-59 | SshSignature - verification_status enum | E-03, E-08 | ○ |
| C-60 | SshSignature - sha_attribute :object_name | E-03, E-07 | ○ |
| C-61 | SshSignature#gpg? | E-03, E-06 | ○ |
| C-62 | SshSignature#ssh? | E-03, E-06 | ○ |
| C-63 | SshSignature#x509? | E-03, E-06 | ○ |
| C-64 | X509Signature - belongs_to :project 正常系 | E-04, E-12 | ○ |
| C-65 | X509Signature - belongs_to :project 必須 | E-04, E-12 | ○ |
| C-66 | X509Signature - belongs_to :x509_certificate 正常系 | E-04, E-12 | ○ |
| C-67 | X509Signature - belongs_to :x509_certificate 必須 | E-04, E-12 | ○ |
| C-68 | X509Signature - validates :object_name presence | E-04, E-12 | ○ |
| C-69 | X509Signature - validates :object_name uniqueness | E-04, E-12 | ○ |
| C-70 | X509Signature - verification_status enum | E-04, E-08 | ○ |
| C-71 | X509Signature - sha_attribute :object_name | E-04, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全てのテストケースにソースコードの根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード及び既存テストスペックに基づいている
- 注意点：
  - X509Signatureにはtypeメソッドが定義されていない（SignatureType concernのtypeが抽象メソッドのため要確認）
  - BulkInsertSafe concernの挙動テストは省略（共通concern）

## 6) レビュアーチェックリスト（最小）
- [ ] CommitCollectionWithNextCursorが親クラスの全メソッドを正しく継承していることを確認
- [ ] GpgSignatureのgpg_key getter/setterのカスタムロジックが網羅されているか確認
- [ ] verification_status enumの全ステータス（10種類）がテスト対象となっているか確認
- [ ] sha_attributeのバイナリ変換が正しくテストされているか確認
- [ ] scope定義（by_project, by_object_name）のSQLが期待通りか確認
- [ ] X509SignatureにはSignatureType concernのtypeメソッド実装がないため、例外発生テストの追加を検討
