---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 130
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：resource_events単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：130 / 130、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコードからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### モデル
- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/resource_events/issue_assignment_event.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/resource_events/merge_request_assignment_event.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/resource_events/abuse_report_event.rb`

### サービス
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/base_change_timebox_service.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/change_milestone_service.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/change_labels_service.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/change_state_service.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/merge_into_notes_service.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/base_synthetic_notes_builder_service.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/synthetic_label_notes_builder_service.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/synthetic_milestone_notes_builder_service.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/services/resource_events/synthetic_state_notes_builder_service.rb`

### ヘルパー
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/helpers/resource_events/abuse_report_events_helper.rb`

### ライブラリ
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/lib/gitlab/resource_events/assignment_event_recorder.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### モデル：IssueAssignmentEvent (UT-RES-001〜008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :user（optional: true）の定義 | E-01 L7 | ○ |
| C-02 | belongs_to :issueの定義 | E-01 L8 | ○ |
| C-03 | validates :issue, presence: trueの定義 | E-01 L10 | ○ |
| C-04 | enum :action, { add: 1, remove: 2 }の定義 | E-01 L12 | ○ |
| C-05 | self.issuable_id_columnメソッドの定義 | E-01 L14-16 | ○ |

### モデル：MergeRequestAssignmentEvent (UT-RES-009〜015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | belongs_to :user（optional: true）の定義 | E-02 L7 | ○ |
| C-07 | belongs_to :merge_requestの定義 | E-02 L8 | ○ |
| C-08 | validates :merge_request, presence: trueの定義 | E-02 L10 | ○ |
| C-09 | enum :action, { add: 1, remove: 2 }の定義 | E-02 L12 | ○ |
| C-10 | self.issuable_id_columnメソッドの定義 | E-02 L14-16 | ○ |

### モデル：AbuseReportEvent (UT-RES-016〜035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | belongs_to :abuse_report（optional: false）の定義 | E-03 L7 | ○ |
| C-12 | belongs_to :userの定義 | E-03 L8 | ○ |
| C-13 | belongs_to :organization（class_name指定）の定義 | E-03 L9 | ○ |
| C-14 | validates :action, presence: trueの定義 | E-03 L11 | ○ |
| C-15 | validates :organization_id（on: :create）の定義 | E-03 L12 | ○ |
| C-16 | enum :action（9種類のアクション）の定義 | E-03 L14-24 | ○ |
| C-17 | enum :reason（10種類の理由）の定義 | E-03 L26-37 | ○ |
| C-18 | success_messageメソッドの定義 | E-03 L39-41 | ○ |

### サービス：BaseChangeTimeboxService (UT-RES-036〜043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | initializeでresource, userを設定 | E-04 L7-10 | ○ |
| C-20 | executeでcreate_event, track_event, broadcast呼び出し | E-04 L12-17 | ○ |
| C-21 | create_eventがNotImplementedErrorを発生 | E-04 L24-26 | ○ |
| C-22 | build_resource_argsの引数構築ロジック | E-04 L28-36 | ○ |

### サービス：ChangeMilestoneService (UT-RES-044〜053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | initializeでmilestone, old_milestoneを設定 | E-05 L7-12 | ○ |
| C-24 | create_eventでResourceMilestoneEvent.createを呼び出し | E-05 L22-24 | ○ |
| C-25 | build_resource_argsでaction（add/remove）判定 | E-05 L26-34 | ○ |
| C-26 | track_eventでWorkItem判定とトラッキング | E-05 L16-20 | ○ |

### サービス：ChangeLabelsService (UT-RES-054〜067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | initializeでresource, userを設定 | E-06 L6-10 | ○ |
| C-28 | executeでラベル追加・削除イベント作成 | E-06 L12-43 | ○ |
| C-29 | resource_columnでリソースタイプ判定 | E-06 L47-56 | ○ |
| C-30 | create_timeline_events_fromでインシデント連携 | E-06 L58-67 | ○ |

### サービス：ChangeStateService (UT-RES-068〜079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | initializeでuser, resourceを設定 | E-07 L6-10 | ○ |
| C-32 | executeでResourceStateEvent.createを呼び出し | E-07 L12-27 | ○ |
| C-33 | commit_id_ofでCommitのID取得（先頭40文字） | E-07 L49-53 | ○ |
| C-34 | merge_request_id_ofでMergeRequestのID取得 | E-07 L55-59 | ○ |

### サービス：MergeIntoNotesService (UT-RES-080〜086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | initializeでresource, current_user, paramsを設定 | E-08 L18-24 | ○ |
| C-36 | executeでnotesとsynthetic_notesのマージ・ソート | E-08 L26-28 | ○ |
| C-37 | SYNTHETIC_NOTE_BUILDER_SERVICESの定義（3サービス） | E-08 L12-16 | ○ |

### サービス：BaseSyntheticNotesBuilderService (UT-RES-087〜100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | initializeでresource, current_user, paramsを設定 | E-09 L13-18 | ○ |
| C-39 | apply_paginationでページネーション処理 | E-09 L31-35 | ○ |
| C-40 | apply_last_fetched_atで日時フィルタ処理 | E-09 L38-44 | ○ |
| C-41 | resource_parentでフォールバック処理 | E-09 L46-49 | ○ |
| C-42 | table_nameがNotImplementedErrorを発生 | E-09 L51-53 | ○ |

### サービス：SyntheticLabelNotesBuilderService (UT-RES-101〜105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | synthetic_notesでLabelNote生成 | E-10 L12-15 | ○ |
| C-44 | label_events_by_discussion_idでグループ化 | E-10 L18-25 | ○ |
| C-45 | table_name='resource_label_events'の定義 | E-10 L27-29 | ○ |

### サービス：SyntheticMilestoneNotesBuilderService (UT-RES-106〜109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | synthetic_notesでMilestoneNote生成 | E-11 L12-15 | ○ |
| C-47 | milestone_change_eventsでイベント取得 | E-11 L18-23 | ○ |
| C-48 | table_name='resource_milestone_events'の定義 | E-11 L25-27 | ○ |

### サービス：SyntheticStateNotesBuilderService (UT-RES-110〜113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | synthetic_notesでStateNote生成 | E-12 L7-10 | ○ |
| C-50 | state_change_eventsでイベント取得 | E-12 L13-17 | ○ |
| C-51 | table_name='resource_state_events'の定義 | E-12 L19-21 | ○ |

### ライブラリ：AssignmentEventRecorder (UT-RES-114〜125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | BATCH_SIZE=100の定義 | E-14 L6 | ○ |
| C-53 | initializeでparent, old_assigneesを設定 | E-14 L8-11 | ○ |
| C-54 | recordでIssue/MergeRequest分岐 | E-14 L13-29 | ○ |
| C-55 | record_for_parentで追加・削除イベント作成 | E-14 L36-55 | ○ |
| C-56 | バッチ処理（each_slice(BATCH_SIZE)） | E-14 L53-55 | ○ |

### ヘルパー：AbuseReportEventsHelper (UT-RES-126〜130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | success_message_for_actionで9種類のメッセージ返却 | E-13 L5-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいており、推測による記述はない

## 6) レビュアーチェックリスト（最小）
- [ ] IssueAssignmentEvent / MergeRequestAssignmentEventのenum :actionの値（add: 1, remove: 2）が正しいか確認
- [ ] AbuseReportEventのenum :action, :reasonの値が実際のコードと一致しているか確認
- [ ] ChangeMilestoneServiceのbuild_resource_argsでのaction判定ロジックが正しいか確認
- [ ] ChangeLabelsServiceのresource_columnでのリソースタイプ判定が網羅されているか確認
- [ ] ChangeStateServiceのcommit_id_ofで先頭40文字切り詰めが正しいか確認
- [ ] AssignmentEventRecorderのBATCH_SIZE=100が適切か確認
- [ ] 各Syntheticサービスのeager loading（includes）が正しいか確認
