---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 116
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：root モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：116 / 120、根拠なし：4
- 優先レビュー（高）
  1. **UT-ROT-090～092 User関連テスト**：Userモデルの詳細実装未確認
  2. **UT-ROT-096～099 Project関連テスト**：Projectモデルの詳細実装未確認
  3. **UT-ROT-100～108 MergeRequest関連テスト**：MergeRequestモデルの部分的確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/issue.rb` - Issueモデルの実装（リレーション、バリデーション、メソッド）
- E-02: `app/models/note.rb` - Noteモデルの実装（リレーション、スコープ、メソッド）
- E-03: `app/models/milestone.rb` - Milestoneモデルの実装（リレーション、状態遷移、バリデーション）
- E-04: `app/models/label.rb` - Labelモデルの実装（リレーション、優先度、バリデーション）
- E-05: `app/models/todo.rb` - Todoモデルの実装（リレーション、状態遷移、アクション）
- E-06: `app/models/event.rb` - Eventモデルの実装（リレーション、アクション、スコープ）
- E-07: `app/models/commit.rb` - Commitモデルの実装（タイトル、説明、マージコミット判定）
- E-08: `app/models/deploy_key.rb` - DeployKeyモデルの実装（リレーション、権限確認）
- E-09: `app/models/release.rb` - Releaseモデルの実装（リレーション、バリデーション）
- E-10: `app/models/snippet.rb` - Snippetモデルの実装（リレーション、可視性、スパムチェック）
- E-11: `app/models/user.rb` - Userモデルの実装（一部確認）
- E-12: `app/models/project.rb` - Projectモデルの実装（一部確認）
- E-13: `app/models/merge_request.rb` - MergeRequestモデルの実装（一部確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Issue belongs_to :projectリレーション | E-01 | ○ |
| C-02 | Issue belongs_to :namespaceリレーション | E-01 | ○ |
| C-03 | Issue has_many :assigneesリレーション | E-01 | ○ |
| C-04 | Issue moved?メソッド（true） | E-01 | ○ |
| C-05 | Issue moved?メソッド（false） | E-01 | ○ |
| C-06 | Issue duplicated?メソッド（true） | E-01 | ○ |
| C-07 | Issue duplicated?メソッド（false） | E-01 | ○ |
| C-08 | Issue can_move?メソッド | E-01 | ○ |
| C-09 | Issue can_move?エラーケース | E-01 | ○ |
| C-10 | Issue to_branch_name（機密） | E-01 | ○ |
| C-11 | Issue to_branch_name（通常） | E-01 | ○ |
| C-12 | Issue hidden?メソッド（banned） | E-01 | ○ |
| C-13 | Issue hidden?メソッド（通常） | E-01 | ○ |
| C-14 | Issue from_service_desk?メソッド | E-01 | ○ |
| C-15 | Issue group_level?メソッド（グループ） | E-01 | ○ |
| C-16 | Issue group_level?メソッド（プロジェクト） | E-01 | ○ |
| C-17 | Issue state遷移（open→close） | E-01 | ○ |
| C-18 | Issue state遷移（close→open） | E-01 | ○ |
| C-19 | Issue due_dateバリデーション | E-01 | ○ |
| C-20 | Issue ensure_namespace_id | E-01 | ○ |
| C-21 | Note belongs_to :projectリレーション | E-02 | ○ |
| C-22 | Note belongs_to :noteableリレーション | E-02 | ○ |
| C-23 | Note for_commit?メソッド | E-02 | ○ |
| C-24 | Note for_issue?メソッド | E-02 | ○ |
| C-25 | Note for_merge_request?メソッド | E-02 | ○ |
| C-26 | Note editable?（通常） | E-02 | ○ |
| C-27 | Note editable?（システム） | E-02 | ○ |
| C-28 | Note confidential?メソッド | E-02 | ○ |
| C-29 | Note award_emoji?メソッド | E-02 | ○ |
| C-30 | Note can_create_todo?メソッド | E-02 | ○ |
| C-31 | Milestone belongs_to :projectリレーション | E-03 | ○ |
| C-32 | Milestone belongs_to :groupリレーション | E-03 | ○ |
| C-33 | Milestone group_milestone?メソッド | E-03 | ○ |
| C-34 | Milestone project_milestone?メソッド | E-03 | ○ |
| C-35 | Milestone state遷移（active→closed） | E-03 | ○ |
| C-36 | Milestone state遷移（closed→active） | E-03 | ○ |
| C-37 | Milestone parent_type_checkバリデーション | E-03 | ○ |
| C-38 | Milestone resource_parentメソッド | E-03 | ○ |
| C-39 | Label belongs_to :projectリレーション | E-04 | ○ |
| C-40 | Label belongs_to :groupリレーション | E-04 | ○ |
| C-41 | Label prioritize!メソッド | E-04 | ○ |
| C-42 | Label prioritize!（アーカイブ時） | E-04 | ○ |
| C-43 | Label unprioritize!メソッド | E-04 | ○ |
| C-44 | Label lock_on_mergeバリデーション | E-04 | ○ |
| C-45 | Label prevent_locked_label_destroy | E-04 | ○ |
| C-46 | Todo belongs_to :userリレーション | E-05 | ○ |
| C-47 | Todo belongs_to :targetリレーション | E-05 | ○ |
| C-48 | Todo state遷移（pending→done） | E-05 | ○ |
| C-49 | Todo action_nameメソッド | E-05 | ○ |
| C-50 | Todo for_commit?メソッド | E-05 | ○ |
| C-51 | Todo done?メソッド | E-05 | ○ |
| C-52 | Todo self_added?メソッド | E-05 | ○ |
| C-53 | Todo body（Note有） | E-05 | ○ |
| C-54 | Todo body（Note無） | E-05 | ○ |
| C-55 | Event belongs_to :projectリレーション | E-06 | ○ |
| C-56 | Event belongs_to :targetリレーション | E-06 | ○ |
| C-57 | Event issue?メソッド | E-06 | ○ |
| C-58 | Event merge_request?メソッド | E-06 | ○ |
| C-59 | Event visible_to_user?メソッド | E-06 | ○ |
| C-60 | Event action_nameメソッド | E-06 | ○ |
| C-61 | Event membership_changed?メソッド | E-06 | ○ |
| C-62 | Commit initializeエラー | E-07 | ○ |
| C-63 | Commit title（短い） | E-07 | ○ |
| C-64 | Commit title（長い） | E-07 | ○ |
| C-65 | Commit descriptionメソッド | E-07 | ○ |
| C-66 | Commit authorメソッド | E-07 | ○ |
| C-67 | Commit merge_commit?メソッド | E-07 | ○ |
| C-68 | Commit draft?メソッド | E-07 | ○ |
| C-69 | Commit valid_hash?メソッド | E-07 | ○ |
| C-70 | Commit short_idメソッド | E-07 | ○ |
| C-71 | DeployKey has_many :projectsリレーション | E-08 | ○ |
| C-72 | DeployKey private?メソッド | E-08 | ○ |
| C-73 | DeployKey orphaned?メソッド | E-08 | ○ |
| C-74 | DeployKey has_access_to?メソッド | E-08 | ○ |
| C-75 | DeployKey can_push_to?メソッド | E-08 | ○ |
| C-76 | Release belongs_to :projectリレーション | E-09 | ○ |
| C-77 | Release has_many :milestonesリレーション | E-09 | ○ |
| C-78 | Release upcoming_release?メソッド | E-09 | ○ |
| C-79 | Release historical_release?メソッド | E-09 | ○ |
| C-80 | Release sha_unchangedバリデーション | E-09 | ○ |
| C-81 | Release name（設定済み） | E-09 | ○ |
| C-82 | Release name（未設定） | E-09 | ○ |
| C-83 | Snippet belongs_to :authorリレーション | E-10 | ○ |
| C-84 | Snippet belongs_to :projectリレーション | E-10 | ○ |
| C-85 | Snippet embeddable?メソッド | E-10 | ○ |
| C-86 | Snippet hidden_due_to_author_ban?メソッド | E-10 | ○ |
| C-87 | Snippet check_for_spam?メソッド | E-10 | ○ |
| C-88 | Snippet file_name（nil時） | E-10 | ○ |
| C-89 | Snippet multiple_files?メソッド | E-10 | ○ |
| C-90 | User has_one :namespaceリレーション | E-11 | △ |
| C-91 | User has_many :projectsリレーション | E-11 | △ |
| C-92 | User has_many :issuesリレーション | E-11 | △ |
| C-93 | User usernameバリデーション | E-11 | ○ |
| C-94 | User projects_limitバリデーション | E-11 | ○ |
| C-95 | User update_tracked_fields!メソッド | E-11 | ○ |
| C-96 | Project belongs_to :namespaceリレーション | E-12 | ○ |
| C-97 | Project belongs_to :creatorリレーション | E-12 | ○ |
| C-98 | Project has_many :issuesリレーション | E-12 | ○ |
| C-99 | Project has_many :merge_requestsリレーション | E-12 | △ |
| C-100 | MergeRequest belongs_to :target_projectリレーション | E-13 | ○ |
| C-101 | MergeRequest belongs_to :source_projectリレーション | E-13 | ○ |
| C-102 | MergeRequest state遷移（opened→closed） | E-13 | ○ |
| C-103 | MergeRequest state遷移（opened→merged） | E-13 | ○ |
| C-104 | MergeRequest merge_status遷移 | E-13 | ○ |
| C-105 | MergeRequest public_merge_statusメソッド | E-13 | ○ |
| C-106 | MergeRequest draft?メソッド | E-13 | ○ |
| C-107 | MergeRequest source_projectバリデーション | E-13 | ○ |
| C-108 | MergeRequest allow_broken例外 | E-13 | ○ |
| C-109 | ApplicationRecord table_name_prefix | **根拠なし** | △ |
| C-110 | Issue scope :with_due_date | E-01 | ○ |
| C-111 | Issue scope :without_due_date | E-01 | ○ |
| C-112 | Issue scope :due_before | E-01 | ○ |
| C-113 | Issue scope :confidential_only | E-01 | ○ |
| C-114 | Issue scope :public_only | E-01 | ○ |
| C-115 | Note scope :system | E-02 | ○ |
| C-116 | Note scope :user | E-02 | ○ |
| C-117 | Todo scope :pending | E-05 | ○ |
| C-118 | Todo scope :done | E-05 | ○ |
| C-119 | Event scope :recent | E-06 | ○ |
| C-120 | Milestone scope :active | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **User, Project, MergeRequestモデルの詳細確認**
  - これらのモデルは非常に大きいため、部分的にしか確認できていない
  - 候補：`app/models/user.rb`（全文）/ `app/models/project.rb`（全文）/ `app/models/merge_request.rb`（全文）

- **ApplicationRecordの基底クラス実装**
  - `app/models/application_record.rb` の確認が必要
  - 候補：`app/models/application_record.rb`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Issue, Note, Milestone, Label, Todo, Event, Commit, DeployKey, Release, Snippet関連テスト
  - ソースコードを直接確認し、メソッドの存在と動作を検証済み

- **1（中リスク）**: User, Project, MergeRequest関連テスト（一部）
  - 部分的なソースコード確認のため、詳細な実装との乖離の可能性あり
  - ただし、GitLabの標準的なRailsモデル構造に基づいた推論は信頼性が高い

- **0（低リスク）**: スコープ関連テスト
  - ソースコードで直接スコープ定義を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] User, Project, MergeRequestモデルの詳細実装と生成テストケースの整合性確認
- [ ] ApplicationRecordの基底クラス実装確認
- [ ] 各モデルのconcernsによる拡張メソッドの網羅性確認
- [ ] EE（Enterprise Edition）固有の機能がテストケースに含まれていないことの確認
- [ ] 状態遷移テストの完全性確認（全遷移パスのカバレッジ）
- [ ] バリデーションテストの境界値テスト追加検討
