---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 102
  claims_with_evidence: 102
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：service_desk単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：102 / 102、根拠なし：0
- 優先レビュー（高）
  1. **SMTP関連エラーハンドリング（UT-SDS-059〜061）**：実際のSMTPエラー発生時の挙動確認が必要
  2. **状態遷移テスト（UT-SDS-041〜047）**：state_machineの挙動確認が必要
  3. **トランザクション処理（UT-SDS-077〜078）**：ロールバック挙動の実機確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/service_desk/custom_email_credential.rb`
- E-02: `app/models/service_desk/custom_email_verification.rb`
- E-03: `app/services/service_desk/custom_email_verifications/base_service.rb`
- E-04: `app/services/service_desk/custom_email_verifications/create_service.rb`
- E-05: `app/services/service_desk/custom_email_verifications/update_service.rb`
- E-06: `app/services/service_desk/custom_emails/base_service.rb`
- E-07: `app/services/service_desk/custom_emails/create_service.rb`
- E-08: `app/services/service_desk/custom_emails/destroy_service.rb`
- E-09: `app/workers/service_desk/custom_email_verification_cleanup_worker.rb`
- E-10: `lib/service_desk/emails.rb`
- E-11: `app/services/concerns/service_desk/custom_emails/logger.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### CustomEmailCredentialモデル（UT-SDS-001〜026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :project リレーション | E-01 L42 | ○ |
| C-02 | project presence検証 | E-01 L44 | ○ |
| C-03 | smtp_address presence/length/hostname検証 | E-01 L46-49 | ○ |
| C-04 | validate_smtp_address ブロックURL検証 | E-01 L79-91 | ○ |
| C-05 | smtp_port presence/numericality検証 | E-01 L52-54 | ○ |
| C-06 | smtp_username presence/length検証 | E-01 L56-58 | ○ |
| C-07 | smtp_password length検証（min:8, max:128） | E-01 L59-61 | ○ |
| C-08 | delivery_optionsメソッドの返却値 | E-01 L65-75 | ○ |
| C-09 | SMTP_READ_TIMEOUT定数（7秒） | E-01 L19 | ○ |
| C-10 | attr_encrypted :smtp_username/smtp_password | E-01 L29-40 | ○ |
| C-11 | enum :smtp_authentication (plain/login/cram_md5) | E-01 L23-27 | ○ |

### CustomEmailVerificationモデル（UT-SDS-027〜054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | belongs_to :project リレーション | E-02 L27 | ○ |
| C-13 | belongs_to :triggerer (optional) | E-02 L28 | ○ |
| C-14 | TIMEFRAME定数（30分） | E-02 L7 | ○ |
| C-15 | STATES定数（started/finished/failed） | E-02 L8 | ○ |
| C-16 | scope :overdue | E-02 L33 | ○ |
| C-17 | generate_tokenクラスメソッド（12文字） | E-02 L100-102 | ○ |
| C-18 | accepted_untilメソッド | E-02 L105-110 | ○ |
| C-19 | in_timeframe?メソッド | E-02 L112-116 | ○ |
| C-20 | state_machine定義と状態遷移 | E-02 L37-93 | ○ |
| C-21 | mark_as_started!イベント | E-02 L55-57, L67-74 | ○ |
| C-22 | mark_as_finished!イベント | E-02 L59-61, L76-78 | ○ |
| C-23 | mark_as_failed!イベント | E-02 L63-65, L80-85 | ○ |
| C-24 | 状態別バリデーション | E-02 L38-53 | ○ |
| C-25 | enum :error定義 | E-02 L10-18 | ○ |
| C-26 | attr_encrypted :token | E-02 L20-25 | ○ |

### CustomEmailVerifications::CreateService（UT-SDS-055〜061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | settings存在チェック | E-04 L17 | ○ |
| C-28 | admin権限チェック | E-04 L18 | ○ |
| C-29 | SMTP_HOST_ERRORS定数 | E-04 L6-14 | ○ |
| C-30 | SMTPエラーハンドリング | E-04 L54-68 | ○ |
| C-31 | custom_email_enabled更新 | E-04 L40 | ○ |

### CustomEmailVerifications::UpdateService（UT-SDS-062〜071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | パラメータ存在チェック | E-05 L9 | ○ |
| C-33 | 既完了チェック | E-05 L10 | ○ |
| C-34 | 既失敗チェック | E-05 L11 | ○ |
| C-35 | verify検証ロジック | E-05 L45-52 | ○ |
| C-36 | EMAIL_TOKEN_REGEXP | E-05 L6 | ○ |
| C-37 | incorrect_from検証 | E-05 L70-72 | ○ |
| C-38 | incorrect_token検証 | E-05 L75-83 | ○ |
| C-39 | forwarded_to_service_desk_alias_address検証 | E-05 L59-68 | ○ |

### CustomEmails::CreateService（UT-SDS-072〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | 権限チェック | E-07 L7 | ○ |
| C-41 | 必須パラメータチェック | E-07 L8, L66-71 | ○ |
| C-42 | 既存設定チェック | E-07 L9 | ○ |
| C-43 | credential作成処理 | E-07 L41-46 | ○ |
| C-44 | ロールバック処理 | E-07 L37-39 | ○ |

### CustomEmails::DestroyService（UT-SDS-079〜083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | 権限チェック | E-08 L7 | ○ |
| C-46 | 存在チェック | E-08 L8 | ○ |
| C-47 | 削除処理と設定リセット | E-08 L10-13 | ○ |

### CustomEmailVerificationCleanupWorker（UT-SDS-084〜086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | overdue検索とlimit(2400) | E-09 L21 | ○ |
| C-49 | UpdateService呼び出し | E-09 L24-31 | ○ |

### ServiceDesk::Emails（UT-SDS-087〜099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | initialize処理 | E-10 L8-10 | ○ |
| C-51 | all_addressesメソッド | E-10 L12-18 | ○ |
| C-52 | addressメソッド | E-10 L20-22 | ○ |
| C-53 | system_addressメソッド | E-10 L24-26 | ○ |
| C-54 | alias_addressメソッド | E-10 L28-34 | ○ |
| C-55 | incoming_addressメソッド | E-10 L36-43 | ○ |
| C-56 | default_subaddress_partメソッド | E-10 L45-47 | ○ |

### Logger Concern（UT-SDS-100〜102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | log_warningメソッド | E-11 L8-12 | ○ |
| C-58 | log_infoメソッド | E-11 L14-18 | ○ |
| C-59 | build_log_messageメソッド | E-11 L33-37 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対応するソースコードの根拠が確認できました
- 追加で確認が推奨される項目：
  - 実際の既存specファイル（`spec/models/service_desk/`、`spec/services/service_desk/`）との整合性確認
  - ServiceDeskSettings::UpdateServiceとの連携部分の詳細確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なバリデーション、リレーション、アクセサのテスト
- **1（中リスク）**: 状態遷移、ロールバック処理のテスト
  - UT-SDS-041〜054: state_machineの状態遷移テスト - 実機での遷移確認推奨
  - UT-SDS-077〜078: トランザクションのロールバックテスト - 実機確認推奨
- **1（中リスク）**: SMTPエラーハンドリングのテスト
  - UT-SDS-059〜061: 実際のSMTPエラー発生時の挙動はモック環境との差異に注意

## 6) レビュアーチェックリスト（最小）
- [ ] CustomEmailCredentialのSMTPアドレスバリデーション（UT-SDS-003〜007）が実際のセキュリティ要件を満たしているか確認
- [ ] パスワード長制限（8〜128文字）がセキュリティポリシーと整合しているか確認
- [ ] 状態遷移テスト（UT-SDS-041〜054）がstate_machineの全遷移パターンをカバーしているか確認
- [ ] SMTPエラーハンドリング（UT-SDS-059〜061）がSMTP_HOST_ERRORS定数の全エラー型をカバーしているか確認
- [ ] CleanupWorkerの制限（2400件）がパフォーマンス要件と整合しているか確認
- [ ] ServiceDesk::Emailsのアドレス生成ロジックが実際の運用要件と整合しているか確認
