---
generated_at: 2026-01-22 15:20:00
metrics:
  claims_total: 97
  claims_with_evidence: 97
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：service_ping.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：97 / 97、根拠なし：0
- 優先レビュー（高）
  1. **UT-SPI-025〜031**：SubmitService.execute関連 - 外部HTTP通信のモック戦略確認
  2. **UT-SPI-069〜072**：DevopsReport.execute関連 - DevOpsReport::Metricとの連携確認
  3. **UT-SPI-042〜055**：BuildPayload関連 - MetricDefinitionのモック戦略確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/service_ping/queries_service_ping.rb` - QueriesServicePingモデル定義
- E-02: `app/models/service_ping/non_sql_service_ping.rb` - NonSqlServicePingモデル定義
- E-03: `app/services/service_ping/submit_service.rb` - SubmitService実装
- E-04: `lib/service_ping/build_payload.rb` - BuildPayload実装
- E-05: `lib/service_ping/service_ping_settings.rb` - ServicePingSettings実装
- E-06: `lib/service_ping/permit_data_categories.rb` - PermitDataCategories実装
- E-07: `lib/service_ping/devops_report.rb` - DevopsReport実装
- E-08: `lib/gitlab/usage/service_ping/instrumented_payload.rb` - InstrumentedPayload実装
- E-09: `lib/gitlab/usage/service_ping/legacy_metric_metadata_decorator.rb` - LegacyMetricMetadataDecorator実装
- E-10: `lib/gitlab/usage/service_ping/payload_keys_processor.rb` - PayloadKeysProcessor実装

## 3) Claims と根拠の対応（レビューの主戦場）

### ServicePing::QueriesServicePing（UT-SPI-001〜011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | organizationリレーション定義 | E-01 L7: `belongs_to :organization, class_name: 'Organizations::Organization'` | ○ |
| C-02 | payloadのJSON型属性 | E-01 L9: `attribute :payload, Gitlab::Database::Type::JsonPgSafe.new` | ○ |
| C-03 | payloadのpresenceバリデーション | E-01 L11: `validates :payload, presence: true` | ○ |
| C-04 | recorded_atのpresenceバリデーション | E-01 L12: `validates :recorded_at, presence: true, uniqueness: { scope: :organization_id }` | ○ |
| C-05 | recorded_atのuniquenessバリデーション（organization_idスコープ） | E-01 L12 | ○ |
| C-06 | for_current_reporting_cycleスコープ | E-01 L14-17: scopeブロック定義 | ○ |
| C-07 | REPORTING_CADENCE定数参照 | E-01 L5: `REPORTING_CADENCE = RawUsageData::REPORTING_CADENCE` | ○ |

### ServicePing::NonSqlServicePing（UT-SPI-012〜022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | organizationリレーション定義 | E-02 L7: `belongs_to :organization, class_name: 'Organizations::Organization'` | ○ |
| C-09 | payloadのJSON型属性 | E-02 L9: `attribute :payload, Gitlab::Database::Type::JsonPgSafe.new` | ○ |
| C-10 | payloadのpresenceバリデーション | E-02 L11: `validates :payload, presence: true` | ○ |
| C-11 | recorded_atのpresenceバリデーション | E-02 L12 | ○ |
| C-12 | for_current_reporting_cycleスコープ | E-02 L14-17 | ○ |

### ServicePing::SubmitService（UT-SPI-023〜041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | initializeでorganizationとpayload引数 | E-03 L13-16 | ○ |
| C-14 | enabled_and_consented?のチェック | E-03 L19 | ○ |
| C-15 | payloadがblankの場合SubmissionError | E-03 L64: `raise SubmissionError, 'Usage data payload is blank' if payload.blank?` | ○ |
| C-16 | HTTPレスポンス失敗時のエラー | E-03 L26: `raise SubmissionError, "Unsuccessful response code: #{response.code}"` | ○ |
| C-17 | usage_data_id検証 | E-03 L70-75 | ○ |
| C-18 | エラー時のsubmit_error_payload呼び出し | E-03 L31 | ○ |
| C-19 | base_url環境判定 | E-03 L111-113 | ○ |
| C-20 | PRODUCTION_BASE_URL定数 | E-03 L5: `PRODUCTION_BASE_URL = 'https://version.gitlab.com'` | ○ |
| C-21 | STAGING_BASE_URL定数 | E-03 L6 | ○ |
| C-22 | save_raw_usage_dataでfind_or_create_by | E-03 L101-107 | ○ |
| C-23 | metadataメソッド構造 | E-03 L41-49 | ○ |

### ServicePing::BuildPayload（UT-SPI-042〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | executeでfiltered_usage_data呼び出し | E-04 L5-7 | ○ |
| C-25 | filtered_usage_dataのHash判定 | E-04 L16: `return unless payload.is_a?(Hash)` | ○ |
| C-26 | include_metric?の条件 | E-04 L29-31 | ○ |
| C-27 | valid_metric_status?の実装 | E-04 L33-35 | ○ |
| C-28 | permitted_metric?の実装 | E-04 L41-43 | ○ |
| C-29 | has_metric_definition?の実装 | E-04 L45-47 | ○ |
| C-30 | metric_categoryのデフォルト値 | E-04 L50: `OPTIONAL_CATEGORY` | ○ |
| C-31 | PermitDataCategoriesの呼び出し | E-04 L38 | ○ |

### ServicePing::ServicePingSettings（UT-SPI-056〜061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | enabled_and_consented?の実装 | E-05 L7-9 | ○ |
| C-33 | enabled?の実装 | E-05 L18-20 | ○ |
| C-34 | license_operational_metric_enabled?がfalse | E-05 L11-13 | ○ |
| C-35 | usage_ping_enabled?の参照 | E-05 L19 | ○ |
| C-36 | single_user同意チェック | E-05 L8 | ○ |

### ServicePing::PermitDataCategories（UT-SPI-062〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | 4つのカテゴリ定数 | E-06 L5-8 | ○ |
| C-38 | CATEGORIESがfrozen Set | E-06 L9-14 | ○ |
| C-39 | executeでCATEGORIES返却 | E-06 L16-18 | ○ |

### ServicePing::DevopsReport（UT-SPI-068〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | initializeでdata引数 | E-07 L5-7 | ○ |
| C-41 | conv_index/dev_ops_score取得 | E-07 L12 | ○ |
| C-42 | usage_data_idのみの場合早期リターン | E-07 L17 | ○ |
| C-43 | DevOpsReport::Metric.create呼び出し | E-07 L19-21 | ○ |
| C-44 | 永続化失敗時のエラートラッキング | E-07 L23-27 | ○ |

### Gitlab::Usage::ServicePing::InstrumentedPayload（UT-SPI-073〜079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | initializeで2引数 | E-08 L12-15 | ○ |
| C-46 | buildでmap/reduce | E-08 L17-21 | ○ |
| C-47 | compute_instrumental_valueの実装 | E-08 L31-40 | ○ |
| C-48 | metric_fallbackの実装 | E-08 L42-44 | ○ |
| C-49 | エラー時のErrorTracking呼び出し | E-08 L38 | ○ |

### Gitlab::Usage::ServicePing::LegacyMetricMetadataDecorator（UT-SPI-080〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | SimpleDelegator継承 | E-09 L6 | ○ |
| C-51 | duration属性 | E-09 L7 | ○ |
| C-52 | error属性 | E-09 L7 | ○ |
| C-53 | delegate宣言 | E-09 L9 | ○ |
| C-54 | initializeの実装 | E-09 L11-15 | ○ |

### Gitlab::Usage::ServicePing::PayloadKeysProcessor（UT-SPI-088〜097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | initializeでold_payload | E-10 L11-13 | ○ |
| C-56 | key_pathsのメモ化 | E-10 L15-17 | ○ |
| C-57 | missing_instrumented_metrics_key_paths | E-10 L19-21 | ○ |
| C-58 | payload_keysの再帰処理 | E-10 L25-35 | ○ |
| C-59 | has_metric_definition?の実装 | E-10 L37-40 | ○ |
| C-60 | metric_definitionsでnot_removed | E-10 L42-44 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全テストケースがソースコードに基づいて生成されており、根拠が明確
- **注意点**：
  - SubmitServiceの外部HTTP通信テストには適切なモック戦略が必要
  - DevopsReportはDevOpsReport::Metricモデルとの連携確認が必要
  - prepend_mod/extend_mod_withによるEE拡張の影響を考慮する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] QueriesServicePingとNonSqlServicePingの違いが適切にテストされているか
- [ ] SubmitServiceのHTTP通信モック戦略が適切か
- [ ] BuildPayloadのフィルタリングロジックが網羅されているか
- [ ] ServicePingSettingsの同意チェックロジックが正しいか
- [ ] DevopsReportのDevOpsReport::Metric連携が正しいか
- [ ] InstrumentedPayloadのエラーハンドリングが適切か
- [ ] PayloadKeysProcessorの再帰処理が正しくテストされているか
- [ ] EE拡張（prepend_mod）の影響を考慮したテストが必要か確認
