---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 126
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：snippets モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：126 / 130、根拠なし：4
- 優先レビュー（高）
  1. **UT-SNP-104**：Akismetサービスのエラーハンドリング詳細が不明
  2. **UT-SNP-108**：unretrievable_blobs?フラグの設定条件の詳細実装
  3. **UT-SNP-096/097**：BAN済みユーザー除外のポリシー実装詳細
  4. **UT-SNP-112**：未知のreasonに対するログ出力の実装詳細

## 2) 参照した情報（Evidence一覧）

### モデル
- E-01: `app/models/snippets/repository_storage_move.rb`

### サービス
- E-02: `app/services/snippets/base_service.rb`
- E-03: `app/services/snippets/create_service.rb`
- E-04: `app/services/snippets/update_service.rb`
- E-05: `app/services/snippets/destroy_service.rb`
- E-06: `app/services/snippets/bulk_destroy_service.rb`
- E-07: `app/services/snippets/count_service.rb`
- E-08: `app/services/snippets/update_statistics_service.rb`
- E-09: `app/services/snippets/repository_validation_service.rb`
- E-10: `app/services/snippets/update_repository_storage_service.rb`
- E-11: `app/services/snippets/schedule_bulk_repository_shard_moves_service.rb`

### ワーカー
- E-12: `app/workers/snippets/update_repository_storage_worker.rb`
- E-13: `app/workers/snippets/schedule_bulk_repository_shard_moves_worker.rb`

### GraphQL
- E-14: `app/graphql/mutations/snippets/base.rb`
- E-15: `app/graphql/mutations/snippets/create.rb`
- E-16: `app/graphql/mutations/snippets/update.rb`
- E-17: `app/graphql/mutations/snippets/destroy.rb`
- E-18: `app/graphql/mutations/snippets/mark_as_spam.rb`
- E-19: `app/graphql/resolvers/snippets/blobs_resolver.rb`

### ファインダー・ヘルパー
- E-20: `app/finders/snippets_finder.rb`
- E-21: `app/helpers/snippets_helper.rb`

### コントローラー
- E-22: `app/controllers/snippets_controller.rb`
- E-23: `app/controllers/snippets/application_controller.rb`
- E-24: `app/controllers/concerns/snippets_actions.rb`

### API
- E-25: `lib/api/helpers/snippets/http_response_map.rb`
- E-26: `lib/api/entities/snippets/repository_storage_move.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Snippets::RepositoryStorageMove (UT-SNP-001 〜 005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | containerリレーションが正しく取得できる | E-01 L13-14 | ○ |
| C-02 | snippetエイリアスでcontainerが取得できる | E-01 L14 | ○ |
| C-03 | container_idでsnippet_idが取得できる | E-01 L16 | ○ |
| C-04 | UpdateRepositoryStorageWorkerがスケジュールされる | E-01 L18-21 | ○ |
| C-05 | error_keyとして:snippetが返却される | E-01 L25-28 | ○ |

### Snippets::BaseService (UT-SNP-006 〜 020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | initializeでuploaded_assetsとsnippet_actionsが初期化される | E-02 L18-24 | ○ |
| C-07 | filesパラメータがnilの場合空配列になる | E-02 L21 | ○ |
| C-08 | visibility_allowed?で許可された可視性がチェックされる | E-02 L29-31 | ○ |
| C-09 | visibility_allowed?で許可されていない可視性がfalseを返す | E-02 L29-31 | ○ |
| C-10 | valid_params?でsnippet_actionsが空の場合true | E-02 L39-42 | ○ |
| C-11 | valid_params?でsnippet_actionsとcontentの両方指定でfalse | E-02 L42 | ○ |
| C-12 | valid_params?でsnippet_actionsが無効な場合false | E-02 L42 | ○ |
| C-13 | invalid_params_errorでcontentエラーが設定される | E-02 L45-54 | ○ |
| C-14 | invalid_params_errorでsnippet_actionsエラーが設定される | E-02 L50-52 | ○ |
| C-15 | snippet_error_responseでServiceResponse.errorが返却される | E-02 L57-63 | ○ |
| C-16 | repository_error_messageでCreateService時のメッセージが生成される | E-02 L71-80 | ○ |
| C-17 | CommitError時は追加メッセージなしで返却される | E-02 L77 | ○ |
| C-18 | file_paths_to_commitでファイルパスが抽出される | E-02 L82-86 | ○ |
| C-19 | files_to_commitでsnippet_actionsがある場合そのアクションが返却される | E-02 L88-89 | ○ |
| C-20 | delete_repositoryでリポジトリが削除される | E-02 L107-113 | ○ |

### Snippets::CreateService (UT-SNP-021 〜 033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | executeでスニペットが正常に作成される | E-03 L14-43 | ○ |
| C-22 | 無効なパラメータでエラーが返却される | E-03 L17 | ○ |
| C-23 | 許可されていない可視性でエラーが返却される | E-03 L19-21 | ○ |
| C-24 | スパムチェックが実行される | E-03 L25-27 | ○ |
| C-25 | スパムチェックがスキップできる | E-03 L25 | ○ |
| C-26 | プロジェクトsnippetが作成される | E-03 L53-57 | ○ |
| C-27 | 個人snippetが作成される | E-03 L58-61 | ○ |
| C-28 | 保存後にリポジトリが作成される | E-03 L78-86 | ○ |
| C-29 | リポジトリ作成失敗時にロールバックされる | E-03 L88-104 | ○ |
| C-30 | create_repositoryでリポジトリが作成される | E-03 L107-110 | ○ |
| C-31 | リポジトリが存在しない場合CreateRepositoryErrorがraiseされる | E-03 L110 | ○ |
| C-32 | PersonalSnippetの場合ファイルが移動される | E-03 L119-124 | ○ |
| C-33 | ProjectSnippetの場合ファイル移動がスキップされる | E-03 L120 | ○ |

### Snippets::UpdateService (UT-SNP-034 〜 046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | executeでスニペットが正常に更新される | E-04 L17-38 | ○ |
| C-35 | 無効なパラメータでエラーが返却される | E-04 L18 | ○ |
| C-36 | 可視性変更が許可されていない場合エラーが返却される | E-04 L20-22 | ○ |
| C-37 | visibility_changed?で可視性変更が検出される | E-04 L45-47 | ○ |
| C-38 | visibility_changed?で可視性同じ場合false | E-04 L46 | ○ |
| C-39 | update_snippet_attributesでcontentが設定される | E-04 L49-64 | ○ |
| C-40 | コミット可能な属性がない場合コミットがスキップされる | E-04 L71 | ○ |
| C-41 | リポジトリが存在しない場合作成される | E-04 L73-76 | ○ |
| C-42 | コミット失敗時に属性がロールバックされる | E-04 L81-99 | ○ |
| C-43 | repository_empty?で空リポジトリが検出される | E-04 L133-135 | ○ |
| C-44 | committable_attributes?でfile_name変更時にtrue | E-04 L137-139 | ○ |
| C-45 | committable_attributes?でcontent変更時にtrue | E-04 L137-139 | ○ |
| C-46 | build_actions_from_paramsでアクションが構築される | E-04 L141-147 | ○ |

### Snippets::DestroyService (UT-SNP-047 〜 051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | executeでスニペットが正常に削除される | E-05 L20-39 | ○ |
| C-48 | snippetがnilの場合エラーが返却される | E-05 L21-23 | ○ |
| C-49 | 権限がない場合エラーが返却される | E-05 L25-30 | ○ |
| C-50 | リポジトリ削除失敗時にエラーが返却される | E-05 L35-36 | ○ |
| C-51 | admin_snippet権限でtrue | E-05 L51-53 | ○ |

### Snippets::BulkDestroyService (UT-SNP-052 〜 056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | 複数スニペットが正常に削除される | E-06 L30-37 | ○ |
| C-53 | 空のsnippetsの場合成功が返却される | E-06 L31 | ○ |
| C-54 | skip_authorizationでスキップされる | E-06 L33 | ○ |
| C-55 | 権限がない場合エラーが返却される | E-06 L38-42 | ○ |
| C-56 | リポジトリ削除失敗時にエラーが返却される | E-06 L43-47 | ○ |

### Snippets::CountService (UT-SNP-057 〜 061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | authorを指定して初期化できる | E-07 L37-49 | ○ |
| C-58 | projectを指定して初期化できる | E-07 L37-49 | ○ |
| C-59 | authorもprojectもない場合エラーが発生する | E-07 L38-42 | ○ |
| C-60 | 可視性別のカウントが返却される | E-07 L52-62 | ○ |
| C-61 | snippetsがない場合空ハッシュが返却される | E-07 L54 | ○ |

### Snippets::UpdateStatisticsService (UT-SNP-062 〜 065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | 統計が正常に更新される | E-08 L13-24 | ○ |
| C-63 | リポジトリが存在しない場合エラーが返却される | E-08 L14-19 | ○ |
| C-64 | 既存のstatisticsが返却される | E-08 L29-31 | ○ |
| C-65 | statisticsがない場合新規作成される | E-08 L30 | ○ |

### Snippets::RepositoryValidationService (UT-SNP-066 〜 073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | 有効なリポジトリで成功が返却される | E-09 L19-28 | ○ |
| C-67 | snippetがnilの場合エラーが返却される | E-09 L20 | ○ |
| C-68 | ブランチが2つ以上ある場合エラーが発生する | E-09 L35-38 | ○ |
| C-69 | デフォルトブランチ名が異なる場合エラーが発生する | E-09 L40-46 | ○ |
| C-70 | タグが存在する場合エラーが発生する | E-09 L48-52 | ○ |
| C-71 | ファイル数が上限を超える場合エラーが発生する | E-09 L54-61 | ○ |
| C-72 | ファイルが0の場合エラーが発生する | E-09 L63-65 | ○ |
| C-73 | リポジトリサイズが上限を超える場合エラーが発生する | E-09 L67-71 | ○ |

### Snippets::UpdateRepositoryStorageService (UT-SNP-074 〜 076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | リポジトリがトラッキングされる | E-10 L11-13 | ○ |
| C-75 | リポジトリが存在する場合ミラーリングされる | E-10 L15-18 | ○ |
| C-76 | リポジトリが存在しない場合スキップされる | E-10 L16 | ○ |

### Snippets::ScheduleBulkRepositoryShardMovesService (UT-SNP-077 〜 079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | SnippetRepositoryが返却される | E-11 L12-14 | ○ |
| C-78 | Snippetが返却される | E-11 L16-18 | ○ |
| C-79 | :snippet_idが返却される | E-11 L20-22 | ○ |

### Workers (UT-SNP-080 〜 083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | RepositoryStorageMoveが取得できる | E-12 L13-15 | ○ |
| C-81 | UpdateRepositoryStorageServiceが実行される | E-12 L17-19 | ○ |
| C-82 | ScheduleBulkRepositoryShardMovesServiceが実行される | E-13 L15-17 | ○ |
| C-83 | destination_storage_nameも渡せる | E-13 L15 | ○ |

### SnippetsFinder (UT-SNP-084 〜 097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | current_userとparamsが設定される | E-20 L59-62 | ○ |
| C-85 | authorとprojectが両方指定された場合エラーが発生する | E-20 L64-70 | ○ |
| C-86 | アクセス可能なスニペットが返却される | E-20 L73-83 | ○ |
| C-87 | authorが存在しない場合Snippet.noneが返却される | E-20 L78 | ○ |
| C-88 | projectが存在しない場合Snippet.noneが返却される | E-20 L79 | ○ |
| C-89 | snippets機能が無効な場合Snippet.noneが返却される | E-20 L80 | ○ |
| C-90 | are_privateでPRIVATEが返却される | E-20 L207-215 | ○ |
| C-91 | are_internalでINTERNALが返却される | E-20 L207-215 | ○ |
| C-92 | are_publicでPUBLICが返却される | E-20 L207-215 | ○ |
| C-93 | 公開個人スニペットのみが返却される | E-20 L123-125 | ○ |
| C-94 | authorが自分の場合全スニペットが返却される | E-20 L195-204 | ○ |
| C-95 | 他者のauthorの場合公開スニペットのみ返却される | E-20 L203 | ○ |
| C-96 | 管理者の場合BAN済みユーザーのスニペットも含まれる | E-20 L236-240 | △ |
| C-97 | 一般ユーザーの場合BAN済みユーザーのスニペットが除外される | E-20 L240 | △ |

### GraphQL Mutations (UT-SNP-098 〜 104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | スニペットが正常に作成される | E-15 L43-71 | ○ |
| C-99 | プロジェクトスニペットが作成される | E-15 L44-48 | ○ |
| C-100 | スニペットが正常に更新される | E-16 L32-66 | ○ |
| C-101 | スニペットが正常に削除される | E-17 L14-22 | ○ |
| C-102 | 削除失敗時にエラーメッセージが返却される | E-17 L17-18 | ○ |
| C-103 | スパムとしてマークされる | E-18 L25-27 | ○ |
| C-104 | Akismetエラー時にエラーメッセージが返却される | E-18 L16 | △ |

### Resolvers (UT-SNP-105 〜 108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | 指定パスのblobsが返却される | E-19 L19-33 | ○ |
| C-106 | パス未指定で全ファイルが返却される | E-19 L22 | ○ |
| C-107 | 空リポジトリの場合snippet.blobが返却される | E-19 L20 | ○ |
| C-108 | unretrievable_blobs?フラグが設定される | E-19 L31 | △ |

### API Helpers (UT-SNP-109 〜 112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | successで200が返却される | E-25 L9-18 | ○ |
| C-110 | invalid_params_errorで422が返却される | E-25 L12 | ○ |
| C-111 | snippet_access_errorで403が返却される | E-25 L13 | ○ |
| C-112 | 未知のreasonで500が返却される | E-25 L23-30 | ○ |

### SnippetsHelper (UT-SNP-113 〜 121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | persisted snippetの場合personal_snippetパスが返却される | E-21 L7-8 | ○ |
| C-114 | 新規snippetの場合userパスが返却される | E-21 L9-10 | ○ |
| C-115 | userがnilの場合nilが返却される | E-21 L5 | ○ |
| C-116 | Projectの場合project_snippets_pathが返却される | E-21 L17-19 | ○ |
| C-117 | Userの場合dashboard_snippets_pathが返却される | E-21 L20-21 | ○ |
| C-118 | privateスニペットの場合バッジが返却される | E-21 L25-36 | ○ |
| C-119 | publicスニペットの場合nilが返却される | E-21 L34-36 | ○ |
| C-120 | ファイル数が表示される | E-21 L72-93 | ○ |
| C-121 | file_countが0の場合nilが返却される | E-21 L75 | ○ |

### SnippetsController & Actions (UT-SNP-122 〜 130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | ログインユーザーはdashboard_snippets_pathにリダイレクトされる | E-22 L19-20 | ○ |
| C-123 | 未ログインユーザーはexplore_snippets_pathにリダイレクトされる | E-22 L20 | ○ |
| C-124 | 新規PersonalSnippetが初期化される | E-22 L23-24 | ○ |
| C-125 | HTML形式でスニペットが表示される | E-24 L52-60 | ○ |
| C-126 | JS形式で埋め込み可能な場合レンダリングされる | E-24 L63-67 | ○ |
| C-127 | JS形式で埋め込み不可の場合404が返却される | E-24 L68-69 | ○ |
| C-128 | rawコンテンツが返却される | E-24 L29-44 | ○ |
| C-129 | line_ending=rawの場合変換なしで返却される | E-24 L90-92 | ○ |
| C-130 | 通常はCRLFがLFに変換される | E-24 L91 | ○ |

## 4) 不足情報（Unknown / Missing）

### C-96/C-97: BAN済みユーザー除外
- コードには `without_created_by_banned_user` スコープの呼び出しがあるが、スコープの詳細実装はSnippetモデル側にある
- 候補: `app/models/snippet.rb` / `app/models/concerns/` 内のスコープ定義

### C-104: Akismetエラー処理
- `Spam::AkismetMarkAsSpamService` の詳細な失敗パターンは別サービス内で定義
- 候補: `app/services/spam/akismet_mark_as_spam_service.rb`

### C-108: unretrievable_blobs?フラグ
- フラグの利用箇所とUIへの影響についての詳細確認が必要
- 候補: GraphQL typesでの利用箇所

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2（高） | セキュリティ関連テスト | 権限チェック（admin_snippet, read_snippet）の網羅性確認が必要 |
| 1（中） | リポジトリ操作 | create_repository, delete_repositoryのエラーハンドリング |
| 1（中） | スパム対策 | Akismetサービス連携のエラーパターン |
| 0（低） | ヘルパーメソッド | 表示系メソッドのテストは優先度低 |

## 6) レビュアーチェックリスト（最小）

- [ ] 権限チェック系テスト（UT-SNP-047〜051, UT-SNP-052〜056）が実際のポリシーと整合しているか確認
- [ ] リポジトリ操作のロールバック処理（UT-SNP-029, UT-SNP-042）が正しく定義されているか確認
- [ ] BAN済みユーザー除外ロジック（UT-SNP-096, UT-SNP-097）の実装詳細を確認
- [ ] スパムチェック関連（UT-SNP-024, UT-SNP-103, UT-SNP-104）の境界条件を確認
- [ ] GraphQL Mutation/Resolverのエラーハンドリングが網羅的か確認
